/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.selfhealing.execution.healers;

import com.katalon.selfhealing.execution.healers.StandardTestObject;
import com.kms.katalon.ai.core.model.llm.AssistantMessage;
import com.kms.katalon.ai.core.model.llm.CompletionOptions;
import com.kms.katalon.ai.core.model.llm.CompositeUserMessage;
import com.kms.katalon.ai.core.model.llm.ImageFormat;
import com.kms.katalon.ai.core.model.llm.InlineImageInput;
import com.kms.katalon.ai.core.model.llm.SystemMessage;
import com.kms.katalon.ai.core.model.llm.TextInput;
import com.kms.katalon.ai.core.model.llm.UserInput;
import com.kms.katalon.ai.core.services.ILlmService;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.main.ExecutionServiceContext;
import com.kms.katalon.core.selfhealing.TestObjectLocatorHealer;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.util.Strings;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class LLMTestObjectHealer
implements TestObjectLocatorHealer<LLMTestObjectHealingInput> {
    private KeywordLogger logger = KeywordLogger.getInstance(this.getClass());

    public List<TestObjectLocatorHealer.FoundLocator> heal(LLMTestObjectHealingInput input) throws Exception {
        LLMCustomPrompts customPrompts = input.customPrompts;
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("locatorTypes", customPrompts.locatorTypes);
        variables.put("outputRules", customPrompts.outputRules);
        boolean useAccessibilityTree = StringUtils.isNotBlank((CharSequence)input.accessibilityTree);
        String accessibilityTreeRules = useAccessibilityTree ? "- **If accessibility tree is provided**, prioritize `ref` attributes for locators. But REMEMBER to rename the `ref` attribute to `data-mcp-ref`. E.g., In the accessibility tree, there is \"[ref=e42]\" => CSS selector must be \"[data-mcp-ref=\\\"e42\\\"]\"." : "";
        variables.put("accessibilityTreeRules", accessibilityTreeRules);
        ArrayList<Object> messages = new ArrayList<Object>();
        String mainPrompt = new StringSubstitutor(variables).replace("### \ud83c\udfaf Goal\n\nGiven a broken test object and the current page state (Page DOM, Accessibility Tree, etc.), find up to 3 **reliable locators** for the broken test object at runtime, prioritizing text content matching across different languages, including Vietnamese, French, Chinese, etc. . If there are **no similar elements**, return an empty list for \"possibleLocators\" field.\nImportant!!! Try to avoid disabled or readonly elements. Only select them if they are the only element that match.\n\n---\n\n### \ud83e\udded Reasoning Steps\n\n1. **Understand** the broken test object model.\nEverything here are captured at the recording time.\n```typescript\n   type Locator = {\n       type: string;\n       value: string;\n   }\n    type TestObject = {\n        filePath: string; // The test object file path in the local system.\n        name: string; // Test object name.\n        textContent: string; // The text content.\n        screenshotPath: string; // The screenshot file path in the local system.\n        attributes: Map<String, String>; // Element attributes.\n        locators: Array<Locator>; // Captured locators.\n    }\n```\n2. Analyze the Test Object by extracting:\n- Selector information.\n- DOM structure patterns: parent/child relationships if present\n- **Visible text**: including innerText, label text, aria-label, placeholder, title\n- Functional role: button, input, link, etc.\n3. Then find on the provided page the elements that are similar across ALL applicable dimensions:\n- Similarity dimensions:\n    - Tag similarity \u2013 same HTML tag or same UI role\n    - Attribute similarity \u2013 overlapping classes, attribute patterns, id/name patterns\n    - DOM similarity \u2013 similar structural position (optional if DOM is missing)\n    - **Text similarity** \u2013 measure similarity based on:\n        - Levenshtein / fuzzy matching\n        - semantic similarity of phrases, including across languages\n        - shared keywords.\n        - Similar meaning even if in different languages (e.g., \"\u0110\u1eb7t l\u1ecbch h\u1eb9n\" in Vietnamese is similar to \"Make Appointment\" in English).\n    - Functional similarity \u2013 elements that serve the same purpose (e.g., \u201cLogin\u201d, \u201cSubmit\u201d buttons).\n- Important!!! Try to avoid disabled or readonly elements. Only select them if they are the only element that match.\n4. **Generate** 1 unique locator per matched element (CSS or XPath) in the given page source or accessibility tree (Must not based on the provided broken test object).\n    - The generated locator MUST be generated based on the given page source or accessibility tree.\n    - The generated locator MUST be unique, pointed to one and only one element! Please check if the generated locator can also point to other elements or not.\n    ${accessibilityTreeRules}\n\n---\n\n### \u274c Critical Restrictions\n\n- **Do NOT propose an element based solely on contextual relevance** (e.g., page purpose, nearby text). Use explicit, inspectable data only.\n\n---\n\n### \ud83e\udde9 Output Rules\n\n- If the Page DOM or Accessibility Tree is provided: analyze it and list real elements.\n- If NOT provided: Return an empty list for `possibleLocators` field with a message indicating no locators were found.\n- Output **only** one valid JSON object (no explanations) follows the `Response` model below.\n- Up to 3 candidates, sorted by descending `confidence`. Prefer 1.\n- Use index selectors only if necessary (confidence < 0.50).\n- Avoid dynamic attributes (e.g., `id-1234`).\n${outputRules}\n\n### \ud83e\udde0 Reason Field Rules\n\nEach `reason` must explicitly mention **which information** from the broken test object was matched.\n\n\u2705 Examples:\n- \"Matched text='Make Appointment' in button label.\"\n- \"Matched id='btn-make-appointment' from object attributes.\"\n- \"Text similarity 'Make Appointment' and '\u0110\u1eb7t l\u1ecbch h\u1eb9n'.\"\n\n\u274c Invalid:\n- \"This button is relevant to healthcare context.\"\n### \ud83e\udde9 Output Specification\n\n```typescript\ntype FoundLocator = {\n  type: ${locatorTypes};\n  value: string; // Locator value\n  semanticLocator: string; // Short, human-meaningful description of element\u2019s role\n  confidence: number; // How confident are you about this locator is the replacement for the broken test object. Value range: [0.00\u20131.00] (2 decimals)\n  reason: string; // Must specify which field(s) matched from the broken test object\n}\n\ntype Response = {\n    possibleLocators: Array<FoundLocator>;\n}\n```\n\nExample:\n\n```json\n{\n    possibleLocators: []\n}\n```\n".trim());
        messages.add(SystemMessage.of((String)mainPrompt));
        CompositeUserMessage.Builder userMessageBuilder = CompositeUserMessage.builder();
        if (StringUtils.isNotBlank((CharSequence)input.currentAction)) {
            userMessageBuilder.addInput((UserInput)TextInput.of((String)MessageFormat.format("The current action that I'm going to perform on the target element is: \"{0}\". You should also based on this action to find a more suitable element.\n".trim(), input.currentAction)));
        }
        if (StringUtils.isNotBlank((CharSequence)input.currentActionPrompt)) {
            userMessageBuilder.addInput((UserInput)TextInput.of((String)MessageFormat.format("And with that action, there is an additional requirements here:\n\n```\n{0}\n```\n".trim(), input.currentActionPrompt)));
        }
        userMessageBuilder.addInput((UserInput)TextInput.of((String)MessageFormat.format("The broken test object:\n\n```json\n{0}\n```\n".trim(), JsonUtil.toJson((Object)input.testObject))));
        this.logger.logDebug("\n> Test Object:\n" + JsonUtil.toJson((Object)input.testObject, (boolean)true));
        if (StringUtils.isNotBlank((CharSequence)input.pageSource)) {
            userMessageBuilder.addInput((UserInput)TextInput.of((String)MessageFormat.format("The page source:\n\n```html\n{0}\n```\n".trim(), input.pageSource)));
        }
        if (StringUtils.isNotBlank((CharSequence)input.accessibilityTree)) {
            userMessageBuilder.addInput((UserInput)TextInput.of((String)MessageFormat.format("The accessibility tree:\n\n```text\n{0}\n```\n".trim(), input.accessibilityTree)));
        }
        if (StringUtils.isNotBlank((CharSequence)input.elementScreenshot)) {
            userMessageBuilder.addInput((UserInput)InlineImageInput.of((String)input.elementScreenshot, (ImageFormat)ImageFormat.JPEG));
        }
        if (StringUtils.isNotBlank((CharSequence)input.fullpageScreenshot)) {
            userMessageBuilder.addInput((UserInput)InlineImageInput.of((String)input.fullpageScreenshot, (ImageFormat)ImageFormat.JPEG));
        }
        messages.add(userMessageBuilder.build());
        ILlmService aiService = (ILlmService)ExecutionServiceContext.getInstance().getService(ILlmService.class);
        CompletionOptions completionOptions = CompletionOptions.builder().build();
        AssistantMessage completionResponse = aiService.getChatCompletions(messages, completionOptions);
        String rawResponse = completionResponse.getContent();
        ChatResponse response = this.parseChatResponse(rawResponse);
        if (response == null || response.possibleLocators == null || response.possibleLocators.isEmpty()) {
            return null;
        }
        return response.possibleLocators;
    }

    private ChatResponse parseChatResponse(String rawResponse) throws Exception {
        try {
            ChatResponse chatResponse = (ChatResponse)JsonUtil.fromJson((String)Strings.extractJSONContent((String)rawResponse), ChatResponse.class);
            if (chatResponse != null && chatResponse.possibleLocators != null) {
                chatResponse.possibleLocators.forEach(locator -> {
                    if (locator.type == null) {
                        locator.type = locator.value.startsWith("/") ? SelectorMethod.XPATH.getName() : SelectorMethod.CSS.getName();
                    }
                });
            }
            return chatResponse;
        }
        catch (Exception error) {
            throw new Exception("Cannot parse the response:\n" + rawResponse, error);
        }
    }

    private static class ChatResponse {
        public List<TestObjectLocatorHealer.FoundLocator> possibleLocators;

        private ChatResponse() {
        }
    }

    public static final class LLMCustomPrompts {
        public String outputRules;
        public String locatorTypes;
    }

    public static final class LLMTestObjectHealingInput {
        public StandardTestObject testObject;
        public String pageSource;
        public String accessibilityTree;
        public String fullpageScreenshot;
        public String elementScreenshot;
        public String currentAction;
        public String currentActionPrompt;
        public LLMCustomPrompts customPrompts = new LLMCustomPrompts();
    }
}

