/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.selfhealing.execution.healers;

import com.katalon.selfhealing.execution.healers.LLMTestObjectHealer;
import com.katalon.selfhealing.execution.healers.StandardTestObject;
import com.katalon.selfhealing.execution.healers.StandardTestObjectMapper;
import com.kms.katalon.core.aut.ApplicationUnderTest;
import com.kms.katalon.core.executionpipeline.ExecutionPipeline;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.selfhealing.SelfHealingInputSource;
import com.kms.katalon.core.selfhealing.TestObjectElementHealer;
import com.kms.katalon.core.selfhealing.TestObjectLocatorHealer;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.FileUtil;
import com.kms.katalon.core.util.ImageProcessor;
import com.kms.katalon.core.util.internal.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class SelfHealingPipeline
extends ExecutionPipeline<SelfHealingContext> {
    private KeywordLogger logger = KeywordLogger.getInstance(((Object)((Object)this)).getClass());

    public SelfHealingPipeline() {
        this.initSelfHealingPhases();
    }

    private void initSelfHealingPhases() {
        this.registerBasicHealingPhase();
        this.registerLLMHealingPhase();
    }

    private void registerBasicHealingPhase() {
        this.registerPhase(context -> {
            TestObjectElementHealer<TestObject> basicSelfHealer = ((SelfHealingContext)context.data).params.basicSelfHealer;
            TestObject testObject = ((SelfHealingContext)context.data).params.testObject;
            List foundElements = (List)basicSelfHealer.heal((Object)testObject);
            if (foundElements == null || foundElements.isEmpty()) {
                return;
            }
            ((SelfHealingContext)context.data).results.foundElements = foundElements;
            context.subPipeline.requestSkip();
        });
    }

    private void registerLLMHealingPhase() {
        this.registerPhase(context -> {
            List<TestObjectLocatorHealer.FoundLocator> foundLocators;
            String elementScreenshot;
            StandardTestObject standardTestObject;
            SelfHealingContext data = (SelfHealingContext)context.data;
            List<WebElement> foundElements = data.results.foundElements;
            if (foundElements != null && !foundElements.isEmpty()) {
                return;
            }
            SelfHealingParams params = data.params;
            ElementsFinder elementFinder = params.elementsFinder;
            ApplicationUnderTest aut = params.aut;
            TestObject testObject = params.testObject;
            List<SelfHealingInputSource> aiSelfHealingInputSources = params.aiSelfHealingInputSources;
            StandardTestObjectMapper standardTestObjectMapper = params.standardTestObjectMapper;
            this.logger.logInfo("Recovering element locator by using AI Self-Healing...");
            LLMTestObjectHealer.LLMTestObjectHealingInput llmHealingInput = new LLMTestObjectHealer.LLMTestObjectHealingInput();
            llmHealingInput.testObject = standardTestObject = standardTestObjectMapper.map(testObject);
            llmHealingInput.customPrompts = params.customPrompts;
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.PAGE_SOURCE)) {
                llmHealingInput.pageSource = aut.getPageSource();
            }
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.ACCESSIBILITY_TREE)) {
                llmHealingInput.accessibilityTree = aut.getAccessibilityTree();
            }
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.ELEMENT_SCREENSHOT) && StringUtils.isNotBlank((CharSequence)(elementScreenshot = standardTestObject.screenshot))) {
                File screenshotFile = new File(elementScreenshot);
                if (screenshotFile.exists()) {
                    try {
                        llmHealingInput.elementScreenshot = FileUtil.readFileAsBase64((File)screenshotFile);
                    }
                    catch (IOException e) {
                        this.logger.logWarning("Failed to read element screenshot: " + e.getMessage());
                    }
                } else {
                    llmHealingInput.elementScreenshot = elementScreenshot;
                }
            }
            if (aiSelfHealingInputSources.contains(SelfHealingInputSource.FULL_PAGE_SCREENSHOT)) {
                llmHealingInput.fullpageScreenshot = ImageProcessor.fromBase64((String)aut.takeFullPageScreenshot()).scale(0.5).toJPEG().toJPEGBase64();
            }
            if ((foundLocators = new LLMTestObjectHealer().heal(llmHealingInput)) == null || foundLocators.isEmpty()) {
                this.logger.logInfo("No possible locators found");
                return;
            }
            this.logger.logInfo(MessageFormat.format("Found \"{0}\" possible locators:\n {1}", foundLocators.size(), JsonUtil.toJson(foundLocators)));
            for (TestObjectLocatorHealer.FoundLocator foundLocator : foundLocators) {
                this.logger.logInfo(MessageFormat.format("Verifying locator: \"{0}\"", foundLocator.value));
                try {
                    foundElements = elementFinder.find(foundLocator);
                    if (foundElements != null && !foundElements.isEmpty()) {
                        this.logger.logInfo(MessageFormat.format("Found valid locator: \"{0}\"", foundLocator.value));
                        data.results.foundElements = foundElements;
                        data.results.foundLocator = foundLocator;
                        return;
                    }
                    this.logger.logInfo(MessageFormat.format("Invalid locator: \"{0}\"", foundLocator.value));
                }
                catch (Exception error) {
                    this.logger.logInfo(MessageFormat.format("Invalid locator: \"{0}\"", foundLocator.value));
                    this.logger.logWarning(error.getMessage());
                }
            }
        });
    }

    public SelfHealingContext execute(SelfHealingParams params) throws Exception {
        SelfHealingContext context = new SelfHealingContext();
        context.params = params;
        return (SelfHealingContext)this.execute(context);
    }

    public static interface ElementsFinder {
        public List<WebElement> find(TestObjectLocatorHealer.FoundLocator var1) throws Exception;
    }

    public static class SelfHealingContext {
        public SelfHealingParams params = new SelfHealingParams();
        public SelfHealingResults results = new SelfHealingResults();
    }

    public static class SelfHealingParams {
        public TestObject testObject;
        public StandardTestObjectMapper standardTestObjectMapper;
        public ApplicationUnderTest aut;
        public String currentAction;
        public String currentActionPrompt;
        public ElementsFinder elementsFinder;
        public TestObjectElementHealer<TestObject> basicSelfHealer;
        public boolean useBasicSelfHealing;
        public boolean useAISelfHealing;
        public List<SelfHealingInputSource> aiSelfHealingInputSources;
        public LLMTestObjectHealer.LLMCustomPrompts customPrompts;
    }

    public static class SelfHealingResults {
        public List<WebElement> foundElements;
        public TestObjectLocatorHealer.FoundLocator foundLocator;
    }
}

