/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media.jpeg;

import atu.testrecorder.media.AbstractVideoCodec;
import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.Format;
import atu.testrecorder.media.VideoFormat;
import atu.testrecorder.media.io.ByteArrayImageOutputStream;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public class JPEGCodec
extends AbstractVideoCodec {
    @Override
    public Format setInputFormat(Format f) {
        VideoFormat vf;
        if (f instanceof VideoFormat && BufferedImage.class.isAssignableFrom((vf = (VideoFormat)f).getDataClass())) {
            return super.setInputFormat(new VideoFormat("image", vf.getDataClass(), vf.getWidth(), vf.getHeight(), vf.getDepth()));
        }
        return super.setInputFormat(null);
    }

    @Override
    public Format setOutputFormat(Format f) {
        if (f instanceof VideoFormat) {
            VideoFormat vf = (VideoFormat)f;
            return super.setOutputFormat(new VideoFormat("MJPG", byte[].class, vf.getWidth(), vf.getHeight(), 24));
        }
        return super.setOutputFormat(null);
    }

    @Override
    public void process(Buffer in, Buffer out) {
        if ((in.flags & 2) != 0) {
            out.flags = 2;
            return;
        }
        BufferedImage image = this.getBufferedImage(in);
        if (image == null) {
            out.flags = 2;
            return;
        }
        out.format = this.outputFormat;
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        try {
            ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/jpeg").next();
            ImageWriteParam iwParam = iw.getDefaultWriteParam();
            iwParam.setCompressionMode(2);
            iwParam.setCompressionQuality(this.quality);
            iw.setOutput(tmp);
            IIOImage img = new IIOImage(image, null, null);
            iw.write(null, img, iwParam);
            iw.dispose();
            out.flags = 16;
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.flags = 2;
            return;
        }
    }
}

