/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.controls;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.resources.image.ImageManager;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextField
extends Composite {
    protected Composite inputWrapper;
    protected Composite labelWrapper;
    protected Label label;
    protected Label placeholderLabel;
    protected Text input;
    protected boolean isFocusing = false;
    protected boolean isShowingPassword = false;
    protected Composite buttonWrapper;
    protected Canvas showPasswordButton;
    protected int style;
    protected Color color;
    public static final int PASSWORD_FIELD = 16384;

    private int applyZoom(int size) {
        return ComponentUtil.applyZoom(size);
    }

    public TextField(Composite parent, int style) {
        super(parent, 0);
        this.style = style;
        this.init(this);
    }

    protected boolean isPasswordField() {
        return ControlUtil.checkStyle(this.style, 16384);
    }

    protected boolean isCopyable() {
        return ControlUtil.checkStyle(this.style, 524288);
    }

    protected boolean isSimple() {
        return ControlUtil.checkStyle(this.style, 65536);
    }

    protected boolean useAdornments() {
        return this.isPasswordField() || this.isCopyable();
    }

    protected Color getInputBackground() {
        return ColorUtil.themeColor("#FFFFFF", "#515658");
    }

    protected Color getLabelColor() {
        return ColorUtil.getColor("#919299");
    }

    private void init(Composite parent) {
        ComponentBuilder.from(parent).fill().cursor(19).gridLayout(this.useAdornments() ? 2 : 1).margin(this.applyZoom(5), this.applyZoom(this.isSimple() ? 5 : 17), this.applyZoom(this.isSimple() ? 7 : 13), this.applyZoom(this.isSimple() ? 5 : 10)).borderWidth(2).borderRadius(10).focusable().onPaint((event, gc, widget) -> {
            Rectangle rect = widget.getBounds();
            int borderRadius = ComponentUtil.applyZoom(ComponentDataUtil.getInt((Widget)widget, "control.border.radius"));
            int borderWidth = ComponentUtil.applyZoom(ComponentDataUtil.getInt((Widget)widget, "control.border.width"));
            if (ColorUtil.isDarkTheme()) {
                gc.setBackground(this.getParent().getBackground());
                gc.fillRectangle(0, 0, rect.width, rect.height);
            } else {
                gc.setBackground(this.getInputBackground());
            }
            gc.fillRoundRectangle(1, 1, rect.width - borderWidth, rect.height - borderWidth, borderRadius, borderRadius);
            gc.setLineWidth(ComponentUtil.applyZoom(1));
            if (this.isFocusing) {
                gc.setForeground(ColorUtil.PRIMARY_COLOR);
            } else {
                gc.setForeground(ColorUtil.themeColor("#E9E8F0", "#46474D"));
            }
            gc.drawRoundRectangle(1, 1, rect.width - borderWidth, rect.height - borderWidth, borderRadius, borderRadius);
        }).onClick(event -> this.setFocus()).build();
        this.inputWrapper = ComponentBuilder.gridContainer(parent).gridSpacing(0).marginTop(this.applyZoom(this.isSimple() ? 0 : 4)).marginBottom(this.applyZoom(this.isSimple() ? 0 : 4)).fillHorizontal().background(this.getInputBackground()).onClick(event -> this.setFocus()).build();
        this.inputWrapper.setBackgroundMode(2);
        this.labelWrapper = ComponentBuilder.gridContainer(this.inputWrapper).fillHorizontal().marginLeft(this.applyZoom(4)).background(this.getInputBackground()).onClick(event -> this.setFocus()).build();
        this.label = ComponentBuilder.label(this.labelWrapper).fontSize(8).color(this.getLabelColor()).background(this.getInputBackground()).fillHorizontal().hide().onClick(event -> this.setFocus()).build();
        this.placeholderLabel = ComponentBuilder.label(this.inputWrapper).background(this.getInputBackground()).color(this.getLabelColor()).fillHorizontal().show().onClick(event -> this.setFocus()).build();
        this.input = ComponentBuilder.text(this.inputWrapper, this.style).background(this.getInputBackground()).fillHorizontal().onChange(event -> parent.notifyListeners(24, event)).onFocus(event -> {
            this.input.setSelection(this.input.getText().length());
            this.isFocusing = true;
            this.updateLabel(true);
            this.redraw();
        }).onBlur(event -> {
            this.isFocusing = false;
            this.updateLabel(false);
            this.redraw();
        }).build();
        ComponentEventUtil.submitOnEnter((Control)this.input);
        ComponentEventUtil.switchOnTab((Control)this.input);
        if (this.useAdornments()) {
            this.buttonWrapper = ComponentBuilder.gridContainer(parent).marginTop(this.applyZoom(this.isSimple() ? 4 : 8)).marginRight(this.applyZoom(this.isSimple() ? 4 : 0)).background(this.getInputBackground()).onClick(event -> this.setFocus()).build();
        }
        if (this.isPasswordField()) {
            this.input.setEchoChar('\u2022');
            this.showPasswordButton = ComponentBuilder.canvas(this.buttonWrapper, this.getEyeSlashIcon(), this.applyZoom(20), this.applyZoom(20)).cursorPointer().background(this.getInputBackground()).onClick(event -> {
                this.setFocus();
                boolean bl = this.isShowingPassword = !this.isShowingPassword;
                if (this.isShowingPassword) {
                    this.input.setEchoChar('\u0000');
                    this.showPasswordButton.setBackgroundImage(this.getEyeIcon());
                } else {
                    this.input.setEchoChar('\u2022');
                    this.showPasswordButton.setBackgroundImage(this.getEyeSlashIcon());
                }
                this.input.redraw();
            }).build();
        }
        if (this.isCopyable()) {
            ComponentBuilder.canvas(this.buttonWrapper, ImageManager.getImage((String)"toolbar/save_24.png"), this.applyZoom(20), this.applyZoom(20)).cursorPointer().background(this.getInputBackground()).onClick(event -> {
                this.setFocus();
                this.input.selectAll();
                this.input.copy();
            }).build();
        }
        this.updateLabel(this.isFocusing);
    }

    public boolean setFocus() {
        this.isFocusing = this.getEnabled();
        this.updateLabel(this.isFocusing);
        return this.input.setFocus();
    }

    public boolean forceFocus() {
        this.isFocusing = this.getEnabled();
        this.updateLabel(this.isFocusing);
        return this.input.forceFocus();
    }

    public void blur() {
        this.isFocusing = false;
    }

    private Image getEyeIcon() {
        return ColorUtil.isDarkTheme() ? ImageManager.getImage((String)"eye_white_32.png") : ImageManager.getImage((String)"eye_32.png");
    }

    private Image getEyeSlashIcon() {
        return ColorUtil.isDarkTheme() ? ImageManager.getImage((String)"eye-slash_white_32.png") : ImageManager.getImage((String)"eye_slash_32.png");
    }

    private void updateLabel(boolean focusing) {
        if (!this.isSimple()) {
            boolean shouldShowLabel;
            boolean bl = shouldShowLabel = focusing || StringUtils.isNotEmpty((String)this.input.getText());
            if (shouldShowLabel) {
                ComponentUtil.setMarginTop(this.inputWrapper, this.applyZoom(0));
                ComponentUtil.setMarginBottom(this.inputWrapper, this.applyZoom(0));
            } else {
                ComponentUtil.setMarginTop(this.inputWrapper, this.applyZoom(8));
                ComponentUtil.setMarginBottom(this.inputWrapper, this.applyZoom(4));
            }
            ComponentUtil.setVisible((Control)this.label, shouldShowLabel);
        }
        boolean shouldShowPlaceHolder = !focusing && StringUtils.isBlank((String)this.input.getText());
        ComponentUtil.setVisible((Control)this.placeholderLabel, shouldShowPlaceHolder);
        ComponentUtil.setHeight((Control)this.input, shouldShowPlaceHolder ? 1 : -1);
        this.inputWrapper.pack();
    }

    public String getText() {
        return this.input.getText();
    }

    public void setText(String text) {
        this.input.setText(text);
        this.updateLabel(this.isFocusControl());
    }

    public void setMessage(String placeholder) {
        this.label.setText(placeholder);
        this.placeholderLabel.setText(placeholder);
        this.updateLabel(false);
    }

    public void setEnabled(boolean enabled) {
        Color disableColor = ColorUtil.getColor("#919299");
        this.label.setForeground(enabled ? this.getLabelColor() : disableColor);
        this.input.setForeground(enabled ? this.getForeground() : disableColor);
        if (this.showPasswordButton != null) {
            this.showPasswordButton.setEnabled(enabled);
        }
        this.isFocusing = this.isFocusing && enabled;
        this.updateLabel(this.isFocusing);
        super.setEnabled(enabled);
        this.redraw();
    }

    public void setForeground(Color color) {
        this.input.setForeground(color);
        this.color = color;
    }

    public Color getForeground() {
        return this.color;
    }

    public void setBackground(Color color) {
    }

    public void addVerifyListener(VerifyListener listener) {
        this.input.addVerifyListener(listener);
    }

    public void setSelection(int start) {
        this.input.setSelection(start);
    }

    public void setSelection(int start, int end) {
        this.input.setSelection(start, end);
    }

    public void setSelection(Point selection) {
        this.input.setSelection(selection);
    }
}

