/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.controls;

import com.equo.chromium.swt.Browser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.core.event.EventEmitter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class WebviewComponent
extends Composite {
    private static final boolean DEBUG_MODE = false;
    private static final String NOTIFY_EVENT_METHOD_NAME = "notifyEvent";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS");
    protected Browser browser;
    protected EventEmitter emitter = new EventEmitter();
    protected Set<ComponentUtil.BrowserLoadedListener> onLoadedListeners = new HashSet<ComponentUtil.BrowserLoadedListener>();
    protected Map<String, ComponentUtil.BrowserFunctionHandler> browserFunctions = new HashMap<String, ComponentUtil.BrowserFunctionHandler>();
    private ObjectMapper objectMapper = new ObjectMapper();
    private Path debugScriptFilePath = null;
    protected ColorUtil.ThemeChangeListener themeChangeListener = theme -> this.setTheme(theme);

    public String getControllerName() {
        return "controller";
    }

    public WebviewComponent(Composite parent) {
        this(parent, 0);
    }

    public WebviewComponent(Composite parent, int style) {
        super(parent, style);
        ComponentUtil.setFillLayout((Control)this, 512);
        this.init();
    }

    protected void init() {
        this.initBrowser();
        this.registerListeners();
    }

    public void dispose() {
        this.unregisterListeners();
        super.dispose();
    }

    protected void registerListeners() {
        ColorUtil.onThemeChange(this.themeChangeListener);
    }

    protected void unregisterListeners() {
        ColorUtil.offThemeChange(this.themeChangeListener);
    }

    protected void initBrowser() {
        ComponentUtil.removeAllChildren(this);
        this.browser = ComponentBuilder.browser(this).defaultBrowserConfig().build();
        this.browser.requestLayout();
        for (ComponentUtil.BrowserLoadedListener listener : this.onLoadedListeners) {
            ComponentUtil.onBrowserLoaded(this.browser, listener);
        }
        ComponentUtil.onBrowserLoaded(this.browser, browser -> this.handleBrowserLoaded());
    }

    public void loadFromURL(String url) {
        this.browser.setUrl(url);
    }

    public void loadFromURL(URL url) {
        this.browser.setUrl(url.toString());
    }

    public void loadFromURL(URI uri) throws MalformedURLException {
        this.browser.setUrl(uri.toURL().toString());
    }

    public void loadFromFile(String filePath) {
        String url = new File(filePath).toURI().toString();
        this.loadFromURL(url);
    }

    public void loadFromFile(File file) {
        String url = file.toURI().toString();
        this.loadFromURL(url);
    }

    public void loadFromText(String html) {
        this.browser.setText(html, true);
    }

    public void loadFromFileText(File file) throws IOException {
        String html = FileUtils.readFileToString((File)file, (Charset)Charset.forName("UTF-8"));
        this.loadFromText(html);
    }

    protected void handleBrowserEvent(String event, Object data) {
        this.emitter.emit(event, data);
    }

    protected void handleBrowserLoaded() {
        this.attachBrowserFunctions();
        this.syncTheme();
    }

    protected void attachBrowserFunctions() {
        for (Map.Entry<String, ComponentUtil.BrowserFunctionHandler> browserFunction : this.browserFunctions.entrySet()) {
            ComponentUtil.defineBrowserFunction(this.browser, browserFunction.getKey(), browserFunction.getValue());
        }
        ComponentUtil.defineBrowserFunction(this.browser, NOTIFY_EVENT_METHOD_NAME, params -> {
            void event;
            Object object;
            if (params.length < 2 || !((object = params[0]) instanceof String)) {
                return false;
            }
            String string = (String)object;
            this.handleBrowserEvent((String)event, params[1]);
            return true;
        });
    }

    protected void syncTheme() {
        this.setTheme(ColorUtil.isDarkTheme() ? "dark" : "light");
    }

    public void registerBrowserFunction(String name, ComponentUtil.BrowserFunctionHandler browserFunction) {
        this.browserFunctions.put(name, browserFunction);
        if (this.browser != null) {
            ComponentUtil.defineBrowserFunction(this.browser, name, browserFunction);
        }
    }

    public void onBrowserLoaded(ComponentUtil.BrowserLoadedListener listener) {
        this.onLoadedListeners.add(listener);
        ComponentUtil.onBrowserLoaded(this.browser, listener);
    }

    public boolean isBrowserLoaded() {
        AtomicBoolean isLoaded = new AtomicBoolean(false);
        UISynchronizeService.syncExec(() -> {
            try {
                Object result = this.browser.evaluate("return document.readyState === 'complete'");
                if (result instanceof Boolean) {
                    Boolean isComplete = (Boolean)result;
                    isLoaded.set(isComplete);
                }
            }
            catch (Throwable throwable) {
                isLoaded.set(false);
            }
        });
        return isLoaded.get();
    }

    public synchronized void refreshBrowser() {
        UISynchronizeService.syncExec(() -> this.browser.refresh());
    }

    public void recreateBrowser() {
        UISynchronizeService.syncExec(() -> {
            try {
                this.browser.close();
            }
            catch (Throwable throwable) {}
            try {
                this.browser.dispose();
            }
            catch (Throwable throwable) {}
            this.browser = null;
            this.initBrowser();
        });
    }

    public void setTheme(String theme) {
        this.execute(this.buildRPCPayload("globalController", "setTheme", theme, false));
    }

    public void executeControllerMethod(String method) {
        this.execute(this.buildControllerPayload(method, null));
    }

    public void executeControllerMethod(String method, Object params) {
        this.execute(this.buildControllerPayload(method, params));
    }

    public void executeControllerMethod(String method, List<Object> params) {
        this.execute(this.buildControllerPayloadWithList(method, params));
    }

    public Object syncExecuteControllerMethod(String method) {
        return this.syncExecute(this.buildControllerPayload(method, null));
    }

    public Object syncExecuteControllerMethod(String method, Object params) {
        return this.syncExecute(this.buildControllerPayload(method, params));
    }

    public Object syncExecuteControllerMethod(String method, List<Object> params) {
        return this.syncExecute(this.buildControllerPayloadWithList(method, params));
    }

    protected String buildControllerPayload(String method, Object params) {
        return this.buildControllerPayload(method, params, false);
    }

    protected String buildControllerPayload(String method, Object params, boolean isParameterArray) {
        return this.buildRPCPayload(this.getControllerName(), method, params, isParameterArray);
    }

    protected String buildControllerPayloadWithList(String method, List<Object> params) {
        return this.buildRPCPayloadWithList(this.getControllerName(), method, params);
    }

    protected String buildRPCPayload(String instanceName, String method, Object params, boolean isParameterArray) {
        return instanceName + "." + method + "(" + (isParameterArray ? "..." : "") + this.serializeParams(params) + ")";
    }

    protected String buildRPCPayloadWithList(String instanceName, String method, List<Object> params) {
        StringBuilder sb = new StringBuilder();
        sb.append(instanceName).append(".").append(method).append("(");
        if (params != null && !params.isEmpty()) {
            int i = 0;
            while (i < params.size()) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.serializeParams(params.get(i)));
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected String serializeParams(Object params) {
        String jsonString;
        try {
            jsonString = this.objectMapper.writeValueAsString(params);
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonString = "";
        }
        return jsonString;
    }

    protected void execute(String script) {
        if (ControlUtil.isDisposed((Widget)this.browser)) {
            return;
        }
        UISynchronizeService.asyncExec(() -> {
            if (ControlUtil.isDisposed((Widget)this.browser)) {
                return;
            }
            this.browser.execute(script);
        });
    }

    protected Object syncExecute(String script) {
        if (ControlUtil.isDisposed((Widget)this.browser)) {
            return null;
        }
        Object[] result = new Object[1];
        UISynchronizeService.syncExec(() -> {
            if (ControlUtil.isDisposed((Widget)this.browser)) {
                return;
            }
            objectArray[0] = this.browser.execute(script);
        });
        return result[0];
    }
}

