/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.dialogs;

import com.kms.katalon.composer.components.constants.StringConstants;
import com.kms.katalon.composer.components.dialogs.ApplyingEditingValue;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialogCellEditor
extends DialogCellEditor
implements ApplyingEditingValue {
    protected String defaultContent;
    protected Composite editor;
    protected boolean isEditorClosed;
    private Composite parent;

    public AbstractDialogCellEditor(Composite parent) {
        this(parent, "");
    }

    public AbstractDialogCellEditor(Composite parent, String defaultContent) {
        super(parent, 0);
        this.parent = parent;
        this.isEditorClosed = false;
        this.defaultContent = defaultContent;
    }

    protected void updateContents(Object value) {
        if (this.defaultContent != null) {
            super.updateContents((Object)this.defaultContent.replace("&", "&&"));
        } else {
            super.updateContents(value);
        }
    }

    protected String getValidatorMessage(String className) {
        return MessageFormat.format(StringConstants.EDI_MSG_VALIDATOR_REQUIRE_MESSAGE, className);
    }

    protected Button createButton(Composite parent) {
        Button button = super.createButton(parent);
        button.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                AbstractDialogCellEditor.this.getControl().notifyListeners(31, e);
            }
        });
        return button;
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        super.activate(activationEvent);
        this.doShowDialog();
    }

    protected int getDoubleClickTimeout() {
        return 0;
    }

    public void deactivate() {
        super.deactivate();
        this.isEditorClosed = true;
    }

    protected void waitTofireApplyEditorValue() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!AbstractDialogCellEditor.this.isEditorClosed) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                AbstractDialogCellEditor.this.fireApplyEditorValue();
            }
        }).start();
    }

    protected void waitTofireCancelEditor() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!AbstractDialogCellEditor.this.isEditorClosed) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                AbstractDialogCellEditor.this.fireCancelEditor();
            }
        }).start();
    }

    protected void doShowDialog() {
        Object newValue = this.openDialogBox((Control)this.editor);
        if (newValue == null) {
            this.fireCancelEditor();
            return;
        }
        if (!this.isCorrect(newValue)) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), newValue.toString()));
            return;
        }
        this.markDirty();
        this.doSetValue(newValue);
        this.fireApplyEditorValue();
    }

    protected final Control createControl(Composite parent) {
        return null;
    }

    @Override
    public void applyEditingValue() {
        this.fireApplyEditorValue();
    }

    protected Shell getParentShell() {
        return this.parent.getShell();
    }
}

