/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.MessageStyle;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class MessageComponentBuilder {
    private Composite parent;
    private boolean fillHorizontal;
    private String message = "";
    private String imageKey;
    private Color backgroundColor;
    private Color borderColor;
    private MessageStyle style = MessageStyle.NONE;
    private static final Color INFORMATIVE_MESSAGE_BACKGROUND_COLOR = ColorUtil.getColor("#D3EAF5");
    private static final Color INFORMATIVE_MESSAGE_BORDER_COLOR = ColorUtil.getColor("#249CD7");
    private static final Color INFORMATIVE_MESSAGE_BACKGROUND_DARK_COLOR = ColorUtil.getColor("#2D4854");
    private static final Color INFORMATIVE_MESSAGE_BORDER_DARK_COLOR = ColorUtil.getColor("#246D91");
    private static final Color WARNING_MESSAGE_BACKGROUND_COLOR = ColorUtil.getColor("#FEF4DA");
    private static final Color WARNING_MESSAGE_BORDER_COLOR = ColorUtil.getColor("#E6B124");
    private static final Color WARNING_MESSAGE_BACKGROUND_DARK_COLOR = ColorUtil.getColor("#5E5233");
    private static final Color WARNING_MESSAGE_BORDER_DARK_COLOR = ColorUtil.getColor("#84703B");
    private static final Color ERROR_MESSAGE_BACKGROUND_COLOR = ColorUtil.getColor("#FBD8D5");
    private static final Color ERROR_MESSAGE_BORDER_COLOR = ColorUtil.getColor("#F44336");
    private static final Color ERROR_MESSAGE_BACKGROUND_DARK_COLOR = ColorUtil.getColor("#5C3530");
    private static final Color ERROR_MESSAGE_BORDER_DARK_COLOR = ColorUtil.getColor("#803416");
    private static final Color SUCCESS_MESSAGE_BACKGROUND_COLOR = ColorUtil.getColor("#E0F7E3");
    private static final Color SUCCESS_MESSAGE_BORDER_COLOR = ColorUtil.getColor("#379B3C");
    private static final Color SUCCESS_MESSAGE_BACKGROUND_DARK_COLOR = ColorUtil.getColor("#324730");
    private static final Color SUCCESS_MESSAGE_BORDER_DARK_COLOR = ColorUtil.getColor("#37703A");
    private static final Map<MessageStyle, Color> BACKGROUND_COLORS = Map.of(MessageStyle.INFO, INFORMATIVE_MESSAGE_BACKGROUND_COLOR, MessageStyle.WARNING, WARNING_MESSAGE_BACKGROUND_COLOR, MessageStyle.ERROR, ERROR_MESSAGE_BACKGROUND_COLOR, MessageStyle.SUCCESS, SUCCESS_MESSAGE_BACKGROUND_COLOR);
    private static final Map<MessageStyle, Color> BORDER_COLORS = Map.of(MessageStyle.INFO, INFORMATIVE_MESSAGE_BORDER_COLOR, MessageStyle.WARNING, WARNING_MESSAGE_BORDER_COLOR, MessageStyle.ERROR, ERROR_MESSAGE_BORDER_COLOR, MessageStyle.SUCCESS, SUCCESS_MESSAGE_BORDER_COLOR);
    private static final Map<MessageStyle, Color> BACKGROUND_DARK_COLORS = Map.of(MessageStyle.INFO, INFORMATIVE_MESSAGE_BACKGROUND_DARK_COLOR, MessageStyle.WARNING, WARNING_MESSAGE_BACKGROUND_DARK_COLOR, MessageStyle.ERROR, ERROR_MESSAGE_BACKGROUND_DARK_COLOR, MessageStyle.SUCCESS, SUCCESS_MESSAGE_BACKGROUND_DARK_COLOR);
    private static final Map<MessageStyle, Color> BORDER_DARK_COLORS = Map.of(MessageStyle.INFO, INFORMATIVE_MESSAGE_BORDER_DARK_COLOR, MessageStyle.WARNING, WARNING_MESSAGE_BORDER_DARK_COLOR, MessageStyle.ERROR, ERROR_MESSAGE_BORDER_DARK_COLOR, MessageStyle.SUCCESS, SUCCESS_MESSAGE_BORDER_DARK_COLOR);
    private static final int BORDER_RADIUS = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int ICON_SIZE = 16;

    public static MessageComponentBuilder create() {
        return new MessageComponentBuilder();
    }

    public MessageComponentBuilder parent(Composite parent) {
        this.parent = parent;
        return this;
    }

    public MessageComponentBuilder fillHorizontal(boolean fillHorizontal) {
        this.fillHorizontal = fillHorizontal;
        return this;
    }

    public MessageComponentBuilder message(String message) {
        this.message = message;
        return this;
    }

    public MessageComponentBuilder imageKey(String imageKey) {
        this.imageKey = imageKey;
        return this;
    }

    public MessageComponentBuilder backgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public MessageComponentBuilder borderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public MessageComponentBuilder style(MessageStyle style) {
        this.style = style;
        return this;
    }

    public MessageComponentBuilder infoStyle() {
        this.style = MessageStyle.INFO;
        this.imageKey = "info_status_32.png";
        return this;
    }

    public MessageComponentBuilder warningStyle() {
        this.style = MessageStyle.WARNING;
        this.imageKey = "warning_status_32.png";
        return this;
    }

    public MessageComponentBuilder errorStyle() {
        this.style = MessageStyle.ERROR;
        this.imageKey = "error_status_32.png";
        return this;
    }

    public MessageComponentBuilder successStyle() {
        this.style = MessageStyle.SUCCESS;
        this.imageKey = "success_status_32.png";
        return this;
    }

    public Composite build() {
        ComponentBuilder<Composite> messageBuilder = ComponentBuilder.gridContainer(this.parent, 2).margin(8).backgroundMode(2);
        if (this.fillHorizontal) {
            messageBuilder = messageBuilder.fillHorizontal();
        }
        Composite messageComposite = messageBuilder.build();
        if (this.style != MessageStyle.NONE) {
            if (this.backgroundColor == null) {
                this.backgroundColor = this.getBackgroundColor();
            }
            if (this.borderColor == null) {
                this.borderColor = this.getBorderColor();
            }
            messageComposite.addPaintListener(e -> {
                GC gc = e.gc;
                Rectangle bounds = messageComposite.getBounds();
                gc.setAntialias(1);
                gc.setBackground(this.backgroundColor);
                gc.fillRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, 8, 8);
                gc.setForeground(this.borderColor);
                gc.setLineWidth(1);
                gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, 8, 8);
            });
        }
        if (this.imageKey != null) {
            ComponentBuilder.image(messageComposite, this.imageKey).size(16, 16).top().build();
        }
        final Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(this.message);
        messageLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                messageLabel.setBackground(MessageComponentBuilder.this.backgroundColor);
                messageLabel.setForeground(MessageComponentBuilder.this.getTextColor());
            }
        });
        messageLabel.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        return messageComposite;
    }

    private Color getTextColor() {
        if (ColorUtil.isDarkTheme()) {
            return ColorUtil.WHITE_COLOR;
        }
        return ColorUtil.BLACK_COLOR;
    }

    private Color getBackgroundColor() {
        if (ColorUtil.isDarkTheme()) {
            return BACKGROUND_DARK_COLORS.get((Object)this.style);
        }
        return BACKGROUND_COLORS.get((Object)this.style);
    }

    private Color getBorderColor() {
        if (ColorUtil.isDarkTheme()) {
            return BORDER_DARK_COLORS.get((Object)this.style);
        }
        return BORDER_COLORS.get((Object)this.style);
    }
}

