/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.util.ComponentDataUtil;
import com.kms.katalon.composer.components.util.ComponentFinder;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.core.util.ArrayUtil;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ShellManager {
    private static Shell lastActiveShell = null;
    private static Shell mainShell = null;
    private static Listener shellActivateListener = event -> {
        if (ControlUtil.isDisposed((Widget)ShellManager.getMainShell())) {
            ShellManager.storeMainShell(Display.getCurrent().getActiveShell());
        }
        lastActiveShell = Display.getCurrent().getActiveShell();
    };

    public static void init() {
        Display.getCurrent().addFilter(26, shellActivateListener);
    }

    public static void destroy() {
        Display display = Display.getCurrent();
        if (display != null && !display.isDisposed()) {
            display.removeFilter(26, shellActivateListener);
        }
    }

    public static void storeMainShell(Shell activeShell) {
        if (activeShell == null) {
            return;
        }
        mainShell = activeShell;
        while (mainShell.getParent() != null) {
            mainShell = (Shell)mainShell.getParent();
        }
    }

    public static Shell getMainShell() {
        return mainShell;
    }

    public static Shell getLastActiveShell() {
        return lastActiveShell;
    }

    public static Shell getLastActiveAliveShell() {
        return !ControlUtil.isDisposed((Widget)lastActiveShell) ? lastActiveShell : ShellManager.getMainShell();
    }

    public static Shell[] getShells() {
        return Display.getCurrent().getShells();
    }

    public static Shell getWebRecorderDialog() {
        Object[] shells = ShellManager.getMainShell().getDisplay().getShells();
        return (Shell)ArrayUtil.find((Object[])shells, shell -> !shell.isDisposed() && StringUtils.equals((String)ComponentDataUtil.getAnyText((Widget)shell), (String)"Web Recorder"));
    }

    public static Shell getTestObjectsSavingDialog() {
        Object[] shells = ShellManager.getMainShell().getDisplay().getShells();
        return (Shell)ArrayUtil.find((Object[])shells, shell -> !shell.isDisposed() && StringUtils.equals((String)ComponentDataUtil.getAnyText((Widget)shell), (String)"Add Element to Object Repository"));
    }

    public static Shell getTestCaseSavingDialog() {
        Object[] shells = ShellManager.getMainShell().getDisplay().getShells();
        return (Shell)ArrayUtil.find((Object[])shells, shell -> {
            if (shell.isDisposed() || !StringUtils.equals((String)ComponentDataUtil.getAnyText((Widget)shell), (String)"New")) {
                return false;
            }
            Text createTestCaseLabel = ComponentFinder.findByTypeAndText((Widget)shell, Text.class, "Create Test Case");
            return createTestCaseLabel != null;
        });
    }

    public static Shell getTestSuiteSavingDialog() {
        Object[] shells = ShellManager.getMainShell().getDisplay().getShells();
        return (Shell)ArrayUtil.find((Object[])shells, shell -> {
            if (shell.isDisposed() || !StringUtils.equals((String)ComponentDataUtil.getAnyText((Widget)shell), (String)"New")) {
                return false;
            }
            Text createSuiteCaseLabel = ComponentFinder.findByTypeAndText((Widget)shell, Text.class, "Create Test Suite");
            return createSuiteCaseLabel != null;
        });
    }

    public static Shell getTestCaseBrowserDialog() {
        Object[] shells = ShellManager.getMainShell().getDisplay().getShells();
        return (Shell)ArrayUtil.find((Object[])shells, shell -> !shell.isDisposed() && StringUtils.equals((String)ComponentDataUtil.getAnyText((Widget)shell), (String)"Test Case Browser"));
    }

    public static Shell getTestOpsInterationDialog() {
        Object[] shells = ShellManager.getMainShell().getDisplay().getShells();
        return (Shell)ArrayUtil.find((Object[])shells, shell -> !shell.isDisposed() && StringUtils.equals((String)ComponentDataUtil.getAnyText((Widget)shell), (String)"Katalon Platform Integration"));
    }

    public static Shell getNewDialog() {
        Object[] shells = ShellManager.getMainShell().getDisplay().getShells();
        return (Shell)ArrayUtil.find((Object[])shells, shell -> !shell.isDisposed() && StringUtils.equals((String)ComponentDataUtil.getAnyText((Widget)shell), (String)"New"));
    }
}

