/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.util;

import com.kms.katalon.composer.components.constants.ComposerComponentsMessageConstants;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.core.util.TimeUtil;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public class UITimeUtil
extends TimeUtil {
    public static final long DEFAULT_WAIT_FOR_TIMEOUT = 0L;
    public static final long DEFAULT_WAIT_FOR_INTERVAL = 300L;

    public static Timer setInterval(TimeUtil.IntervalCallback callback, long interval) {
        return UITimeUtil.setInterval(callback, interval, 0L);
    }

    public static Timer setInterval(TimeUtil.IntervalCallback callback, long interval, long duration) {
        return TimeUtil.setInterval(timer -> UISynchronizeService.asyncExec(() -> callback.call(timer)), (long)interval, (long)duration);
    }

    public static Timer setIntervalSync(TimeUtil.IntervalCallback callback, long interval) {
        return UITimeUtil.setIntervalSync(callback, interval, 0L);
    }

    public static Timer setIntervalSync(TimeUtil.IntervalCallback callback, long interval, long duration) {
        return TimeUtil.setInterval(timer -> UISynchronizeService.syncExec(() -> callback.call(timer)), (long)interval, (long)duration);
    }

    public static Timer setTimeout(TimeUtil.TimeoutCallback callback, long timeout) {
        return TimeUtil.setTimeout(() -> UISynchronizeService.asyncExec(() -> callback.call()), (long)timeout);
    }

    public static Timer waitFor(WaitForCondition test) {
        return UITimeUtil.waitFor(test, 0L);
    }

    public static Timer waitFor(WaitForCondition test, long timeout) {
        return UITimeUtil.waitFor(test, timeout, 300L);
    }

    public static Timer waitFor(WaitForCondition test, long timeout, long interval) {
        return UITimeUtil.waitFor(test, null, timeout, interval);
    }

    public static Timer waitFor(WaitForCondition test, Runnable callback) {
        return UITimeUtil.waitFor(test, callback, 0L);
    }

    public static Timer waitFor(WaitForCondition test, Runnable callback, long timeout) {
        return UITimeUtil.waitFor(test, callback, null, timeout, 300L);
    }

    public static Timer waitFor(WaitForCondition test, Runnable callback, long timeout, long interval) {
        return UITimeUtil.waitFor(test, callback, null, timeout, interval);
    }

    public static Timer waitFor(WaitForCondition test, Runnable callback, Runnable onNotFound, long timeout, long interval) {
        return UITimeUtil.setIntervalSync(timer -> {
            Timer timer2 = timer;
            synchronized (timer2) {
                if (!UITimeUtil.isCanceled((Timer)timer) && test.test(timer)) {
                    timer.cancel();
                    timer.purge();
                    if (callback != null) {
                        UISynchronizeService.asyncExec(() -> callback.run());
                    }
                }
            }
        }, interval, timeout);
    }

    public static Timer waitForAsync(WaitForCondition test, Runnable callback, long timeout, long interval) {
        return UITimeUtil.waitForAsync(test, callback, null, timeout, interval);
    }

    public static Timer waitForAsync(WaitForCondition test, Runnable callback, Runnable onNotFound, long timeout, long interval) {
        return UITimeUtil.setInterval(timer -> {
            Timer timer2 = timer;
            synchronized (timer2) {
                if (!UITimeUtil.isCanceled((Timer)timer) && test.test(timer)) {
                    timer.cancel();
                    timer.purge();
                    callback.run();
                }
            }
        }, interval, timeout);
    }

    public static Disposable waitForWithTimeout(Predicate<Object> test, Runnable onSuccess, Runnable onTimeout, long timeout) {
        return UITimeUtil.waitForWithTimeout(test, onSuccess, onTimeout, timeout, 300L);
    }

    public static Disposable waitForWithTimeout(Predicate<Object> test, Runnable onSuccess, Runnable onError, long timeoutMillis, long checkIntervalMillis) {
        return Observable.interval((long)0L, (long)checkIntervalMillis, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).flatMap(tick -> Observable.fromCallable(() -> {
            try {
                return test.test(null);
            }
            catch (Exception exception) {
                return false;
            }
        }).subscribeOn(Schedulers.computation())).filter(conditionResult -> conditionResult).take(1L).timeout(timeoutMillis, TimeUnit.MILLISECONDS).subscribe(conditionResult -> onSuccess.run(), error -> {
            if (error instanceof TimeoutException) {
                onError.run();
            } else {
                LoggerSingleton.logError(MessageFormat.format(ComposerComponentsMessageConstants.UITIMER_LOG_WAIT_FOR_WITH_TIMEOUT_ERROR, error.getMessage()));
                onError.run();
            }
        });
    }

    public static interface WaitForCondition {
        public boolean test(Timer var1);
    }
}

