/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.dal.fileservice.manager;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.dal.fileservice.EntityService;
import com.kms.katalon.dal.fileservice.FileServiceConstant;
import com.kms.katalon.dal.fileservice.constants.StringConstants;
import com.kms.katalon.dal.fileservice.dataprovider.WindowsElementFileServiceDataProvider;
import com.kms.katalon.dal.fileservice.dataprovider.setting.FileServiceDataProviderSetting;
import com.kms.katalon.dal.fileservice.manager.CheckpointFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.DataFileFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.FolderFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestCaseFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.TestSuiteFileServiceManager;
import com.kms.katalon.dal.fileservice.manager.WebElementFileServiceManager;
import com.kms.katalon.dal.fileservice.strategies.IEntityLoadStrategy;
import com.kms.katalon.dal.fileservice.util.PathValidationUtil;
import com.kms.katalon.dal.state.DataProviderState;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;

public class EntityFileServiceManager {
    private static final String[] EXCLUDED_FOLDER = new String[]{".svn", ".meta", ".DS_Store", ".git"};
    public static final FileFilter fileFilter = new FileFilter(){
        List<String> excludedList = Arrays.asList(EXCLUDED_FOLDER);

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return !this.excludedList.contains(file.getName());
        }
    };
    private static final FileFilter fileFilterWithoutGroovy = new FileFilter(){
        List<String> excludedList = Arrays.asList(EXCLUDED_FOLDER);

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return !this.excludedList.contains(file.getName()) && !file.getName().endsWith(".groovy");
        }
    };

    public static FileEntity get(File localFile) throws Exception {
        return EntityFileServiceManager.get(localFile, null);
    }

    public static FileEntity get(File localFile, IEntityLoadStrategy entityLoadStrategy) throws Exception {
        if (localFile != null && localFile.exists()) {
            FileEntity entity = null;
            if (localFile.isDirectory()) {
                if (EntityService.getInstance().findEntityInCache(localFile.getAbsolutePath()) != null) {
                    entity = EntityService.getInstance().findEntityInCache(localFile.getAbsolutePath());
                    EntityFileServiceManager.setParentFolder(entity, localFile);
                } else {
                    entity = EntityFileServiceManager.loadFolder(localFile);
                    EntityFileServiceManager.setParentFolder(entity, localFile);
                    EntityService.getInstance().getEntityCache().put(entity.getLocation(), entity);
                }
            } else if (localFile.isFile()) {
                entity = EntityService.getInstance().getEntityByPath(localFile.getAbsolutePath(), entityLoadStrategy);
                EntityFileServiceManager.setParentFolder(entity, localFile);
                EntityFileServiceManager.init(entity);
            }
            return entity;
        }
        return null;
    }

    public static FolderEntity getFolder(File localFile) throws Exception {
        if (localFile == null || !localFile.exists()) {
            return null;
        }
        FolderEntity entity = null;
        if (EntityService.getInstance().findEntityInCache(localFile.getAbsolutePath()) != null) {
            entity = (FolderEntity)EntityService.getInstance().findEntityInCache(localFile.getAbsolutePath());
        } else {
            entity = new FolderEntity();
            entity.setName(localFile.getName());
        }
        EntityFileServiceManager.setParentFolder((FileEntity)entity, localFile);
        EntityService.getInstance().getEntityCache().put(entity.getLocation(), (FileEntity)entity);
        return entity;
    }

    private static FileEntity loadFolder(File folderFile) throws Exception {
        if (folderFile == null || !folderFile.exists() || !folderFile.isDirectory()) {
            return null;
        }
        File folderMetaDataFile = new File(folderFile, FolderEntity.getMetaDataFileExtension());
        FolderEntity folderEntity = null;
        if (folderMetaDataFile.exists() && (folderEntity = EntityService.getInstance().getEntityByPath(folderMetaDataFile.getAbsolutePath())) instanceof FolderEntity) {
            return folderEntity;
        }
        folderEntity = new FolderEntity();
        folderEntity.setName(folderFile.getName());
        return folderEntity;
    }

    private static void setParentFolder(FileEntity entity, File localFile) throws Exception {
        if (entity != null && entity.getParentFolder() == null && localFile != null && localFile.exists()) {
            String parentFolderLocation = localFile.getParent();
            FolderEntity parentFolder = (FolderEntity)EntityService.getInstance().findEntityInCache(parentFolderLocation);
            if (parentFolder != null) {
                entity.setParentFolder(parentFolder);
                entity.setProject(parentFolder.getProject());
                if (entity instanceof FolderEntity) {
                    ((FolderEntity)entity).setFolderType(parentFolder.getFolderType());
                }
            } else {
                ProjectEntity currentProject = DataProviderState.getInstance().getCurrentProject();
                if (currentProject == null) {
                    return;
                }
                String projectFolderLocation = currentProject.getFolderLocation();
                if (!parentFolderLocation.toLowerCase().equalsIgnoreCase(projectFolderLocation.toLowerCase()) && !parentFolderLocation.toLowerCase().startsWith(projectFolderLocation.toLowerCase() + File.separator)) {
                    return;
                }
                if (projectFolderLocation.equalsIgnoreCase(parentFolderLocation) && entity instanceof FolderEntity) {
                    String fileName = localFile.getName();
                    FolderEntity folderEntity = (FolderEntity)entity;
                    if (FileServiceConstant.TEST_CASE_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.TESTCASE);
                    } else if (FileServiceConstant.TEST_SUITE_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.TESTSUITE);
                    } else if (FileServiceConstant.OBJECT_REPOSITORY_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.WEBELEMENT);
                    } else if (FileServiceConstant.DATA_FILE_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.DATAFILE);
                    } else if (FileServiceConstant.CHECKPOINT_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.CHECKPOINT);
                    } else if (FileServiceConstant.KEYWORD_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.KEYWORD);
                    } else if (FileServiceConstant.REPORT_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.REPORT);
                    } else if (FileServiceConstant.INCLUDE_SCRIPT_ROOT_FOLDER_NAME.equals(fileName)) {
                        folderEntity.setFolderType(FolderEntity.FolderType.INCLUDE);
                    }
                    folderEntity.setProject(currentProject);
                } else {
                    parentFolder = (FolderEntity)EntityFileServiceManager.loadFolder(localFile.getParentFile());
                    parentFolder.setProject(currentProject);
                    EntityFileServiceManager.setParentFolder((FileEntity)parentFolder, localFile.getParentFile());
                    if (entity instanceof FolderEntity) {
                        ((FolderEntity)entity).setFolderType(parentFolder.getFolderType());
                    }
                    entity.setParentFolder(parentFolder);
                    entity.setProject(parentFolder.getProject());
                    EntityService.getInstance().getEntityCache().put(parentFolder.getLocation(), (FileEntity)parentFolder);
                }
            }
        }
    }

    private static void init(FileEntity entity) throws Exception {
        if (entity instanceof TestSuiteEntity) {
            TestSuiteFileServiceManager.initTestSuite((TestSuiteEntity)entity);
        } else if (entity instanceof DataFileEntity) {
            DataFileFileServiceManager.initTestData((DataFileEntity)entity);
        } else if (entity instanceof TestCaseEntity) {
            TestCaseFileServiceManager.initTestCase((TestCaseEntity)entity);
        }
    }

    public static <T extends FileEntity> List<T> getChildren(FolderEntity parentFolder, Class<T> clazz) throws Exception {
        if (parentFolder != null) {
            ArrayList<FileEntity> childrenEntities = new ArrayList<FileEntity>();
            File localFolder = new File(parentFolder.getLocation());
            if (localFolder.exists() && localFolder.isDirectory()) {
                File[] fileArray = localFolder.listFiles(fileFilterWithoutGroovy);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File localFile = fileArray[n2];
                    try {
                        FileEntity fileEntity = EntityFileServiceManager.get(localFile);
                        if (fileEntity != null && clazz.isInstance(fileEntity)) {
                            childrenEntities.add((FileEntity)clazz.cast(fileEntity));
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
            return childrenEntities;
        }
        return Collections.emptyList();
    }

    public static List<File> getFileChildren(FolderEntity parentFolder) throws Exception {
        if (parentFolder != null) {
            ArrayList<File> childrenEntities = new ArrayList<File>();
            File localFolder = new File(parentFolder.getLocation());
            if (localFolder.exists() && localFolder.isDirectory()) {
                File[] fileArray = localFolder.listFiles(fileFilter);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File localFile = fileArray[n2];
                    try {
                        childrenEntities.add(localFile);
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
            return childrenEntities;
        }
        return Collections.emptyList();
    }

    public static <T extends FileEntity> List<T> getDescendants(FolderEntity parentFolder, Class<T> clazz) throws Exception {
        return EntityFileServiceManager.getDescendants(parentFolder, clazz, null);
    }

    public static <T extends FileEntity> List<T> getDescendants(FolderEntity parentFolder, Class<T> clazz, IEntityLoadStrategy entityLoadStrategy) throws Exception {
        if (parentFolder == null) {
            throw new IllegalArgumentException("Folder cannot be null");
        }
        ArrayList<Object> childrenEntities = new ArrayList<Object>();
        File localFolder = new File(parentFolder.getLocation());
        if (localFolder.exists() && localFolder.isDirectory()) {
            File[] fileArray = localFolder.listFiles(fileFilterWithoutGroovy);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    File localFile = fileArray[n2];
                    FileEntity fileEntity = null;
                    try {
                        fileEntity = EntityFileServiceManager.get(localFile, entityLoadStrategy);
                    }
                    catch (UnmarshalException unmarshalException) {
                        break block7;
                    }
                    if (fileEntity != null && clazz.isInstance(fileEntity)) {
                        childrenEntities.add((FileEntity)clazz.cast(fileEntity));
                    }
                    if (fileEntity instanceof FolderEntity) {
                        childrenEntities.addAll(EntityFileServiceManager.getDescendants((FolderEntity)fileEntity, clazz, entityLoadStrategy));
                    }
                }
                ++n2;
            }
        }
        return childrenEntities;
    }

    public static void delete(FileEntity entity) throws Exception {
        if (entity != null) {
            EntityService.getInstance().deleteEntity(entity);
        }
    }

    public static void deleteFolder(FolderEntity folder) throws Exception {
        if (folder != null) {
            if (folder.getFolderType() != FolderEntity.FolderType.USER) {
                List<FileEntity> childEntities = EntityFileServiceManager.getChildren(folder, FileEntity.class);
                for (FileEntity childEntity : childEntities) {
                    if (childEntity instanceof FolderEntity) {
                        EntityFileServiceManager.deleteFolder((FolderEntity)childEntity);
                        continue;
                    }
                    EntityFileServiceManager.delete(childEntity);
                }
            }
            EntityService.getInstance().deleteEntity((FileEntity)folder);
        }
    }

    private static void deleteScriptFolderRecursively(File folder) {
        if (folder == null || !folder.exists() || !folder.isDirectory() || folder.getName().equals(StringConstants.TEST_CASE_SCRIPT_ROOT_FOLDER_NAME)) {
            return;
        }
        if (!ArrayUtils.isEmpty((Object[])folder.list())) {
            return;
        }
        FileUtils.deleteQuietly((File)folder);
        EntityFileServiceManager.deleteScriptFolderRecursively(folder.getParentFile());
    }

    public static <T extends FileEntity> T copy(T entity, FolderEntity destinationFolder) throws Exception {
        if (entity != null && destinationFolder != null) {
            FileEntity clonedEntity = (FileEntity)entity.clone();
            File fEntity = new File(destinationFolder.getLocation() + File.separator + entity.getName() + entity.getFileExtension());
            if (fEntity.exists()) {
                Object name = entity.getName() + " - Copy";
                name = EntityService.getInstance().getAvailableName(destinationFolder.getLocation(), (String)name, true);
                clonedEntity.setName((String)name);
            }
            clonedEntity.setParentFolder(destinationFolder);
            clonedEntity.setProject(destinationFolder.getProject());
            EntityFileServiceManager.validateEntityFilePathLength(clonedEntity, clonedEntity.getName(), destinationFolder);
            if (clonedEntity instanceof IntegratedFileEntity) {
                IntegratedFileEntity integratedEntity = (IntegratedFileEntity)clonedEntity;
                integratedEntity.getIntegratedEntities().clear();
            }
            EntityService.getInstance().saveEntity(clonedEntity);
            return (T)clonedEntity;
        }
        return null;
    }

    public static FolderEntity copyFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        if (folder != null && destinationFolder != null) {
            FolderEntity clonedFolder = folder.clone();
            File fFolder = new File(destinationFolder.getLocation() + File.separator + folder.getName());
            if (fFolder.exists()) {
                String name = EntityService.getInstance().getAvailableName(destinationFolder.getLocation(), folder.getName() + " - Copy", false);
                clonedFolder.setName(name);
            }
            clonedFolder.setParentFolder(destinationFolder);
            clonedFolder.setProject(destinationFolder.getProject());
            clonedFolder.getIntegratedEntities().clear();
            File sourceFolder = new File(folder.getLocation());
            File destinationFolderFile = new File(clonedFolder.getLocation());
            if (sourceFolder.exists() && sourceFolder.isDirectory()) {
                FileUtils.copyDirectory((File)sourceFolder, (File)destinationFolderFile);
            }
            EntityService.getInstance().saveIntergratedFolderMetadataEntity((IntegratedFileEntity)clonedFolder);
            return clonedFolder;
        }
        return null;
    }

    public static FolderEntity copyKeywordFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        if (folder != null && destinationFolder != null) {
            FolderEntity clonedFolder = folder.clone();
            File fFolder = new File(destinationFolder.getLocation() + File.separator + folder.getName());
            if (fFolder.exists()) {
                String name = EntityService.getInstance().getAvailableName(destinationFolder.getLocation(), folder.getName() + "_copy", false);
                clonedFolder.setName(name);
            }
            clonedFolder.setParentFolder(destinationFolder);
            clonedFolder.setProject(destinationFolder.getProject());
            clonedFolder.getIntegratedEntities().clear();
            EntityService.getInstance().saveEntity((FileEntity)clonedFolder);
            for (File entity : FolderFileServiceManager.getFileChildren(folder)) {
                if (entity.isDirectory()) {
                    FolderEntity tmpFolder = FolderFileServiceManager.getFolder(entity.getAbsolutePath());
                    if (tmpFolder.getLocation() == null) {
                        tmpFolder.setName(entity.getAbsolutePath());
                    }
                    EntityFileServiceManager.copyKeywordFolder(tmpFolder, clonedFolder);
                    continue;
                }
                Files.copy(Paths.get(entity.getPath(), new String[0]), Paths.get(clonedFolder.getLocation() + File.separator + entity.getName(), new String[0]), new CopyOption[0]);
            }
            return clonedFolder;
        }
        return null;
    }

    public static <T extends FileEntity> T move(T entity, FolderEntity destinationFolder) throws Exception {
        if (entity != null && destinationFolder != null) {
            String newName;
            String oldName = entity.getName();
            if (!oldName.equals(newName = EntityService.getInstance().getAvailableName(destinationFolder.getLocation(), oldName, true))) {
                EntityService.getInstance().deleteEntity(entity);
                EntityFileServiceManager.rename(entity, newName);
            }
            EntityFileServiceManager.validateEntityFilePathLength(entity, newName, destinationFolder);
            File sourceFile = new File(entity.getLocation());
            File destinationFile = new File(destinationFolder.getLocation());
            if (sourceFile.exists() && destinationFile.exists() && destinationFile.isDirectory()) {
                EntityService.getInstance().getEntityCache().remove(entity, false);
                FileUtils.moveFileToDirectory((File)sourceFile, (File)destinationFile, (boolean)false);
            }
            entity.setParentFolder(destinationFolder);
            entity.setProject(destinationFolder.getProject());
            entity.setName(newName);
            if (entity instanceof IntegratedFileEntity) {
                IntegratedFileEntity integratedEntity = (IntegratedFileEntity)entity;
                List integratedEntities = integratedEntity.getIntegratedEntities();
                integratedEntities = integratedEntities.stream().filter(e -> !e.getProductName().equals(GlobalStringConstants.AZURE_DEVOPS_NAME)).collect(Collectors.toList());
                integratedEntities.clear();
            }
            EntityService.getInstance().saveEntity(entity);
            return entity;
        }
        return null;
    }

    public static <T extends FileEntity> T move(T entity, FolderEntity destinationFolder, String newName) throws Exception {
        if (entity != null && destinationFolder != null) {
            EntityFileServiceManager.validateEntityFilePathLength(entity, newName, destinationFolder);
            String oldName = entity.getName();
            if (!oldName.equals(newName)) {
                EntityService.getInstance().deleteEntity(entity);
                EntityFileServiceManager.rename(entity, newName);
            }
            File sourceFile = new File(entity.getLocation());
            File destinationFile = new File(destinationFolder.getLocation());
            if (sourceFile.exists() && destinationFile.exists() && destinationFile.isDirectory()) {
                EntityService.getInstance().getEntityCache().remove(entity, false);
                FileUtils.moveFileToDirectory((File)sourceFile, (File)destinationFile, (boolean)false);
            }
            entity.setParentFolder(destinationFolder);
            entity.setProject(destinationFolder.getProject());
            entity.setName(newName);
            if (entity instanceof IntegratedFileEntity) {
                IntegratedFileEntity integratedEntity = (IntegratedFileEntity)entity;
                List integratedEntities = integratedEntity.getIntegratedEntities();
                integratedEntities = integratedEntities.stream().filter(e -> !e.getProductName().equals(GlobalStringConstants.AZURE_DEVOPS_NAME)).collect(Collectors.toList());
                integratedEntities.clear();
            }
            EntityService.getInstance().saveEntity(entity);
            return entity;
        }
        return null;
    }

    public static FolderEntity moveFolder(FolderEntity folder, FolderEntity destinationFolder) throws Exception {
        if (folder != null && destinationFolder != null) {
            ApiCollectionEntity newFolder;
            String newName = EntityService.getInstance().getAvailableName(destinationFolder.getLocation(), folder.getName(), false);
            EntityFileServiceManager.validateEntityFilePathLength(folder, newName, destinationFolder);
            if (folder instanceof ApiCollectionEntity) {
                newFolder = new ApiCollectionEntity();
                ApiCollectionEntity sourceApiCollection = (ApiCollectionEntity)folder;
                ApiCollectionEntity targetApiCollection = newFolder;
                targetApiCollection.setCollectionType(sourceApiCollection.getCollectionType());
                targetApiCollection.setAuthorization(sourceApiCollection.getAuthorization());
            } else {
                newFolder = new FolderEntity();
            }
            newFolder.setParentFolder(destinationFolder);
            newFolder.setProject(destinationFolder.getProject());
            newFolder.setName(newName);
            newFolder.setFolderType(destinationFolder.getFolderType());
            newFolder.getIntegratedEntities().clear();
            EntityService.getInstance().saveEntity((FileEntity)newFolder);
            for (FileEntity childEntity : EntityFileServiceManager.getChildren(folder, FileEntity.class)) {
                if (childEntity instanceof TestCaseEntity) {
                    try {
                        TestCaseFileServiceManager.moveTestCase((TestCaseEntity)childEntity, (FolderEntity)newFolder);
                        continue;
                    }
                    catch (Exception e) {
                        EntityService.getInstance().deleteEntity((FileEntity)newFolder);
                        throw e;
                    }
                }
                if (childEntity instanceof TestSuiteEntity) {
                    TestSuiteFileServiceManager.moveTestSuite((TestSuiteEntity)childEntity, (FolderEntity)newFolder);
                    continue;
                }
                if (childEntity instanceof DataFileEntity) {
                    DataFileFileServiceManager.moveDataFile((DataFileEntity)childEntity, (FolderEntity)newFolder);
                }
                if (childEntity instanceof WebElementEntity) {
                    WebElementFileServiceManager.moveWebElement((WebElementEntity)childEntity, (FolderEntity)newFolder);
                    continue;
                }
                if (childEntity instanceof TestSuiteCollectionEntity) {
                    new FileServiceDataProviderSetting().getTestSuiteCollectionDataProvider().move(childEntity.getId(), (FolderEntity)newFolder);
                    continue;
                }
                if (childEntity instanceof CheckpointEntity) {
                    CheckpointFileServiceManager.move((CheckpointEntity)childEntity, (FolderEntity)newFolder);
                    continue;
                }
                if (childEntity instanceof WindowsElementEntity) {
                    new WindowsElementFileServiceDataProvider().move(childEntity.getId(), (FolderEntity)newFolder);
                }
                if (childEntity instanceof ApiCollectionEntity) {
                    EntityFileServiceManager.moveFolder((FolderEntity)((ApiCollectionEntity)childEntity), (FolderEntity)newFolder);
                    continue;
                }
                if (!(childEntity instanceof FolderEntity)) continue;
                EntityFileServiceManager.moveFolder((FolderEntity)childEntity, (FolderEntity)newFolder);
            }
            EntityService.getInstance().getEntityCache().remove((FileEntity)folder, false);
            File folderFile = new File(folder.getLocation());
            if (folderFile.exists() && folderFile.isDirectory()) {
                FileUtils.deleteDirectory((File)new File(folder.getLocation()));
            }
            File oldScriptFolderFile = new File(folder.getProject().getFolderLocation() + File.separator + GroovyUtil.getScriptPackageRelativePathForFolder((FolderEntity)folder));
            EntityFileServiceManager.deleteScriptFolderRecursively(oldScriptFolderFile);
            return newFolder;
        }
        return null;
    }

    public static void rename(FileEntity entity, String newName) throws Exception {
        File file = new File(entity.getLocation());
        if (file.exists()) {
            EntityService.getInstance().getEntityCache().remove(entity, false);
            file.renameTo(new File(newName));
            entity.setName(newName);
            EntityService.getInstance().saveEntity(entity);
        }
    }

    public static boolean update(FileEntity entity) throws Exception {
        if (entity == null) {
            return false;
        }
        File file = new File(entity.getLocation());
        if (!file.exists()) {
            return false;
        }
        return EntityService.getInstance().saveEntity(entity);
    }

    public static String toXmlString(Object entity) throws Exception {
        return EntityService.getInstance().toXmlString(entity);
    }

    public static <T> T toEntity(String xmlString, Class<T> clazz) throws Exception {
        return EntityService.getInstance().toEntity(xmlString, clazz);
    }

    private static <T extends FileEntity> void validateEntityFilePathLength(T fileEntity, String newName, FolderEntity destinationFolder) throws Exception {
        FileEntity entity = (FileEntity)fileEntity.clone();
        entity.setName(newName);
        if (Objects.nonNull(destinationFolder)) {
            entity.setParentFolder(destinationFolder);
            entity.setProject(destinationFolder.getProject());
        }
        PathValidationUtil.validatePathLength(entity);
    }
}

