/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.tracking.domain.model;

import com.katalon.tracking.domain.model.Account;
import com.katalon.tracking.domain.model.Application;
import com.katalon.tracking.domain.model.Host;
import com.katalon.tracking.domain.model.License;
import com.katalon.tracking.domain.model.Organization;
import com.katalon.tracking.domain.model.Os;
import com.katalon.tracking.domain.model.Session;

public class KatalonStudioContext {
    private final Os os;
    private final Host host;
    private final Application application;
    private final Account account;
    private final Organization organization;
    private final License license;
    private final Session session;

    private KatalonStudioContext(Builder builder) {
        this.os = builder.os;
        this.host = builder.host;
        this.application = builder.application;
        this.account = builder.account;
        this.organization = builder.organization;
        this.license = builder.license;
        this.session = builder.session;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Os getOs() {
        return this.os;
    }

    public Host getHost() {
        return this.host;
    }

    public Application getApplication() {
        return this.application;
    }

    public Account getAccount() {
        return this.account;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public License getLicense() {
        return this.license;
    }

    public Session getSession() {
        return this.session;
    }

    public static class Builder {
        private Os os;
        private Host host;
        private Application application;
        private Account account;
        private Organization organization;
        private License license;
        private Session session;

        public Builder os(Os os) {
            this.os = os;
            return this;
        }

        public Builder host(Host host) {
            this.host = host;
            return this;
        }

        public Builder application(Application application) {
            this.application = application;
            return this;
        }

        public Builder account(Account account) {
            this.account = account;
            return this;
        }

        public Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        public Builder license(License license) {
            this.license = license;
            return this;
        }

        public Builder session(Session session) {
            this.session = session;
            return this;
        }

        public KatalonStudioContext build() {
            return new KatalonStudioContext(this);
        }
    }
}

