/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.tracking.domain.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.katalon.tracking.domain.model.FeatureContext;
import com.katalon.tracking.domain.model.KatalonStudioContext;
import com.katalon.tracking.domain.model.TrackingData;

public class TrackingProperties {
    @JsonProperty
    private final String action;
    @JsonProperty(value="context")
    private final KatalonStudioContext ksContext;
    @JsonProperty(value="feature")
    private final FeatureContext featureContext;
    @JsonProperty(value="data")
    private final TrackingData trackingData;
    @JsonProperty
    private final long timestamp;

    private TrackingProperties(Builder builder) {
        this.action = builder.action;
        this.ksContext = builder.ksContext;
        this.featureContext = builder.featureContext;
        this.trackingData = builder.trackingData;
        this.timestamp = builder.timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String action;
        private KatalonStudioContext ksContext;
        private FeatureContext featureContext;
        private TrackingData trackingData;
        private long timestamp;

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder ksContext(KatalonStudioContext ksContext) {
            this.ksContext = ksContext;
            return this;
        }

        public Builder featureContext(FeatureContext featureContext) {
            this.featureContext = featureContext;
            return this;
        }

        public Builder trackingData(TrackingData trackingData) {
            this.trackingData = trackingData;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TrackingProperties build() {
            return new TrackingProperties(this);
        }
    }
}

