/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.tracking.domain.model;

import com.katalon.tracking.constant.TrackingEventEnum;
import com.katalon.tracking.domain.model.FeatureContext;
import com.katalon.tracking.domain.model.TrackingData;

public class TrackingRequest {
    private final TrackingEventEnum event;
    private final String action;
    private final FeatureContext featureContext;
    private final TrackingData trackingData;

    private TrackingRequest(Builder builder) {
        this.event = builder.event;
        this.action = builder.action;
        this.featureContext = builder.featureContext;
        this.trackingData = builder.trackingData;
    }

    public TrackingEventEnum getEvent() {
        return this.event;
    }

    public String getAction() {
        return this.action;
    }

    public FeatureContext getFeatureContext() {
        return this.featureContext;
    }

    public TrackingData getTrackingData() {
        return this.trackingData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TrackingEventEnum event;
        private String action;
        private FeatureContext featureContext;
        private TrackingData trackingData;

        public Builder event(TrackingEventEnum event) {
            this.event = event;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder featureContext(FeatureContext featureContext) {
            this.featureContext = featureContext;
            return this;
        }

        public Builder trackingData(TrackingData trackingData) {
            this.trackingData = trackingData;
            return this;
        }

        public TrackingRequest build() {
            return new TrackingRequest(this);
        }
    }
}

