/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.tagexpressions;

import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TagExpressionParser {
    private static final Map<String, Assoc> ASSOC = new HashMap<String, Assoc>(){
        {
            this.put("or", Assoc.LEFT);
            this.put("and", Assoc.LEFT);
            this.put("not", Assoc.RIGHT);
        }
    };
    private static final Map<String, Integer> PREC = new HashMap<String, Integer>(){
        {
            this.put("(", -2);
            this.put(")", -1);
            this.put("or", 0);
            this.put("and", 1);
            this.put("not", 2);
        }
    };
    private static final char ESCAPING_CHAR = '\\';
    private final String infix;

    public static Expression parse(String infix) {
        return new TagExpressionParser(infix).parse();
    }

    private TagExpressionParser(String infix) {
        this.infix = infix;
    }

    private Expression parse() {
        List<String> tokens = TagExpressionParser.tokenize(this.infix);
        if (tokens.isEmpty()) {
            return new True();
        }
        ArrayDeque<String> operators = new ArrayDeque<String>();
        ArrayDeque<Expression> expressions = new ArrayDeque<Expression>();
        TokenType expectedTokenType = TokenType.OPERAND;
        for (String token : tokens) {
            if (this.isUnary(token)) {
                this.check(expectedTokenType, TokenType.OPERAND);
                operators.push(token);
                expectedTokenType = TokenType.OPERAND;
                continue;
            }
            if (this.isBinary(token)) {
                this.check(expectedTokenType, TokenType.OPERATOR);
                while (operators.size() > 0 && this.isOperator((String)operators.peek()) && (ASSOC.get(token) == Assoc.LEFT && PREC.get(token) <= PREC.get(operators.peek()) || ASSOC.get(token) == Assoc.RIGHT && PREC.get(token) < PREC.get(operators.peek()))) {
                    this.pushExpr((String)operators.pop(), expressions);
                }
                operators.push(token);
                expectedTokenType = TokenType.OPERAND;
                continue;
            }
            if ("(".equals(token)) {
                this.check(expectedTokenType, TokenType.OPERAND);
                operators.push(token);
                expectedTokenType = TokenType.OPERAND;
                continue;
            }
            if (")".equals(token)) {
                this.check(expectedTokenType, TokenType.OPERATOR);
                while (operators.size() > 0 && !"(".equals(operators.peek())) {
                    this.pushExpr((String)operators.pop(), expressions);
                }
                if (operators.size() == 0) {
                    throw new TagExpressionException("Tag expression \"%s\" could not be parsed because of syntax error: Unmatched ).", this.infix);
                }
                if ("(".equals(operators.peek())) {
                    operators.pop();
                }
                expectedTokenType = TokenType.OPERATOR;
                continue;
            }
            this.check(expectedTokenType, TokenType.OPERAND);
            this.pushExpr(token, expressions);
            expectedTokenType = TokenType.OPERATOR;
        }
        while (operators.size() > 0) {
            if ("(".equals(operators.peek())) {
                throw new TagExpressionException("Tag expression \"%s\" could not be parsed because of syntax error: Unmatched (.", this.infix);
            }
            this.pushExpr((String)operators.pop(), expressions);
        }
        return (Expression)expressions.pop();
    }

    private static List<String> tokenize(String expr) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean isEscaped = false;
        StringBuilder token = new StringBuilder();
        for (int i = 0; i < expr.length(); ++i) {
            char c = expr.charAt(i);
            if (isEscaped) {
                if (c == '(' || c == ')' || c == '\\' || Character.isWhitespace(c)) {
                    token.append(c);
                    isEscaped = false;
                    continue;
                }
                throw new TagExpressionException("Tag expression \"%s\" could not be parsed because of syntax error: Illegal escape before \"%s\".", expr, Character.valueOf(c));
            }
            if (c == '\\') {
                isEscaped = true;
                continue;
            }
            if (c == '(' || c == ')' || Character.isWhitespace(c)) {
                if (token.length() > 0) {
                    tokens.add(token.toString());
                    token = new StringBuilder();
                }
                if (Character.isWhitespace(c)) continue;
                tokens.add(String.valueOf(c));
                continue;
            }
            token.append(c);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }

    private void check(TokenType expectedTokenType, TokenType tokenType) {
        if (expectedTokenType != tokenType) {
            throw new TagExpressionException("Tag expression \"%s\" could not be parsed because of syntax error: Expected %s.", this.infix, expectedTokenType.toString().toLowerCase());
        }
    }

    private void pushExpr(String token, Deque<Expression> expressions) {
        switch (token) {
            case "and": {
                Expression rightAndExpr = this.popOperand(expressions);
                Expression leftAndExpr = this.popOperand(expressions);
                expressions.push(new And(leftAndExpr, rightAndExpr));
                break;
            }
            case "or": {
                Expression rightOrExpr = this.popOperand(expressions);
                Expression leftOrExpr = this.popOperand(expressions);
                expressions.push(new Or(leftOrExpr, rightOrExpr));
                break;
            }
            case "not": {
                Expression expression = this.popOperand(expressions);
                expressions.push(new Not(expression));
                break;
            }
            default: {
                expressions.push(new Literal(token));
            }
        }
    }

    private <T> T popOperand(Deque<T> stack) {
        if (stack.isEmpty()) {
            throw new TagExpressionException("Tag expression \"%s\" could not be parsed because of syntax error: Expected operand.", this.infix);
        }
        return stack.pop();
    }

    private boolean isUnary(String token) {
        return "not".equals(token);
    }

    private boolean isBinary(String token) {
        return "or".equals(token) || "and".equals(token);
    }

    private boolean isOperator(String token) {
        return ASSOC.get(token) != null;
    }

    private static class True
    implements Expression {
        private True() {
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return true;
        }

        public String toString() {
            return "";
        }
    }

    private static enum TokenType {
        OPERAND,
        OPERATOR;

    }

    private static enum Assoc {
        LEFT,
        RIGHT;

    }

    private static class And
    implements Expression {
        private final Expression left;
        private final Expression right;

        And(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return this.left.evaluate(variables) && this.right.evaluate(variables);
        }

        public String toString() {
            return "( " + this.left.toString() + " and " + this.right.toString() + " )";
        }
    }

    private static class Or
    implements Expression {
        private final Expression left;
        private final Expression right;

        Or(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return this.left.evaluate(variables) || this.right.evaluate(variables);
        }

        public String toString() {
            return "( " + this.left.toString() + " or " + this.right.toString() + " )";
        }
    }

    private static class Not
    implements Expression {
        private final Expression expr;

        Not(Expression expr) {
            this.expr = expr;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return !this.expr.evaluate(variables);
        }

        public String toString() {
            if (And.class.isInstance(this.expr) || Or.class.isInstance(this.expr)) {
                return "not " + this.expr.toString();
            }
            return "not ( " + this.expr.toString() + " )";
        }
    }

    private static class Literal
    implements Expression {
        private final String value;

        Literal(String value) {
            this.value = value;
        }

        @Override
        public boolean evaluate(List<String> variables) {
            return variables.contains(this.value);
        }

        public String toString() {
            return this.value.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement("\\\\")).replaceAll(Pattern.quote("("), Matcher.quoteReplacement("\\(")).replaceAll(Pattern.quote(")"), Matcher.quoteReplacement("\\)")).replaceAll("\\s", "\\\\ ");
        }
    }
}

