/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.windows;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.windows.driver.FlaUIDriverManager;
import com.kms.katalon.core.windows.driver.WindowsDriverType;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.execution.windows.WindowsRunConfiguration;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WindowsRunConfigurationContributor
implements IRunConfigurationContributor {
    public List<ConsoleOption<?>> getConsoleOptionList() {
        return Collections.emptyList();
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
    }

    public String getId() {
        return WindowsDriverType.getInstance().getName();
    }

    public int getPreferredOrder() {
        return 12;
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException, InterruptedException {
        WindowsRunConfiguration runConfig = new WindowsRunConfiguration(new WindowsDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
        this.prepareFlaUIDriverIfNecessary(runConfig);
        return runConfig;
    }

    public List<ConsoleOption<?>> getConsoleOptions(RunConfigurationDescription description) {
        return Collections.emptyList();
    }

    private void prepareFlaUIDriverIfNecessary(WindowsRunConfiguration runConfig) {
        if (runConfig == null) {
            return;
        }
        WindowsDriverConnector windowsDriverConnector = runConfig.getDriverConnector();
        String userDefinedDriverUrl = windowsDriverConnector.getDriverUrl();
        if (!StringUtils.isBlank((CharSequence)userDefinedDriverUrl)) {
            return;
        }
        ProxyInformation proxyInfo = ProxyPreferences.getSystemProxyInformation();
        ProxyConfig proxyConfig = proxyInfo == null ? null : proxyInfo.toNewProxyConfigModel();
        FlaUIDriverManager.FlaUIServer selfHostedServer = FlaUIDriverManager.getInstance().startLocalServer(FlaUIDriverManager.StartMode.ONLY_START_IF_NOT_HEALTHY, proxyConfig);
        if (selfHostedServer != null) {
            runConfig.useSelfHostedServer(selfHostedServer.getServerUrl());
        }
    }
}

