/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.model;

import com.katalon.capability.constant.DriverPlatform;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.model.ICapabilitySetting;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CapabilitySetting
implements ICapabilitySetting {
    private DriverType driverType;
    private Map<String, Object> value;

    public CapabilitySetting(DriverType driverType) {
        this.driverType = driverType;
        this.value = new LinkedHashMap<String, Object>();
    }

    public CapabilitySetting(DriverType driverType, Map<String, Object> value) {
        this.driverType = driverType;
        this.value = value == null ? new LinkedHashMap() : value;
    }

    @Override
    public String getName() {
        return this.driverType.name();
    }

    @Override
    public String getDisplayName() {
        return this.driverType.getDisplayName();
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    public List<DriverType> getSupportedDriverTypes() {
        return Collections.singletonList(this.driverType);
    }

    @Override
    public DriverType getSupportedDriver(DriverPlatform driverPlatform) {
        if (this.driverType.getDriverPlatform() == driverPlatform) {
            return this.driverType;
        }
        return null;
    }

    @Override
    public Map<String, Object> getValue() {
        return this.value;
    }

    @Override
    public Map<String, Object> getValue(DriverType driverType) {
        if (this.driverType == driverType) {
            return this.value;
        }
        return null;
    }

    @Override
    public void putProperty(String key, Object value) {
        this.value.put(key, value);
    }

    @Override
    public void setValue(Map<String, Object> value) {
        this.value = value;
    }

    public DriverType getDriverType() {
        return this.driverType;
    }

    public void setDriverType(DriverType driverType) {
        this.driverType = driverType;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public CapabilitySetting clone() {
        LinkedHashMap<String, Object> clonedValues = new LinkedHashMap<String, Object>(this.value);
        return new CapabilitySetting(this.driverType, clonedValues);
    }
}

