/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.preferences.eclipse.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.network.core.model.config.AllNetworkPreferences;
import com.kms.katalon.network.core.model.config.ManualProxyConfig;
import com.kms.katalon.network.core.model.config.NoProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyAuthentication;
import com.kms.katalon.network.core.model.config.ProxyBasicAuthentication;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyNoAuthentication;
import com.kms.katalon.network.core.model.config.ProxyOption;
import com.kms.katalon.network.core.model.config.ProxyProtocol;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.config.ServerConfig;
import com.kms.katalon.network.core.model.config.SystemProxyConfig;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class EclipseNetworkPreferences
implements INetworkPreferences {
    private static INetworkPreferences instance;
    private ObjectMapper objectMapper = new ObjectMapper();
    private static final String PROXY_OPTION_KEY = "proxy.option";
    private static final String PROXY_SERVER_TYPE_KEY = "proxy.server.type";
    private static final String PROXY_SERVER_ADDRESS_KEY = "proxy.server.address";
    private static final String PROXY_SERVER_PORT_KEY = "proxy.server.port";
    private static final String PROXY_USERNAME_KEY = "proxy.username";
    private static final String PROXY_PASSWORD_KEY = "proxy.password";
    private static final String PROXY_EXCEPTION_LIST_KEY = "proxy.excludes";
    private static final String PROXY_DISABLE_MOB_BROWSER_PROXY_KEY = "proxy.preferences.disableMobRowserProxy";
    private static final String PROXY_PREFERENCE_SET_KEY = "proxy.preferences.set";
    private static final String AUTH_PROXY_OPTION_KEY = "proxy.auth.option";
    private static final String AUTH_PROXY_SERVER_TYPE_KEY = "proxy.auth.server.type";
    private static final String AUTH_PROXY_SERVER_ADDRESS_KEY = "proxy.auth.server.address";
    private static final String AUTH_PROXY_SERVER_PORT_KEY = "proxy.auth.server.port";
    private static final String AUTH_PROXY_USERNAME_KEY = "proxy.auth.username";
    private static final String AUTH_PROXY_PASSWORD_KEY = "proxy.auth.password";
    private static final String AUTH_PROXY_EXCEPTION_LIST_KEY = "proxy.auth.excludes";
    private static final String AUTH_DISABLE_MOB_BROWSER_PROXY_KEY = "proxy.auth.preferences.disableMobRowserProxy";
    private static final String AUTH_PROXY_PREFERENCE_SET_KEY = "proxy.auth.preferences.set";
    private static final String SYSTEM_PROXY_OPTION_KEY = "proxy.system.option";
    private static final String SYSTEM_PROXY_SERVER_TYPE_KEY = "proxy.system.server.type";
    private static final String SYSTEM_PROXY_SERVER_ADDRESS_KEY = "proxy.system.server.address";
    private static final String SYSTEM_PROXY_SERVER_PORT_KEY = "proxy.system.server.port";
    private static final String SYSTEM_PROXY_USERNAME_KEY = "proxy.system.username";
    private static final String SYSTEM_PROXY_PASSWORD_KEY = "proxy.system.password";
    private static final String SYSTEM_PROXY_EXCEPTION_LIST_KEY = "proxy.system.excludes";
    private static final String SYSTEM_DISABLE_MOB_BROWSER_PROXY_KEY = "proxy.system.preferences.disableMobRowserProxy";
    private static final String SYSTEM_PROXY_PREFERENCE_SET_KEY = "proxy.system.preferences.set";
    private static final String SYSTEM_PROXY_APPLY_TO_DESIRED_CAPABILITIES_KEY = "proxy.system.applyToDesiredCapabilities";
    private static final String KATALON_EXECUTION_BUNDLE_ID = "com.kms.katalon.execution";
    private static final String KATALON_SERVER_CONFIG = "network.preferences.server.config";

    public static INetworkPreferences getInstance() {
        if (Objects.isNull(instance)) {
            BundleContext bundleContext = FrameworkUtil.getBundle(EclipseNetworkPreferences.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            instance = (INetworkPreferences)ContextInjectionFactory.make(EclipseNetworkPreferences.class, (IEclipseContext)context);
        }
        return instance;
    }

    public ProxyConfig getProxyConfig(ProxyType proxyType) {
        ProxyConfig proxyConfig = null;
        if (ProxyType.AUTHENTICATION.equals((Object)proxyType)) {
            proxyConfig = this.getAuthenticationProxyConfig();
        } else if (ProxyType.SYSTEM.equals((Object)proxyType)) {
            proxyConfig = this.getSystemProxyConfig();
        }
        return proxyConfig;
    }

    public void setProxyConfig(ProxyType proxyType, ProxyConfig proxyConfig) throws IOException {
        if (ProxyType.AUTHENTICATION.equals((Object)proxyType)) {
            this.setAuthenticationProxyConfig(proxyConfig);
        } else if (ProxyType.SYSTEM.equals((Object)proxyType)) {
            this.setSystemProxyConfig(proxyConfig);
        }
    }

    public ServerConfig getServerConfig() {
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        String json = preferenceStore.getString(KATALON_SERVER_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (ServerConfig)this.objectMapper.readValue(json, ServerConfig.class);
            }
            catch (JsonProcessingException jsonProcessingException) {}
        }
        return null;
    }

    public void setServerConfig(ServerConfig serverConfig) throws IOException {
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        try {
            String json = this.objectMapper.writeValueAsString((Object)serverConfig);
            preferenceStore.setValue(KATALON_SERVER_CONFIG, json);
            preferenceStore.save();
        }
        catch (JsonProcessingException jsonProcessingException) {}
    }

    private ProxyConfig getAuthenticationProxyConfig() {
        NoProxyConfig proxyConfig = null;
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        ProxyOption proxyOptions = ProxyOption.valueOf((String)preferenceStore.getString(AUTH_PROXY_OPTION_KEY));
        if (ProxyOption.NO_PROXY.equals((Object)proxyOptions)) {
            proxyConfig = new NoProxyConfig();
        } else if (ProxyOption.USE_SYSTEM.equals((Object)proxyOptions)) {
            proxyConfig = new SystemProxyConfig();
        } else if (ProxyOption.MANUAL_CONFIG.equals((Object)proxyOptions)) {
            String[] hosts;
            String exclusionList;
            int proxyServerPort;
            String proxyServerAddress;
            ManualProxyConfig.Builder manualProxyConfigBuilder = new ManualProxyConfig.Builder();
            ProxyProtocol proxyProtocol = ProxyProtocol.valueOf((String)preferenceStore.getString(AUTH_PROXY_SERVER_TYPE_KEY));
            if (Objects.nonNull(proxyProtocol)) {
                manualProxyConfigBuilder.protocol(proxyProtocol);
            }
            if (StringUtils.isNotBlank((CharSequence)(proxyServerAddress = preferenceStore.getString(AUTH_PROXY_SERVER_ADDRESS_KEY)))) {
                manualProxyConfigBuilder.address(proxyServerAddress);
            }
            if ((proxyServerPort = preferenceStore.getInt(AUTH_PROXY_SERVER_PORT_KEY)) > 0) {
                manualProxyConfigBuilder.port(proxyServerPort);
            }
            ProxyNoAuthentication proxyAuthentication = new ProxyNoAuthentication();
            String username = preferenceStore.getString(AUTH_PROXY_USERNAME_KEY);
            String password = preferenceStore.getString(AUTH_PROXY_PASSWORD_KEY);
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                proxyAuthentication = new ProxyBasicAuthentication(username, password);
            }
            if (Objects.nonNull(proxyAuthentication)) {
                manualProxyConfigBuilder.authentication((ProxyAuthentication)proxyAuthentication);
            }
            if (StringUtils.isNotBlank((CharSequence)(exclusionList = preferenceStore.getString(AUTH_PROXY_EXCEPTION_LIST_KEY))) && (hosts = exclusionList.split(",")).length > 0) {
                manualProxyConfigBuilder.bypassedHosts(Arrays.asList(hosts));
            }
            proxyConfig = manualProxyConfigBuilder.build();
        }
        return proxyConfig;
    }

    private void setAuthenticationProxyConfig(ProxyConfig proxyConfig) throws IOException {
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        if (proxyConfig instanceof NoProxyConfig) {
            preferenceStore.setValue(AUTH_PROXY_OPTION_KEY, ProxyOption.NO_PROXY.toString());
        } else if (proxyConfig instanceof SystemProxyConfig) {
            preferenceStore.setValue(AUTH_PROXY_OPTION_KEY, ProxyOption.USE_SYSTEM.toString());
        } else if (proxyConfig instanceof ManualProxyConfig) {
            ProxyAuthentication proxyAuthentication;
            int port;
            String serverAddress;
            ManualProxyConfig manualProxyConfig = (ManualProxyConfig)proxyConfig;
            preferenceStore.setValue(AUTH_PROXY_OPTION_KEY, ProxyOption.MANUAL_CONFIG.toString());
            ProxyProtocol proxyProtocol = manualProxyConfig.getProtocol();
            if (Objects.nonNull(proxyProtocol)) {
                preferenceStore.setValue(AUTH_PROXY_SERVER_TYPE_KEY, proxyProtocol.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)(serverAddress = manualProxyConfig.getAddress()))) {
                preferenceStore.setValue(AUTH_PROXY_SERVER_ADDRESS_KEY, serverAddress);
            }
            if ((port = manualProxyConfig.getPort()) > 0) {
                preferenceStore.setValue(AUTH_PROXY_SERVER_PORT_KEY, port);
            }
            if (Objects.nonNull(proxyAuthentication = manualProxyConfig.getAuthentication()) && proxyAuthentication instanceof ProxyBasicAuthentication) {
                ProxyBasicAuthentication proxyBasicAuthentication = (ProxyBasicAuthentication)proxyAuthentication;
                String username = proxyBasicAuthentication.getUsername();
                String password = proxyBasicAuthentication.getPassword();
                if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                    preferenceStore.setValue(AUTH_PROXY_USERNAME_KEY, username);
                    preferenceStore.setValue(AUTH_PROXY_PASSWORD_KEY, password);
                }
            }
        }
        preferenceStore.save();
    }

    private ProxyConfig getSystemProxyConfig() {
        NoProxyConfig proxyConfig = null;
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        ProxyOption proxyOptions = ProxyOption.valueOf((String)preferenceStore.getString(SYSTEM_PROXY_OPTION_KEY));
        if (ProxyOption.NO_PROXY.equals((Object)proxyOptions)) {
            proxyConfig = new NoProxyConfig();
        } else if (ProxyOption.USE_SYSTEM.equals((Object)proxyOptions)) {
            proxyConfig = new SystemProxyConfig();
        } else if (ProxyOption.MANUAL_CONFIG.equals((Object)proxyOptions)) {
            String[] hosts;
            String exclusionList;
            int proxyServerPort;
            String proxyServerAddress;
            ProxyProtocol proxyProtocol = ProxyProtocol.valueOf((String)preferenceStore.getString(SYSTEM_PROXY_SERVER_TYPE_KEY));
            ManualProxyConfig.Builder manualProxyConfigBuilder = new ManualProxyConfig.Builder();
            if (Objects.nonNull(proxyProtocol)) {
                manualProxyConfigBuilder.protocol(proxyProtocol);
            }
            if (StringUtils.isNotBlank((CharSequence)(proxyServerAddress = preferenceStore.getString(SYSTEM_PROXY_SERVER_ADDRESS_KEY)))) {
                manualProxyConfigBuilder.address(proxyServerAddress);
            }
            if ((proxyServerPort = preferenceStore.getInt(SYSTEM_PROXY_SERVER_PORT_KEY)) > 0) {
                manualProxyConfigBuilder.port(proxyServerPort);
            }
            ProxyNoAuthentication proxyAuthentication = new ProxyNoAuthentication();
            String username = preferenceStore.getString(SYSTEM_PROXY_USERNAME_KEY);
            String password = preferenceStore.getString(SYSTEM_PROXY_PASSWORD_KEY);
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                proxyAuthentication = new ProxyBasicAuthentication(username, password);
            }
            if (Objects.nonNull(proxyAuthentication)) {
                manualProxyConfigBuilder.authentication((ProxyAuthentication)proxyAuthentication);
            }
            if (StringUtils.isNotBlank((CharSequence)(exclusionList = preferenceStore.getString(SYSTEM_PROXY_EXCEPTION_LIST_KEY))) && (hosts = exclusionList.split(",")).length > 0) {
                manualProxyConfigBuilder.bypassedHosts(Arrays.asList(hosts));
            }
            proxyConfig = manualProxyConfigBuilder.build();
        }
        return proxyConfig;
    }

    private void setSystemProxyConfig(ProxyConfig proxyConfig) throws IOException {
        ScopedPreferenceStore preferenceStore = this.getPreferenceStore();
        if (proxyConfig instanceof NoProxyConfig) {
            preferenceStore.setValue(SYSTEM_PROXY_OPTION_KEY, ProxyOption.NO_PROXY.toString());
        } else if (proxyConfig instanceof SystemProxyConfig) {
            preferenceStore.setValue(SYSTEM_PROXY_OPTION_KEY, ProxyOption.USE_SYSTEM.toString());
        } else if (proxyConfig instanceof ManualProxyConfig) {
            ProxyAuthentication proxyAuthentication;
            int port;
            String serverAddress;
            ManualProxyConfig manualProxyConfig = (ManualProxyConfig)proxyConfig;
            preferenceStore.setValue(SYSTEM_PROXY_OPTION_KEY, ProxyOption.MANUAL_CONFIG.toString());
            ProxyProtocol proxyProtocol = manualProxyConfig.getProtocol();
            if (Objects.nonNull(proxyProtocol)) {
                preferenceStore.setValue(SYSTEM_PROXY_SERVER_TYPE_KEY, proxyProtocol.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)(serverAddress = manualProxyConfig.getAddress()))) {
                preferenceStore.setValue(SYSTEM_PROXY_SERVER_ADDRESS_KEY, serverAddress);
            }
            if ((port = manualProxyConfig.getPort()) > 0) {
                preferenceStore.setValue(SYSTEM_PROXY_SERVER_PORT_KEY, port);
            }
            if (Objects.nonNull(proxyAuthentication = manualProxyConfig.getAuthentication()) && proxyAuthentication instanceof ProxyBasicAuthentication) {
                ProxyBasicAuthentication proxyBasicAuthentication = (ProxyBasicAuthentication)proxyAuthentication;
                String username = proxyBasicAuthentication.getUsername();
                String password = proxyBasicAuthentication.getPassword();
                if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                    preferenceStore.setValue(SYSTEM_PROXY_USERNAME_KEY, username);
                    preferenceStore.setValue(SYSTEM_PROXY_PASSWORD_KEY, password);
                }
            }
        }
        preferenceStore.save();
    }

    private ScopedPreferenceStore getPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore((String)KATALON_EXECUTION_BUNDLE_ID);
    }

    public AllNetworkPreferences getNetworkPrefs() {
        AllNetworkPreferences networkPrefs = new AllNetworkPreferences();
        Arrays.stream(ProxyType.values()).forEach(proxyType -> allNetworkPreferences.proxies.put(proxyType, this.getProxyConfig((ProxyType)proxyType)));
        networkPrefs.discoveryServer = this.getServerConfig();
        return networkPrefs;
    }
}

