/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.query.Lineage;
import io.cucumber.query.NamingStrategy;
import io.cucumber.query.Query;
import io.cucumber.query.Repository;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class XmlReportData {
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private final Repository repository = Repository.builder().feature(Repository.RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS, true).build();
    private final Query query = new Query(this.repository);
    private final String testSuiteName;
    private final String testClassName;
    private final NamingStrategy testNamingStrategy;
    private static final Duration ZERO_DURATION = new Duration(Long.valueOf(0L), Long.valueOf(0L));
    private static final TestStepResult SCENARIO_WITH_NO_STEPS = new TestStepResult(ZERO_DURATION, null, TestStepResultStatus.PASSED, null);

    XmlReportData(String testSuiteName, String testClassName, NamingStrategy testNamingStrategy) {
        this.testSuiteName = Objects.requireNonNull(testSuiteName);
        this.testClassName = testClassName;
        this.testNamingStrategy = Objects.requireNonNull(testNamingStrategy);
    }

    void collect(Envelope envelope) {
        this.repository.update(envelope);
    }

    double getSuiteDurationInSeconds() {
        return (double)this.query.findTestRunDuration().orElse(java.time.Duration.ZERO).toMillis() / (double)MILLIS_PER_SECOND;
    }

    double getDurationInSeconds(TestCaseStarted testCaseStarted) {
        return (double)this.query.findTestCaseDurationBy(testCaseStarted).orElse(java.time.Duration.ZERO).toMillis() / (double)MILLIS_PER_SECOND;
    }

    Map<TestStepResultStatus, Long> getTestCaseStatusCounts() {
        return this.query.countMostSevereTestStepResultStatus();
    }

    int getTestCaseCount() {
        return this.query.findAllTestCaseStarted().size();
    }

    private Pickle getPickle(TestCaseStarted testCaseStarted) {
        return (Pickle)this.query.findPickleBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No pickle for " + testCaseStarted.getId()));
    }

    String getTestName(TestCaseStarted testCaseStarted) {
        Pickle pickle = this.getPickle(testCaseStarted);
        return this.query.findLineageBy(pickle).map(lineage -> (String)this.testNamingStrategy.reduce(lineage, pickle)).orElseGet(() -> ((Pickle)pickle).getName());
    }

    String getTestClassName(TestCaseStarted testCaseStarted) {
        if (this.testClassName != null) {
            return this.testClassName;
        }
        return this.query.findLineageBy(testCaseStarted).flatMap(Lineage::feature).map(Feature::getName).orElseGet(() -> this.getPickle(testCaseStarted).getUri());
    }

    String getTestSuiteName() {
        return this.testSuiteName;
    }

    List<Map.Entry<String, String>> getStepsAndResult(TestCaseStarted testCaseStarted) {
        return this.query.findTestStepFinishedAndTestStepBy(testCaseStarted).stream().filter(entry -> ((TestStep)entry.getValue()).getPickleStepId().isPresent()).map(testStep -> {
            String key = this.renderTestStepText((TestStep)testStep.getValue());
            String value = this.renderTestStepResult((TestStepFinished)testStep.getKey());
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }).collect(Collectors.toList());
    }

    private String renderTestStepResult(TestStepFinished testStepFinished) {
        return testStepFinished.getTestStepResult().getStatus().toString().toLowerCase(Locale.ROOT);
    }

    private String renderTestStepText(TestStep testStep) {
        Optional pickleStep = this.query.findPickleStepBy(testStep);
        String stepKeyWord = pickleStep.flatMap(arg_0 -> ((Query)this.query).findStepBy(arg_0)).map(Step::getKeyword).orElse("");
        String stepText = pickleStep.map(PickleStep::getText).orElse("");
        return stepKeyWord + stepText;
    }

    List<TestCaseStarted> getAllTestCaseStarted() {
        return this.query.findAllTestCaseStarted();
    }

    TestStepResult getTestCaseStatus(TestCaseStarted testCaseStarted) {
        return this.query.findMostSevereTestStepResultBy(testCaseStarted).orElse(SCENARIO_WITH_NO_STEPS);
    }

    Optional<String> getTestRunStartedAt() {
        return this.query.findTestRunStarted().map(TestRunStarted::getTimestamp).map(Convertor::toInstant).map(DateTimeFormatter.ISO_INSTANT::format);
    }
}

