/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.LoginMethod;
import com.kms.katalon.composer.components.controls.TextField;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.InputValidator;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.session.core.model.RememberMeOption;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.session.core.services.ISessionService;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LicenseServerDialog
extends BaseModernDialog {
    @Inject
    private ISessionController sessionController;
    @Inject
    ISessionService sessionService;
    @Inject
    private IDiscoveryController discoveryController;
    private static final Color INPUT_BACKGROUND_COLOR = ColorUtil.getColor((String)"#FFFFFF");
    private String serverUrl;
    private InputValidator validator;
    private TextField usernameInput;
    private TextField passwordInput;
    private Link statusLabel;
    private Canvas signInButton;
    private Set<Control> blockedUIControls = new HashSet<Control>();
    private Session session;

    public LicenseServerDialog(Shell parentShell) {
        super(parentShell);
    }

    public void initLicenseServerAddress() {
        this.serverUrl = this.discoveryController.getDiscoveryServerUrl();
    }

    @Override
    protected Point getInitialSize() {
        return new Point(-1, -1);
    }

    @Override
    protected void createContent(Composite container) {
        ComponentEventUtil.onSubmit((Control)container, event -> {
            if (!this.signInButton.isEnabled()) {
                return;
            }
            String username = StringUtils.trim((String)this.usernameInput.getText());
            String password = this.passwordInput.getText();
            new Thread(() -> this.signIn(username, password)).start();
        });
        this.createHeaderContent(container);
        this.createLoginInfoContent(container);
        this.createBottomContent(container);
    }

    private void createHeaderContent(Composite container) {
        Composite header = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).marginBottom(ComponentUtil.applyZoom((int)20)).fillHorizontal().marginTop(ComponentUtil.applyZoom((int)20)).build();
        ComponentBuilder.label((Composite)header).text(MessageConstants.LOG_IN_WITH_LICENSE_SERVER).fontSize(18).bold().fillHorizontal().build();
        Composite learnMoreWrapper = (Composite)ComponentBuilder.gridContainer((Composite)header).fillHorizontal().right().build();
        ComponentBuilder.label((Composite)learnMoreWrapper, (int)4).linkButton().text("Learn more ").fontSize(10).bottom().textRight().fillHorizontal().onClick(event -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.KATALON_ONPREMISE)).build();
    }

    private void createLoginInfoContent(Composite container) {
        ComponentBuilder.textField((Composite)container).placeholder(MessageConstants.LICENSE_SERVER_ADDRESS).text(this.serverUrl).background(INPUT_BACKGROUND_COLOR).fillHorizontal().forceFocus().onChange(event -> {
            this.serverUrl = ((TextField)event.widget).getText();
        }).addTo(this.blockedUIControls).build();
        this.validator = new InputValidator();
        this.validator.onValidation((validated, errors) -> {
            if (ControlUtil.isDisposed((Widget)this.signInButton)) {
                return;
            }
            ComponentUtil.setEnabledButton((Control)this.signInButton, (boolean)validated);
        });
        this.usernameInput = (TextField)ComponentBuilder.textField((Composite)container).placeholder(MessageConstants.PLACEHOLDER_EMAIL_ADDRESS).background(INPUT_BACKGROUND_COLOR).validateEmail(this.validator).fillHorizontal().addTo(this.blockedUIControls).build();
        this.passwordInput = (TextField)ComponentBuilder.textField((Composite)container, (int)16384).placeholder(MessageConstants.LBL_PASSWORD).background(INPUT_BACKGROUND_COLOR).validatePassword(this.validator).fillHorizontal().addTo(this.blockedUIControls).build();
        this.statusLabel = (Link)ComponentBuilder.link((Composite)container).color(ColorUtil.getTextErrorColor()).fontSize(10).fillHorizontal().hide().build();
    }

    private void createBottomContent(Composite container) {
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().marginTop(ComponentUtil.applyZoom((int)10)).marginBottom(ComponentUtil.applyZoom((int)5)).gridSpacing(this.applyZoom(15)).build();
        this.signInButton = (Canvas)ComponentBuilder.canvas((Composite)buttonBar).text(MessageConstants.Account_LOG_IN).submitButton().bold().fontSize(14).primaryButton3().onClick(event -> UISynchronizeService.asyncExec(() -> Trackings.trackLoginDialogAction((String)"sign-in", Optional.of(RememberMeOption.isExplicitlyEnabled((RememberMeOption)this.sessionService.getRememberMeOption()))))).disable().autoHeight(45).fillHorizontal().addTo(this.blockedUIControls).build();
        Composite cancelButtonWrapper = (Composite)ComponentBuilder.gridContainer((Composite)buttonBar).fillHorizontal().center().build();
        ComponentBuilder.label((Composite)cancelButtonWrapper, (int)4).text("Cancel ").linkButton().textCenter().fontSize(10).fillHorizontal().onClick(event -> this.cancelPressed()).marginBottom(ComponentUtil.applyZoom((int)10)).build();
    }

    private void signIn(String username, String password) {
        String errorMessage;
        block8: {
            block7: {
                errorMessage = null;
                UISynchronizeService.syncExec(() -> this.blockUI(true));
                UISynchronizeService.syncExec(() -> this.setMessage(MessageConstants.ActivationDialogV2_MSG_LOGIN));
                this.discoveryController.setDiscoveryServerUrl(this.serverUrl);
                if (this.discoveryController.isOnline()) break block7;
                String message = MessageFormat.format(MessageConstants.MSG_UNABLE_TO_CONNECT_FORMAT, this.serverUrl);
                UISynchronizeService.syncExec(() -> this.setErrorMessage(message));
                Trackings.trackActivation((LoginMethod)LoginMethod.CREDENTIAL, (boolean)this.sessionController.isActivated(), (String)errorMessage);
                UISynchronizeService.syncExec(() -> this.blockUI(false));
                return;
            }
            this.discoveryController.discover();
            this.session = this.sessionController.activateWithPassword(username, password);
            if (this.sessionController.isActivated()) break block8;
            UISynchronizeService.syncExec(() -> this.setErrorMessage("Authentication failed."));
            Trackings.trackActivation((LoginMethod)LoginMethod.CREDENTIAL, (boolean)this.sessionController.isActivated(), (String)errorMessage);
            UISynchronizeService.syncExec(() -> this.blockUI(false));
            return;
        }
        try {
            try {
                ApplicationInfo.setLoginMethod((LoginMethod)LoginMethod.CREDENTIAL);
                UISynchronizeService.asyncExec(() -> ((LicenseServerDialog)this).okPressed());
            }
            catch (SessionException e) {
                errorMessage = e.getMessage();
                if (errorMessage.contains("<!DOCTYPE html>") || errorMessage.contains("MismatchedInputException")) {
                    errorMessage = "The license server address invalid!";
                }
                String message = errorMessage;
                UISynchronizeService.syncExec(() -> this.setErrorMessage(this.extractMessageAfterColon(message)));
                Trackings.trackActivation((LoginMethod)LoginMethod.CREDENTIAL, (boolean)this.sessionController.isActivated(), (String)errorMessage);
                UISynchronizeService.syncExec(() -> this.blockUI(false));
            }
        }
        catch (Throwable throwable) {
            Trackings.trackActivation((LoginMethod)LoginMethod.CREDENTIAL, (boolean)this.sessionController.isActivated(), (String)errorMessage);
            UISynchronizeService.syncExec(() -> this.blockUI(false));
            throw throwable;
        }
        Trackings.trackActivation((LoginMethod)LoginMethod.CREDENTIAL, (boolean)this.sessionController.isActivated(), (String)errorMessage);
        UISynchronizeService.syncExec(() -> this.blockUI(false));
    }

    private String extractMessageAfterColon(String message) {
        if (message == null) {
            return "";
        }
        int colonIndex = message.indexOf(58);
        if (colonIndex == -1) {
            return message;
        }
        return message.substring(colonIndex + 1).trim();
    }

    private void blockUI(boolean blocked) {
        if (this.signInButton.isDisposed()) {
            return;
        }
        boolean enabled = !blocked;
        this.blockedUIControls.forEach(controlI -> {
            if (controlI instanceof Canvas) {
                ComponentUtil.setEnabledButton((Control)controlI, (boolean)enabled);
            } else {
                controlI.setEnabled(enabled);
            }
        });
        ComponentUtil.setEnabledButton((Control)this.signInButton, (enabled && this.validator.isValidated() ? 1 : 0) != 0);
    }

    private void setMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.showSuccess((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.getShell().pack();
    }

    private void setErrorMessage(String message) {
        if (this.statusLabel.isDisposed()) {
            return;
        }
        ComponentUtil.show((Control)this.statusLabel);
        ComponentUtil.showError((Control)this.statusLabel, (String)ComponentUtil.autoWrapLinks((String)message), (boolean)true);
        this.getShell().pack();
    }

    public Session getSession() {
        return this.session;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }
}

