/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ImageUtil;
import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolItem;

public class CHandledContributionItem
extends HandledContributionItem {
    private static final String ICON_URI = "iconURI";
    private static final String DISABLED_URI = "disabledURI";

    public void update(String id) {
        super.update(id);
        this.updateIcons();
    }

    protected void updateIcons() {
        if (!(this.getWidget() instanceof Item)) {
            return;
        }
        Item item = (Item)this.getWidget();
        String iconURI = this.getModel().getIconURI() != null ? this.getModel().getIconURI() : "";
        String disabledURI = this.getDisabledIconURI((MItem)this.getModel());
        Object disabledData = item.getData(DISABLED_URI);
        if (disabledData == null) {
            disabledData = "";
        }
        Image iconImage = this.getImage(iconURI);
        item.setImage(iconImage);
        item.setData(ICON_URI, (Object)iconURI);
        if (item instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)item;
            toolItem.setToolTipText(this.getModel().getLabel());
            toolItem.setText("");
            if (toolItem.getDisabledImage() == null && (iconImage = this.getImage(disabledURI)) != null) {
                toolItem.setDisabledImage(iconImage);
                item.setData(DISABLED_URI, (Object)disabledURI);
            }
        }
    }

    private String getDisabledIconURI(MItem toolItem) {
        Object obj = toolItem.getTransientData().get("e4_disabled_icon_image_key");
        return obj instanceof String ? (String)obj : "";
    }

    private Image getImage(String iconURI) {
        if (StringUtils.isBlank((CharSequence)iconURI)) {
            return null;
        }
        try {
            return ImageUtil.loadImage((String)iconURI);
        }
        catch (MalformedURLException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
    }
}

