/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.util.groovy.GroovyEditorUtil;
import com.kms.katalon.constants.MessageConstants;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

final class AgentProfilePromptSaveValidator {
    private static final long MAX_PROMPT_BYTES = 0xA00000L;
    private static final String PROMPT_FILE_NAME = "prompt.md";
    private static final String AGENTS_DIR_NAME = "Agents";

    private AgentProfilePromptSaveValidator() {
    }

    static Optional<String> validate(MPart part) {
        IEditorPart editor;
        Optional<Path> promptPath = AgentProfilePromptSaveValidator.getPromptPath(part);
        if (promptPath.isEmpty()) {
            return Optional.empty();
        }
        IEditorInput editorInput = (editor = GroovyEditorUtil.getEditor((MPart)part)) != null ? editor.getEditorInput() : null;
        IDocument document = AgentProfilePromptSaveValidator.getDocument(editor, editorInput).orElse(null);
        if (document != null) {
            return AgentProfilePromptSaveValidator.validateDocument(document);
        }
        try {
            long sizeBytes = Files.size(promptPath.get());
            if (sizeBytes > 0xA00000L) {
                return Optional.of(AgentProfilePromptSaveValidator.toTooLargeMessage());
            }
        }
        catch (Exception exception) {}
        return Optional.empty();
    }

    static boolean isAgentProfilePromptPart(MPart part) {
        return AgentProfilePromptSaveValidator.getPromptPath(part).isPresent();
    }

    private static Optional<String> validateDocument(IDocument document) {
        String content = document.get();
        long sizeBytes = content.getBytes(StandardCharsets.UTF_8).length;
        if (sizeBytes > 0xA00000L) {
            return Optional.of(AgentProfilePromptSaveValidator.toTooLargeMessage());
        }
        return Optional.empty();
    }

    private static String toTooLargeMessage() {
        return MessageFormat.format(MessageConstants.PROMPT_MD_TOO_LARGE_TO_SAVE, 10L);
    }

    private static Optional<Path> getPromptPath(MPart part) {
        Path agentsDir;
        if (part == null) {
            return Optional.empty();
        }
        IEditorPart editor = GroovyEditorUtil.getEditor((MPart)part);
        Optional<Path> path = AgentProfilePromptSaveValidator.getEditorPath(editor);
        if (path.isEmpty()) {
            return Optional.empty();
        }
        Path resolvedPath = path.get();
        if (resolvedPath.getFileName() == null || !PROMPT_FILE_NAME.equalsIgnoreCase(resolvedPath.getFileName().toString())) {
            return Optional.empty();
        }
        Path profileDir = resolvedPath.getParent();
        Path path2 = agentsDir = profileDir != null ? profileDir.getParent() : null;
        if (agentsDir != null && agentsDir.getFileName() != null && AGENTS_DIR_NAME.equalsIgnoreCase(agentsDir.getFileName().toString())) {
            return Optional.of(resolvedPath);
        }
        return Optional.empty();
    }

    private static Optional<Path> getEditorPath(IEditorPart editor) {
        IURIEditorInput uriInput;
        String osPath;
        IPathEditorInput pathInput;
        String osPath2;
        if (editor == null) {
            return Optional.empty();
        }
        IEditorInput input = editor.getEditorInput();
        if (input == null) {
            return Optional.empty();
        }
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file == null) {
            file = (IFile)editor.getAdapter(IFile.class);
        }
        if (file != null && file.getLocation() != null && StringUtils.isNotBlank((CharSequence)(osPath2 = file.getLocation().toOSString()))) {
            return Optional.of(Path.of(osPath2, new String[0]).normalize());
        }
        if (input instanceof IPathEditorInput && (pathInput = (IPathEditorInput)input).getPath() != null && StringUtils.isNotBlank((CharSequence)(osPath = pathInput.getPath().toOSString()))) {
            return Optional.of(Path.of(osPath, new String[0]).normalize());
        }
        if (input instanceof IURIEditorInput && (uriInput = (IURIEditorInput)input).getURI() != null && "file".equalsIgnoreCase(uriInput.getURI().getScheme())) {
            try {
                return Optional.of(Path.of(uriInput.getURI()).normalize());
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Optional<IDocument> getDocument(IEditorPart editor, IEditorInput input) {
        if (editor == null || input == null) {
            return Optional.empty();
        }
        ITextEditor textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
        IDocumentProvider provider = textEditor != null ? textEditor.getDocumentProvider() : (IDocumentProvider)editor.getAdapter(IDocumentProvider.class);
        return provider != null ? Optional.ofNullable(provider.getDocument((Object)input)) : Optional.empty();
    }
}

