/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import com.kms.katalon.constants.DocumentationMessageConstants;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;

public class PreferenceDialog
extends WorkbenchPreferenceDialog {
    private static final String GENERAL_PAGE_NAME = "General";
    private Composite helpComposite;

    public PreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
    }

    public String getSelectedNodePreference() {
        String selectedNode = super.getSelectedNodePreference();
        return StringUtils.isNotEmpty((CharSequence)selectedNode) ? selectedNode : "com.kms.katalon.composer.preferences.GeneralPreferencePage";
    }

    protected void setContentAndLabelProviders(TreeViewer treeViewer) {
        super.setContentAndLabelProviders(treeViewer);
        treeViewer.setLabelProvider((IBaseLabelProvider)new TypeCheckedStyleCellLabelProvider<IPreferenceNode>(0){

            protected Class<IPreferenceNode> getElementType() {
                return IPreferenceNode.class;
            }

            protected Image getImage(IPreferenceNode element) {
                return null;
            }

            protected String getText(IPreferenceNode element) {
                return element.getLabelText();
            }
        });
    }

    protected boolean showPage(IPreferenceNode node) {
        boolean success = super.showPage(node);
        if (success) {
            IPreferencePage shownPage = this.getCurrentPage();
            this.showHelpButtonForPage(shownPage);
        }
        return success;
    }

    private void showHelpButtonForPage(IPreferencePage page) {
        Control[] helpCompositeChildren = this.helpComposite.getChildren();
        if (helpCompositeChildren.length > 0) {
            Composite oldHelpButton = (Composite)helpCompositeChildren[0];
            oldHelpButton.dispose();
        }
        if (page.getTitle().equals(GENERAL_PAGE_NAME)) {
            String documentationUrl = DocumentationMessageConstants.PREFERENCE_GENERAL;
            this.createAndShowHelpButton(this.helpComposite, documentationUrl);
        } else if (page instanceof PreferencePageWithHelp) {
            PreferencePageWithHelp prefPageWithHelp = (PreferencePageWithHelp)page;
            if (prefPageWithHelp.hasDocumentation()) {
                String documentationUrl = prefPageWithHelp.getDocumentationUrl();
                this.createAndShowHelpButton(this.helpComposite, documentationUrl);
            } else {
                this.helpComposite.setVisible(false);
            }
        } else {
            this.helpComposite.setVisible(false);
        }
    }

    private void createAndShowHelpButton(Composite helpComposite, String documentationUrl) {
        new HelpCompositeForDialog(helpComposite, documentationUrl){

            protected GridData createGridData() {
                return new GridData(131072, 0x1000000, true, false);
            }

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginBottom = 0;
                layout.marginWidth = 0;
                return layout;
            }
        };
        helpComposite.setVisible(true);
        helpComposite.getParent().layout(true, true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.helpComposite = new Composite(parent, 0);
        GridLayout glHelp = new GridLayout();
        glHelp.marginWidth = 0;
        glHelp.marginHeight = 0;
        this.helpComposite.setLayout((Layout)glHelp);
        this.helpComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        super.createButtonsForButtonBar(parent);
    }

    protected void selectSavedItem() {
        super.selectSavedItem();
    }
}

