/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.openqa.selenium.Platform;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ProjectToolbarHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication application;
    @Inject
    private IFeatureController featureController;

    @PostConstruct
    public void registerEventListener() {
        this.eventBroker.subscribe("TOOLBAR/RELOAD", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                ProjectToolbarHandler.this.showToolBar();
            }
        });
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                ProjectToolbarHandler.this.showToolBar();
            }
        });
        this.eventBroker.subscribe("PROJECT/CLOSED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                MUIElement newTestCaseToolbar = ProjectToolbarHandler.this.modelService.find("com.kms.katalon.toolbar.createTestCase", (MUIElement)ProjectToolbarHandler.this.application);
                if (newTestCaseToolbar != null) {
                    newTestCaseToolbar.setVisible(false);
                    newTestCaseToolbar.setToBeRendered(false);
                }
            }
        });
    }

    private void showToolBar() {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        MUIElement genericToolbar = this.modelService.find("com.kms.katalon.composer.toolbar.generic", (MUIElement)this.application);
        MUIElement webserviceToolbar = this.modelService.find("com.kms.katalon.composer.toolbar.webservice", (MUIElement)this.application);
        MUIElement newTestCaseToolbar = this.modelService.find("com.kms.katalon.toolbar.createTestCase", (MUIElement)this.application);
        this.setToolTipExecution();
        if (currentProject.getType() == ProjectType.WEBSERVICE) {
            if (genericToolbar != null) {
                genericToolbar.setVisible(false);
                genericToolbar.setToBeRendered(false);
            }
            if (webserviceToolbar != null) {
                webserviceToolbar.setVisible(true);
                webserviceToolbar.setToBeRendered(true);
            }
        } else {
            if (genericToolbar != null) {
                genericToolbar.setVisible(true);
                genericToolbar.setToBeRendered(true);
            }
            if (webserviceToolbar != null) {
                webserviceToolbar.setVisible(false);
                webserviceToolbar.setToBeRendered(false);
            }
        }
        if (newTestCaseToolbar != null) {
            newTestCaseToolbar.setVisible(true);
            newTestCaseToolbar.setToBeRendered(true);
        }
    }

    private void showDebugToolitemForEnterpriseAccount() {
        boolean isEnableDebugFeature = this.featureController.canUse(ProductFeature.DEBUG_MODE);
        MToolBar executionToolBar = (MToolBar)this.modelService.find("com.kms.katalon.composer.toolbar.execution", (MUIElement)this.application);
        MHandledToolItem executionToolItemDebug = (MHandledToolItem)this.modelService.find("com.kms.katalon.composer.execution.handledtoolitem.debug", (MUIElement)executionToolBar);
        if (executionToolItemDebug != null) {
            executionToolItemDebug.setVisible(isEnableDebugFeature);
            executionToolItemDebug.setToBeRendered(isEnableDebugFeature);
        }
    }

    private void setToolTipExecution() {
        if (Platform.getCurrent().is(Platform.MAC)) {
            MToolBar executionToolBar = (MToolBar)this.modelService.find("com.kms.katalon.composer.toolbar.execution", (MUIElement)this.application);
            MHandledToolItem executionToolItemRun = (MHandledToolItem)this.modelService.find("com.kms.katalon.composer.execution.handledtoolitem.run", (MUIElement)executionToolBar);
            executionToolItemRun.setLabel("Run (Command + Shift + A)");
            MHandledToolItem executionToolItemDebug = (MHandledToolItem)this.modelService.find("com.kms.katalon.composer.execution.handledtoolitem.debug", (MUIElement)executionToolBar);
            executionToolItemDebug.setLabel("Run (Command + Shift + D)");
        } else if (Platform.getCurrent().is(Platform.WINDOWS)) {
            MToolBar executionToolBar = (MToolBar)this.modelService.find("com.kms.katalon.composer.toolbar.execution", (MUIElement)this.application);
            MHandledToolItem executionToolItemRun = (MHandledToolItem)this.modelService.find("com.kms.katalon.composer.execution.handledtoolitem.run", (MUIElement)executionToolBar);
            executionToolItemRun.setLabel("Run (Ctrl + Shift + A)");
            MHandledToolItem executionToolItemDebug = (MHandledToolItem)this.modelService.find("com.kms.katalon.composer.execution.handledtoolitem.debug", (MUIElement)executionToolBar);
            executionToolItemDebug.setLabel("Run (Ctrl + Shift + D)");
        }
    }
}

