/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.initializer;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.initializer.ApplicationInitializer;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

public class ContentAssistProposalInitializer
implements ApplicationInitializer {
    private static final String DEFAULT_PROPOSAL_CATEGORY = "org.eclipse.jdt.ui.defaultProposalCategory";
    private static final String GROOVY_CODEASSIST_PROPOSAL = "org.codehaus.groovy.eclipse.codeassist.category";
    private static final String JDT_PREF_ID = "org.eclipse.jdt.ui";
    private static final String CONTENT_ASSIST_CATEGORY_ORDER = "content_assist_category_order";
    private static final String CONTENT_ASSIST_DISABLED_COMPUTERS = "content_assist_disabled_computers";
    private static final String CONTENT_ASSIST_PROPOSAL_ID = "com.kms.katalon.proposal";
    private static final String CONTENT_ASSIST_PROPOSAL_ID_WITH_INDEX = "com.kms.katalon.proposal:0";
    private static final String SEPARATOR = "\u0000";
    private static final String CONTENT_ASSIST_AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final int AUTOACTIVATION_DELAY_IN_MILLIS = 500;
    private ScopedPreferenceStore jdtStore = PreferenceStoreManager.getPreferenceStore((String)"org.eclipse.jdt.ui");

    @Override
    public void setup() {
        if (this.isNotFirstTimeUsed()) {
            return;
        }
        this.enableAutoActivationTrigger();
        this.updateFistTimeUsed();
        try {
            this.jdtStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void enableAutoActivationTrigger() {
        this.jdtStore.setValue(CONTENT_ASSIST_AUTOACTIVATION_DELAY, 500);
    }

    private boolean isNotFirstTimeUsed() {
        return this.jdtStore.getBoolean("firstTimeSetupCompleted");
    }

    private void updateFistTimeUsed() {
        this.jdtStore.setValue("firstTimeSetupCompleted", true);
    }

    private void topUpKatalonStudioProposal() {
        ArrayList<String> proposals = new ArrayList<String>();
        String katalonProposalDescription = CONTENT_ASSIST_PROPOSAL_ID_WITH_INDEX;
        String[] stringArray = this.jdtStore.getString(CONTENT_ASSIST_CATEGORY_ORDER).split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.startsWith(CONTENT_ASSIST_PROPOSAL_ID)) {
                katalonProposalDescription = p;
            } else {
                proposals.add(p);
            }
            ++n2;
        }
        proposals.add(0, katalonProposalDescription);
        this.jdtStore.setValue(CONTENT_ASSIST_CATEGORY_ORDER, StringUtils.join(proposals, (String)SEPARATOR));
    }

    private void disableGroovyProposal() {
        LinkedHashSet<String> proposals = new LinkedHashSet<String>();
        proposals.add(GROOVY_CODEASSIST_PROPOSAL);
        proposals.add(DEFAULT_PROPOSAL_CATEGORY);
        String[] stringArray = this.jdtStore.getString(CONTENT_ASSIST_DISABLED_COMPUTERS).split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            proposals.add(p);
            ++n2;
        }
        this.jdtStore.setValue(CONTENT_ASSIST_DISABLED_COMPUTERS, StringUtils.join(proposals, (String)SEPARATOR));
    }
}

