/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.toolbar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.toolbar.notification.INotificationContent;
import com.kms.katalon.composer.toolbar.notification.KatalonNotificationContent;
import com.kms.katalon.composer.toolbar.notification.NotificationContent;
import com.kms.katalon.composer.toolbar.notification.PopupNotification;
import com.kms.katalon.composer.toolbar.notification.TrackedNotification;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.LicenseType;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.EventHandler;

public class NotificationToolControl {
    private static final String UNIDENTIFIED = "unidentified";
    private static final String KATALON_NOTIFICATION = "katalon_notification";
    private static final String TRIAL_NOTIFICATION = "trial_notification";
    private static final String TRACKED_NOTIFICATIONS_JSON_FILE_NAME = "tracked_notifications.json";
    private static final String TRACKED_KATALON_NOTIFICATIONS_FILE_NAME = "tracked_katalon_notifications.json";
    private static final String KATALON_NOTIFICATION_PATH = "/katalon-notifications";
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IHttpClient httpClient;
    @Inject
    private INetworkPreferences networkPreferences;
    @Inject
    private ISessionController sessionController;
    @Inject
    private IFeatureController featureController;
    private List<PopupNotification> popupNotifications = new ArrayList<PopupNotification>();
    private ToolItem communityToolItem;

    @Inject
    public void registerListeners() {
        this.eventBroker.subscribe("ACTIVATION/CHECKED", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                NotificationToolControl.this.loadNotifications();
            }
        });
        this.eventBroker.subscribe("NOTIFICATIONS/RELOAD", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                NotificationToolControl.this.loadNotifications();
            }
        });
        this.eventBroker.subscribe("ACTIVATION/DEACTIVATED", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                NotificationToolControl.this.popupNotifications = new ArrayList<PopupNotification>();
                UISynchronizeService.asyncExec(() -> NotificationToolControl.this.communityToolItem.setImage(ImageConstants.IMG_KATALON_NOTIFICATION_24));
            }
        });
    }

    private void loadNotifications() {
        Executors.newFixedThreadPool(1).submit(() -> {
            ArrayList<PopupNotification> trialAndKataloNoti = new ArrayList<PopupNotification>();
            List<PopupNotification> list1 = this.getPopupNotificationsForTrialUser();
            List<PopupNotification> list2 = this.getPopupKatalonNotifications();
            trialAndKataloNoti.addAll(list2);
            trialAndKataloNoti.addAll(list1);
            this.popupNotifications = trialAndKataloNoti;
            UISynchronizeService.asyncExec(() -> {
                long unreadMessageCount = this.popupNotifications.stream().filter(p -> p.getTracked() == null).count();
                if (unreadMessageCount > 0L) {
                    this.communityToolItem.setImage(ImageConstants.IMG_KATALON_DOT_NOTIFICATION_24);
                }
            });
        });
    }

    @PostConstruct
    public void createWidget(Composite parent, MToolControl toolControl) {
        final ToolBar toolbar = new ToolBar(parent, 0x820000);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.communityToolItem = new ToolItem(toolbar, 32);
        this.communityToolItem.setImage(ImageConstants.IMG_KATALON_NOTIFICATION_24);
        this.communityToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private Shell popup;

            private void uncheckNotificationItem() {
                NotificationToolControl.this.communityToolItem.setSelection(false);
                NotificationToolControl.this.communityToolItem.notifyListeners(13, new Event());
            }

            public void widgetSelected(SelectionEvent e) {
                NotificationToolControl.this.communityToolItem.setImage(ImageConstants.IMG_KATALON_NOTIFICATION_24);
                if (NotificationToolControl.this.communityToolItem.getSelection()) {
                    Trackings.trackClickOnTrialNotificationButton();
                    this.popup = new Shell(toolbar.getDisplay(), 16392);
                    this.popup.setLayout((Layout)new FillLayout());
                    Composite mainComposite = new Composite((Composite)this.popup, 2048);
                    mainComposite.setLayoutData((Object)new GridData(1808));
                    mainComposite.setLayout((Layout)new GridLayout());
                    if (!NotificationToolControl.this.popupNotifications.isEmpty()) {
                        for (final PopupNotification noti2 : NotificationToolControl.this.popupNotifications) {
                            Composite composite = new Composite(mainComposite, 0);
                            composite.setLayoutData((Object)new GridData(768));
                            composite.setLayout((Layout)new GridLayout(2, false));
                            final Link link = new Link(composite, 0);
                            link.setLayoutData((Object)new GridData(256, 0x1000000, true, false));
                            link.setText(noti2.getContent().getMessage());
                            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    link.removeSelectionListener((SelectionListener)this);
                                    this.uncheckNotificationItem();
                                    Executors.newFixedThreadPool(1).submit(() -> {
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                        Program.launch((String)selectionEvent.text);
                                        Trackings.trackClickOnTrialNotification((String)noti2.getContent().getMessage());
                                    });
                                }
                            });
                            if (noti2.getTracked() == null) {
                                TrackedNotification tracked = new TrackedNotification();
                                tracked.setId(noti2.getContent().getId());
                                tracked.setTrackedDate(OffsetDateTime.now());
                                tracked.setType(this.getType(noti2.getContent()));
                                noti2.setTracked(tracked);
                            }
                            Label lbl = new Label(composite, 0);
                            GridData gdLbl = new GridData(16384, 0x1000000, false, false);
                            lbl.setLayoutData((Object)gdLbl);
                            lbl.setText(NotificationToolControl.this.getReadDate(Date.from(noti2.getTracked().getTrackedDate().toInstant()), new Date()));
                        }
                        List<TrackedNotification> newTracked = NotificationToolControl.this.popupNotifications.stream().map(noti -> noti.getTracked()).collect(Collectors.toList());
                        NotificationToolControl.this.saveTrackedNotifications(newTracked);
                        this.popup.setSize(mainComposite.computeSize(400, -1));
                    } else {
                        Composite composite = new Composite(mainComposite, 0);
                        composite.setLayoutData((Object)new GridData(1808));
                        GridLayout gridLayout = new GridLayout(1, false);
                        gridLayout.marginWidth = 10;
                        gridLayout.marginHeight = 10;
                        composite.setLayout((Layout)gridLayout);
                        Label lbl = new Label(composite, 0);
                        lbl.setText("There are no new messages");
                        this.popup.setSize(mainComposite.computeSize(300, -1));
                    }
                    this.popup.getDisplay().addFilter(26, new Listener(){

                        public void handleEvent(Event event) {
                            if (popup == null || popup.isDisposed()) {
                                return;
                            }
                            if (event.widget == null) {
                                event.display.removeFilter(26, (Listener)this);
                                this.uncheckNotificationItem();
                                return;
                            }
                            if (event.widget instanceof Shell) {
                                if (event.widget == popup) {
                                    return;
                                }
                                event.display.removeFilter(26, (Listener)this);
                                this.uncheckNotificationItem();
                                return;
                            }
                            Control control = (Control)event.widget;
                            if (control.getShell() != popup) {
                                event.display.removeFilter(26, (Listener)this);
                                this.uncheckNotificationItem();
                                return;
                            }
                        }
                    });
                    this.popup.setLocation(toolbar.getBounds().x - this.popup.getSize().x + 36, toolbar.getBounds().y + 78);
                    this.popup.setVisible(true);
                } else {
                    this.popup.setVisible(false);
                    this.popup.dispose();
                }
            }

            private String getType(INotificationContent content) {
                if (content instanceof NotificationContent) {
                    return NotificationToolControl.TRIAL_NOTIFICATION;
                }
                if (content instanceof KatalonNotificationContent) {
                    return NotificationToolControl.KATALON_NOTIFICATION;
                }
                return NotificationToolControl.UNIDENTIFIED;
            }
        });
    }

    public List<NotificationContent> getNotificationContents() {
        try {
            Bundle bundle = FrameworkUtil.getBundle(NotificationToolControl.class);
            URL contentUrl = FileLocator.toFileURL((URL)bundle.getResource("resources/notification/notification_content.json"));
            Type listType = new TypeToken<List<NotificationContent>>(){}.getType();
            return (List)JsonUtil.fromJson((String)FileUtils.readFileToString((File)new File(contentUrl.getFile())), (Type)listType);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    private List<TrackedNotification> InternallyGetTrackedNotifications(String fileName) {
        File trackedNotificationFile = new File(GlobalStringConstants.APP_USER_DIR_LOCATION, "notification/" + fileName);
        if (!trackedNotificationFile.exists()) {
            return Collections.emptyList();
        }
        try {
            Type mapType = new TypeToken<Map<String, List<TrackedNotification>>>(){}.getType();
            Map userNotifications = (Map)JsonUtil.fromJson((String)FileUtils.readFileToString((File)trackedNotificationFile), (Type)mapType);
            String email = ApplicationContext.getInstance().getUserId();
            return userNotifications.getOrDefault(email, Collections.emptyList());
        }
        catch (IOException | IllegalArgumentException e) {
            LoggerSingleton.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    private void saveTrackedNotifications(List<TrackedNotification> trackedNotifications) {
        this.internallySaveTrackedNotifications(trackedNotifications.stream().filter(noti -> TRIAL_NOTIFICATION.equals(noti.getType())).collect(Collectors.toList()), TRACKED_NOTIFICATIONS_JSON_FILE_NAME);
        this.internallySaveTrackedNotifications(trackedNotifications.stream().filter(noti -> KATALON_NOTIFICATION.equals(noti.getType())).collect(Collectors.toList()), TRACKED_KATALON_NOTIFICATIONS_FILE_NAME);
    }

    private void internallySaveTrackedNotifications(List<TrackedNotification> trackedNotifications, String fileName) {
        File trackedNotificationFile = new File(GlobalStringConstants.APP_USER_DIR_LOCATION, "notification/" + fileName);
        try {
            Type mapType = new TypeToken<Map<String, List<TrackedNotification>>>(){}.getType();
            Map<String, List<TrackedNotification>> trackedNotiByUsers = new HashMap<String, List<TrackedNotification>>();
            if (trackedNotificationFile.exists()) {
                trackedNotiByUsers = (Map)JsonUtil.fromJson((String)FileUtils.readFileToString((File)trackedNotificationFile), (Type)mapType);
            }
            String email = ApplicationContext.getInstance().getUserId();
            trackedNotiByUsers.put(email, trackedNotifications);
            FileUtils.writeStringToFile((File)trackedNotificationFile, (String)JsonUtil.toJson(trackedNotiByUsers), (boolean)false);
        }
        catch (IOException | IllegalArgumentException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private List<PopupNotification> getPopupNotifications(List<? extends INotificationContent> contentList, List<TrackedNotification> trackedNotifications) {
        Map<String, TrackedNotification> trackedById = this.trackedById(trackedNotifications);
        ArrayList<PopupNotification> popupNotifications = new ArrayList<PopupNotification>();
        for (INotificationContent iNotificationContent : contentList) {
            PopupNotification popup = new PopupNotification();
            popup.setContent(iNotificationContent);
            String notificationId = iNotificationContent.getId();
            popup.setTracked(trackedById.getOrDefault(notificationId, null));
            popupNotifications.add(popup);
        }
        return popupNotifications;
    }

    private Map<String, TrackedNotification> trackedById(List<TrackedNotification> trackedNotifications) {
        HashMap<String, TrackedNotification> trackedById = new HashMap<String, TrackedNotification>();
        for (TrackedNotification tracked : trackedNotifications) {
            trackedById.put(tracked.getId(), tracked);
        }
        return trackedById;
    }

    private String getReadDate(Date oldDate, Date newDate) {
        long diffDays = this.diffDays(oldDate, newDate);
        if (diffDays <= 0L) {
            return "Today";
        }
        if (diffDays == 1L) {
            return "Yesterday";
        }
        return String.format("%d days ago", diffDays);
    }

    private long diffDays(Date oldDate, Date newDate) {
        long diff = DateUtils.truncate((Date)newDate, (int)5).getTime() - DateUtils.truncate((Date)oldDate, (int)5).getTime();
        long diffDays = diff / 86400000L;
        return diffDays;
    }

    private List<PopupNotification> getPopupNotificationsForTrialUser() {
        Session session = this.sessionController.getSession();
        License license = session.getLicense();
        if (license.getLicenseType() == LicenseType.ENTERPRISE) {
            return Collections.emptyList();
        }
        Date expiredDate = ApplicationContext.getInstance().getExpirationTrial();
        if (expiredDate == null) {
            return Collections.emptyList();
        }
        Date activationDate = DateUtils.addDays((Date)expiredDate, (int)-30);
        long diffDays = this.diffDays(activationDate, new Date());
        List<TrackedNotification> trackedNotifications = this.InternallyGetTrackedNotifications(TRACKED_NOTIFICATIONS_JSON_FILE_NAME);
        Map<String, TrackedNotification> trackedById = this.trackedById(trackedNotifications);
        List notifications = this.getNotificationContents().stream().filter(content -> {
            if (trackedById.containsKey(content.getId())) {
                return true;
            }
            if ((long)content.getStartDate() > diffDays) {
                return false;
            }
            return content.getEndDate() <= 0 || (long)content.getEndDate() >= diffDays;
        }).collect(Collectors.toList());
        notifications.sort(new Comparator<NotificationContent>(){

            @Override
            public int compare(NotificationContent notiA, NotificationContent notiB) {
                return notiB.getStartDate() - notiA.getStartDate();
            }
        });
        return this.getPopupNotifications(notifications, trackedNotifications);
    }

    private List<KatalonNotificationContent> getKatalonNotificationContent() {
        if (!this.allowReceiveDynamicContentNotifications()) {
            return Collections.emptyList();
        }
        try {
            String noti_server_url = ApplicationInfo.getAppProperty((String)"notification_server");
            if (noti_server_url == null) {
                noti_server_url = "https://backend.katalon.com";
                ApplicationInfo.setAppProperty((String)"notification_server", (String)"https://backend.katalon.com", (boolean)true);
            }
            URI baseUri = new URI(noti_server_url);
            URI uri = new URIBuilder().setScheme(baseUri.getScheme()).setHost(baseUri.getHost()).setPath(KATALON_NOTIFICATION_PATH).build();
            ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
            HttpOptions httpOptions = new HttpOptions.Builder().proxy(proxyConfig).build();
            HttpResponse response = this.httpClient.get(uri, httpOptions);
            ObjectMapper objectMapper = new ObjectMapper();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
            objectMapper.setDateFormat((DateFormat)dateFormat);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                return (List)objectMapper.readValue(response.getBody(), (TypeReference)new TypeReference<List<KatalonNotificationContent>>(){});
            }
            catch (JsonProcessingException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return Collections.emptyList();
    }

    private boolean allowReceiveDynamicContentNotifications() {
        boolean allowConfigReceiveNotifications;
        ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        boolean bl = allowConfigReceiveNotifications = prefStore.contains("general.receiveDynamicContentNotifications") ? prefStore.getBoolean("general.receiveDynamicContentNotifications") : true;
        if (this.featureController.canUse(ProductFeature.CONFIGURE_RECEIVE_DYNAMIC_CONTENT_NOTIFICATIONS)) {
            return allowConfigReceiveNotifications;
        }
        return true;
    }

    private List<PopupNotification> getPopupKatalonNotifications() {
        List<TrackedNotification> trackedNotifications = this.InternallyGetTrackedNotifications(TRACKED_KATALON_NOTIFICATIONS_FILE_NAME);
        Map<String, TrackedNotification> trackedById = this.trackedById(trackedNotifications);
        Date currentDate = new Date();
        List notifications = this.getKatalonNotificationContent().stream().filter(content -> {
            if (trackedById.containsKey(content.getId())) {
                return true;
            }
            if (content.getStartDate() != null && content.getStartDate().after(currentDate)) {
                return false;
            }
            return content.getEndDate() == null || !content.getEndDate().before(currentDate);
        }).filter(element -> this.shouldShowForCurrentLicense((KatalonNotificationContent)element)).collect(Collectors.toList());
        notifications.sort(new Comparator<KatalonNotificationContent>(){

            @Override
            public int compare(KatalonNotificationContent notiA, KatalonNotificationContent notiB) {
                return notiB.getStartDate().compareTo(notiA.getStartDate());
            }
        });
        return this.getPopupNotifications(notifications, trackedNotifications);
    }

    private boolean shouldShowForCurrentLicense(KatalonNotificationContent element) {
        boolean canConfigReceiveDynamicContentNoti = this.featureController.canUse(ProductFeature.CONFIGURE_RECEIVE_DYNAMIC_CONTENT_NOTIFICATIONS);
        return canConfigReceiveDynamicContentNoti && "KSE".equals(element.getType()) || !canConfigReceiveDynamicContentNoti && "KS".equals(element.getType());
    }
}

