/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.application;

import com.kms.katalon.activation.dialog.BrowserLoginAvailableDialog;
import com.kms.katalon.activation.dialog.ExpiredSessionDialog;
import com.kms.katalon.activation.dialog.ModernActivationDialog;
import com.kms.katalon.activation.dialog.WarningLicenseDialog;
import com.kms.katalon.activation.dialog.WarningUpgradeEditionDialog;
import com.kms.katalon.addons.CommandBindingRemover;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserExperienceLevel;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.editors.extensions.OpenEditorActionFactory;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.composer.handlers.CloseHandler;
import com.kms.katalon.composer.handlers.DeactivateHandler;
import com.kms.katalon.composer.handlers.IdleTimeoutHandler;
import com.kms.katalon.composer.handlers.QuitHandler;
import com.kms.katalon.composer.handlers.ResetPerspectiveHandler;
import com.kms.katalon.composer.handlers.SaveHandler;
import com.kms.katalon.composer.handlers.SearchHandler;
import com.kms.katalon.composer.handlers.WorkbenchSaveHandler;
import com.kms.katalon.composer.initializer.CommandBindingInitializer;
import com.kms.katalon.composer.initializer.ContentAssistProposalInitializer;
import com.kms.katalon.composer.initializer.CucumberEditorColorInitializer;
import com.kms.katalon.composer.initializer.DefaultLineNumberInitializer;
import com.kms.katalon.composer.initializer.DefaultTextFontInitializer;
import com.kms.katalon.composer.initializer.ProblemViewImageInitializer;
import com.kms.katalon.composer.project.template.SampleProjectProvider;
import com.kms.katalon.composer.quickstart.QuickStartDialogV2;
import com.kms.katalon.composer.quickstart.QuickStartDialogV3;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.discovery.core.services.IDiscoveryController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.QuickStartProjectType;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.marketing.core.model.LoginSurveyContext;
import com.kms.katalon.marketing.core.model.MarketingSurvey;
import com.kms.katalon.marketing.core.model.MarketingUrl;
import com.kms.katalon.marketing.core.model.MarketingUrlContext;
import com.kms.katalon.marketing.core.model.MarketingWelcomePageContext;
import com.kms.katalon.marketing.core.model.SurveyContext;
import com.kms.katalon.marketing.core.sevices.IMarketingService;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.composer.dialog.ReloginViaRememberDialog;
import com.kms.katalon.session.core.model.ActivationNotice;
import com.kms.katalon.session.core.model.License;
import com.kms.katalon.session.core.model.RememberedApiKey;
import com.kms.katalon.session.core.model.RememberedCredential;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.model.SessionExpireSchedule;
import com.kms.katalon.session.core.model.User;
import com.kms.katalon.session.core.model.exception.MultipleActivationException;
import com.kms.katalon.session.core.model.exception.SessionException;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.tracking.core.TrackingManager;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.OpenEditorAction;
import io.cucumber.eclipse.editor.CucumberActivitySupport;
import io.cucumber.eclipse.editor.launching.Mode;
import io.cucumber.eclipse.editor.preferences.CucumberEditorPreferences;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Timer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.PartSite;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleManager {
    private Logger logger = LoggerFactory.getLogger(LifeCycleManager.class);
    private IEclipseContext context;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ISessionController sessionController;
    @Inject
    private IDiscoveryController discoveryController;
    @Inject
    private IMarketingService marketingService;
    private Queue<SessionExpireSchedule> pendingSessionExpireSchedules = new ConcurrentLinkedQueue<SessionExpireSchedule>();
    private SessionExpireSchedule currentSessionExpireSchedule;
    private AtomicReference<SessionExpireSchedule> currentSessionExpireScheduleForToken = new AtomicReference<Object>(null);
    private SampleProjectProvider sampleProjectProvider = SampleProjectProvider.getInstance();
    private Timer logoutTimer;
    private static boolean WORKSPACE_CREATED = false;
    private volatile String latestOpenedProjectId;

    public static boolean isWorkspaceCreated() {
        return WORKSPACE_CREATED;
    }

    private void startUpGUIMode() throws Exception {
        this.setUpDefaultTheme();
        this.setupHandlers();
        this.setupPreferences();
        this.eventBroker.post("WORKSPACE/CREATED", (Object)"");
        WORKSPACE_CREATED = true;
    }

    protected void setupHandlers() throws BundleException {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.save", (IHandler)new SaveHandler());
        handlerService.activateHandler("org.eclipse.ui.file.close", (IHandler)new CloseHandler());
        handlerService.activateHandler("org.eclipse.ui.file.exit", (IHandler)new QuitHandler());
        handlerService.activateHandler("org.eclipse.search.ui.openSearchDialog", (IHandler)new SearchHandler());
        handlerService.activateHandler("com.kms.katalon.composer.menu.handler.resetPerspective", (IHandler)new ResetPerspectiveHandler());
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        contextService.activateContext("katalonContext");
        BundleContext bundleContext = FrameworkUtil.getBundle(LifeCycleManager.class).getBundleContext();
        this.context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.context.set(ISaveHandler.class, (Object)new WorkbenchSaveHandler());
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IWorkbenchPage page = workbenchWindow.getActivePage();
        workbenchWindow.getPartService().addPartListener(new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                EventBrokerSingleton.getInstance().getEventBroker().post("EDITORS_CLOSED", (Object)partRef.getPart(true));
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                if ("org.eclipse.search.ui.views.SearchView".equals(partRef.getId())) {
                    SearchHandler.openSearchView();
                    return;
                }
                if ("org.codehaus.groovy.eclipse.editor.GroovyEditor".equals(partRef.getId())) {
                    IEditorPart editor = page.getActiveEditor();
                    if (editor != null && editor instanceof GroovyEditor) {
                        OpenEditorActionFactory.fixOpenDeclarationEditor((GroovyEditor)((GroovyEditor)editor));
                    }
                    EventUtil.post((String)"PROPERTIES/ENTITY", null);
                    new CommandBindingInitializer().resetDeleteKeyBinding();
                }
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if ("org.eclipse.ui.console.ConsoleView".equals(partRef.getId())) {
                    Trackings.trackOpenConsoleView();
                }
                if (LifeCycleManager.this.isRawGroovyEditorOfEntityPart(partRef, page)) {
                    IEditorPart editor = page.getActiveEditor();
                    if (editor == null) {
                        return;
                    }
                    IEditorInput input = editor.getEditorInput();
                    IFile file = ((IFileEditorInput)input).getFile();
                    IEditorPart replacedEditor = LifeCycleManager.this.replaceEditor(file, page);
                    if (replacedEditor != null) {
                        Display.getDefault().asyncExec(() -> page.hideEditor((IEditorReference)page.getReference((IWorkbenchPart)editor)));
                    }
                }
            }
        });
        new CommandBindingInitializer().setup();
        new CommandBindingRemover().setup();
        new ContentAssistProposalInitializer().setup();
        new ProblemViewImageInitializer().setup();
        new DefaultTextFontInitializer().setup();
        new CucumberEditorColorInitializer().setup();
        new DefaultLineNumberInitializer().setup();
    }

    private void setupPreferences() {
        this.setupResourcePlugin();
        this.setupGroovyTemplatePlugin();
        CucumberActivitySupport.disableAllCucumberActivities();
        Mode[] modeArray = Mode.values();
        int n = modeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mode launchMode = modeArray[n2];
            CucumberEditorPreferences.setShowShortcutFor((Mode)launchMode, (boolean)false);
            ++n2;
        }
    }

    private void setupGroovyTemplatePlugin() {
        try {
            ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"org.codehaus.groovy.eclipse.quickfix");
            if (!prefStore.getBoolean("groovy.first.setup")) {
                prefStore.setDefault("groovy", "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><templates><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Checkpoint\" enabled=\"true\" name=\"cp\">${Checkpoint:newType(com.kms.katalon.core.checkpoint.Checkpoint)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Checkpoint Factory\" enabled=\"true\" name=\"cpf\">${CheckpointFactory:newType(com.kms.katalon.core.checkpoint.CheckpointFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Failure Handling\" enabled=\"true\" name=\"fh\">${FailureHandling:newType(com.kms.katalon.core.model.FailureHandling)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Checkpoint\" enabled=\"true\" name=\"fcp\">${findCheckpoint:importStatic(com.kms.katalon.core.checkpoint.CheckpointFactory.findCheckpoint)}findCheckpoint(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Case\" enabled=\"true\" name=\"ftc\">${findTestCase:importStatic(com.kms.katalon.core.testcase.TestCaseFactory.findTestCase)}findTestCase(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Data\" enabled=\"true\" name=\"ftd\">${findTestData:importStatic(com.kms.katalon.core.testdata.TestDataFactory.findTestData)}findTestData(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Find Test Object\" enabled=\"true\" name=\"fto\">${findTestObject:importStatic(com.kms.katalon.core.testobject.ObjectRepository.findTestObject)}findTestObject(${word_selection}${null})${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Global Variables\" enabled=\"true\" name=\"gv\">${GlobalVariable:newType(internal.GlobalVariable)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Object Repository\" enabled=\"true\" name=\"tof\">${ObjectRepository:newType(com.kms.katalon.core.testobject.ObjectRepository)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Case\" enabled=\"true\" name=\"tc\">${TestCase:newType(com.kms.katalon.core.testcase.TestCase)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Case Factory\" enabled=\"true\" name=\"tcf\">${TestCaseFactory:newType(com.kms.katalon.core.testcase.TestCaseFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Data\" enabled=\"true\" name=\"td\">${TestData:newType(com.kms.katalon.core.testdata.TestData)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Data Factory\" enabled=\"true\" name=\"tdf\">${TestDataFactory:newType(com.kms.katalon.core.testdata.TestDataFactory)}${cursor}</template><template autoinsert=\"true\" context=\"groovy\" deleted=\"false\" description=\"Katalon - Test Object\" enabled=\"true\" name=\"to\">${TestObject:newType(com.kms.katalon.core.testobject.TestObject)}${cursor}</template></templates>");
                prefStore.setToDefault("groovy");
                prefStore.setValue("groovy.first.setup", true);
            }
            prefStore.save();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
    }

    private void setupResourcePlugin() {
        try {
            ScopedPreferenceStore runtimePrefStore = PreferenceStoreManager.getPreferenceStore((String)"org.eclipse.core.resources");
            if (!runtimePrefStore.getBoolean("description.autobuilding")) {
                runtimePrefStore.setValue("description.autobuilding", true);
            }
            if (!runtimePrefStore.getBoolean("refresh.lightweight.enabled")) {
                runtimePrefStore.setValue("refresh.lightweight.enabled", true);
            }
            runtimePrefStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setUpDefaultTheme() {
        IThemeEngine engine = ComponentBundleActivator.getThemeEngine((Display)Display.getCurrent());
        if (engine.getActiveTheme() == null) {
            engine.setTheme("com.kms.katalon.theme.default", true);
        }
    }

    @PostContextCreate
    void postContextCreate(final IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/LifeCycle/appStartupComplete", new EventHandler(){

            public void handleEvent(Event event) {
                if (LifeCycleManager.this.isTestMode()) {
                    return;
                }
                LifeCycleManager.this.cleanProjects();
                try {
                    LifeCycleManager.this.startUpGUIMode();
                }
                catch (Exception e) {
                    LifeCycleManager.this.logger.error(e.getMessage());
                    return;
                }
                eventBroker.send("ACTIVATION", null);
            }
        });
        eventBroker.subscribe("ACTIVATION", new EventHandler(){

            public void handleEvent(Event event) {
                LifeCycleManager.this.cancelAllSessionExpireSchedules();
                new RestoreProgressDialog(LifeCycleManager.this.getShell()).run(() -> LifeCycleManager.this.checkSession());
            }
        });
        eventBroker.subscribe("SURVEY/START", new EventHandler(){

            public void handleEvent(Event event) {
                LifeCycleManager.this.handleQuickStart();
                eventBroker.post("SURVEY/CLOSED", null);
            }
        });
        eventBroker.subscribe("DEACTIVATION", new EventHandler(){

            public void handleEvent(Event event) {
                LifeCycleManager.this.cancelAllSessionExpireSchedules();
                ReleaseProgressDialog releaseDialog = new ReleaseProgressDialog(Display.getCurrent().getActiveShell());
                releaseDialog.run();
                eventBroker.send("CLOSE_DIALOG", null);
                eventBroker.send("PROJECT/CLOSE", null);
                eventBroker.send("DEACTIVATION/WEBVIEW_PAGE", null);
            }
        });
        eventBroker.subscribe("LOGOUT", new EventHandler(){

            public void handleEvent(Event event) {
                ProjectEntity project = ProjectController.getInstance().getCurrentProject();
                LifeCycleManager.this.latestOpenedProjectId = project != null ? project.getId() : null;
                eventBroker.send("DEACTIVATION", null);
                LogoutProgressDialog logoutDialog = new LogoutProgressDialog(Display.getCurrent().getActiveShell());
                logoutDialog.run();
                eventBroker.send("ACTIVATION", null);
            }
        });
        eventBroker.subscribe("WORKSPACE/CLOSE", new EventHandler(){

            public void handleEvent(Event event) {
                if (PlatformUI.getWorkbench() != null && !PlatformUI.getWorkbench().isClosing()) {
                    PlatformUI.getWorkbench().close();
                }
            }
        });
        eventBroker.subscribe("MKT_REGISTER_TRACKING", new EventHandler(){

            public void handleEvent(Event event) {
                LifeCycleManager.this.handleOpenMarketingWelcomePage();
            }
        });
    }

    private void checkSession() {
        String machineId;
        if (!this.sessionController.isActivated()) {
            Trackings.trackOpenFirstTime();
            Shell shell = this.getShell();
            ModernActivationDialog activationDialog = new ModernActivationDialog(shell);
            ContextInjectionFactory.inject((Object)((Object)activationDialog), (IEclipseContext)this.context);
            SessionExpireSchedule.Reason lastExpireReason = this.sessionController.getLastExpireReason();
            RememberedCredential rememberedCredential = this.sessionController.getRememberedCredential();
            if (lastExpireReason != null && rememberedCredential != null && rememberedCredential instanceof RememberedApiKey) {
                RememberedApiKey rememberedApiKey = (RememberedApiKey)rememberedCredential;
                LoggerSingleton.logInfo((String)("Will show relogin dialog with last session expire: " + String.valueOf(lastExpireReason)));
                ReloginViaRememberDialog reloginDialog = new ReloginViaRememberDialog(shell, lastExpireReason);
                AtomicReference<Object> friendlyReloginErrorMessage = new AtomicReference<Object>(null);
                AtomicReference<Object> rawReloginErrorMessage = new AtomicReference<Object>(null);
                AtomicReference<Boolean> didUserChooseLoginWithAnotherAccount = new AtomicReference<Boolean>(false);
                reloginDialog.setReloginHandler(() -> {
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                    try {
                        progressDialog.run(true, false, monitor -> {
                            monitor.beginTask("Relogging in...", -1);
                            try {
                                this.sessionController.activateWithApiKey(rememberedApiKey.getValue());
                                if (StringUtils.isNotEmpty((CharSequence)this.latestOpenedProjectId)) {
                                    try {
                                        this.eventBroker.send("PROJECT/OPEN_LATEST", (Object)this.latestOpenedProjectId);
                                    }
                                    catch (Exception e) {
                                        this.logger.error("Failed to open latest project after relogin", (Throwable)e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                LoggerSingleton.logError((Throwable)e, (String)"Failed to relogin via remember me API key");
                                rawReloginErrorMessage.set(e.getMessage());
                                friendlyReloginErrorMessage.set("Automatic login failed due to account or network issues. Please log in again.");
                                this.sessionController.clearRememberedCredential();
                            }
                            monitor.done();
                        });
                    }
                    catch (Exception e) {
                        LoggerSingleton.logError((Throwable)e, (String)"Failed to relogin via remember me API key");
                    }
                    UISynchronizeService.asyncExec(() -> ((ReloginViaRememberDialog)reloginDialog).close());
                });
                reloginDialog.setLoginWithAnotherAccountHandler(() -> {
                    this.sessionController.clearRememberedCredential();
                    UISynchronizeService.asyncExec(() -> ((ReloginViaRememberDialog)reloginDialog).close());
                    UISynchronizeService.asyncExec(() -> ((ModernActivationDialog)activationDialog).open());
                    didUserChooseLoginWithAnotherAccount.set(true);
                    Trackings.trackLoginWithAnotherAccountAction();
                });
                reloginDialog.open();
                if (this.sessionController.isActivated()) {
                    activationDialog.close();
                    Trackings.trackReloginViaRememberMe((boolean)true, (SessionExpireSchedule.Reason)lastExpireReason, null);
                } else {
                    if (friendlyReloginErrorMessage.get() != null) {
                        activationDialog.create();
                        activationDialog.setErrorMessage(friendlyReloginErrorMessage.get());
                    }
                    if (!didUserChooseLoginWithAnotherAccount.get().booleanValue()) {
                        Trackings.trackReloginViaRememberMe((boolean)false, (SessionExpireSchedule.Reason)lastExpireReason, (String)rawReloginErrorMessage.get());
                    }
                    activationDialog.open();
                }
            } else {
                activationDialog.open();
            }
            this.showActivationNotice();
            this.showBrowserLoginAvailable();
        }
        if (!this.sessionController.isActivated()) {
            this.eventBroker.send("WORKSPACE/CLOSE", null);
            return;
        }
        this.sessionController.clearLastExpireReason();
        ApplicationContext appContext = ApplicationContext.getInstance();
        appContext.setLogoutAck(false);
        this.scheduleCheckingLicense();
        this.scheduleCheckingToken();
        this.scheduleCollectingStatistics();
        Session session = this.sessionController.getSession();
        User user = session.getUser();
        if (Objects.nonNull(user)) {
            ApplicationContext.getInstance().setUserId(user.getEmail());
            ApplicationContext.getInstance().setUserFirstName(user.getFirstName());
        }
        if (StringUtils.isNotBlank((CharSequence)(machineId = session.getMachineId()))) {
            ApplicationContext.getInstance().setMachineId(machineId);
        }
        try {
            Trackings.trackOpenApplication((boolean)false, (String)"gui");
        }
        catch (Exception exception) {}
        this.eventBroker.post("ACTIVATION/CHECKED", null);
        this.eventBroker.post("ACTIVATION/WEBVIEW_PAGE", null);
        String actionContext = session.getContextAction();
        if (StringUtils.isNotBlank((CharSequence)actionContext) && StringUtils.contains((CharSequence)actionContext, (CharSequence)"REGISTER")) {
            this.eventBroker.post("MKT_REGISTER_TRACKING", null);
        }
        this.eventBroker.post("SURVEY/START", null);
    }

    private void scheduleCollectingStatistics() {
        int trackingTime = TrackingManager.getInstance().getTrackingTime();
        ExecutionDefaultSettingStore executionStore = ExecutionDefaultSettingStore.getStore();
        Boolean smartWaitEnabled = executionStore != null ? Boolean.valueOf(executionStore.isSmartWaitEnabled()) : null;
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> Trackings.trackProjectStatistics((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (boolean)false, (String)"gui", (Boolean)smartWaitEnabled), trackingTime, trackingTime, TimeUnit.SECONDS);
    }

    private boolean isTestMode() {
        List<String> args = Arrays.asList(Platform.getCommandLineArgs());
        return args.contains("-testproperties") || args.contains("-testLoaderClass");
    }

    private boolean isRawGroovyEditorOfEntityPart(IWorkbenchPartReference partRef, IWorkbenchPage page) {
        if ("org.codehaus.groovy.eclipse.editor.GroovyEditor".equals(partRef.getId())) {
            ProjectEntity project;
            IEditorPart editor = page.getActiveEditor();
            if (editor == null) {
                return false;
            }
            IEditorSite site = editor.getEditorSite();
            String eleId = ((PartSite)site).getModel().getElementId();
            if (this.isScriptEditorInEntityPart(eleId)) {
                return false;
            }
            IEditorInput input = editor.getEditorInput();
            IFile file = ((IFileEditorInput)input).getFile();
            String filePath = file.getRawLocation().toString();
            return GroovyUtil.isScriptFile((String)filePath, (ProjectEntity)(project = ProjectController.getInstance().getCurrentProject())) || GroovyUtil.isTestSuiteScriptFile((String)filePath, (ProjectEntity)project) || GroovyUtil.isWebServiceVerificationFile((String)filePath, (ProjectEntity)project);
        }
        return false;
    }

    private boolean isScriptEditorInEntityPart(String eleId) {
        return eleId.contains("com.kms.katalon.composer.content.testcase") || eleId.contains("com.kms.katalon.composer.content.testobject") || eleId.contains("com.kms.katalon.composer.content.testsuite");
    }

    private IEditorPart replaceEditor(IFile file, IWorkbenchPage page) {
        String fileExtension = "." + file.getFileExtension();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        try {
            if (fileExtension.equals(".groovy")) {
                TestCaseEntity testCase;
                String filePath = file.getRawLocation().toString();
                if (GroovyUtil.isScriptFile((String)filePath, (ProjectEntity)project) && (testCase = TestCaseController.getInstance().getTestCaseByScriptFilePath(filePath)) != null) {
                    return OpenEditorAction.openTestCase(testCase);
                }
                if (GroovyUtil.isTestSuiteScriptFile((String)filePath, (ProjectEntity)project)) {
                    String testSuiteId = file.getFullPath().toString().replace(file.getProject().getFullPath().toString() + "/", "").replace(".groovy", "");
                    TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
                    if (testSuite != null) {
                        return OpenEditorAction.openTestSuite(testSuite);
                    }
                }
                if (GroovyUtil.isWebServiceVerificationFile((String)filePath, (ProjectEntity)project)) {
                    String testObjectId = file.getFullPath().toString().replace(file.getProject().getFullPath().toString() + "/", "").replace(".groovy", "");
                    WebElementEntity testObject = ObjectRepositoryController.getInstance().getWebElementByScriptName(testObjectId, project);
                    if (testObject != null) {
                        return OpenEditorAction.openTestObject(testObject);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return null;
    }

    private void enqueueNewSessionExpireSchedule(SessionExpireSchedule newSchedule) {
        if (newSchedule == null) {
            return;
        }
        if (this.pendingSessionExpireSchedules.stream().anyMatch(event -> event.getReason() == newSchedule.getReason())) {
            return;
        }
        if (this.currentSessionExpireSchedule != null && this.currentSessionExpireSchedule.getReason() == newSchedule.getReason()) {
            return;
        }
        this.pendingSessionExpireSchedules.add(newSchedule);
        UISynchronizeService.syncExec(() -> this.popAndScheduleNextSessionExpire());
    }

    private void scheduleCheckingLicense() {
        this.sessionController.startScheduleCheckingLicense(() -> {
            SessionExpireSchedule schedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.LICENSE_EXPIRED, ApplicationMessageConstants.LICENSE_EXPIRED_MESSAGE);
            this.enqueueNewSessionExpireSchedule(schedule);
        }, () -> {
            block3: {
                try {
                    boolean isTokenExpired;
                    boolean bl = isTokenExpired = this.currentSessionExpireScheduleForToken.get() != null && this.currentSessionExpireScheduleForToken.get().getReason() == SessionExpireSchedule.Reason.TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW;
                    if (isTokenExpired) {
                        return;
                    }
                    this.sessionController.reactivation();
                }
                catch (SessionException e) {
                    this.logger.error(e.getMessage());
                    Throwable cause = e.getCause();
                    if (!(cause instanceof MultipleActivationException)) break block3;
                    String format = ApplicationMessageConstants.LICENSE_ERROR_MESSAGE_FORMAT;
                    String message = MessageFormat.format(format, cause.getMessage());
                    SessionExpireSchedule schedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.LICENSE_ERROR, message);
                    this.enqueueNewSessionExpireSchedule(schedule);
                }
            }
        });
    }

    private void scheduleCheckingToken() {
        this.sessionController.startScheduleCheckingToken(sessionExpireSchedule -> this.handleSessionExpireScheduleForToken((SessionExpireSchedule)sessionExpireSchedule), () -> {
            try {
                this.sessionController.renewTokens();
                this.currentSessionExpireScheduleForToken.set(null);
            }
            catch (SessionException sessionException) {
                SessionExpireSchedule sessionExpireSchedule = new SessionExpireSchedule(SessionExpireSchedule.Reason.TOKEN_WILL_EXPIRE_AND_FAILED_TO_RENEW, ApplicationMessageConstants.TOKEN_WILL_EXPIRE_AND_FAILED_TO_RENEW_MESSAGE);
                this.handleSessionExpireScheduleForToken(sessionExpireSchedule);
            }
        });
    }

    private void popAndScheduleNextSessionExpire() {
        ApplicationContext appContext = ApplicationContext.getInstance();
        if (appContext.isLogoutAck()) {
            return;
        }
        if (this.pendingSessionExpireSchedules.isEmpty()) {
            return;
        }
        if (this.currentSessionExpireSchedule != null) {
            return;
        }
        TimeUtil.cancel((Timer)this.logoutTimer);
        IdleTimeoutHandler.getInstance().stopCountingDown();
        appContext.setLogoutAck(true);
        this.currentSessionExpireSchedule = this.pendingSessionExpireSchedules.poll();
        LoggerSingleton.logInfo((String)("Scheduling session expire: " + String.valueOf(this.currentSessionExpireSchedule.getReason())));
        Shell shell = Display.getCurrent().getActiveShell();
        ExpiredSessionDialog dialog = new ExpiredSessionDialog(shell, this.currentSessionExpireSchedule);
        dialog.open();
        long remainingTimeUntilLogout = Math.max(0L, this.currentSessionExpireSchedule.getScheduledLogoutTimeEpochMs() - System.currentTimeMillis());
        this.logoutTimer = UITimeUtil.setTimeout(() -> DeactivateHandler.getInstance().execute(this.currentSessionExpireSchedule.getReason()), (long)remainingTimeUntilLogout);
    }

    private void cancelAllSessionExpireSchedules() {
        this.pendingSessionExpireSchedules.clear();
        this.currentSessionExpireSchedule = null;
        this.currentSessionExpireScheduleForToken.set(null);
        if (this.logoutTimer != null) {
            UITimeUtil.cancel((Timer)this.logoutTimer);
            this.logoutTimer = null;
        }
    }

    private void showActivationNotice() {
        License license = this.sessionController.getSession().getLicense();
        if (license == null) {
            return;
        }
        ActivationNotice activationNotice = license.getActivationNotice();
        if (activationNotice == null) {
            return;
        }
        String code = activationNotice.getCode();
        String message = activationNotice.getMessage();
        if (StringUtils.isBlank((CharSequence)message)) {
            return;
        }
        if ("WARNING_UPGRADE_EDITION".equals(code)) {
            UISynchronizeService.syncExec(() -> {
                int n = new WarningUpgradeEditionDialog(this.getShell(), message).open();
            });
            return;
        }
        UISynchronizeService.syncExec(() -> {
            int n = new WarningLicenseDialog(this.getShell(), message).open();
        });
    }

    private void showBrowserLoginAvailable() {
        if (this.sessionController.shouldShowBrowserLoginAvailableDialog()) {
            UISynchronizeService.syncExec(() -> {
                int n = new BrowserLoginAvailableDialog(this.getShell()).open();
            });
        }
    }

    private void handleQuickStart() {
        boolean isOfflineLicenseOrOnPremise = false;
        if (isOfflineLicenseOrOnPremise) {
            this.showQuickStartDialogV2();
        } else {
            this.showQuickStartDialogV3();
        }
    }

    private void showQuickStartDialogV2() {
        boolean isSkipQuickStart;
        UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
        boolean bl = isSkipQuickStart = StringUtils.equals((CharSequence)System.getProperty("skipQuickStart"), (CharSequence)Boolean.TRUE.toString()) || StringUtils.equals((CharSequence)System.getenv("skipQuickStart"), (CharSequence)Boolean.TRUE.toString());
        if (isSkipQuickStart) {
            currentProfile.setDoneQuickStart(true);
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
            return;
        }
        currentProfile = UserProfileHelper.getCurrentProfile();
        if (currentProfile.isDoneQuickStart()) {
            return;
        }
        ProjectController.getInstance().setOpenning(true);
        QuickStartDialogV2 quickStartDialog = new QuickStartDialogV2(ShellManager.getMainShell());
        quickStartDialog.open();
        currentProfile.setExperienceLevel(quickStartDialog.getUserLevel());
        currentProfile.setPreferredTestingType(quickStartDialog.getProjectType());
        if (currentProfile.isOldUser()) {
            currentProfile.setDoneQuickStart(true);
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
            return;
        }
        if (!currentProfile.isDoneCreateFirstProject()) {
            try {
                switch (quickStartDialog.getProjectType()) {
                    case WEBUI: 
                    case MOBILE: 
                    case API: 
                    case DESKTOP: {
                        this.sampleProjectProvider.createFirstSampleProject(quickStartDialog.getProjectType());
                        break;
                    }
                    case BDD: {
                        this.sampleProjectProvider.createFirstBDDSampleProject();
                        break;
                    }
                }
            }
            catch (Exception error) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)MessageConstants.MSG_UNABLE_TO_CREATE_FIRST_PROJECT, (String)error.getLocalizedMessage(), (Shell)ShellManager.getLastActiveAliveShell());
                return;
            }
        }
        currentProfile.setDoneQuickStart(true);
        UserProfileHelper.saveProfile((UserProfile)currentProfile);
    }

    private void showQuickStartDialogV3() {
        boolean isSkipQuickStart;
        boolean bl = isSkipQuickStart = StringUtils.equals((CharSequence)System.getProperty("skipQuickStart"), (CharSequence)Boolean.TRUE.toString()) || StringUtils.equals((CharSequence)System.getenv("skipQuickStart"), (CharSequence)Boolean.TRUE.toString());
        if (isSkipQuickStart) {
            UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
            currentProfile.setExperienceLevel(UserExperienceLevel.EXPERIENCED);
            UserProfileHelper.saveProfile((UserProfile)currentProfile);
            return;
        }
        MarketingSurvey marketingSurvey = new MarketingSurvey();
        try {
            marketingSurvey = this.marketingService.getSurvey((SurveyContext)new LoginSurveyContext());
        }
        catch (Exception exception) {
            this.saveUserProfileWithDefaultValuIfNeed();
            return;
        }
        if (marketingSurvey == null) {
            this.saveUserProfileWithDefaultValuIfNeed();
            return;
        }
        String surveyUrl = marketingSurvey.getSurveyURL();
        if (surveyUrl == null || !surveyUrl.isEmpty()) {
            if (this.isValidUrl(surveyUrl)) {
                QuickStartDialogV3 quickStartDialog = new QuickStartDialogV3(ShellManager.getMainShell(), marketingSurvey.getDialogWidth(), marketingSurvey.getDialogHeight(), marketingSurvey.isCloseable());
                quickStartDialog.create();
                quickStartDialog.setUrl(surveyUrl);
                quickStartDialog.open();
                String defaultAction = marketingSurvey.getDefaultAction();
                if (quickStartDialog.isFinishedOnboardingSurvey()) {
                    UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
                    currentProfile.setExperienceLevel(quickStartDialog.getUserLevel());
                    currentProfile.setPreferredTestingType(quickStartDialog.getProjectType());
                    UserProfileHelper.saveProfile((UserProfile)currentProfile);
                    this.eventBroker.post("SURVEY/COMPLETED", null);
                } else if (defaultAction != null && defaultAction.equals("save_user_profile")) {
                    this.saveUserProfileWithDefaultValue();
                }
            } else {
                this.saveUserProfileWithDefaultValuIfNeed();
            }
        }
    }

    private boolean isValidUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)("Invalid url: " + url));
            return false;
        }
    }

    private void saveUserProfileWithDefaultValue() {
        UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
        currentProfile.setExperienceLevel(UserExperienceLevel.EXPERIENCED);
        currentProfile.setPreferredTestingType(QuickStartProjectType.WEBUI);
        UserProfileHelper.saveProfile((UserProfile)currentProfile);
    }

    private void saveUserProfileWithDefaultValuIfNeed() {
        UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
        if (currentProfile.getExperienceLevel() == null) {
            currentProfile.setExperienceLevel(UserExperienceLevel.EXPERIENCED);
        }
        if (currentProfile.getPreferredTestingType() == null) {
            currentProfile.setPreferredTestingType(QuickStartProjectType.WEBUI);
        }
        UserProfileHelper.saveProfile((UserProfile)currentProfile);
    }

    private Shell getShell() {
        Shell shell = Display.getCurrent().getActiveShell();
        if (shell == null || shell.isDisposed()) {
            shell = ShellManager.getMainShell();
        }
        if (shell == null || shell.isDisposed()) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return shell;
    }

    private void handleOpenMarketingWelcomePage() {
        MarketingUrl marketingUrl = new MarketingUrl();
        try {
            String nextAction;
            marketingUrl = this.marketingService.getUrl((MarketingUrlContext)new MarketingWelcomePageContext());
            if (marketingUrl == null) {
                return;
            }
            String url = marketingUrl.getUrl();
            if (StringUtils.isEmpty((CharSequence)url)) {
                return;
            }
            Program.launch((String)url);
            switch (nextAction = marketingUrl.getNextAction()) {
                case "RE_ACTIVE_APP": {
                    int timeout = marketingUrl.getTimeout();
                    Display.getDefault().timerExec(timeout, () -> this.getShell().forceActive());
                    break;
                }
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Error: GET Welcome Page URL and Open Browser");
        }
    }

    private void handleSessionExpireScheduleForToken(SessionExpireSchedule scheduleToken) {
        SessionExpireSchedule current = this.currentSessionExpireScheduleForToken.get();
        if (current != null && current.getReason() == scheduleToken.getReason()) {
            return;
        }
        this.currentSessionExpireScheduleForToken.set(scheduleToken);
        if (scheduleToken.getReason() == SessionExpireSchedule.Reason.TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW) {
            this.sessionController.endScheduleCheckingAdminToken();
        }
        this.logger.error(scheduleToken.getMessage());
    }

    public void cleanProjects() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.delete(false, true, null);
                this.logger.debug("Cleaned up project: {}", (Object)project.getName());
            }
            catch (CoreException e) {
                this.logger.error(MessageFormat.format("Failed to clean up project: {0}", project.getName()), (Throwable)e);
            }
            ++n2;
        }
    }

    public class LogoutProgressDialog
    extends ProgressMonitorDialog {
        public LogoutProgressDialog(Shell parent) {
            super(parent);
        }

        public void run() {
            try {
                this.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(StringConstants.MSG_LOG_OUT, -1);
                        try {
                            ((LogoutProgressDialog)LogoutProgressDialog.this).LifeCycleManager.this.sessionController.logout();
                        }
                        catch (Exception e) {
                            ((LogoutProgressDialog)LogoutProgressDialog.this).LifeCycleManager.this.logger.error(e.getMessage());
                        }
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {}
        }
    }

    public class ReleaseProgressDialog
    extends ProgressMonitorDialog {
        public ReleaseProgressDialog(Shell parent) {
            super(parent);
        }

        public void run() {
            try {
                this.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(StringConstants.MSG_RELEASING_LICENSE, -1);
                        ((ReleaseProgressDialog)ReleaseProgressDialog.this).LifeCycleManager.this.sessionController.endScheduleCheckingLicense();
                        ((ReleaseProgressDialog)ReleaseProgressDialog.this).LifeCycleManager.this.sessionController.endScheduleCheckingAdminToken();
                        try {
                            ((ReleaseProgressDialog)ReleaseProgressDialog.this).LifeCycleManager.this.sessionController.deactivate();
                        }
                        catch (Exception e) {
                            ((ReleaseProgressDialog)ReleaseProgressDialog.this).LifeCycleManager.this.logger.error(e.getMessage());
                        }
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {}
        }
    }

    public class RestoreProgressDialog
    extends ProgressMonitorDialog {
        public RestoreProgressDialog(Shell parent) {
            super(parent);
        }

        public void run(Runnable callback) {
            try {
                this.run(true, false, monitor -> {
                    try {
                        monitor.beginTask(MessageConstants.MSG_CHECKING_SERVER_STATUS, -1);
                        LifeCycleManager.this.discoveryController.discover();
                        monitor.beginTask("Restoring session...", -1);
                        LifeCycleManager.this.sessionController.restoreSession();
                    }
                    catch (Exception exception) {}
                    monitor.done();
                    new Thread(() -> {
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException interruptedException) {}
                        UISynchronizeService.asyncExec((Runnable)callback);
                    }).start();
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {}
        }
    }
}

