/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionBridge;
import com.kms.katalon.composer.testops.service.AnalyticsSettingStore;
import com.kms.katalon.feature.TestOpsMessageError;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.testops.core.model.AnalyticsProject;
import com.kms.katalon.testops.core.model.exception.AnalyticsApiException;
import com.kms.katalon.testops.core.services.ITestOpsController;
import java.util.Map;
import java.util.concurrent.Executors;

public class TestOpsProjectInfoRpcHandler {
    private ITestOpsController testOpsController;
    private BrowserFunctionBridge browserFunctionBridge;

    public TestOpsProjectInfoRpcHandler(ITestOpsController testOpsController) {
        this.testOpsController = testOpsController;
    }

    private void handleRpcRequest(String requestId, Browser browser, ThrowingSupplier action) {
        try {
            Object result = action.get();
            this.browserFunctionBridge.sendRpcResponse(browser, requestId, result);
        }
        catch (AnalyticsApiException error) {
            this.handleError(browser, requestId, error);
        }
    }

    private void handleError(Browser browser, String requestId, AnalyticsApiException error) {
        LogUtil.logError((Throwable)error);
        TestOpsMessageError testOpsMessageError = new TestOpsMessageError();
        testOpsMessageError.setMessage(error.getMessage());
        testOpsMessageError.setException((Exception)((Object)error));
        testOpsMessageError.setHasError(true);
        this.browserFunctionBridge.sendRpcError(browser, requestId, (Object)testOpsMessageError);
    }

    public void registerBrowserfunctions(BrowserFunctionBridge browserFunctionBridge, Browser browser) {
        this.browserFunctionBridge = browserFunctionBridge;
        browserFunctionBridge.registerBrowserFunction("startPageView.fetch3LatestExecutions", String.class, Map.class, (requestId, extraParams) -> Executors.newSingleThreadExecutor().submit(() -> this.handleFetch3LatestExecutions((String)requestId, (Map)extraParams, browser)));
        browserFunctionBridge.registerBrowserFunction("startPageView.fetchProjectStatisticsThisWeek", String.class, Map.class, (requestId, extraParams) -> Executors.newSingleThreadExecutor().submit(() -> this.handleFetchProjectStatisticsThisWeek((String)requestId, (Map)extraParams, browser)));
        browserFunctionBridge.registerBrowserFunction("startPageView.fetchTotalExecutionsStatisticsThisWeek", String.class, Map.class, (requestId, extraParams) -> Executors.newSingleThreadExecutor().submit(() -> this.handleFetchTotalExecutionsStatisticsThisWeek((String)requestId, (Map)extraParams, browser)));
        browserFunctionBridge.registerBrowserFunction("startPageView.fetch6LatestExecutionsTestSuite", String.class, Map.class, (requestId, extraParams) -> Executors.newSingleThreadExecutor().submit(() -> this.handleFetch6LatestExecutionsOfTestSuite((String)requestId, (Map<String, Object>)extraParams, browser)));
    }

    private void handleFetch6LatestExecutionsOfTestSuite(String requestId, Map<String, Object> extraParams, Browser browser) {
        this.handleRpcRequest(requestId, browser, () -> {
            AnalyticsProject project = AnalyticsSettingStore.getStore().getProject();
            String testSuitePath = (String)extraParams.get("testSuitePath");
            String testSuiteName = (String)extraParams.get("testSuiteName");
            if (testSuitePath != null && testSuiteName != null) {
                return this.testOpsController.getCompletedExecutionTestSuite(project.getId(), testSuitePath, testSuiteName, 6);
            }
            return null;
        });
    }

    private void handleFetchTotalExecutionsStatisticsThisWeek(String requestId, Map extraParams, Browser browser) {
        this.handleRpcRequest(requestId, browser, () -> {
            AnalyticsProject project = AnalyticsSettingStore.getStore().getProject();
            return this.testOpsController.getTotalExecutionsStatistics(project.getId());
        });
    }

    private void handleFetchProjectStatisticsThisWeek(String requestId, Map extraParams, Browser browser) {
        this.handleRpcRequest(requestId, browser, () -> {
            AnalyticsProject project = AnalyticsSettingStore.getStore().getProject();
            return this.testOpsController.getProjectStatisticsInLast7Days(project.getId());
        });
    }

    private void handleFetch3LatestExecutions(String requestId, Map extraParams, Browser browser) {
        this.handleRpcRequest(requestId, browser, () -> {
            AnalyticsProject project = AnalyticsSettingStore.getStore().getProject();
            return this.testOpsController.getCompletedExecutions(project.getId(), 3);
        });
    }

    @FunctionalInterface
    private static interface ThrowingSupplier {
        public Object get() throws AnalyticsApiException;
    }
}

