/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import groovy.transform.Trait;
import groovyjarjarantlr.LexerSharedInputState;
import groovyjarjarantlr.RecognitionException;
import groovyjarjarantlr.TokenStreamException;
import groovyjarjarantlr.TokenStreamIOException;
import groovyjarjarantlr.TokenStreamRecognitionException;
import groovyjarjarantlr.collections.AST;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.antlr.ASTParserException;
import org.codehaus.groovy.antlr.ASTRuntimeException;
import org.codehaus.groovy.antlr.AntlrASTProcessSnippets;
import org.codehaus.groovy.antlr.EnumHelper;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.LocationSupport;
import org.codehaus.groovy.antlr.PrimitiveHelper;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.SourceInfo;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.UnicodeLexerSharedInputState;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.antlr.parser.GroovyTokenTypes;
import org.codehaus.groovy.antlr.treewalker.CompositeVisitor;
import org.codehaus.groovy.antlr.treewalker.MindMapPrinter;
import org.codehaus.groovy.antlr.treewalker.NodeAsHTMLPrinter;
import org.codehaus.groovy.antlr.treewalker.PreOrderTraversal;
import org.codehaus.groovy.antlr.treewalker.SourceCodeTraversal;
import org.codehaus.groovy.antlr.treewalker.SourcePrinter;
import org.codehaus.groovy.antlr.treewalker.Visitor;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.EnumConstantClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImmutableClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ParserPlugin;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.ASTHelper;
import org.codehaus.groovy.syntax.Numbers;
import org.codehaus.groovy.syntax.ParserException;
import org.codehaus.groovy.syntax.Reduction;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;

public class AntlrParserPlugin
extends ASTHelper
implements ParserPlugin,
GroovyTokenTypes {
    protected AST ast;
    private ClassNode classNode;
    private MethodNode methodNode;
    protected String[] tokenNames;
    private boolean enumConstantBeingDef;
    private boolean forStatementBeingDef;
    private boolean annotationBeingDef;
    private boolean firstParamIsVarArg;
    private boolean firstParam;
    protected LocationSupport locations = LocationSupport.NO_LOCATIONS;

    public Reduction parseCST(SourceUnit sourceUnit, Reader reader) throws CompilationFailedException {
        SourceBuffer sourceBuffer = new SourceBuffer();
        this.transformCSTIntoAST(sourceUnit, reader, sourceBuffer);
        this.processAST();
        return this.outputAST(sourceUnit, sourceBuffer);
    }

    protected void transformCSTIntoAST(SourceUnit sourceUnit, Reader reader, SourceBuffer sourceBuffer) throws CompilationFailedException {
        GroovyRecognizer parser;
        block10: {
            this.ast = null;
            this.setController(sourceUnit);
            UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(reader, sourceBuffer);
            UnicodeLexerSharedInputState inputState = new UnicodeLexerSharedInputState(unicodeReader);
            GroovyLexer lexer = new GroovyLexer((LexerSharedInputState)inputState);
            unicodeReader.setLexer(lexer);
            parser = GroovyRecognizer.make(lexer);
            this.tokenNames = parser.getTokenNames();
            parser.setFilename(sourceUnit.getName());
            try {
                parser.compilationUnit();
                this.configureLocationSupport(sourceBuffer);
            }
            catch (TokenStreamRecognitionException tsre) {
                this.configureLocationSupport(sourceBuffer);
                RecognitionException e = tsre.recog;
                SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, e.getLine(), e.getColumn());
                se.setFatal(true);
                sourceUnit.addError(se);
            }
            catch (RecognitionException e) {
                int offset;
                this.configureLocationSupport(sourceBuffer);
                int line = e.getLine();
                int column = e.getColumn();
                if (this.locations.isPopulated() && (offset = this.locations.findOffset(line, column)) >= this.locations.getEnd() - 1) {
                    int[] row_col = this.locations.getRowCol(this.locations.getEnd() - 1);
                    line = row_col[0];
                    column = row_col[1];
                }
                SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, line, column);
                se.setFatal(true);
                sourceUnit.addError(se);
            }
            catch (TokenStreamException e) {
                String m;
                this.configureLocationSupport(sourceBuffer);
                boolean handled = false;
                if (e instanceof TokenStreamIOException && (m = e.getMessage()) != null && m.startsWith("Did not find four digit hex character code.")) {
                    try {
                        int linepos = m.indexOf("line:");
                        int colpos = m.indexOf("col:");
                        int line = Integer.valueOf(m.substring(linepos + 5, colpos).trim());
                        int column = Integer.valueOf(m.substring(colpos + 4).trim());
                        SyntaxException se = new SyntaxException(e.getMessage(), (Throwable)e, line, column);
                        se.setFatal(true);
                        sourceUnit.addError(se);
                        handled = true;
                    }
                    catch (Throwable t) {
                        System.err.println(m);
                        t.printStackTrace();
                    }
                }
                if (handled) break block10;
                sourceUnit.addException((Exception)((Object)e));
            }
        }
        this.ast = parser.getAST();
        sourceUnit.setComments(parser.getComments());
        for (Map error : parser.getErrorList()) {
            int offset;
            int line = (Integer)error.get("line");
            int column = (Integer)error.get("column");
            if (this.locations.isPopulated() && (offset = this.locations.findOffset(line, column)) >= this.locations.getEnd() - 1) {
                int[] row_col = this.locations.getRowCol(this.locations.getEnd() - 1);
                line = row_col[0];
                column = row_col[1];
            }
            SyntaxException se = new SyntaxException((String)error.get("error"), line, column);
            sourceUnit.addError(se);
        }
    }

    protected void configureLocationSupport(SourceBuffer sourceBuffer) {
        this.locations = sourceBuffer.getLocationSupport();
    }

    protected void processAST() {
        AntlrASTProcessSnippets snippets = new AntlrASTProcessSnippets();
        this.ast = snippets.process(this.ast);
    }

    public Reduction outputAST(SourceUnit sourceUnit, SourceBuffer sourceBuffer) {
        this.outputASTInVariousFormsIfNeeded(sourceUnit, sourceBuffer);
        return null;
    }

    private void outputASTInVariousFormsIfNeeded(SourceUnit sourceUnit, SourceBuffer sourceBuffer) {
        SourceCodeTraversal treewalker;
        SourcePrinter visitor;
        PrintStream out;
        String formatProp = System.getProperty("ANTLR.AST".toLowerCase());
        if ("groovy".equals(formatProp)) {
            try {
                out = new PrintStream(new FileOutputStream(sourceUnit.getName() + ".pretty.groovy"));
                visitor = new SourcePrinter(out, this.tokenNames);
                treewalker = new SourceCodeTraversal((Visitor)visitor);
                treewalker.process(this.ast);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot create " + sourceUnit.getName() + ".pretty.groovy");
            }
        }
        if ("mindmap".equals(formatProp)) {
            try {
                out = new PrintStream(new FileOutputStream(sourceUnit.getName() + ".mm"));
                visitor = new MindMapPrinter(out, this.tokenNames);
                treewalker = new PreOrderTraversal((Visitor)visitor);
                treewalker.process(this.ast);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot create " + sourceUnit.getName() + ".mm");
            }
        }
        if ("extendedMindmap".equals(formatProp)) {
            try {
                out = new PrintStream(new FileOutputStream(sourceUnit.getName() + ".mm"));
                visitor = new MindMapPrinter(out, this.tokenNames, sourceBuffer);
                treewalker = new PreOrderTraversal((Visitor)visitor);
                treewalker.process(this.ast);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot create " + sourceUnit.getName() + ".mm");
            }
        }
        if ("html".equals(formatProp)) {
            try {
                out = new PrintStream(new FileOutputStream(sourceUnit.getName() + ".html"));
                ArrayList<Object> v = new ArrayList<Object>();
                v.add(new NodeAsHTMLPrinter(out, this.tokenNames));
                v.add(new SourcePrinter(out, this.tokenNames));
                CompositeVisitor visitors = new CompositeVisitor(v);
                SourceCodeTraversal treewalker2 = new SourceCodeTraversal((Visitor)visitors);
                treewalker2.process(this.ast);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot create " + sourceUnit.getName() + ".html");
            }
        }
    }

    public ModuleNode buildAST(SourceUnit sourceUnit, ClassLoader classLoader, Reduction cst) throws ParserException {
        this.setClassLoader(classLoader);
        this.makeModule();
        try {
            BlockStatement scriptBlockNode;
            List statements;
            ClassNode scriptClassNode;
            this.convertGroovy(this.ast);
            if (AntlrParserPlugin.looksBroken(this.output) && this.output.getMethods().isEmpty() && sourceUnit.getErrorCollector().hasErrors()) {
                this.output.setEncounteredUnrecoverableError(true);
            }
            if (this.output.getStatementBlock().isEmpty() && this.output.getMethods().isEmpty() && this.output.getClasses().isEmpty()) {
                this.output.addStatement(this.createEmptyScriptStatement());
                if (this.ast == null && sourceUnit.getErrorCollector().hasErrors()) {
                    this.output.setEncounteredUnrecoverableError(true);
                }
            }
            if ((scriptClassNode = this.output.getScriptClassDummy()) != null && !(statements = (scriptBlockNode = this.output.getStatementBlock()).getStatements()).isEmpty()) {
                Statement firstStatement = (Statement)statements.get(0);
                Statement lastStatement = (Statement)statements.get(statements.size() - 1);
                scriptBlockNode.setStart(firstStatement.getStart());
                scriptBlockNode.setLineNumber(firstStatement.getLineNumber());
                scriptBlockNode.setColumnNumber(firstStatement.getColumnNumber());
                scriptBlockNode.setEnd(lastStatement.getEnd());
                scriptBlockNode.setLastLineNumber(lastStatement.getLastLineNumber());
                scriptBlockNode.setLastColumnNumber(lastStatement.getLastColumnNumber());
                scriptClassNode.setSourcePosition((ASTNode)scriptBlockNode);
            }
            this.output.setStart(0);
            this.output.setLineNumber(1);
            this.output.setColumnNumber(1);
            this.output.setEnd(this.locations.getEnd());
            this.output.setLastLineNumber(this.locations.getEndLine());
            this.output.setLastColumnNumber(this.locations.getEndColumn());
            BlockStatement blockStatement = this.output.getStatementBlock();
            if (!blockStatement.isEmpty() || !this.output.getMethods().isEmpty()) {
                MethodNode runMethod;
                ASTNode first = this.getFirst(blockStatement, this.output.getMethods());
                ASTNode last = this.getLast(blockStatement, this.output.getMethods());
                ClassNode scriptClass = this.output.getClasses().get(0);
                if (first instanceof MethodNode) {
                    scriptClass.setStart(first.getStart());
                    scriptClass.setLineNumber(first.getLineNumber());
                    scriptClass.setColumnNumber(first.getColumnNumber());
                }
                if (last instanceof MethodNode) {
                    scriptClass.setEnd(last.getEnd());
                    scriptClass.setLastLineNumber(last.getLastLineNumber());
                    scriptClass.setLastColumnNumber(last.getLastColumnNumber());
                }
                if ((runMethod = scriptClass.getDeclaredMethod("run", Parameter.EMPTY_ARRAY)) != null) {
                    runMethod.setSourcePosition((ASTNode)blockStatement);
                    runMethod.addAnnotation(AntlrParserPlugin.makeAnnotationNode(Override.class));
                }
            }
            this.output.putNodeMetaData(LocationSupport.class, this.locations);
        }
        catch (ASTRuntimeException e) {
            throw new ASTParserException(e.getMessage() + ". File: " + sourceUnit.getName(), e);
        }
        this.ast = null;
        return this.output;
    }

    private static boolean looksBroken(ModuleNode moduleNode) {
        Expression expression;
        Statement statement;
        List<ClassNode> classes = moduleNode.getClasses();
        if (classes.size() != 1 || !classes.get(0).isScript()) {
            return false;
        }
        if (moduleNode.getStatementBlock().isEmpty()) {
            return true;
        }
        List statements = moduleNode.getStatementBlock().getStatements();
        return statements.size() == 1 && (statement = (Statement)statements.get(0)) instanceof ExpressionStatement && (expression = ((ExpressionStatement)statement).getExpression()) instanceof ConstantExpression && expression.getText().equals("ERROR");
    }

    private ASTNode getFirst(BlockStatement blockStatement, List<MethodNode> methods) {
        Statement statement = !blockStatement.isEmpty() ? (Statement)blockStatement.getStatements().get(0) : null;
        MethodNode method = !methods.isEmpty() ? methods.get(0) : null;
        int statementStart = statement != null ? statement.getStart() : Integer.MAX_VALUE;
        int methodStart = method != null ? method.getStart() : Integer.MAX_VALUE;
        return statementStart <= methodStart ? statement : method;
    }

    private ASTNode getLast(BlockStatement blockStatement, List<MethodNode> methods) {
        Statement statement = !blockStatement.isEmpty() ? (Statement)DefaultGroovyMethods.last((List)blockStatement.getStatements()) : null;
        MethodNode method = !methods.isEmpty() ? (MethodNode)DefaultGroovyMethods.last(methods) : null;
        int statementEnd = statement != null ? statement.getEnd() : Integer.MIN_VALUE;
        int methodStart = method != null ? method.getStart() : Integer.MIN_VALUE;
        return statementEnd >= methodStart ? statement : method;
    }

    private Statement createEmptyScriptStatement() {
        ReturnStatement statement = ReturnStatement.RETURN_NULL_OR_VOID;
        ASTNode target = null;
        if (DefaultGroovyMethods.asBoolean(this.output.getImports())) {
            target = (ASTNode)DefaultGroovyMethods.last(this.output.getImports());
        } else if (this.output.hasPackage()) {
            target = this.output.getPackage();
        }
        if (target != null) {
            int off = Math.min(this.locations.findOffset(target.getLastLineNumber() + 1, 1), this.locations.getEnd() - 1);
            int[] row_col = this.locations.getRowCol(off);
            statement = new ReturnStatement((Expression)ConstantExpression.NULL);
            statement.setStart(off);
            statement.setEnd(off);
            statement.setLineNumber(row_col[0]);
            statement.setColumnNumber(row_col[1]);
            statement.setLastLineNumber(row_col[0]);
            statement.setLastColumnNumber(row_col[1]);
        }
        return statement;
    }

    protected void convertGroovy(AST node) {
        while (node != null) {
            switch (node.getType()) {
                case 16: {
                    this.packageDef(node);
                    break;
                }
                case 29: 
                case 60: {
                    this.importDef(node);
                    break;
                }
                case 13: 
                case 15: {
                    this.classDef(node);
                    break;
                }
                case 14: {
                    this.interfaceDef(node);
                    break;
                }
                case 8: {
                    this.methodDef(node);
                    break;
                }
                case 61: {
                    this.enumDef(node);
                    break;
                }
                case 64: {
                    this.annotationDef(node);
                    break;
                }
                default: {
                    this.output.addStatement(this.statement(node));
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void packageDef(AST packageDef) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST node = packageDef.getFirstChild();
        if (AntlrParserPlugin.isType(65, node)) {
            this.processAnnotations(annotations, node);
            node = node.getNextSibling();
        }
        PackageNode packageNode = this.setPackage(AntlrParserPlugin.qualifiedName(node), annotations);
        this.configureAST((ASTNode)packageNode, node);
    }

    protected void importDef(AST importNode) {
        try {
            this.output.putNodeMetaData(ImportNode.class, ImportNode.class);
            boolean isStatic = importNode.getType() == 60;
            ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
            AST node = importNode.getFirstChild();
            if (AntlrParserPlugin.isType(65, node)) {
                this.processAnnotations(annotations, node);
                node = node.getNextSibling();
            }
            String alias = null;
            AST aliasNode = null;
            if (AntlrParserPlugin.isType(114, node)) {
                node = node.getFirstChild();
                aliasNode = node.getNextSibling();
                alias = this.identifier(aliasNode);
            }
            if (node.getNumberOfChildren() == 0) {
                String name = this.identifier(node);
                ClassNode type = AntlrParserPlugin.makeClassNode(name);
                this.configureAST(type, "?".equals(name) ? importNode : node);
                this.addImport(type, name, alias, annotations);
                ImportNode imp = (ImportNode)DefaultGroovyMethods.last(this.output.getImports());
                this.configureAST(imp, importNode, node, null);
                return;
            }
            AST packageNode = node.getFirstChild();
            String packageName = AntlrParserPlugin.qualifiedName(packageNode);
            AST nameNode = packageNode.getNextSibling();
            if (AntlrParserPlugin.isType(113, nameNode)) {
                if (isStatic) {
                    ClassNode type = AntlrParserPlugin.makeClassNode(packageName);
                    this.configureAST(type, packageNode);
                    this.addStaticStarImport(type, packageName, annotations);
                    ImportNode imp = this.output.getStaticStarImports().get(packageName);
                    this.configureAST(imp, importNode, packageNode, null);
                } else {
                    this.addStarImport(packageName, annotations);
                    ImportNode imp = (ImportNode)DefaultGroovyMethods.last(this.output.getStarImports());
                    this.configureAST(imp, importNode, packageNode, null);
                }
                if (alias != null) {
                    throw new GroovyBugError("imports like 'import foo.* as Bar' are not supported and should be caught by the grammar");
                }
            } else {
                ImportNode imp;
                String name = this.identifier(nameNode);
                if (isStatic) {
                    ClassNode type = AntlrParserPlugin.makeClassNode(packageName);
                    this.configureAST(type, packageNode);
                    this.addStaticImport(type, name, alias, annotations);
                    imp = this.output.getStaticImports().get(alias == null ? name : alias);
                    imp.setFieldNameExpr(this.literalExpression(nameNode, name));
                    this.configureAST(imp, importNode, packageNode, nameNode);
                } else {
                    ClassNode type = AntlrParserPlugin.makeClassNode(packageName + "." + name);
                    type.setLineNumber(packageNode.getLine());
                    type.setColumnNumber(packageNode.getColumn());
                    type.setStart(this.locations.findOffset(type.getLineNumber(), type.getColumnNumber()));
                    type.setLastLineNumber(((GroovySourceAST)nameNode).getLineLast());
                    type.setLastColumnNumber(((GroovySourceAST)nameNode).getColumnLast());
                    type.setEnd(this.locations.findOffset(type.getLastLineNumber(), type.getLastColumnNumber()));
                    this.addImport(type, name, alias, annotations);
                    imp = (ImportNode)DefaultGroovyMethods.last(this.output.getImports());
                    this.configureAST(imp, importNode, packageNode, nameNode);
                }
                if (alias != null) {
                    imp.setAliasExpr(this.literalExpression(aliasNode, alias));
                }
            }
        }
        finally {
            Object node = this.output.getNodeMetaData(ImportNode.class);
            if (node != null && node != ImportNode.class) {
                this.configureAST((ImportNode)node, importNode);
            }
            this.output.removeNodeMetaData(ImportNode.class);
        }
    }

    private void processAnnotations(List<AnnotationNode> annotations, AST node) {
        AST child = node.getFirstChild();
        while (child != null) {
            if (AntlrParserPlugin.isType(66, child)) {
                annotations.add(this.annotation(child));
            }
            child = child.getNextSibling();
        }
    }

    protected void annotationDef(AST classDef) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST node = classDef.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            AntlrParserPlugin.checkNoInvalidModifier(classDef, "Annotation Definition", modifiers, 32, "synchronized");
            node = node.getNextSibling();
        }
        modifiers |= 0x2600;
        String name = this.identifier(node);
        GroovySourceAST groovySourceAST = (GroovySourceAST)node;
        int nameStart = this.locations.findOffset(groovySourceAST.getLine(), groovySourceAST.getColumn());
        int nameEnd = this.locations.findOffset(groovySourceAST.getLineLast(), groovySourceAST.getColumnLast());
        node = node.getNextSibling();
        ClassNode superClass = ClassHelper.OBJECT_TYPE;
        GenericsType[] genericsType = null;
        if (AntlrParserPlugin.isType(72, node)) {
            genericsType = this.makeGenericsType(node);
            node = node.getNextSibling();
        }
        ClassNode[] interfaces = ClassNode.EMPTY_ARRAY;
        if (AntlrParserPlugin.isType(18, node)) {
            interfaces = this.interfaces(node);
            node = node.getNextSibling();
        }
        boolean syntheticPublic = (modifiers & 0x1000) != 0;
        this.classNode = new ClassNode(AntlrParserPlugin.dot((String)this.getPackageName(), (String)name), modifiers &= 0xFFFFEFFF, superClass, interfaces, null);
        this.classNode.setSyntheticPublic(syntheticPublic);
        this.classNode.addAnnotations(annotations);
        this.classNode.setGenericsTypes(genericsType);
        this.classNode.addInterface(ClassHelper.Annotation_TYPE);
        this.classNode.setNameStart(nameStart);
        this.classNode.setNameEnd(nameEnd - 1);
        this.configureAST(this.classNode, classDef);
        this.assertNodeType(6, node);
        this.objectBlock(node);
        this.output.addClass(this.classNode);
        this.classNode = null;
    }

    protected void interfaceDef(AST classDef) {
        this.innerInterfaceDef(classDef);
        this.classNode = null;
    }

    protected void innerInterfaceDef(AST classDef) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST node = classDef.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            AntlrParserPlugin.checkNoInvalidModifier(classDef, "Interface", modifiers, 32, "synchronized");
            node = node.getNextSibling();
        }
        modifiers |= 0x600;
        Object name = this.identifier(node);
        GroovySourceAST groovySourceAST = (GroovySourceAST)node;
        int nameStart = this.locations.findOffset(groovySourceAST.getLine(), groovySourceAST.getColumn());
        int nameEnd = this.locations.findOffset(groovySourceAST.getLineLast(), groovySourceAST.getColumnLast());
        node = node.getNextSibling();
        ClassNode superClass = ClassHelper.OBJECT_TYPE;
        GenericsType[] genericsType = null;
        if (AntlrParserPlugin.isType(72, node)) {
            genericsType = this.makeGenericsType(node);
            node = node.getNextSibling();
        }
        ClassNode[] interfaces = ClassNode.EMPTY_ARRAY;
        if (AntlrParserPlugin.isType(18, node)) {
            interfaces = this.interfaces(node);
            node = node.getNextSibling();
        }
        ClassNode outerClass = this.classNode;
        boolean syntheticPublic = (modifiers & 0x1000) != 0;
        modifiers &= 0xFFFFEFFF;
        if (this.classNode != null) {
            name = this.classNode.getNameWithoutPackage() + "$" + (String)name;
            String fullName = AntlrParserPlugin.dot((String)this.classNode.getPackageName(), (String)name);
            this.classNode = new InnerClassNode(this.classNode, fullName, modifiers, superClass, interfaces, null);
        } else {
            this.classNode = new ClassNode(AntlrParserPlugin.dot((String)this.getPackageName(), (String)name), modifiers, superClass, interfaces, null);
        }
        this.classNode.setSyntheticPublic(syntheticPublic);
        this.classNode.addAnnotations(annotations);
        this.classNode.setGenericsTypes(genericsType);
        this.configureAST(this.classNode, classDef);
        if (genericsType != null) {
            GenericsType[] genericsTypeArray = genericsType;
            int n = genericsType.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType tp = genericsTypeArray[n2];
                tp.getType().setDeclaringClass(this.classNode);
                ++n2;
            }
        }
        this.classNode.setNameStart(nameStart);
        this.classNode.setNameEnd(nameEnd - 1);
        this.assertNodeType(6, node);
        this.objectBlock(node);
        this.output.addClass(this.classNode);
        this.classNode = outerClass;
    }

    protected void classDef(AST classDef) {
        this.innerClassDef(classDef);
        this.classNode = null;
    }

    private ClassNode getClassOrScript(ClassNode node) {
        if (node != null) {
            return node;
        }
        return this.output.getScriptClassDummy();
    }

    private static int anonymousClassCount(ClassNode node) {
        int count = 0;
        Iterator<InnerClassNode> it = node.getInnerClasses();
        while (it.hasNext()) {
            InnerClassNode innerClass = it.next();
            if (!innerClass.isAnonymous()) continue;
            ++count;
        }
        return count;
    }

    protected Expression anonymousInnerClassDef(AST node) {
        ClassNode otherClass = this.classNode;
        ClassNode outerClass = this.getClassOrScript(otherClass);
        String innerClassName = outerClass.getName() + "$" + (AntlrParserPlugin.anonymousClassCount(outerClass) + 1);
        this.classNode = this.enumConstantBeingDef ? new EnumConstantClassNode(outerClass, innerClassName, 16400, ClassHelper.OBJECT_TYPE) : new InnerClassNode(outerClass, innerClassName, 1, ClassHelper.OBJECT_TYPE);
        ((InnerClassNode)this.classNode).setAnonymous(true);
        this.classNode.setEnclosingMethod(this.methodNode);
        this.configureAST(this.classNode, node);
        this.output.addClass(this.classNode);
        this.assertNodeType(6, node);
        this.objectBlock(node);
        AnonymousInnerClassCarrier ret = new AnonymousInnerClassCarrier();
        ret.innerClass = this.classNode;
        this.classNode = otherClass;
        return ret;
    }

    protected void innerClassDef(AST classDef) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (AntlrParserPlugin.isType(15, classDef)) {
            annotations.add(AntlrParserPlugin.makeAnnotationNode(Trait.class));
        }
        AST node = classDef.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            AntlrParserPlugin.checkNoInvalidModifier(classDef, "Class", modifiers, 32, "synchronized");
            node = node.getNextSibling();
        }
        Object name = this.identifier(node);
        GroovySourceAST groovySourceAST = (GroovySourceAST)node;
        int nameStart = this.locations.findOffset(groovySourceAST.getLine(), groovySourceAST.getColumn());
        int nameEnd = nameStart + ((String)name).length();
        node = node.getNextSibling();
        GenericsType[] genericsType = null;
        if (AntlrParserPlugin.isType(72, node)) {
            genericsType = this.makeGenericsType(node);
            node = node.getNextSibling();
        }
        ClassNode superClass = null;
        if (AntlrParserPlugin.isType(18, node)) {
            superClass = this.makeTypeWithArguments(node);
            node = node.getNextSibling();
        }
        ClassNode[] interfaces = ClassNode.EMPTY_ARRAY;
        if (AntlrParserPlugin.isType(19, node)) {
            interfaces = this.interfaces(node);
            node = node.getNextSibling();
        }
        MixinNode[] mixins = new MixinNode[]{};
        ClassNode outerClass = this.classNode;
        boolean syntheticPublic = (modifiers & 0x1000) != 0;
        modifiers &= 0xFFFFEFFF;
        if (this.classNode != null) {
            name = this.classNode.getNameWithoutPackage() + "$" + (String)name;
            String fullName = AntlrParserPlugin.dot((String)this.classNode.getPackageName(), (String)name);
            if (this.classNode.isInterface()) {
                modifiers |= 8;
            }
            this.classNode = new InnerClassNode(this.classNode, fullName, modifiers, superClass, interfaces, mixins);
        } else {
            this.classNode = new ClassNode(AntlrParserPlugin.dot((String)this.getPackageName(), (String)name), modifiers, superClass, interfaces, mixins);
        }
        this.classNode.addAnnotations(annotations);
        this.classNode.setGenericsTypes(genericsType);
        this.classNode.setSyntheticPublic(syntheticPublic);
        this.configureAST(this.classNode, classDef);
        if (genericsType != null) {
            GenericsType[] genericsTypeArray = genericsType;
            int n = genericsType.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType tp = genericsTypeArray[n2];
                tp.getType().setDeclaringClass(this.classNode);
                ++n2;
            }
        }
        this.classNode.setNameStart(nameStart);
        this.classNode.setNameEnd(nameEnd - 1);
        this.output.addClass(this.classNode);
        if (node != null) {
            this.assertNodeType(6, node);
            this.objectBlock(node);
        }
        this.classNode = outerClass;
    }

    protected void objectBlock(AST objectBlock) {
        AST node = objectBlock.getFirstChild();
        while (node != null) {
            switch (node.getType()) {
                case 6: {
                    this.objectBlock(node);
                    break;
                }
                case 8: 
                case 68: {
                    this.methodDef(node);
                    break;
                }
                case 46: {
                    this.constructorDef(node);
                    break;
                }
                case 9: {
                    this.fieldDef(node);
                    break;
                }
                case 11: {
                    this.staticInit(node);
                    break;
                }
                case 10: {
                    this.objectInit(node);
                    break;
                }
                case 61: {
                    this.enumDef(node);
                    break;
                }
                case 62: {
                    this.enumConstantDef(node);
                    break;
                }
                case 13: 
                case 15: {
                    this.innerClassDef(node);
                    break;
                }
                case 14: {
                    this.innerInterfaceDef(node);
                    break;
                }
                default: {
                    this.unknownAST(node);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void enumDef(AST enumNode) {
        this.assertNodeType(61, enumNode);
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST node = enumNode.getFirstChild();
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        GroovySourceAST groovySourceAST = (GroovySourceAST)node;
        int nameStart = this.locations.findOffset(groovySourceAST.getLine(), groovySourceAST.getColumn());
        int nameEnd = this.locations.findOffset(groovySourceAST.getLineLast(), groovySourceAST.getColumnLast());
        String name = this.identifier(node);
        node = node.getNextSibling();
        ClassNode[] interfaces = this.interfaces(node);
        node = node.getNextSibling();
        boolean syntheticPublic = (modifiers & 0x1000) != 0;
        String enumName = this.classNode != null ? name : AntlrParserPlugin.dot((String)this.getPackageName(), (String)name);
        ClassNode enumClass = EnumHelper.makeEnumNode((String)enumName, (int)(modifiers &= 0xFFFFEFFF), (ClassNode[])interfaces, (ClassNode)this.classNode);
        enumClass.setSyntheticPublic(syntheticPublic);
        enumClass.addAnnotations(annotations);
        enumClass.setNameStart(nameStart);
        enumClass.setNameEnd(nameEnd - 1);
        this.configureAST(enumClass, enumNode);
        ClassNode oldNode = this.classNode;
        this.classNode = enumClass;
        this.assertNodeType(6, node);
        this.objectBlock(node);
        this.classNode = oldNode;
        this.output.addClass(enumClass);
    }

    protected void enumConstantDef(AST node) {
        this.enumConstantBeingDef = true;
        this.assertNodeType(62, node);
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST element = node.getFirstChild();
        if (AntlrParserPlugin.isType(65, element)) {
            this.processAnnotations(annotations, element);
            element = element.getNextSibling();
        }
        String identifier = this.identifier(element);
        int nameStart = this.locations.findOffset(element.getLine(), element.getColumn());
        int nameEnd = nameStart + identifier.length();
        Expression init = null;
        if ((element = element.getNextSibling()) != null) {
            ClassNode innerClass;
            init = this.expression(element);
            if (element.getNextSibling() == null) {
                innerClass = AntlrParserPlugin.getAnonymousInnerClassNode(init);
                if (innerClass != null) {
                    init = null;
                }
            } else {
                element = element.getNextSibling();
                Expression next = this.expression(element);
                innerClass = AntlrParserPlugin.getAnonymousInnerClassNode(next);
            }
            if (innerClass != null) {
                innerClass.setSuperClass(this.classNode.getPlainNodeReference());
                innerClass.setNameStart(nameStart);
                innerClass.setNameEnd(nameEnd - 1);
                ClassExpression inner = new ClassExpression(innerClass);
                if (init == null) {
                    ListExpression le = new ListExpression();
                    le.addExpression((Expression)inner);
                    init = le;
                } else if (init instanceof ListExpression) {
                    ((ListExpression)init).addExpression((Expression)inner);
                } else {
                    ListExpression le = new ListExpression();
                    le.addExpression(init);
                    le.addExpression((Expression)inner);
                    init = le;
                }
                this.classNode.setModifiers(this.classNode.getModifiers() & 0xFFFFFFEF);
            } else if (AntlrParserPlugin.isType(33, element) && init instanceof ListExpression && !((ListExpression)init).isWrapped()) {
                ListExpression le = new ListExpression();
                le.addExpression(init);
                init = le;
            }
        }
        FieldNode enumField = EnumHelper.addEnumConstant((ClassNode)this.classNode, (String)identifier, (Expression)init);
        enumField.addAnnotations(annotations);
        enumField.setNameStart(nameStart);
        enumField.setNameEnd(nameEnd - 1);
        this.configureAST((ASTNode)enumField, node);
        this.enumConstantBeingDef = false;
    }

    protected void throwsList(AST node, List<ClassNode> list) {
        String name = AntlrParserPlugin.isType(90, node) ? AntlrParserPlugin.qualifiedName(node) : this.identifier(node);
        ClassNode exception = AntlrParserPlugin.makeClassNode(name);
        this.configureAST(exception, node);
        if (AntlrParserPlugin.isType(90, node)) {
            GroovySourceAST type = (GroovySourceAST)node.getFirstChild().getNextSibling();
            exception.setNameStart2(this.locations.findOffset(type.getLine(), type.getColumn()));
            exception.setEnd(this.locations.findOffset(type.getLineLast(), type.getColumnLast()));
            exception.setLastLineNumber(type.getLineLast());
            exception.setLastColumnNumber(type.getColumnLast());
        }
        list.add(exception);
        AST next = node.getNextSibling();
        if (next != null) {
            this.throwsList(next, list);
        }
    }

    protected void methodDef(AST methodDef) {
        MethodNode oldNode = this.methodNode;
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST node = methodDef.getFirstChild();
        GenericsType[] generics = null;
        if (AntlrParserPlugin.isType(72, node)) {
            generics = this.makeGenericsType(node);
            node = node.getNextSibling();
        }
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            AntlrParserPlugin.checkNoInvalidModifier(methodDef, "Method", modifiers, 64, "volatile");
            node = node.getNextSibling();
        } else {
            modifiers |= 0x1000;
        }
        if (this.isAnInterface()) {
            modifiers |= 0x400;
        }
        ClassNode returnType = null;
        if (AntlrParserPlugin.isType(12, node)) {
            returnType = this.makeTypeWithArguments(node);
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        if (this.classNode != null && !this.classNode.isAnnotationDefinition() && this.classNode.getNameWithoutPackage().equals(name)) {
            if (this.isAnInterface()) {
                throw new ASTRuntimeException(methodDef, "Constructor not permitted within an interface.");
            }
            throw new ASTRuntimeException(methodDef, "Invalid constructor format. Remove '" + returnType.getName() + "' as the return type if you want a constructor, or use a different name if you want a method.");
        }
        GroovySourceAST groovySourceAST = (GroovySourceAST)node;
        int nameStart = this.locations.findOffset(groovySourceAST.getLine(), groovySourceAST.getColumn());
        int nameEnd = this.locations.findOffset(groovySourceAST.getLine(), groovySourceAST.getColumnLast());
        node = node.getNextSibling();
        Parameter[] parameters = Parameter.EMPTY_ARRAY;
        ClassNode[] exceptions = ClassNode.EMPTY_ARRAY;
        if (this.classNode == null || !this.classNode.isAnnotationDefinition()) {
            this.assertNodeType(20, node);
            parameters = this.parameters(node);
            if (parameters == null) {
                parameters = Parameter.EMPTY_ARRAY;
            }
            groovySourceAST = (GroovySourceAST)node;
            if (AntlrParserPlugin.isType(130, node = node.getNextSibling())) {
                AST throwsNode = node.getFirstChild();
                ArrayList<ClassNode> exceptionList = new ArrayList<ClassNode>();
                this.throwsList(throwsNode, exceptionList);
                exceptions = exceptionList.toArray(exceptions);
                node = node.getNextSibling();
            }
        }
        boolean hasAnnotationDefault = false;
        Statement code = null;
        boolean syntheticPublic = (modifiers & 0x1000) != 0;
        this.methodNode = new MethodNode(name, modifiers &= 0xFFFFEFFF, returnType, parameters, exceptions, code);
        if ((modifiers & 0x400) == 0) {
            if (node == null) {
                if (this.getController() != null) {
                    this.getController().addError(new SyntaxException("You defined a method without a body. Try adding a body, or declare it abstract.", methodDef.getLine(), methodDef.getColumn()));
                }
                code = this.statementListNoChild(null, methodDef);
            } else {
                this.assertNodeType(7, node);
                code = this.statementList(node);
            }
        } else if (node != null) {
            if (this.classNode != null && this.classNode.isAnnotationDefinition()) {
                code = this.statement(node);
                hasAnnotationDefault = true;
            } else {
                throw new ASTRuntimeException(methodDef, "Abstract methods do not define a body.");
            }
        }
        this.methodNode.setCode(code);
        this.methodNode.addAnnotations(annotations);
        this.methodNode.setGenericsTypes(generics);
        this.methodNode.setAnnotationDefault(hasAnnotationDefault);
        this.methodNode.setSyntheticPublic(syntheticPublic);
        this.configureAST(this.methodNode, methodDef);
        this.methodNode.setNameStart(nameStart);
        this.methodNode.setNameEnd(nameEnd - 1);
        if (AntlrParserPlugin.isType(20, (AST)groovySourceAST)) {
            this.methodNode.putNodeMetaData("rparen.offset", this.locations.findOffset(groovySourceAST.getLineLast(), groovySourceAST.getColumnLast()));
        }
        if (this.classNode != null) {
            this.classNode.addMethod(this.methodNode);
        } else {
            this.output.addMethod(this.methodNode);
        }
        this.methodNode = oldNode;
    }

    private static void checkNoInvalidModifier(AST node, String nodeType, int modifiers, int modifier, String modifierText) {
        if ((modifiers & modifier) != 0) {
            throw new ASTRuntimeException(node, nodeType + " has an incorrect modifier '" + modifierText + "'.");
        }
    }

    private boolean isAnInterface() {
        return this.classNode != null && (this.classNode.getModifiers() & 0x200) > 0;
    }

    protected void staticInit(AST staticInit) {
        BlockStatement code = (BlockStatement)this.statementList(staticInit);
        this.classNode.addStaticInitializerStatements(code.getStatements(), false);
        ((Statement)code.getStatements().get(0)).putNodeMetaData((Object)"static.offset", (Object)code.getStart());
    }

    protected void objectInit(AST init) {
        BlockStatement code = (BlockStatement)this.statementList(init);
        this.classNode.addObjectInitializerStatements((Statement)code);
    }

    protected void constructorDef(AST constructorDef) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST node = constructorDef.getFirstChild();
        GroovySourceAST groovySourceAST = (GroovySourceAST)node;
        int nameStart = this.locations.findOffset(groovySourceAST.getLineLast(), groovySourceAST.getColumnLast());
        int modifiers = 1;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            AntlrParserPlugin.checkNoInvalidModifier(constructorDef, "Constructor", modifiers, 8, "static");
            AntlrParserPlugin.checkNoInvalidModifier(constructorDef, "Constructor", modifiers, 16, "final");
            AntlrParserPlugin.checkNoInvalidModifier(constructorDef, "Constructor", modifiers, 1024, "abstract");
            AntlrParserPlugin.checkNoInvalidModifier(constructorDef, "Constructor", modifiers, 256, "native");
            node = node.getNextSibling();
        } else {
            modifiers |= 0x1000;
        }
        this.assertNodeType(20, node);
        Parameter[] parameters = this.parameters(node);
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        }
        int nameEnd = this.locations.findOffset(node.getLine(), node.getColumn()) - 1;
        groovySourceAST = (GroovySourceAST)node;
        node = node.getNextSibling();
        ClassNode[] exceptions = ClassNode.EMPTY_ARRAY;
        if (AntlrParserPlugin.isType(130, node)) {
            AST throwsNode = node.getFirstChild();
            ArrayList<ClassNode> exceptionList = new ArrayList<ClassNode>();
            this.throwsList(throwsNode, exceptionList);
            exceptions = exceptionList.toArray(exceptions);
            node = node.getNextSibling();
        }
        this.assertNodeType(7, node);
        boolean syntheticPublic = (modifiers & 0x1000) != 0;
        ConstructorNode constructorNode = this.classNode.addConstructor(modifiers &= 0xFFFFEFFF, parameters, exceptions, null);
        MethodNode oldMethod = this.methodNode;
        this.methodNode = constructorNode;
        Statement code = this.statementList(node);
        this.methodNode = oldMethod;
        constructorNode.setCode(code);
        constructorNode.setSyntheticPublic(syntheticPublic);
        constructorNode.addAnnotations(annotations);
        this.configureAST((ASTNode)constructorNode, constructorDef);
        constructorNode.setNameStart(nameStart);
        constructorNode.setNameEnd(nameEnd - 1);
        constructorNode.putNodeMetaData((Object)"rparen.offset", (Object)this.locations.findOffset(groovySourceAST.getLineLast(), groovySourceAST.getColumnLast()));
    }

    protected void fieldDef(AST fieldDef) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        AST node = fieldDef.getFirstChild();
        int nodeStart = this.locations.findOffset(node.getLine(), node.getColumn());
        int modifiers = 0;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            modifiers &= 0xFFFFEFFF;
            node = node.getNextSibling();
        }
        if (this.classNode.isInterface() && ((modifiers |= 0x18) & 6) == 0) {
            modifiers |= 1;
        }
        ClassNode type = null;
        if (AntlrParserPlugin.isType(12, node)) {
            type = this.makeTypeWithArguments(node);
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        int nameStart = this.locations.findOffset(node.getLine(), node.getColumn());
        node = node.getNextSibling();
        Expression initialValue = null;
        if (node != null) {
            this.assertNodeType(124, node);
            initialValue = this.expression(node.getFirstChild());
        }
        if (this.classNode.isInterface() && initialValue == null && type != null) {
            initialValue = AntlrParserPlugin.getDefaultValueForPrimitive(type);
        }
        FieldNode fieldNode = new FieldNode(name, modifiers, type, this.classNode, initialValue);
        fieldNode.addAnnotations(annotations);
        this.configureAST((ASTNode)fieldNode, fieldDef);
        fieldNode.setNameStart(nameStart);
        fieldNode.setNameEnd(nameStart + name.length() - 1);
        if (nodeStart < fieldNode.getStart()) {
            fieldNode.setStart(nodeStart);
        }
        if (AntlrParserPlugin.isType(9, node = fieldDef.getNextSibling())) {
            fieldNode.putNodeMetaData((Object)"end2pos", (Object)(this.locations.findOffset(node.getLine(), node.getColumn()) - 1));
        }
        if (!this.hasVisibility(modifiers)) {
            int fieldModifiers = 0;
            int flags = 216;
            if (!this.hasVisibility(modifiers)) {
                modifiers |= 1;
                fieldModifiers |= 2;
            }
            fieldNode.setModifiers(fieldModifiers |= modifiers & flags);
            fieldNode.setSynthetic(true);
            FieldNode storedNode = this.classNode.getDeclaredField(fieldNode.getName());
            if (storedNode != null && !this.classNode.hasProperty(name)) {
                fieldNode = storedNode;
                this.classNode.getFields().remove(storedNode);
            }
            PropertyNode propertyNode = new PropertyNode(fieldNode, modifiers, null, null);
            this.configureAST((ASTNode)propertyNode, fieldDef);
            this.classNode.addProperty(propertyNode);
        } else {
            fieldNode.setModifiers(modifiers);
            PropertyNode pn = this.classNode.getProperty(name);
            if (pn != null && pn.getField().isSynthetic()) {
                this.classNode.getFields().remove(pn.getField());
                pn.setField(fieldNode);
            }
            this.classNode.addField(fieldNode);
        }
    }

    @Deprecated
    public static Expression getDefaultValueForPrimitive(ClassNode type) {
        return PrimitiveHelper.getDefaultValueForPrimitive((ClassNode)type);
    }

    protected ClassNode[] interfaces(AST node) {
        ArrayList<ClassNode> interfaceList = new ArrayList<ClassNode>();
        AST implementNode = node.getFirstChild();
        while (implementNode != null) {
            interfaceList.add(this.makeTypeWithArguments(implementNode));
            implementNode = implementNode.getNextSibling();
        }
        ClassNode[] interfaces = ClassNode.EMPTY_ARRAY;
        if (!interfaceList.isEmpty()) {
            interfaces = new ClassNode[interfaceList.size()];
            interfaceList.toArray(interfaces);
        }
        return interfaces;
    }

    protected Parameter[] parameters(AST parametersNode) {
        AST node = parametersNode.getFirstChild();
        this.firstParam = false;
        this.firstParamIsVarArg = false;
        if (node == null) {
            if (AntlrParserPlugin.isType(51, parametersNode)) {
                return Parameter.EMPTY_ARRAY;
            }
            return null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        AST firstParameterNode = null;
        do {
            boolean bl = this.firstParam = firstParameterNode == null;
            if (firstParameterNode == null) {
                firstParameterNode = node;
            }
            parameters.add(this.parameter(node));
        } while ((node = node.getNextSibling()) != null);
        this.verifyParameters(parameters, firstParameterNode);
        Parameter[] answer = new Parameter[parameters.size()];
        parameters.toArray(answer);
        return answer;
    }

    private void verifyParameters(List<Parameter> parameters, AST firstParameterNode) {
        if (parameters.size() <= 1) {
            return;
        }
        Parameter first = parameters.get(0);
        if (this.firstParamIsVarArg) {
            throw new ASTRuntimeException(firstParameterNode, "The var-arg parameter " + first.getName() + " must be the last parameter.");
        }
    }

    protected Parameter parameter(AST paramNode) {
        Parameter parameter;
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        boolean variableParameterDef = AntlrParserPlugin.isType(47, paramNode);
        AST node = paramNode.getFirstChild();
        int modifiers = 0;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, modifiers);
            node = node.getNextSibling();
        }
        ClassNode type = ClassHelper.DYNAMIC_TYPE;
        if (AntlrParserPlugin.isType(12, node)) {
            type = this.makeTypeWithArguments(node);
            if (variableParameterDef) {
                type = this.makeArray(type, node);
            }
            node = node.getNextSibling();
        }
        String name = this.identifier(node);
        int nameStart = this.locations.findOffset(node.getLine(), node.getColumn());
        int nameEnd = nameStart + name.length();
        if ((node = node.getNextSibling()) != null) {
            this.assertNodeType(124, node);
            Expression rightExpression = this.expression(node.getFirstChild());
            if (this.isAnInterface()) {
                throw new ASTRuntimeException(node, "Cannot specify default value for method parameter '" + name + " = " + rightExpression.getText() + "' inside an interface");
            }
            parameter = new Parameter(type, name, rightExpression);
        } else {
            parameter = new Parameter(type, name);
        }
        if (this.firstParam) {
            this.firstParamIsVarArg = variableParameterDef;
        }
        this.configureAST(parameter, paramNode);
        parameter.setNameStart(nameStart);
        parameter.setNameEnd(nameEnd - 1);
        if (parameter.hasInitialExpression()) {
            this.setSourceEnd(parameter, (ASTNode)parameter.getInitialExpression());
        } else if (parameter.getEnd() > nameEnd) {
            parameter.setEnd(nameEnd);
            int[] row_col = this.locations.getRowCol(nameEnd);
            parameter.setLastLineNumber(row_col[0]);
            parameter.setLastColumnNumber(row_col[1]);
        }
        parameter.addAnnotations(annotations);
        parameter.setModifiers(modifiers);
        return parameter;
    }

    protected int modifiers(AST modifierNode, List<AnnotationNode> annotations, int defaultModifiers) {
        this.assertNodeType(5, modifierNode);
        boolean access = false;
        int answer = 0;
        AST node = modifierNode.getFirstChild();
        while (node != null) {
            switch (node.getType()) {
                case 60: {
                    break;
                }
                case 66: {
                    annotations.add(this.annotation(node));
                    break;
                }
                case 115: {
                    answer = this.setModifierBit(node, answer, 2);
                    access = this.setAccessTrue(node, access);
                    break;
                }
                case 117: {
                    answer = this.setModifierBit(node, answer, 4);
                    access = this.setAccessTrue(node, access);
                    break;
                }
                case 116: {
                    answer = this.setModifierBit(node, answer, 1);
                    access = this.setAccessTrue(node, access);
                    break;
                }
                case 39: {
                    answer = this.setModifierBit(node, answer, 1024);
                    break;
                }
                case 38: {
                    answer = this.setModifierBit(node, answer, 16);
                    break;
                }
                case 119: {
                    answer = this.setModifierBit(node, answer, 256);
                    break;
                }
                case 83: {
                    answer = this.setModifierBit(node, answer, 8);
                    break;
                }
                case 43: {
                    answer = this.setModifierBit(node, answer, 2048);
                    break;
                }
                case 121: {
                    answer = this.setModifierBit(node, answer, 32);
                    break;
                }
                case 118: {
                    answer = this.setModifierBit(node, answer, 128);
                    break;
                }
                case 122: {
                    answer = this.setModifierBit(node, answer, 64);
                    break;
                }
                default: {
                    this.unknownAST(node);
                }
            }
            node = node.getNextSibling();
        }
        if (!access) {
            answer |= defaultModifiers;
            if (defaultModifiers == 1) {
                answer |= 0x1000;
            }
        }
        return answer;
    }

    protected boolean setAccessTrue(AST node, boolean access) {
        if (!access) {
            return true;
        }
        throw new ASTRuntimeException(node, "Cannot specify modifier: " + node.getText() + " when access scope has already been defined");
    }

    protected int setModifierBit(AST node, int answer, int bit) {
        if ((answer & bit) != 0) {
            throw new ASTRuntimeException(node, "Cannot repeat modifier: " + node.getText());
        }
        return answer | bit;
    }

    protected AnnotationNode annotation(AST annotationNode) {
        char[] sourceChars;
        this.annotationBeingDef = true;
        AST node = annotationNode.getFirstChild();
        AnnotationNode annotatedNode = new AnnotationNode(this.makeType(annotationNode));
        this.configureAST((ASTNode)annotatedNode, annotationNode);
        int start = annotatedNode.getStart();
        int until = annotatedNode.getEnd();
        if (this.getController() != null && (sourceChars = this.getController().readSourceRange(start, until - start)) != null) {
            int i = sourceChars.length - 1;
            while (i >= 0 && Character.isWhitespace(sourceChars[i])) {
                --i;
                --until;
            }
        }
        annotatedNode.setEnd(until);
        int[] row_col = this.locations.getRowCol(until);
        annotatedNode.setLastLineNumber(row_col[0]);
        annotatedNode.setLastColumnNumber(row_col[1]);
        while (AntlrParserPlugin.isType(67, node = node.getNextSibling())) {
            AST memberNode = node.getFirstChild();
            String param = this.identifier(memberNode);
            Expression expression = this.expression(memberNode.getNextSibling());
            if (annotatedNode.getMember(param) != null) {
                throw new ASTRuntimeException(memberNode, "Annotation member '" + param + "' has already been associated with a value");
            }
            annotatedNode.setMember(param, expression);
        }
        this.annotationBeingDef = false;
        return annotatedNode;
    }

    protected Statement statement(AST node) {
        if (node == null) {
            return new EmptyStatement();
        }
        Statement statement = null;
        switch (node.getType()) {
            case 7: 
            case 152: {
                statement = this.statementList(node);
                break;
            }
            case 27: {
                statement = this.methodCall(node);
                break;
            }
            case 9: {
                statement = this.variableDef(node);
                break;
            }
            case 22: {
                return this.labelledStatement(node);
            }
            case 147: {
                statement = this.assertStatement(node);
                break;
            }
            case 144: {
                statement = this.breakStatement(node);
                break;
            }
            case 145: {
                statement = this.continueStatement(node);
                break;
            }
            case 137: {
                statement = this.ifStatement(node);
                break;
            }
            case 141: {
                statement = this.forStatement(node);
                break;
            }
            case 143: {
                statement = this.returnStatement(node);
                break;
            }
            case 121: {
                statement = this.synchronizedStatement(node);
                break;
            }
            case 140: {
                statement = this.switchStatement(node);
                break;
            }
            case 151: {
                statement = this.tryStatement(node);
                break;
            }
            case 146: {
                statement = this.throwStatement(node);
                break;
            }
            case 139: {
                statement = this.whileStatement(node);
                break;
            }
            default: {
                statement = new ExpressionStatement(this.expression(node));
            }
        }
        if (statement != null) {
            this.configureAST((ASTNode)statement, node);
        }
        return statement;
    }

    protected Statement statementList(AST code) {
        BlockStatement block = this.siblingsToBlockStatement(code.getFirstChild());
        this.configureAST((ASTNode)block, code);
        return block;
    }

    protected Statement statementListNoChild(AST node, AST alternativeConfigureNode) {
        BlockStatement block = this.siblingsToBlockStatement(node);
        if (alternativeConfigureNode != null) {
            this.configureAST((ASTNode)block, alternativeConfigureNode);
        } else if (node != null) {
            this.configureAST((ASTNode)block, node);
        }
        return block;
    }

    private BlockStatement siblingsToBlockStatement(AST firstSiblingNode) {
        BlockStatement block = new BlockStatement();
        AST node = firstSiblingNode;
        while (node != null) {
            block.addStatement(this.statement(node));
            node = node.getNextSibling();
        }
        return block;
    }

    protected Statement assertStatement(AST assertNode) {
        AST node = assertNode.getFirstChild();
        BooleanExpression booleanExpression = this.booleanExpression(node);
        ConstantExpression messageExpression = null;
        messageExpression = (node = node.getNextSibling()) != null ? this.expression(node) : GeneralUtils.nullX();
        AssertStatement assertStatement = new AssertStatement(booleanExpression, (Expression)messageExpression);
        this.configureAST((ASTNode)assertStatement, assertNode);
        return assertStatement;
    }

    protected Statement breakStatement(AST node) {
        BreakStatement breakStatement = new BreakStatement(this.label(node));
        this.configureAST((ASTNode)breakStatement, node);
        return breakStatement;
    }

    protected Statement continueStatement(AST node) {
        ContinueStatement continueStatement = new ContinueStatement(this.label(node));
        this.configureAST((ASTNode)continueStatement, node);
        return continueStatement;
    }

    protected Statement forStatement(AST forNode) {
        Parameter forParameter;
        ClosureListExpression collectionExpression;
        AST inNode = forNode.getFirstChild();
        if (AntlrParserPlugin.isType(77, inNode)) {
            this.forStatementBeingDef = true;
            ClosureListExpression clist = this.closureListExpression(inNode);
            this.forStatementBeingDef = false;
            int size = clist.getExpressions().size();
            if (size != 3) {
                throw new ASTRuntimeException(inNode, "3 expressions are required for the classic for loop, you gave " + size);
            }
            collectionExpression = clist;
            forParameter = ForStatement.FOR_LOOP_DUMMY;
        } else {
            AST variableNode = inNode.getFirstChild();
            AST collectionNode = variableNode.getNextSibling();
            ClassNode type = ClassHelper.DYNAMIC_TYPE;
            if (AntlrParserPlugin.isType(9, variableNode)) {
                AST node = variableNode.getFirstChild();
                if (AntlrParserPlugin.isType(5, node)) {
                    int modifiersMask = this.modifiers(node, new ArrayList<AnnotationNode>(), 0);
                    if ((modifiersMask & 0xFFFFFFEF) != 0) {
                        throw new ASTRuntimeException(node, "Only the 'final' modifier is allowed in front of the for loop variable.");
                    }
                    node = node.getNextSibling();
                }
                type = this.makeTypeWithArguments(node);
                variableNode = node.getNextSibling();
            }
            String variable = this.identifier(variableNode);
            collectionExpression = this.expression(collectionNode);
            forParameter = new Parameter(type, variable);
            this.configureAST(forParameter, variableNode);
            forParameter.setNameStart(forParameter.getStart());
            forParameter.setNameEnd(forParameter.getEnd() - 1);
            if (type.getStart() > 0) {
                this.setSourceStart(forParameter, type);
            }
        }
        AST node = inNode.getNextSibling();
        Object block = AntlrParserPlugin.isType(128, node) ? EmptyStatement.INSTANCE : this.statement(node);
        ForStatement forStatement = new ForStatement(forParameter, (Expression)collectionExpression, (Statement)block);
        this.configureAST((ASTNode)((Object)forStatement), forNode);
        return forStatement;
    }

    protected Statement ifStatement(AST ifNode) {
        EmptyStatement thenBlock;
        AST node = ifNode.getFirstChild();
        this.assertNodeType(28, node);
        BooleanExpression booleanExpression = this.booleanExpression(node);
        node = node.getNextSibling();
        Object object = thenBlock = AntlrParserPlugin.isType(128, node) ? EmptyStatement.INSTANCE : this.statement(node);
        if (node != null) {
            node = node.getNextSibling();
        }
        EmptyStatement elseBlock = node == null || AntlrParserPlugin.isType(128, node) ? EmptyStatement.INSTANCE : this.statement(node);
        IfStatement ifStatement = new IfStatement(booleanExpression, (Statement)thenBlock, (Statement)elseBlock);
        this.configureAST((ASTNode)ifStatement, ifNode);
        return ifStatement;
    }

    protected Statement labelledStatement(AST labelNode) {
        AST node = labelNode.getFirstChild();
        String label = this.identifier(node);
        Statement statement = this.statement(node.getNextSibling());
        statement.addStatementLabel(label);
        return statement;
    }

    protected Statement methodCall(AST code) {
        Expression expression = this.methodCallExpression(code);
        ExpressionStatement expressionStatement = new ExpressionStatement(expression);
        this.configureAST((ASTNode)expressionStatement, code);
        return expressionStatement;
    }

    protected Expression declarationExpression(AST variableDef) {
        VariableExpression leftExpression;
        AST node = variableDef.getFirstChild();
        ClassNode type = null;
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        int modifiers = 0;
        if (AntlrParserPlugin.isType(5, node)) {
            modifiers = this.modifiers(node, annotations, 0);
            node = node.getNextSibling();
        }
        if (AntlrParserPlugin.isType(12, node)) {
            type = this.makeTypeWithArguments(node);
            node = node.getNextSibling();
        }
        EmptyExpression rightExpression = EmptyExpression.INSTANCE;
        if (AntlrParserPlugin.isType(124, node)) {
            node = node.getFirstChild();
            AST left = node.getFirstChild();
            ArgumentListExpression alist = new ArgumentListExpression();
            AST varDef = left;
            while (varDef != null) {
                this.assertNodeType(9, varDef);
                DeclarationExpression de = (DeclarationExpression)this.declarationExpression(varDef);
                alist.addExpression((Expression)de.getVariableExpression());
                varDef = varDef.getNextSibling();
            }
            leftExpression = alist;
            AST right = node.getNextSibling();
            if (right != null) {
                rightExpression = this.expression(right);
            }
            this.configureAST((ASTNode)leftExpression, node);
            leftExpression.setLastLineNumber(((GroovySourceAST)left).getLineLast());
            leftExpression.setLastColumnNumber(((GroovySourceAST)left).getColumnLast());
            leftExpression.setEnd(this.locations.findOffset(leftExpression.getLastLineNumber(), leftExpression.getLastColumnNumber()));
        } else {
            String name = this.identifier(node);
            VariableExpression ve = new VariableExpression(name, type);
            ve.setModifiers(modifiers);
            leftExpression = ve;
            AST right = node.getNextSibling();
            if (right != null) {
                this.assertNodeType(124, right);
                rightExpression = this.expression(right.getFirstChild());
            }
            this.configureAST((ASTNode)leftExpression, node);
        }
        Token token = AntlrParserPlugin.makeToken(100, variableDef);
        DeclarationExpression expression = new DeclarationExpression((Expression)leftExpression, token, (Expression)rightExpression);
        expression.addAnnotations(annotations);
        this.configureAST((ASTNode)expression, variableDef);
        ExpressionStatement expressionStatement = new ExpressionStatement((Expression)expression);
        this.configureAST((ASTNode)expressionStatement, variableDef);
        return expression;
    }

    protected Statement variableDef(AST variableDef) {
        ExpressionStatement expressionStatement = new ExpressionStatement(this.declarationExpression(variableDef));
        this.configureAST((ASTNode)expressionStatement, variableDef);
        return expressionStatement;
    }

    protected Statement returnStatement(AST node) {
        AST exprNode = node.getFirstChild();
        ConstantExpression expression = exprNode == null ? GeneralUtils.nullX() : this.expression(exprNode);
        ReturnStatement returnStatement = new ReturnStatement((Expression)expression);
        this.configureAST((ASTNode)returnStatement, node);
        return returnStatement;
    }

    protected Statement switchStatement(AST switchNode) {
        AST node = switchNode.getFirstChild();
        Expression expression = this.expression(node);
        EmptyStatement defaultStatement = EmptyStatement.INSTANCE;
        ArrayList<CaseStatement> caseStatements = new ArrayList<CaseStatement>();
        node = node.getNextSibling();
        while (AntlrParserPlugin.isType(32, node)) {
            AST child = node.getFirstChild();
            Statement tmpDefaultStatement = AntlrParserPlugin.isType(150, child) ? this.caseStatements(child, caseStatements) : this.statement(child.getNextSibling());
            if (!(tmpDefaultStatement instanceof EmptyStatement)) {
                if (defaultStatement instanceof EmptyStatement) {
                    defaultStatement = tmpDefaultStatement;
                } else {
                    throw new ASTRuntimeException(switchNode, "The default case is already defined.");
                }
            }
            node = node.getNextSibling();
        }
        if (node != null) {
            this.unknownAST(node);
        }
        SwitchStatement switchStatement = new SwitchStatement(expression, caseStatements, (Statement)defaultStatement);
        this.configureAST((ASTNode)switchStatement, switchNode);
        return switchStatement;
    }

    protected Statement caseStatements(AST node, List<CaseStatement> cases) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        EmptyStatement statement = EmptyStatement.INSTANCE;
        EmptyStatement defaultStatement = EmptyStatement.INSTANCE;
        AST nextSibling = node;
        do {
            Expression expression = this.expression(nextSibling.getFirstChild());
            expressions.add(expression);
        } while (AntlrParserPlugin.isType(150, nextSibling = nextSibling.getNextSibling()));
        if (nextSibling != null) {
            if (AntlrParserPlugin.isType(129, nextSibling)) {
                defaultStatement = this.statement(nextSibling.getNextSibling());
                statement = EmptyStatement.INSTANCE;
            } else {
                statement = this.statement(nextSibling);
            }
        }
        Iterator iterator = expressions.iterator();
        while (iterator.hasNext()) {
            Expression expr = (Expression)iterator.next();
            CaseStatement stmt = iterator.hasNext() ? new CaseStatement(expr, (Statement)EmptyStatement.INSTANCE) : new CaseStatement(expr, (Statement)statement);
            this.configureAST((ASTNode)stmt, node);
            cases.add(stmt);
        }
        return defaultStatement;
    }

    protected Statement synchronizedStatement(AST syncNode) {
        AST node = syncNode.getFirstChild();
        Expression expression = this.expression(node);
        Statement code = this.statement(node.getNextSibling());
        SynchronizedStatement synchronizedStatement = new SynchronizedStatement(expression, code);
        this.configureAST((ASTNode)synchronizedStatement, syncNode);
        return synchronizedStatement;
    }

    protected Statement throwStatement(AST node) {
        AST expressionNode = node.getFirstChild();
        if (expressionNode == null) {
            expressionNode = node.getNextSibling();
        }
        if (expressionNode == null) {
            throw new ASTRuntimeException(node, "No expression available");
        }
        ThrowStatement throwStatement = new ThrowStatement(this.expression(expressionNode));
        this.configureAST((ASTNode)throwStatement, node);
        return throwStatement;
    }

    protected Statement tryStatement(AST tryStatementNode) {
        AST tryNode = tryStatementNode.getFirstChild();
        Statement tryStatement = this.statement(tryNode);
        EmptyStatement finallyStatement = EmptyStatement.INSTANCE;
        AST node = tryNode.getNextSibling();
        ArrayList<CatchStatement> catches = new ArrayList<CatchStatement>();
        while (AntlrParserPlugin.isType(153, node)) {
            List<CatchStatement> catchStatements = this.catchStatement(node);
            catches.addAll(catchStatements);
            node = node.getNextSibling();
        }
        if (AntlrParserPlugin.isType(152, node)) {
            finallyStatement = this.statement(node);
            node = node.getNextSibling();
        }
        if (finallyStatement instanceof EmptyStatement && catches.isEmpty()) {
            throw new ASTRuntimeException(tryStatementNode, "A try statement must have at least one catch or finally block.");
        }
        TryCatchStatement tryCatchStatement = new TryCatchStatement(tryStatement, (Statement)finallyStatement);
        this.configureAST((ASTNode)tryCatchStatement, tryStatementNode);
        for (CatchStatement statement : catches) {
            tryCatchStatement.addCatch(statement);
        }
        return tryCatchStatement;
    }

    protected List<CatchStatement> catchStatement(AST catchNode) {
        AST node = catchNode.getFirstChild();
        ArrayList<CatchStatement> catches = new ArrayList<CatchStatement>();
        if (78 == node.getType()) {
            AST multicatches = node.getFirstChild();
            if (multicatches.getType() != 79) {
                String variable = this.identifier(multicatches);
                Parameter catchParameter = new Parameter(ClassHelper.DYNAMIC_TYPE, variable);
                this.configureAST(catchParameter, multicatches);
                catchParameter.setNameStart(catchParameter.getStart());
                catchParameter.setNameEnd(catchParameter.getEnd() - 1);
                CatchStatement answer = new CatchStatement(catchParameter, this.statement(node.getNextSibling()));
                this.configureAST((ASTNode)answer, catchNode);
                catches.add(answer);
            } else {
                AST exceptionNodes = multicatches.getFirstChild();
                String variable = this.identifier(multicatches.getNextSibling());
                while (exceptionNodes != null) {
                    ClassNode exceptionType = this.buildName(exceptionNodes);
                    Parameter catchParameter = new Parameter(exceptionType, variable);
                    this.configureAST(catchParameter, multicatches.getNextSibling());
                    catchParameter.setNameStart(catchParameter.getStart());
                    catchParameter.setNameEnd(catchParameter.getEnd() - 1);
                    CatchStatement answer = new CatchStatement(catchParameter, this.statement(node.getNextSibling()));
                    catches.add(answer);
                    exceptionNodes = exceptionNodes.getNextSibling();
                }
                if (catches.size() > 1) {
                    ArrayList<ClassNode> types = new ArrayList<ClassNode>();
                    for (CatchStatement catchStmt : catches) {
                        types.add(catchStmt.getExceptionType());
                        catchStmt.putNodeMetaData((Object)"catch.types", types);
                    }
                }
            }
        }
        return catches;
    }

    protected Statement whileStatement(AST whileNode) {
        AST node = whileNode.getFirstChild();
        this.assertNodeType(28, node);
        if (AntlrParserPlugin.isType(9, node.getFirstChild())) {
            throw new ASTRuntimeException(whileNode, "While loop condition contains a declaration; this is currently unsupported.");
        }
        BooleanExpression booleanExpression = this.booleanExpression(node);
        Object block = AntlrParserPlugin.isType(128, node = node.getNextSibling()) ? EmptyStatement.INSTANCE : this.statement(node);
        WhileStatement whileStatement = new WhileStatement(booleanExpression, (Statement)block);
        this.configureAST((ASTNode)whileStatement, whileNode);
        return whileStatement;
    }

    protected Expression expression(AST node) {
        return this.expression(node, false);
    }

    protected Expression expression(AST node, boolean convertToConstant) {
        if (node == null || node.getType() == 37 || node.getType() == 42) {
            return new ConstantExpression("ERROR");
        }
        Expression expression = this.expressionSwitch(node);
        if (convertToConstant && expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            expression = new ConstantExpression(ve.getName());
            expression.setSourcePosition((ASTNode)ve);
        }
        return expression;
    }

    protected Expression expressionSwitch(AST node) {
        switch (node.getType()) {
            case 28: {
                Expression expression = this.expression(node.getFirstChild());
                int offset = this.locations.findOffset(node.getLine(), node.getColumn());
                if (offset < expression.getStart()) {
                    if (expression instanceof ArrayExpression || expression instanceof ConstructorCallExpression) {
                        expression.putNodeMetaData((Object)"new.offset", (Object)expression.getStart());
                    }
                    this.configureAST((ASTNode)expression, node);
                }
                return expression;
            }
            case 33: {
                return this.expressionList(node);
            }
            case 7: {
                return this.blockExpression(node);
            }
            case 50: {
                return this.closureExpression(node);
            }
            case 44: {
                return this.specialConstructorCallExpression(node, ClassNode.SUPER);
            }
            case 27: {
                return this.methodCallExpression(node);
            }
            case 159: {
                return this.constructorCallExpression(node);
            }
            case 45: {
                return this.specialConstructorCallExpression(node, ClassNode.THIS);
            }
            case 97: 
            case 174: {
                return this.ternaryExpression(node);
            }
            case 90: 
            case 154: 
            case 155: {
                return this.dotExpression(node);
            }
            case 87: 
            case 99: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 132: {
                return this.variableExpression(node);
            }
            case 57: {
                return this.listExpression(node);
            }
            case 58: {
                return this.mapExpression(node);
            }
            case 54: {
                return this.mapEntryExpression(node);
            }
            case 55: {
                return this.spreadExpression(node);
            }
            case 56: {
                return this.spreadMapExpression(node);
            }
            case 156: {
                return this.methodPointerExpression(node);
            }
            case 24: {
                return this.indexExpression(node);
            }
            case 158: {
                return this.instanceofExpression(node);
            }
            case 114: {
                return this.asExpression(node);
            }
            case 23: {
                return this.castExpression(node);
            }
            case 161: {
                return this.literalExpression(node, Boolean.TRUE);
            }
            case 157: {
                return this.literalExpression(node, Boolean.FALSE);
            }
            case 160: {
                return this.literalExpression(node, null);
            }
            case 88: {
                return this.literalExpression(node, node.getText());
            }
            case 48: {
                return this.gstring(node);
            }
            case 200: 
            case 202: 
            case 204: {
                return this.decimalExpression(node);
            }
            case 199: 
            case 201: 
            case 203: {
                return this.integerExpression(node);
            }
            case 196: {
                NotExpression notExpression = new NotExpression(this.expression(node.getFirstChild()));
                this.configureAST((ASTNode)notExpression, node);
                this.setSourceEnd((ASTNode)notExpression, (ASTNode)notExpression.getExpression());
                return notExpression;
            }
            case 30: {
                return this.unaryMinusExpression(node);
            }
            case 195: {
                BitwiseNegationExpression bitwiseNegationExpression = new BitwiseNegationExpression(this.expression(node.getFirstChild()));
                this.configureAST((ASTNode)bitwiseNegationExpression, node);
                this.setSourceEnd((ASTNode)bitwiseNegationExpression, (ASTNode)bitwiseNegationExpression.getExpression());
                return bitwiseNegationExpression;
            }
            case 31: {
                return this.unaryPlusExpression(node);
            }
            case 190: {
                return this.prefixExpression(node, 250);
            }
            case 193: {
                return this.prefixExpression(node, 260);
            }
            case 25: {
                return this.postfixExpression(node, 250);
            }
            case 26: {
                return this.postfixExpression(node, 260);
            }
            case 124: {
                return this.binaryExpression(100, node);
            }
            case 181: {
                return this.binaryExpression(123, node);
            }
            case 182: {
                return this.binaryExpression(121, node);
            }
            case 180: {
                return this.binaryExpression(120, node);
            }
            case 183: {
                return this.binaryExpression(122, node);
            }
            case 184: {
                return this.binaryExpression(128, node);
            }
            case 185: {
                return this.binaryExpression(125, node);
            }
            case 89: {
                return this.binaryExpression(124, node);
            }
            case 100: {
                return this.binaryExpression(126, node);
            }
            case 186: {
                return this.binaryExpression(127, node);
            }
            case 176: {
                return this.binaryExpression(164, node);
            }
            case 175: {
                return this.binaryExpression(162, node);
            }
            case 125: {
                return this.binaryExpression(341, node);
            }
            case 170: {
                return this.binaryExpression(351, node);
            }
            case 134: {
                return this.binaryExpression(340, node);
            }
            case 172: {
                return this.binaryExpression(350, node);
            }
            case 177: {
                return this.binaryExpression(342, node);
            }
            case 171: {
                return this.binaryExpression(352, node);
            }
            case 148: {
                return this.binaryExpression(200, node);
            }
            case 162: {
                return this.binaryExpression(210, node);
            }
            case 149: {
                return this.binaryExpression(201, node);
            }
            case 163: {
                return this.binaryExpression(211, node);
            }
            case 113: {
                return this.binaryExpression(202, node);
            }
            case 164: {
                return this.binaryExpression(212, node);
            }
            case 194: {
                return this.binaryExpression(206, node);
            }
            case 173: {
                return this.binaryExpression(216, node);
            }
            case 191: {
                return this.binaryExpression(203, node);
            }
            case 165: {
                return this.binaryExpression(213, node);
            }
            case 192: {
                return this.binaryExpression(205, node);
            }
            case 166: {
                return this.binaryExpression(215, node);
            }
            case 187: {
                return this.binaryExpression(280, node);
            }
            case 169: {
                return this.binaryExpression(285, node);
            }
            case 102: {
                return this.binaryExpression(281, node);
            }
            case 167: {
                return this.binaryExpression(286, node);
            }
            case 103: {
                return this.binaryExpression(282, node);
            }
            case 168: {
                return this.binaryExpression(287, node);
            }
            case 9: {
                return this.declarationExpression(node);
            }
            case 178: {
                return this.binaryExpression(90, node);
            }
            case 179: {
                return this.binaryExpression(94, node);
            }
            case 188: {
                return this.rangeExpression(node, true);
            }
            case 189: {
                return this.rangeExpression(node, false);
            }
            case 53: {
                return this.dynamicMemberExpression(node);
            }
            case 142: {
                return this.binaryExpression(573, node);
            }
            case 66: {
                AnnotationConstantExpression expression = new AnnotationConstantExpression(this.annotation(node));
                this.configureAST((ASTNode)expression, node);
                return expression;
            }
            case 77: {
                return this.closureListExpression(node);
            }
            case 85: 
            case 91: {
                return this.tupleExpression(node);
            }
            case 6: {
                return this.anonymousInnerClassDef(node);
            }
        }
        this.unknownAST(node);
        return null;
    }

    private TupleExpression tupleExpression(AST node) {
        TupleExpression exp = new TupleExpression();
        this.configureAST((ASTNode)exp, node);
        node = node.getFirstChild();
        while (node != null) {
            this.assertNodeType(9, node);
            AST nameNode = node.getFirstChild().getNextSibling();
            VariableExpression varExp = new VariableExpression(nameNode.getText());
            this.configureAST((ASTNode)varExp, nameNode);
            exp.addExpression((Expression)varExp);
            node = node.getNextSibling();
        }
        return exp;
    }

    private ClosureListExpression closureListExpression(AST node) {
        this.isClosureListExpressionAllowedHere(node);
        AST exprNode = node.getFirstChild();
        ArrayList<Object> list = new ArrayList<Object>();
        while (exprNode != null) {
            if (AntlrParserPlugin.isType(28, exprNode)) {
                Expression expr = this.expression(exprNode);
                this.configureAST((ASTNode)expr, exprNode);
                list.add(expr);
            } else {
                this.assertNodeType(37, exprNode);
                list.add(EmptyExpression.INSTANCE);
            }
            exprNode = exprNode.getNextSibling();
        }
        ClosureListExpression cle = new ClosureListExpression(list);
        this.configureAST((ASTNode)cle, node);
        return cle;
    }

    private void isClosureListExpressionAllowedHere(AST node) {
        if (!this.forStatementBeingDef) {
            throw new ASTRuntimeException(node, "Expression list of the form (a; b; c) is not supported in this context.");
        }
    }

    protected Expression dynamicMemberExpression(AST dynamicMemberNode) {
        AST node = dynamicMemberNode.getFirstChild();
        return this.expression(node);
    }

    protected Expression ternaryExpression(AST ternaryNode) {
        ElvisOperatorExpression ret;
        AST node = ternaryNode.getFirstChild();
        Expression base = this.expression(node);
        node = node.getNextSibling();
        Expression left = this.expression(node);
        if ((node = node.getNextSibling()) == null) {
            ret = new ElvisOperatorExpression(base, left);
        } else {
            Expression right = this.expression(node);
            BooleanExpression booleanExpression = new BooleanExpression(base);
            booleanExpression.setSourcePosition((ASTNode)base);
            ret = new TernaryExpression(booleanExpression, left, right);
        }
        this.setSourceStart((ASTNode)ret, (ASTNode)base);
        this.setSourceEnd((ASTNode)ret, (ASTNode)((TernaryExpression)ret).getFalseExpression());
        return ret;
    }

    protected Expression variableExpression(AST node) {
        String text = node.getText();
        VariableExpression variableExpression = new VariableExpression(text);
        this.configureAST((ASTNode)variableExpression, node);
        return variableExpression;
    }

    protected ConstantExpression literalExpression(AST node, Object value) {
        ConstantExpression constantExpression = new ConstantExpression(value, true);
        this.configureAST((ASTNode)((Object)constantExpression), node);
        return constantExpression;
    }

    protected Expression rangeExpression(AST rangeNode, boolean inclusive) {
        AST node = rangeNode.getFirstChild();
        Expression left = this.expression(node);
        Expression right = this.expression(node.getNextSibling());
        RangeExpression rangeExpression = new RangeExpression(left, right, inclusive);
        this.setSourceStart((ASTNode)rangeExpression, (ASTNode)left);
        this.setSourceEnd((ASTNode)rangeExpression, (ASTNode)right);
        return rangeExpression;
    }

    protected Expression spreadExpression(AST node) {
        AST exprNode = node.getFirstChild();
        AST listNode = exprNode.getFirstChild();
        Expression right = this.expression(listNode);
        SpreadExpression spreadExpression = new SpreadExpression(right);
        this.configureAST((ASTNode)spreadExpression, node);
        this.setSourceEnd((ASTNode)spreadExpression, (ASTNode)right);
        return spreadExpression;
    }

    protected Expression spreadMapExpression(AST node) {
        AST exprNode = node.getFirstChild();
        Expression expr = this.expression(exprNode);
        SpreadMapExpression spreadMapExpression = new SpreadMapExpression(expr);
        this.configureAST((ASTNode)spreadMapExpression, node);
        return spreadMapExpression;
    }

    protected Expression methodPointerExpression(AST node) {
        AST exprNode = node.getFirstChild();
        Expression objectExpression = this.expression(exprNode);
        AST mNode = exprNode.getNextSibling();
        Object methodName = AntlrParserPlugin.isType(53, mNode) ? this.expression(mNode) : new ConstantExpression(this.identifier(mNode));
        this.configureAST((ASTNode)methodName, mNode);
        MethodPointerExpression methodPointerExpression = new MethodPointerExpression(objectExpression, methodName);
        this.configureAST((ASTNode)methodPointerExpression, node);
        return methodPointerExpression;
    }

    protected Expression listExpression(AST listNode) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        AST elist = listNode.getFirstChild();
        this.assertNodeType(33, elist);
        AST node = elist.getFirstChild();
        while (node != null) {
            switch (node.getType()) {
                case 54: {
                    this.assertNodeType(101, node);
                    break;
                }
                case 56: {
                    this.assertNodeType(55, node);
                }
            }
            expressions.add(this.expression(node));
            node = node.getNextSibling();
        }
        ListExpression listExpression = new ListExpression(expressions);
        this.configureAST((ASTNode)listExpression, listNode);
        return listExpression;
    }

    protected Expression mapExpression(AST mapNode) {
        ArrayList<MapEntryExpression> entryExpressions = new ArrayList<MapEntryExpression>();
        AST elist = mapNode.getFirstChild();
        if (elist != null) {
            this.assertNodeType(33, elist);
            AST node = elist.getFirstChild();
            while (node != null) {
                switch (node.getType()) {
                    case 54: 
                    case 56: {
                        break;
                    }
                    case 55: {
                        this.assertNodeType(56, node);
                        break;
                    }
                    default: {
                        this.assertNodeType(54, node);
                    }
                }
                entryExpressions.add(this.mapEntryExpression(node));
                node = node.getNextSibling();
            }
        }
        MapExpression mapExpression = new MapExpression(entryExpressions);
        this.configureAST((ASTNode)mapExpression, mapNode);
        if (entryExpressions.isEmpty() && mapExpression.getLength() <= 1 && this.getController() != null) {
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (Reader r = this.getController().getSource().getReader();){
                    r.skip(mapExpression.getStart());
                    while (r.read() != 93) {
                        mapExpression.setEnd(mapExpression.getEnd() + 1);
                    }
                    int[] row_col = this.locations.getRowCol(mapExpression.getEnd());
                    mapExpression.setLastColumnNumber(row_col[1]);
                    mapExpression.setLastLineNumber(row_col[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                mapExpression.setEnd(mapExpression.getStart() + 3);
                mapExpression.setLastColumnNumber(mapExpression.getColumnNumber() + 3);
            }
        }
        return mapExpression;
    }

    protected MapEntryExpression mapEntryExpression(AST node) {
        if (node.getType() == 56) {
            AST rightNode = node.getFirstChild();
            Expression keyExpression = this.spreadMapExpression(node);
            Expression rightExpression = this.expression(rightNode);
            MapEntryExpression mapEntryExpression = new MapEntryExpression(keyExpression, rightExpression);
            this.configureAST((ASTNode)mapEntryExpression, node);
            return mapEntryExpression;
        }
        AST keyNode = node.getFirstChild();
        Expression keyExpression = this.expression(keyNode);
        AST valueNode = keyNode.getNextSibling();
        Expression valueExpression = this.expression(valueNode);
        MapEntryExpression mapEntryExpression = new MapEntryExpression(keyExpression, valueExpression);
        this.setSourceStart((ASTNode)mapEntryExpression, (ASTNode)keyExpression);
        this.setSourceEnd((ASTNode)mapEntryExpression, (ASTNode)valueExpression);
        return mapEntryExpression;
    }

    protected Expression instanceofExpression(AST node) {
        AST leftNode = node.getFirstChild();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        ClassNode type = this.buildName(rightNode);
        this.assertTypeNotNull(type, rightNode);
        ClassExpression rightExpression = new ClassExpression(type);
        this.configureAST((ASTNode)((Object)rightExpression), rightNode);
        BinaryExpression binaryExpression = new BinaryExpression(leftExpression, AntlrParserPlugin.makeToken(544, node), (Expression)rightExpression);
        this.setSourceStart((ASTNode)binaryExpression, (ASTNode)leftExpression);
        this.setSourceEnd((ASTNode)binaryExpression, (ASTNode)((Object)rightExpression));
        return binaryExpression;
    }

    protected void assertTypeNotNull(ClassNode type, AST rightNode) {
        if (type == null) {
            throw new ASTRuntimeException(rightNode, "No type available for: " + AntlrParserPlugin.qualifiedName(rightNode));
        }
    }

    protected Expression asExpression(AST node) {
        int typeStart;
        AST leftNode = node.getFirstChild();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        ClassNode type = this.makeTypeWithArguments(rightNode);
        CastExpression asExpression = CastExpression.asExpression((ClassNode)type, (Expression)leftExpression);
        asExpression.setStart(leftExpression.getStart());
        asExpression.setLineNumber(leftExpression.getLineNumber());
        asExpression.setColumnNumber(leftExpression.getColumnNumber());
        if (type.getEnd() > 0) {
            typeStart = type.getStart();
            asExpression.setEnd(type.getEnd());
            asExpression.setLastLineNumber(type.getLastLineNumber());
            asExpression.setLastColumnNumber(type.getLastColumnNumber());
        } else {
            SourceInfo typeNode = (SourceInfo)rightNode.getFirstChild();
            typeStart = this.locations.findOffset(typeNode.getLine(), typeNode.getColumn());
            asExpression.setEnd(this.locations.findOffset(typeNode.getLineLast(), typeNode.getColumnLast()));
            asExpression.setLastLineNumber(typeNode.getLineLast());
            asExpression.setLastColumnNumber(typeNode.getColumnLast());
        }
        asExpression.setNameStart(typeStart);
        asExpression.setNameEnd(asExpression.getEnd());
        if (leftExpression instanceof VariableExpression && ((VariableExpression)leftExpression).isSuperExpression()) {
            this.getController().addError(new SyntaxException("Cannot cast or coerce `super`", (ASTNode)asExpression));
        }
        return asExpression;
    }

    protected Expression castExpression(AST castNode) {
        AST node = castNode.getFirstChild();
        ClassNode type = this.makeTypeWithArguments(node);
        this.assertTypeNotNull(type, node);
        AST expressionNode = node.getNextSibling();
        Expression expression = this.expression(expressionNode);
        CastExpression castExpression = new CastExpression(type, expression);
        this.configureAST((ASTNode)castExpression, castNode);
        castExpression.setEnd(expression.getEnd());
        castExpression.setLastLineNumber(expression.getLastLineNumber());
        castExpression.setLastColumnNumber(expression.getLastColumnNumber());
        if (type.getEnd() > 0) {
            castExpression.setNameStart(type.getStart());
            castExpression.setNameEnd(type.getEnd());
        } else {
            SourceInfo typeNode = (SourceInfo)node.getFirstChild();
            castExpression.setNameStart(this.locations.findOffset(typeNode.getLine(), typeNode.getColumn()));
            castExpression.setNameEnd(this.locations.findOffset(typeNode.getLineLast(), typeNode.getColumnLast()));
        }
        if (expression instanceof VariableExpression && ((VariableExpression)expression).isSuperExpression()) {
            this.getController().addError(new SyntaxException("Cannot cast or coerce `super`", (ASTNode)castExpression));
        }
        return castExpression;
    }

    protected Expression indexExpression(AST indexNode) {
        AST bracket = indexNode.getFirstChild();
        AST leftNode = bracket.getNextSibling();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        Expression rightExpression = this.expression(rightNode);
        if (rightExpression instanceof SpreadExpression) {
            ListExpression wrapped = new ListExpression();
            wrapped.addExpression(rightExpression);
            rightExpression = wrapped;
        }
        BinaryExpression binaryExpression = new BinaryExpression(leftExpression, AntlrParserPlugin.makeToken(30, bracket), rightExpression);
        this.configureAST((ASTNode)binaryExpression, indexNode);
        return binaryExpression;
    }

    protected Expression binaryExpression(int type, AST node) {
        Token token = AntlrParserPlugin.makeToken(type, node);
        AST leftNode = node.getFirstChild();
        Expression leftExpression = this.expression(leftNode);
        AST rightNode = leftNode.getNextSibling();
        if (rightNode == null) {
            return leftExpression;
        }
        if (!(!Types.ofType((int)type, (int)1100) || leftExpression instanceof VariableExpression || leftExpression.getClass() == PropertyExpression.class || leftExpression instanceof FieldExpression || leftExpression instanceof AttributeExpression || leftExpression instanceof DeclarationExpression || leftExpression instanceof TupleExpression)) {
            if (leftExpression instanceof ConstantExpression) {
                throw new ASTRuntimeException(node, "\n[" + String.valueOf(((ConstantExpression)leftExpression).getValue()) + "] is a constant expression, but it should be a variable expression");
            }
            if (leftExpression instanceof BinaryExpression) {
                int lefttype = ((BinaryExpression)leftExpression).getOperation().getType();
                if (!Types.ofType((int)lefttype, (int)1100) && lefttype != 30) {
                    throw new ASTRuntimeException(node, "\n" + leftExpression.getText() + " is a binary expression, but it should be a variable expression");
                }
            } else {
                if (leftExpression instanceof GStringExpression) {
                    throw new ASTRuntimeException(node, "\n\"" + leftExpression.getText() + "\" is a GString expression, but it should be a variable expression");
                }
                if (leftExpression instanceof MethodCallExpression) {
                    throw new ASTRuntimeException(node, "\n\"" + leftExpression.getText() + "\" is a method call expression, but it should be a variable expression");
                }
                if (leftExpression instanceof MapExpression) {
                    throw new ASTRuntimeException(node, "\n'" + leftExpression.getText() + "' is a map expression, but it should be a variable expression");
                }
                throw new ASTRuntimeException(node, "\n" + String.valueOf(leftExpression.getClass()) + ", with its value '" + leftExpression.getText() + "', is a bad expression as the left hand side of an assignment operator");
            }
        }
        Expression rightExpression = this.expression(rightNode);
        BinaryExpression binaryExpression = new BinaryExpression(leftExpression, token, rightExpression);
        this.setSourceStart((ASTNode)binaryExpression, (ASTNode)leftExpression);
        this.setSourceEnd((ASTNode)binaryExpression, (ASTNode)rightExpression);
        return binaryExpression;
    }

    protected Expression prefixExpression(AST node, int token) {
        Expression expression = this.expression(node.getFirstChild());
        PrefixExpression prefixExpression = new PrefixExpression(AntlrParserPlugin.makeToken(token, node), expression);
        this.configureAST((ASTNode)prefixExpression, node);
        this.setSourceEnd((ASTNode)prefixExpression, (ASTNode)expression);
        return prefixExpression;
    }

    protected Expression postfixExpression(AST node, int token) {
        Expression expression = this.expression(node.getFirstChild());
        PostfixExpression postfixExpression = new PostfixExpression(expression, AntlrParserPlugin.makeToken(token, node));
        this.configureAST((ASTNode)postfixExpression, node);
        this.setSourceStart((ASTNode)postfixExpression, (ASTNode)expression);
        return postfixExpression;
    }

    protected BooleanExpression booleanExpression(AST node) {
        BooleanExpression booleanExpression = new BooleanExpression(this.expression(node));
        this.configureAST((ASTNode)booleanExpression, node);
        return booleanExpression;
    }

    private PropertyExpression chomp(PropertyExpression propertyExpression) {
        char[] sourceChars;
        if (propertyExpression.getEnd() > propertyExpression.getProperty().getEnd() && this.getController() != null && (sourceChars = this.getController().readSourceRange(propertyExpression.getStart(), propertyExpression.getLength())) != null) {
            int idx = sourceChars.length - 1;
            int off = propertyExpression.getEnd();
            while (idx >= 0 && Character.isWhitespace(sourceChars[idx])) {
                --idx;
                --off;
            }
            if (off < propertyExpression.getEnd()) {
                int[] row_col = this.locations.getRowCol(off);
                propertyExpression.setEnd(off);
                propertyExpression.setLastLineNumber(row_col[0]);
                propertyExpression.setLastColumnNumber(row_col[1]);
            }
        }
        return propertyExpression;
    }

    protected Expression dotExpression(AST node) {
        AST identifierNode;
        AST leftNode = node.getFirstChild();
        if (leftNode != null && (identifierNode = leftNode.getNextSibling()) != null) {
            Expression leftExpression = this.expression(leftNode);
            if (AntlrParserPlugin.isType(52, identifierNode)) {
                Expression field = this.expression(identifierNode.getFirstChild(), !AntlrParserPlugin.isType(53, identifierNode.getFirstChild()));
                AttributeExpression attributeExpression = new AttributeExpression(leftExpression, field, node.getType() != 90);
                if (node.getType() == 154) {
                    attributeExpression.setSpreadSafe(true);
                }
                this.configureAST((ASTNode)attributeExpression, node);
                return this.chomp((PropertyExpression)attributeExpression);
            }
            if (AntlrParserPlugin.isType(7, identifierNode)) {
                Statement code = this.statementList(identifierNode);
                ClosureExpression closureExpression = new ClosureExpression(Parameter.EMPTY_ARRAY, code);
                this.configureAST((ASTNode)closureExpression, identifierNode);
                PropertyExpression propertyExpression = new PropertyExpression(leftExpression, (Expression)closureExpression);
                if (node.getType() == 154) {
                    propertyExpression.setSpreadSafe(true);
                }
                this.configureAST((ASTNode)propertyExpression, node);
                return this.chomp(propertyExpression);
            }
            Expression property = this.expression(identifierNode, !AntlrParserPlugin.isType(53, identifierNode));
            PropertyExpression propertyExpression = new PropertyExpression(leftExpression, property, node.getType() != 90);
            if (node.getType() == 154) {
                propertyExpression.setSpreadSafe(true);
            }
            this.configureAST((ASTNode)propertyExpression, node);
            return this.chomp(propertyExpression);
        }
        return this.methodCallExpression(node);
    }

    protected Expression specialConstructorCallExpression(AST methodCallNode, ClassNode special) {
        AST node = methodCallNode.getFirstChild();
        Expression arguments = this.arguments(node);
        ConstructorCallExpression expression = new ConstructorCallExpression(special, arguments);
        int keywordLength = special == ClassNode.SUPER ? 5 : 4;
        GroovySourceAST ctorCallNode = (GroovySourceAST)methodCallNode;
        ctorCallNode.setColumn(Math.max(1, ctorCallNode.getColumn() - keywordLength));
        this.configureAST((ASTNode)expression, methodCallNode);
        expression.setNameStart(expression.getStart());
        expression.setNameEnd(expression.getStart() + keywordLength - 1);
        expression.setEnd(arguments.getEnd() + 1);
        int[] row_col = this.locations.getRowCol(expression.getEnd());
        expression.setLastLineNumber(row_col[0]);
        expression.setLastColumnNumber(row_col[1]);
        return expression;
    }

    protected Expression methodCallExpression(AST methodCallNode) {
        AST selector;
        Expression objectExpression;
        AST node = methodCallNode.getFirstChild();
        AST elist = node.getNextSibling();
        List<GenericsType> typeArgumentList = null;
        boolean implicitThis = false;
        boolean safe = AntlrParserPlugin.isType(155, node);
        boolean spreadSafe = AntlrParserPlugin.isType(154, node);
        if (AntlrParserPlugin.isType(90, node) || safe || spreadSafe) {
            AST objectNode = node.getFirstChild();
            objectExpression = this.expression(objectNode);
            selector = objectNode.getNextSibling();
        } else {
            implicitThis = true;
            objectExpression = new VariableExpression("this");
            objectExpression.setLineNumber(node.getLine());
            objectExpression.setColumnNumber(node.getColumn());
            selector = node;
        }
        if (AntlrParserPlugin.isType(70, selector)) {
            typeArgumentList = this.getTypeArgumentsList(selector);
            selector = selector.getNextSibling();
        }
        ConstantExpression name = null;
        if (AntlrParserPlugin.isType(99, selector)) {
            implicitThis = true;
            name = new ConstantExpression("super");
            if (objectExpression instanceof VariableExpression && ((VariableExpression)objectExpression).isThisExpression()) {
                objectExpression = VariableExpression.SUPER_EXPRESSION;
            }
        } else {
            if (this.isPrimitiveTypeLiteral(selector)) {
                throw new ASTRuntimeException(selector, "Primitive type literal: " + selector.getText() + " cannot be used as a method name");
            }
            if (AntlrParserPlugin.isType(52, selector)) {
                Expression field = this.expression(selector.getFirstChild(), !AntlrParserPlugin.isType(53, selector.getFirstChild()));
                AttributeExpression attributeExpression = new AttributeExpression(objectExpression, field, node.getType() != 90);
                this.configureAST((ASTNode)attributeExpression, node);
                Expression arguments = this.arguments(elist);
                MethodCallExpression expression = new MethodCallExpression((Expression)attributeExpression, "call", arguments);
                AntlrParserPlugin.setTypeArgumentsOnMethodCallExpression(expression, typeArgumentList);
                this.configureAST((ASTNode)((Object)expression), methodCallNode);
                return expression;
            }
            if (!implicitThis || AntlrParserPlugin.isType(53, selector) || AntlrParserPlugin.isType(87, selector) || AntlrParserPlugin.isType(48, selector) || AntlrParserPlugin.isType(88, selector)) {
                name = this.expression(selector, !AntlrParserPlugin.isType(53, selector));
            } else {
                implicitThis = false;
                name = new ConstantExpression("call");
                objectExpression = this.expression(selector, true);
            }
        }
        if (!(!selector.getText().equals("this") && !selector.getText().equals("super") || this.annotationBeingDef && selector.getText().equals("super"))) {
            throw new ASTRuntimeException(elist, "Constructor call must be the first statement in a constructor.");
        }
        Expression arguments = this.arguments(elist);
        MethodCallExpression expression = new MethodCallExpression(objectExpression, name, arguments);
        expression.setSafe(safe);
        expression.setSpreadSafe(spreadSafe);
        expression.setImplicitThis(implicitThis);
        AntlrParserPlugin.setTypeArgumentsOnMethodCallExpression(expression, typeArgumentList);
        MethodCallExpression ret = expression;
        if (implicitThis && "this".equals(expression.getMethodAsString())) {
            ret = new ConstructorCallExpression(this.classNode, arguments);
        }
        ret.setNameStart(name.getStart());
        ret.setNameEnd(name.getEnd() - 1);
        if (!implicitThis && methodCallNode.getText().equals("<command>")) {
            this.setSourceStart((ASTNode)((Object)ret), (ASTNode)objectExpression);
            this.setSourceEnd((ASTNode)((Object)ret), (ASTNode)arguments);
        } else {
            this.configureAST((ASTNode)((Object)ret), methodCallNode);
        }
        return ret;
    }

    private static void setTypeArgumentsOnMethodCallExpression(MethodCallExpression expression, List<GenericsType> typeArgumentList) {
        if (typeArgumentList != null && !typeArgumentList.isEmpty()) {
            expression.setGenericsTypes(typeArgumentList.toArray(GenericsType.EMPTY_ARRAY));
        }
    }

    protected Expression constructorCallExpression(AST constructorCallNode) {
        AST elist;
        ClassNode type = this.makeTypeWithArguments(constructorCallNode);
        AST node = constructorCallNode.getFirstChild();
        if (node == null) {
            return new ConstructorCallExpression(type, (Expression)new ArgumentListExpression());
        }
        if (this.isPrimitiveTypeLiteral(node)) {
            ClassNode proxy = ClassHelper.makeWithoutCaching(type.getName());
            proxy.setRedirect(type);
            type = proxy;
            this.configureAST(type, node);
        }
        if ((elist = node.getNextSibling()) == null && AntlrParserPlugin.isType(33, node)) {
            elist = node;
            if ("(".equals(type.getName())) {
                type = this.classNode;
            }
        }
        if (AntlrParserPlugin.isType(17, elist)) {
            AST expressionNode = elist.getFirstChild();
            if (expressionNode == null) {
                throw new ASTRuntimeException(elist, "No expression for the array constructor call");
            }
            List<Expression> size = this.arraySizeExpression(expressionNode);
            ArrayExpression arrayExpression = new ArrayExpression(type, null, size);
            this.configureAST((ASTNode)arrayExpression, constructorCallNode);
            arrayExpression.setNameStart(type.getStart());
            arrayExpression.setNameEnd(type.getEnd() - 1);
            return arrayExpression;
        }
        Expression arguments = this.arguments(elist);
        ClassNode innerClass = AntlrParserPlugin.getAnonymousInnerClassNode(arguments);
        ConstructorCallExpression ret = new ConstructorCallExpression(type, arguments);
        if (innerClass != null) {
            ret.setType(innerClass);
            ret.setUsingAnonymousInnerClass(true);
            innerClass.setUnresolvedSuperClass(type);
            innerClass.setNameStart(type.getStart());
            innerClass.setNameStart2(type.getNameStart2());
            innerClass.setNameEnd(type.getEnd() - 1);
            innerClass.putNodeMetaData("rparen.offset", this.locations.findOffset(((GroovySourceAST)elist).getLineLast(), ((GroovySourceAST)elist).getColumnLast()));
        }
        this.configureAST((ASTNode)ret, constructorCallNode);
        ret.setNameStart(type.getStart());
        ret.setNameEnd(type.getEnd() - 1);
        return ret;
    }

    private static ClassNode getAnonymousInnerClassNode(Expression arguments) {
        if (arguments instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)arguments;
            List expressions = te.getExpressions();
            if (expressions.isEmpty()) {
                return null;
            }
            Expression last = (Expression)expressions.remove(expressions.size() - 1);
            if (last instanceof AnonymousInnerClassCarrier) {
                AnonymousInnerClassCarrier carrier = (AnonymousInnerClassCarrier)last;
                return carrier.innerClass;
            }
            expressions.add(last);
        } else if (arguments instanceof AnonymousInnerClassCarrier) {
            AnonymousInnerClassCarrier carrier = (AnonymousInnerClassCarrier)arguments;
            return carrier.innerClass;
        }
        return null;
    }

    protected List<Expression> arraySizeExpression(AST node) {
        List<Expression> list;
        Object size = null;
        if (AntlrParserPlugin.isType(17, node)) {
            AST right = node.getNextSibling();
            size = right != null ? this.expression(right) : ConstantExpression.EMPTY_EXPRESSION;
            AST child = node.getFirstChild();
            if (child == null) {
                throw new ASTRuntimeException(node, "No expression for the array constructor call");
            }
            list = this.arraySizeExpression(child);
        } else {
            size = this.expression(node);
            list = new ArrayList<Expression>();
        }
        list.add((Expression)size);
        return list;
    }

    protected Expression enumArguments(AST elist) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        AST node = elist;
        while (node != null) {
            Expression expression = this.expression(node);
            expressionList.add(expression);
            node = node.getNextSibling();
        }
        ArgumentListExpression argumentListExpression = new ArgumentListExpression(expressionList);
        this.configureAST((ASTNode)argumentListExpression, elist);
        return argumentListExpression;
    }

    /*
     * WARNING - void declaration
     */
    protected Expression arguments(AST elist) {
        ArrayList<MapEntryExpression> expressionList = new ArrayList<MapEntryExpression>();
        boolean namedArguments = false;
        AST node = elist;
        while (node != null) {
            if (AntlrParserPlugin.isType(33, node)) {
                void var5_5;
                AST aST = node.getFirstChild();
                while (var5_5 != null) {
                    namedArguments |= this.addArgumentExpression((AST)var5_5, expressionList);
                    AST aST2 = var5_5.getNextSibling();
                }
            } else {
                namedArguments |= this.addArgumentExpression(node, expressionList);
            }
            node = node.getNextSibling();
        }
        if (namedArguments) {
            if (!expressionList.isEmpty()) {
                ArrayList<Object> argumentList = new ArrayList<Object>();
                for (Object e : expressionList) {
                    Expression expression = (Expression)e;
                    if (expression instanceof MapEntryExpression) continue;
                    argumentList.add(expression);
                }
                if (!argumentList.isEmpty()) {
                    expressionList.removeAll(argumentList);
                    AntlrParserPlugin.checkDuplicateNamedParams(elist, expressionList);
                    MapExpression mapExpression = new MapExpression(expressionList);
                    this.configureAST((ASTNode)mapExpression, elist);
                    argumentList.add(0, mapExpression);
                    ArgumentListExpression argumentListExpression = new ArgumentListExpression(argumentList);
                    this.configureAST((ASTNode)argumentListExpression, elist);
                    return argumentListExpression;
                }
            }
            AntlrParserPlugin.checkDuplicateNamedParams(elist, expressionList);
            NamedArgumentListExpression namedArgumentListExpression = new NamedArgumentListExpression(expressionList);
            this.configureAST((ASTNode)namedArgumentListExpression, elist);
            return namedArgumentListExpression;
        }
        ArgumentListExpression argumentListExpression = new ArgumentListExpression(expressionList);
        if (elist != null) {
            this.configureAST((ASTNode)argumentListExpression, elist);
        }
        return argumentListExpression;
    }

    private static void checkDuplicateNamedParams(AST elist, List<MapEntryExpression> expressionList) {
        if (expressionList.isEmpty()) {
            return;
        }
        HashSet<String> namedArgumentNames = new HashSet<String>();
        for (MapEntryExpression meExp : expressionList) {
            if (!(meExp.getKeyExpression() instanceof ConstantExpression)) continue;
            String argName = meExp.getKeyExpression().getText();
            if (!namedArgumentNames.contains(argName)) {
                namedArgumentNames.add(argName);
                continue;
            }
            throw new ASTRuntimeException(elist, "Duplicate named parameter '" + argName + "' found.");
        }
    }

    protected boolean addArgumentExpression(AST node, List<Expression> expressionList) {
        if (node.getType() == 56) {
            AST rightNode = node.getFirstChild();
            Expression keyExpression = this.spreadMapExpression(node);
            Expression rightExpression = this.expression(rightNode);
            MapEntryExpression mapEntryExpression = new MapEntryExpression(keyExpression, rightExpression);
            expressionList.add((Expression)mapEntryExpression);
            return true;
        }
        Expression expression = this.expression(node);
        expressionList.add(expression);
        return expression instanceof MapEntryExpression;
    }

    protected Expression expressionList(AST node) {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        AST child = node.getFirstChild();
        while (child != null) {
            expressionList.add(this.expression(child));
            child = child.getNextSibling();
        }
        if (expressionList.size() == 1) {
            return (Expression)expressionList.get(0);
        }
        ListExpression listExpression = new ListExpression(expressionList);
        listExpression.setWrapped(true);
        this.configureAST((ASTNode)listExpression, node);
        return listExpression;
    }

    protected ClosureExpression closureExpression(AST node) {
        AST paramNode = node.getFirstChild();
        Parameter[] parameters = null;
        AST codeNode = paramNode;
        if (AntlrParserPlugin.isType(20, paramNode) || AntlrParserPlugin.isType(51, paramNode)) {
            parameters = this.parameters(paramNode);
            codeNode = paramNode.getNextSibling();
        }
        Statement code = this.statementListNoChild(codeNode, node);
        ClosureExpression closureExpression = new ClosureExpression(parameters, code);
        this.configureAST((ASTNode)closureExpression, node);
        return closureExpression;
    }

    protected Expression blockExpression(AST node) {
        AST codeNode = node.getFirstChild();
        if (codeNode == null) {
            return GeneralUtils.nullX();
        }
        if (codeNode.getType() == 28 && codeNode.getNextSibling() == null) {
            return this.expression(codeNode);
        }
        Parameter[] parameters = Parameter.EMPTY_ARRAY;
        Statement code = this.statementListNoChild(codeNode, node);
        ClosureExpression closureExpression = new ClosureExpression(parameters, code);
        this.configureAST((ASTNode)closureExpression, node);
        String callName = "call";
        ArgumentListExpression noArguments = new ArgumentListExpression();
        MethodCallExpression call = new MethodCallExpression((Expression)closureExpression, callName, (Expression)noArguments);
        this.configureAST((ASTNode)((Object)call), node);
        return call;
    }

    protected Expression unaryMinusExpression(AST unaryMinusExpr) {
        AST node = unaryMinusExpr.getFirstChild();
        String text = node.getText();
        switch (node.getType()) {
            case 200: 
            case 202: 
            case 204: {
                ConstantExpression constantExpression = new ConstantExpression(Numbers.parseDecimal((String)("-" + text)), true);
                this.configureAST((ASTNode)((Object)constantExpression), unaryMinusExpr);
                this.setSourceEnd((ASTNode)((Object)constantExpression), (ASTNode)this.expression(node));
                return constantExpression;
            }
            case 199: 
            case 201: 
            case 203: {
                ConstantExpression constantLongExpression = new ConstantExpression(Numbers.parseInteger((String)("-" + text)), true);
                this.configureAST((ASTNode)((Object)constantLongExpression), unaryMinusExpr);
                this.setSourceEnd((ASTNode)((Object)constantLongExpression), (ASTNode)this.expression(node));
                return constantLongExpression;
            }
        }
        UnaryMinusExpression unaryMinusExpression = new UnaryMinusExpression(this.expression(node));
        this.configureAST((ASTNode)unaryMinusExpression, unaryMinusExpr);
        this.setSourceEnd((ASTNode)unaryMinusExpression, (ASTNode)unaryMinusExpression.getExpression());
        return unaryMinusExpression;
    }

    protected Expression unaryPlusExpression(AST unaryPlusExpr) {
        AST node = unaryPlusExpr.getFirstChild();
        UnaryPlusExpression unaryPlusExpression = new UnaryPlusExpression(this.expression(node));
        this.configureAST((ASTNode)unaryPlusExpression, unaryPlusExpr);
        switch (node.getType()) {
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                this.setSourceStart((ASTNode)unaryPlusExpression.getExpression(), (ASTNode)unaryPlusExpression);
                return unaryPlusExpression.getExpression();
            }
        }
        this.setSourceEnd((ASTNode)unaryPlusExpression, (ASTNode)unaryPlusExpression.getExpression());
        return unaryPlusExpression;
    }

    protected ConstantExpression decimalExpression(AST node) {
        Number number = Numbers.parseDecimal((String)node.getText());
        ConstantExpression constantExpression = new ConstantExpression(number, true);
        this.configureAST((ASTNode)((Object)constantExpression), node);
        return constantExpression;
    }

    protected ConstantExpression integerExpression(AST node) {
        Number number = Numbers.parseInteger((String)node.getText());
        ConstantExpression constantExpression = new ConstantExpression(number, true);
        this.configureAST((ASTNode)((Object)constantExpression), node);
        return constantExpression;
    }

    protected Expression gstring(AST gstringNode) {
        ArrayList<ConstantExpression> strings = new ArrayList<ConstantExpression>();
        ArrayList<Expression> values = new ArrayList<Expression>();
        StringBuilder buffer = new StringBuilder();
        boolean isPrevString = false;
        AST node = gstringNode.getFirstChild();
        while (node != null) {
            int type = node.getType();
            switch (type) {
                case 88: {
                    if (isPrevString) {
                        this.assertNodeType(87, node);
                    }
                    isPrevString = true;
                    String text = node.getText();
                    ConstantExpression constantExpression = new ConstantExpression(text);
                    this.configureAST((ASTNode)((Object)constantExpression), node);
                    strings.add(constantExpression);
                    buffer.append(text);
                    break;
                }
                default: {
                    if (!isPrevString) {
                        this.assertNodeType(87, node);
                    }
                    isPrevString = false;
                    Expression expression = this.expression(node);
                    values.add(expression);
                    buffer.append("$");
                    buffer.append(expression.getText());
                }
            }
            node = node.getNextSibling();
        }
        GStringExpression gStringExpression = new GStringExpression(buffer.toString(), strings, values);
        this.configureAST((ASTNode)gStringExpression, gstringNode);
        return gStringExpression;
    }

    public static String qualifiedName(AST qualifiedNameNode) {
        if (AntlrParserPlugin.isType(87, qualifiedNameNode)) {
            return qualifiedNameNode.getText();
        }
        if (AntlrParserPlugin.isType(90, qualifiedNameNode)) {
            AST node = qualifiedNameNode.getFirstChild();
            StringBuilder buffer = new StringBuilder();
            boolean first = true;
            while (node != null && !AntlrParserPlugin.isType(70, node)) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(".");
                }
                buffer.append(AntlrParserPlugin.qualifiedName(node));
                node = node.getNextSibling();
            }
            return buffer.toString();
        }
        return qualifiedNameNode.getText();
    }

    private int getBoundType(AST node) {
        if (node == null) {
            return -1;
        }
        if (AntlrParserPlugin.isType(75, node)) {
            return 75;
        }
        if (AntlrParserPlugin.isType(76, node)) {
            return 76;
        }
        throw new ASTRuntimeException(node, "Unexpected node type: " + this.getTokenName(node) + " found when expecting type: " + this.getTokenName(75) + " or type: " + this.getTokenName(76));
    }

    private GenericsType makeGenericsArgumentType(AST typeArgument) {
        GenericsType gt;
        AST rootNode = typeArgument.getFirstChild();
        if (AntlrParserPlugin.isType(74, rootNode)) {
            ClassNode base = ClassHelper.makeWithoutCaching("?");
            if (rootNode.getNextSibling() != null) {
                int boundType = this.getBoundType(rootNode.getNextSibling());
                ClassNode[] gts = this.makeGenericsBounds(rootNode, boundType);
                gt = boundType == 75 ? new GenericsType(base, gts, null) : new GenericsType(base, null, gts[0]);
            } else {
                gt = new GenericsType(base, null, null);
            }
            gt.setWildcard(true);
        } else {
            ClassNode argument = this.makeTypeWithArguments(rootNode);
            gt = new GenericsType(argument);
        }
        this.configureAST(gt, typeArgument);
        return gt;
    }

    protected ClassNode makeTypeWithArguments(AST rootNode) {
        ClassNode basicType = this.makeType(rootNode);
        AST node = rootNode.getFirstChild();
        if (node == null || AntlrParserPlugin.isType(24, node) || AntlrParserPlugin.isType(17, node)) {
            return basicType;
        }
        if (!AntlrParserPlugin.isType(90, node)) {
            if ((node = node.getFirstChild()) == null) {
                return basicType;
            }
            return this.addTypeArguments(basicType, node);
        }
        node = node.getFirstChild();
        while (node != null && !AntlrParserPlugin.isType(70, node)) {
            node = node.getNextSibling();
        }
        return node == null ? basicType : this.addTypeArguments(basicType, node);
    }

    private ClassNode addTypeArguments(ClassNode basicType, AST node) {
        List<GenericsType> typeArgumentList = this.getTypeArgumentsList(node);
        basicType.setGenericsTypes(typeArgumentList.toArray(GenericsType.EMPTY_ARRAY));
        return basicType;
    }

    private List<GenericsType> getTypeArgumentsList(AST node) {
        this.assertNodeType(70, node);
        ArrayList<GenericsType> typeArgumentList = new ArrayList<GenericsType>();
        AST typeArgument = node.getFirstChild();
        while (typeArgument != null) {
            this.assertNodeType(71, typeArgument);
            GenericsType gt = this.makeGenericsArgumentType(typeArgument);
            typeArgumentList.add(gt);
            typeArgument = typeArgument.getNextSibling();
        }
        return typeArgumentList;
    }

    private ClassNode[] makeGenericsBounds(AST rn, int boundType) {
        AST boundsRoot = rn.getNextSibling();
        if (boundsRoot == null) {
            return null;
        }
        this.assertNodeType(boundType, boundsRoot);
        ArrayList<ClassNode> bounds = new ArrayList<ClassNode>();
        AST boundsNode = boundsRoot.getFirstChild();
        while (boundsNode != null) {
            ClassNode bound = this.makeTypeWithArguments(boundsNode);
            bounds.add(bound);
            boundsNode = boundsNode.getNextSibling();
        }
        if (bounds.isEmpty()) {
            return null;
        }
        return bounds.toArray(ClassNode.EMPTY_ARRAY);
    }

    protected GenericsType[] makeGenericsType(AST rootNode) {
        AST typeParameter = rootNode.getFirstChild();
        ArrayList<GenericsType> generics = new ArrayList<GenericsType>();
        this.assertNodeType(73, typeParameter);
        while (AntlrParserPlugin.isType(73, typeParameter)) {
            GenericsType gt = new GenericsType(this.makeType(typeParameter), this.makeGenericsBounds(typeParameter.getFirstChild(), 75), null);
            this.configureAST(gt, typeParameter);
            generics.add(gt);
            typeParameter = typeParameter.getNextSibling();
        }
        return generics.toArray(GenericsType.EMPTY_ARRAY);
    }

    protected ClassNode makeType(AST typeNode) {
        ClassNode answer = ClassHelper.DYNAMIC_TYPE;
        AST node = typeNode.getFirstChild();
        if (node != null) {
            if (AntlrParserPlugin.isType(17, node) || AntlrParserPlugin.isType(24, node)) {
                answer = this.makeArray(this.makeTypeWithArguments(node), node);
                if (this.getController() != null) {
                    GroovySourceAST root = (GroovySourceAST)node;
                    int start = this.locations.findOffset(root.getLine(), root.getColumn());
                    int until = this.locations.findOffset(root.getLineLast(), root.getColumnLast());
                    char[] sourceChars = this.getController().readSourceRange(start, until - start);
                    if (sourceChars != null) {
                        int idx = sourceChars.length - 1;
                        int off = until;
                        while (idx >= 0 && Character.isWhitespace(sourceChars[idx])) {
                            --idx;
                            --off;
                        }
                        if (off < until) {
                            int[] row_col = this.locations.getRowCol(off);
                            answer.setEnd(off);
                            answer.setLastLineNumber(row_col[0]);
                            answer.setLastColumnNumber(row_col[1]);
                        }
                    }
                }
            } else {
                this.checkTypeArgs(node, false);
                answer = AntlrParserPlugin.makeClassNode(AntlrParserPlugin.qualifiedName(node));
                if (answer.isUsingGenerics()) {
                    ClassNode proxy = ClassHelper.makeWithoutCaching(answer.getName());
                    proxy.setRedirect(answer);
                    answer = proxy;
                }
                this.configureAST(answer, node);
                if (AntlrParserPlugin.isType(90, node)) {
                    GroovySourceAST type = (GroovySourceAST)node.getFirstChild().getNextSibling();
                    answer.setLastLineNumber(type.getLineLast());
                    answer.setLastColumnNumber(type.getColumnLast());
                    answer.setNameStart2(this.locations.findOffset(type.getLine(), type.getColumn()));
                    answer.setEnd(this.locations.findOffset(type.getLineLast(), type.getColumnLast()));
                }
            }
        }
        return answer;
    }

    private ClassNode makeArray(ClassNode elementType, AST node) {
        if (elementType.equals(ClassHelper.VOID_TYPE)) {
            throw new ASTRuntimeException(node.getFirstChild(), "void[] is an invalid type");
        }
        ClassNode arrayType = elementType.makeArray();
        this.configureAST(arrayType, node);
        return arrayType;
    }

    private boolean checkTypeArgs(AST node, boolean seenTypeArgs) {
        if (AntlrParserPlugin.isType(87, node) && seenTypeArgs) {
            throw new ASTRuntimeException(node, "Unexpected type arguments found prior to: " + AntlrParserPlugin.qualifiedName(node));
        }
        if (AntlrParserPlugin.isType(90, node)) {
            AST next = node.getFirstChild();
            while (next != null && !AntlrParserPlugin.isType(70, next)) {
                seenTypeArgs |= this.checkTypeArgs(next, seenTypeArgs);
                seenTypeArgs |= AntlrParserPlugin.isType(70, next.getFirstChild()) || AntlrParserPlugin.isType(70, next.getNextSibling());
                next = next.getNextSibling();
            }
        }
        return seenTypeArgs;
    }

    protected ClassNode buildName(AST node) {
        if (AntlrParserPlugin.isType(12, node)) {
            node = node.getFirstChild();
        }
        if (AntlrParserPlugin.isType(17, node) || AntlrParserPlugin.isType(24, node)) {
            return this.makeArray(this.buildName(node.getFirstChild()), node);
        }
        String name = AntlrParserPlugin.isType(90, node) || AntlrParserPlugin.isType(155, node) ? AntlrParserPlugin.qualifiedName(node) : node.getText();
        if (AntlrParserPlugin.isType(17, node.getNextSibling()) || AntlrParserPlugin.isType(24, node.getNextSibling())) {
            throw new ASTRuntimeException(node, "Unexpected '[' sibling in type name");
        }
        ClassNode answer = AntlrParserPlugin.makeClassNode(name);
        this.configureAST(answer, node);
        if (AntlrParserPlugin.isType(90, node) || AntlrParserPlugin.isType(155, node)) {
            GroovySourceAST type = (GroovySourceAST)node.getFirstChild().getNextSibling();
            answer.setLastLineNumber(type.getLineLast());
            answer.setLastColumnNumber(type.getColumnLast());
            answer.setNameStart2(this.locations.findOffset(type.getLine(), type.getColumn()));
            answer.setEnd(this.locations.findOffset(type.getLineLast(), type.getColumnLast()));
        }
        return answer;
    }

    protected boolean isPrimitiveTypeLiteral(AST node) {
        switch (node.getType()) {
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                return true;
            }
        }
        return false;
    }

    protected String identifier(AST node) {
        this.assertNodeType(87, node);
        return node.getText();
    }

    protected String label(AST labelNode) {
        AST node = labelNode.getFirstChild();
        if (node == null) {
            return null;
        }
        return this.identifier(node);
    }

    protected boolean hasVisibility(int modifiers) {
        return (modifiers & 7) != 0;
    }

    protected void configureAST(ASTNode node, AST ast) {
        if (ast == null) {
            throw new ASTRuntimeException(ast, "PARSER BUG: Tried to configure " + node.getClass().getName() + " with null AST");
        }
        int offset = this.locations.findOffset(ast.getLine(), ast.getColumn());
        if (ast instanceof GroovySourceAST) {
            int last_row = ((GroovySourceAST)ast).getLineLast();
            int last_col = ((GroovySourceAST)ast).getColumnLast();
            int end_offset = this.locations.findOffset(last_row, last_col);
            if ((node instanceof VariableExpression || node instanceof ConstantExpression && ast.getType() == 28) && node.getEnd() > 0 && offset <= node.getStart() && node.getEnd() <= end_offset) {
                node.putNodeMetaData("source.offsets", (long)offset << 32 | (long)end_offset);
                return;
            }
            node.setLastColumnNumber(last_col);
            node.setLastLineNumber(last_row);
            node.setEnd(end_offset);
        }
        node.setColumnNumber(ast.getColumn());
        node.setLineNumber(ast.getLine());
        node.setStart(offset);
    }

    protected void configureAST(AnnotatedNode node, AST ast, AST name0, AST name1) {
        this.configureAST(node, ast);
        node.setNameStart(this.locations.findOffset(name0.getLine(), name0.getColumn()));
        GroovySourceAST nameStop = (GroovySourceAST)(name1 == null ? name0 : name1);
        node.setNameEnd(this.locations.findOffset(nameStop.getLineLast(), nameStop.getColumnLast()) - 1);
    }

    protected void setSourceStart(ASTNode node, ASTNode first) {
        Long offsets = (Long)first.getNodeMetaData("source.offsets");
        if (offsets != null) {
            int offset = (int)(offsets >> 32);
            int[] row_col = this.locations.getRowCol(offset);
            node.setStart(offset);
            node.setLineNumber(row_col[0]);
            node.setColumnNumber(row_col[1]);
        } else {
            node.setStart(first.getStart());
            node.setLineNumber(first.getLineNumber());
            node.setColumnNumber(first.getColumnNumber());
        }
    }

    protected void setSourceEnd(ASTNode node, ASTNode last) {
        Long offsets = (Long)last.getNodeMetaData("source.offsets");
        if (offsets != null) {
            int offset = (int)(offsets & 0xFFFFFFFFFFFFFFFFL);
            int[] row_col = this.locations.getRowCol(offset);
            node.setEnd(offset);
            node.setLastLineNumber(row_col[0]);
            node.setLastColumnNumber(row_col[1]);
        } else {
            node.setEnd(last.getEnd());
            node.setLastLineNumber(last.getLastLineNumber());
            node.setLastColumnNumber(last.getLastColumnNumber());
        }
    }

    protected static AnnotationNode makeAnnotationNode(Class<? extends Annotation> type) {
        AnnotationNode node = new AnnotationNode(ClassHelper.make(type));
        node.getClassNode().setStart(-1);
        node.getClassNode().setEnd(-2);
        node.setStart(-1);
        node.setEnd(-1);
        return node;
    }

    protected static ClassNode makeClassNode(String name) {
        ClassNode node = ClassHelper.make(name);
        if (node instanceof ImmutableClassNode && !ClassHelper.isPrimitiveType(node)) {
            ClassNode wrapper = ClassHelper.makeWithoutCaching(name);
            wrapper.setRedirect(node);
            node = wrapper;
        }
        return node;
    }

    protected static Token makeToken(int typeCode, AST node) {
        return Token.newSymbol((int)typeCode, (int)node.getLine(), (int)node.getColumn());
    }

    protected String getFirstChildText(AST node) {
        AST child = node.getFirstChild();
        return child != null ? child.getText() : null;
    }

    public static boolean isType(int typeCode, AST node) {
        return node != null && node.getType() == typeCode;
    }

    private String getTokenName(int token) {
        if (this.tokenNames == null) {
            return "" + token;
        }
        return this.tokenNames[token];
    }

    private String getTokenName(AST node) {
        if (node == null) {
            return "null";
        }
        return this.getTokenName(node.getType());
    }

    protected void assertNodeType(int type, AST node) {
        if (node == null) {
            throw new ASTRuntimeException(node, "No child node available in AST when expecting type: " + this.getTokenName(type));
        }
        if (node.getType() != type) {
            throw new ASTRuntimeException(node, "Unexpected node type: " + this.getTokenName(node) + " found when expecting type: " + this.getTokenName(type));
        }
    }

    protected void notImplementedYet(AST node) {
        throw new ASTRuntimeException(node, "AST node not implemented yet for type: " + this.getTokenName(node));
    }

    protected void unknownAST(AST node) {
        if (node.getType() == 13) {
            throw new ASTRuntimeException(node, "Class definition not expected here. Please define the class at an appropriate place or perhaps try using a block/Closure instead.");
        }
        if (node.getType() == 8) {
            throw new ASTRuntimeException(node, "Method definition not expected here. Please define the method at an appropriate place or perhaps try using a block/Closure instead.");
        }
        throw new ASTRuntimeException(node, "Unknown type: " + this.getTokenName(node));
    }

    protected void dumpTree(AST ast) {
        AST node = ast.getFirstChild();
        while (node != null) {
            this.dump(node);
            node = node.getNextSibling();
        }
    }

    protected void dump(AST node) {
        System.out.println("Type: " + this.getTokenName(node) + " text: " + node.getText());
    }

    private static class AnonymousInnerClassCarrier
    extends Expression {
        ClassNode innerClass;

        private AnonymousInnerClassCarrier() {
        }

        public Expression transformExpression(ExpressionTransformer transformer) {
            return null;
        }

        public void setSourcePosition(ASTNode node) {
            super.setSourcePosition(node);
            this.innerClass.setSourcePosition(node);
        }

        public void setColumnNumber(int columnNumber) {
            super.setColumnNumber(columnNumber);
            this.innerClass.setColumnNumber(columnNumber);
        }

        public void setLineNumber(int lineNumber) {
            super.setLineNumber(lineNumber);
            this.innerClass.setLineNumber(lineNumber);
        }

        public void setLastColumnNumber(int columnNumber) {
            super.setLastColumnNumber(columnNumber);
            this.innerClass.setLastColumnNumber(columnNumber);
        }

        public void setLastLineNumber(int lineNumber) {
            super.setLastLineNumber(lineNumber);
            this.innerClass.setLastLineNumber(lineNumber);
        }
    }
}

