/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.NodeMetaDataHandler;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class CompileUnit
implements NodeMetaDataHandler {
    private final List<ModuleNode> modules = new ArrayList<ModuleNode>();
    private final Map<String, ClassNode> classes = new LinkedHashMap<String, ClassNode>();
    private List<ClassNode> sortedClasses;
    private final CompilerConfiguration config;
    private final GroovyClassLoader classLoader;
    private final CodeSource codeSource;
    private final Map<String, ClassNode> classesToCompile = new LinkedHashMap<String, ClassNode>();
    private final Map<String, SourceUnit> classNameToSource = new LinkedHashMap<String, SourceUnit>();
    private final Map<String, InnerClassNode> generatedInnerClasses = new LinkedHashMap<String, InnerClassNode>();
    private Map metaDataMap;

    public void setSortedClasses(List<ClassNode> sortedClasses) {
        this.sortedClasses = sortedClasses;
    }

    public List<ClassNode> getSortedClasses() {
        return this.sortedClasses == null ? null : Collections.unmodifiableList(this.sortedClasses);
    }

    public CompileUnit(GroovyClassLoader classLoader, CompilerConfiguration config) {
        this(classLoader, null, config);
    }

    public CompileUnit(GroovyClassLoader classLoader, CodeSource codeSource, CompilerConfiguration config) {
        this.classLoader = classLoader;
        this.codeSource = codeSource;
        this.config = config;
    }

    public List<ModuleNode> getModules() {
        return this.modules;
    }

    public void addModule(ModuleNode node) {
        if (node == null) {
            return;
        }
        this.modules.add(node);
        node.setUnit(this);
        this.addClasses(node.getClasses());
    }

    public ClassNode getClass(String name) {
        ClassNode cn = this.classes.get(name);
        if (cn != null) {
            return cn;
        }
        return this.classesToCompile.get(name);
    }

    public List<ClassNode> getClasses() {
        ArrayList<ClassNode> answer = new ArrayList<ClassNode>();
        for (ModuleNode module : this.modules) {
            answer.addAll(module.getClasses());
        }
        return answer;
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public GroovyClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    void addClasses(List<ClassNode> classList) {
        for (ClassNode node : classList) {
            this.addClass(node);
        }
    }

    public void addClass(ClassNode node) {
        String name = (node = node.redirect()).getName();
        ClassNode stored = this.classes.get(name);
        if (stored != null && stored != node) {
            SourceUnit nodeSource = node.getModule().getContext();
            SourceUnit storedSource = stored.getModule().getContext();
            String txt = "Invalid duplicate class definition of class " + node.getName() + " : ";
            if (nodeSource == storedSource) {
                txt = txt + "The source " + nodeSource.getName() + " contains at least two definitions of the class " + node.getName() + ".\n";
                if (node.isScriptBody() || stored.isScriptBody()) {
                    txt = txt + "One of the classes is an explicit generated class using the class statement, the other is a class generated from the script body based on the file name. Solutions are to change the file name or to change the class name.\n";
                }
            } else {
                txt = txt + "The sources " + nodeSource.getName() + " and " + storedSource.getName() + " each contain a class with the name " + node.getName() + ".\n";
            }
            nodeSource.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage(new SyntaxException(txt, node.getLineNumber(), node.getColumnNumber(), node.getLastLineNumber(), node.getLastColumnNumber()), nodeSource));
        }
        this.classes.put(name, node);
        this.sortedClasses = null;
        ClassNode cn = this.classesToCompile.get(name);
        if (cn != null) {
            cn.setRedirect(node);
            this.classesToCompile.remove(name);
        }
    }

    public void addClassNodeToCompile(ClassNode node, SourceUnit location) {
        String nodeName = node.getName();
        this.classesToCompile.put(nodeName, node);
        this.classNameToSource.put(nodeName, location);
    }

    public Map<String, ClassNode> getClassesToCompile() {
        return this.classesToCompile;
    }

    public Iterator<String> iterateClassNodeToCompile() {
        return this.classesToCompile.keySet().iterator();
    }

    public boolean hasClassNodeToCompile() {
        return !this.classesToCompile.isEmpty();
    }

    public void addGeneratedInnerClass(InnerClassNode icn) {
        this.generatedInnerClasses.put(icn.getName(), icn);
    }

    public InnerClassNode getGeneratedInnerClass(String name) {
        return this.generatedInnerClasses.get(name);
    }

    public Map<String, InnerClassNode> getGeneratedInnerClasses() {
        return Collections.unmodifiableMap(this.generatedInnerClasses);
    }

    public SourceUnit getScriptSourceLocation(String scriptClassName) {
        return this.classNameToSource.get(scriptClassName);
    }

    public Map getMetaDataMap() {
        return this.metaDataMap;
    }

    public void setMetaDataMap(Map metaDataMap) {
        this.metaDataMap = metaDataMap;
    }
}

