/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.codehaus.groovy.GroovyBugError;

public interface NodeMetaDataHandler {
    default public <T> T getNodeMetaData(Object key) {
        Map<?, ?> metaDataMap = this.getMetaDataMap();
        if (metaDataMap == null) {
            return null;
        }
        return (T)metaDataMap.get(key);
    }

    default public <T> T getNodeMetaData(Object key, Function<?, ? extends T> valFn) {
        if (key == null) {
            throw new GroovyBugError("Tried to get/set meta data with null key on " + String.valueOf(this) + ".");
        }
        Map<Object, Object> metaDataMap = this.getMetaDataMap();
        if (metaDataMap == null) {
            metaDataMap = Collections.synchronizedMap(new HashMap(8));
            this.setMetaDataMap(metaDataMap);
        }
        return metaDataMap.computeIfAbsent(key, valFn);
    }

    default public void copyNodeMetaData(NodeMetaDataHandler other) {
        Map<?, ?> otherMetaDataMap = other.getMetaDataMap();
        if (otherMetaDataMap == null) {
            return;
        }
        Map<Object, Object> metaDataMap = this.getMetaDataMap();
        if (metaDataMap == null) {
            metaDataMap = Collections.synchronizedMap(new HashMap(8));
            this.setMetaDataMap(metaDataMap);
        }
        metaDataMap.putAll(otherMetaDataMap);
    }

    default public void setNodeMetaData(Object key, Object value) {
        Object old = this.putNodeMetaData(key, value);
        if (old != null) {
            throw new GroovyBugError("Tried to overwrite existing meta data " + String.valueOf(this) + ".");
        }
    }

    default public Object putNodeMetaData(Object key, Object value) {
        if (key == null) {
            throw new GroovyBugError("Tried to set meta data with null key on " + String.valueOf(this) + ".");
        }
        Map<Object, Object> metaDataMap = this.getMetaDataMap();
        if (metaDataMap == null) {
            if (value == null) {
                return null;
            }
            metaDataMap = Collections.synchronizedMap(new HashMap(8));
            this.setMetaDataMap(metaDataMap);
        } else if (value == null) {
            return metaDataMap.remove(key);
        }
        return metaDataMap.put(key, value);
    }

    default public void removeNodeMetaData(Object key) {
        if (key == null) {
            throw new GroovyBugError("Tried to remove meta data with null key " + String.valueOf(this) + ".");
        }
        Map<?, ?> metaDataMap = this.getMetaDataMap();
        if (metaDataMap == null) {
            return;
        }
        metaDataMap.remove(key);
    }

    default public Map<?, ?> getNodeMetaData() {
        Map<?, ?> metaDataMap = this.getMetaDataMap();
        if (metaDataMap == null) {
            return Collections.emptyMap();
        }
        return new HashMap(metaDataMap);
    }

    public Map<?, ?> getMetaDataMap();

    public void setMetaDataMap(Map<?, ?> var1);
}

