/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import groovy.lang.MetaMethod;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;

public class StaticMethodCallExpression
extends Expression
implements MethodCall {
    private ClassNode ownerType;
    private final String method;
    private final Expression arguments;
    private MetaMethod metaMethod = null;

    public StaticMethodCallExpression(ClassNode type, String method, Expression arguments) {
        this.ownerType = type;
        this.method = method;
        this.arguments = arguments;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitStaticMethodCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        StaticMethodCallExpression ret = new StaticMethodCallExpression(this.getOwnerType(), this.method, transformer.transform(this.arguments));
        ret.setSourcePosition((ASTNode)((Object)this));
        ret.copyNodeMetaData((ASTNode)((Object)this));
        return ret;
    }

    public ASTNode getReceiver() {
        return this.ownerType;
    }

    public String getMethodAsString() {
        return this.method;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getMethod() {
        return this.method;
    }

    public String getText() {
        return this.getOwnerType().getName() + "." + this.method + this.arguments.getText();
    }

    public String toString() {
        return super.toString() + "[" + this.getOwnerType().getName() + "#" + this.method + " arguments: " + String.valueOf(this.arguments) + "]";
    }

    public ClassNode getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(ClassNode ownerType) {
        this.ownerType = ownerType;
    }

    public void setMetaMethod(MetaMethod metaMethod) {
        this.metaMethod = metaMethod;
    }

    public MetaMethod getMetaMethod() {
        return this.metaMethod;
    }

    public void setSourcePosition(ASTNode node) {
        super.setSourcePosition(node);
        if (this.getNameEnd() < 1 && node.getEnd() > 0) {
            if (node instanceof MethodCallExpression) {
                node = ((MethodCallExpression)((Object)node)).getMethod();
            } else if (node instanceof BinaryExpression) {
                node = ((BinaryExpression)node).getLeftExpression();
            }
            this.setNameStart(node.getStart());
            this.setNameEnd((node instanceof StaticMethodCallExpression ? ((StaticMethodCallExpression)((Object)node)).getMethod().length() : node.getEnd()) - 1);
        }
    }
}

