/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

class JDTClassNodeBuilder {
    private final JDTResolver resolver;

    JDTClassNodeBuilder(JDTResolver resolver) {
        this.resolver = resolver;
    }

    protected ClassNode configureType(TypeBinding type) {
        char[][] compoundName;
        LookupEnvironment environment;
        if (type instanceof UnresolvedReferenceBinding && ((type = (environment = this.resolver.getScope().environment).getType(compoundName = ((UnresolvedReferenceBinding)type).compoundName)) == null || type instanceof ProblemReferenceBinding)) {
            throw new IllegalStateException("Unable to resolve type: " + CharOperation.toString((char[][])compoundName));
        }
        if (type instanceof BaseTypeBinding) {
            return this.configureBaseType((BaseTypeBinding)type);
        }
        if (type instanceof BinaryTypeBinding) {
            return this.configureBinaryType((BinaryTypeBinding)type);
        }
        if (type instanceof SourceTypeBinding) {
            return this.configureSourceType((SourceTypeBinding)type);
        }
        if (type instanceof ArrayBinding) {
            return this.configureGenericArray((ArrayBinding)type);
        }
        if (type instanceof WildcardBinding) {
            return this.configureWildcardType((WildcardBinding)type);
        }
        if (type instanceof TypeVariableBinding) {
            return this.configureTypeVariableReference((TypeVariableBinding)type);
        }
        if (type instanceof ParameterizedTypeBinding) {
            return this.configureParameterizedType((ParameterizedTypeBinding)type);
        }
        throw new IllegalStateException("'type' was null or an unhandled type: " + (type == null ? "null" : type.getClass().getName()));
    }

    protected ClassNode[] configureTypes(TypeBinding[] bindings) {
        int n;
        if (bindings == null || (n = bindings.length) == 0) {
            return null;
        }
        ClassNode[] nodes = new ClassNode[n];
        int i = 0;
        while (i < n) {
            nodes[i] = this.configureType(bindings[i]);
            ++i;
        }
        return nodes;
    }

    protected GenericsType[] configureTypeArguments(TypeBinding[] bindings) {
        int n;
        if (bindings == null || (n = bindings.length) == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[n];
        int i = 0;
        while (i < n) {
            ClassNode t = this.configureType(bindings[i]);
            gts[i] = bindings[i] instanceof WildcardBinding ? t.getGenericsTypes()[0] : new GenericsType(t);
            ++i;
        }
        return gts;
    }

    protected GenericsType[] configureTypeVariables(TypeVariableBinding[] bindings) {
        int n;
        if (bindings == null || (n = bindings.length) == 0) {
            return null;
        }
        GenericsType[] gts = new GenericsType[n];
        int i = 0;
        while (i < n) {
            gts[i] = this.configureTypeVariableDefinition(bindings[i]);
            ++i;
        }
        return gts;
    }

    private ClassNode configureGenericArray(ArrayBinding genericArrayType) {
        ClassNode node;
        TypeBinding component = genericArrayType.leafComponentType;
        ClassNode result = node = this.resolver.convertToClassNode(component);
        int n = genericArrayType.dimensions;
        while (n > 0) {
            result = result.makeArray();
            --n;
        }
        return result;
    }

    private ClassNode configureTypeVariableReference(TypeVariableBinding tv) {
        String name = String.valueOf(tv.sourceName);
        if (name.indexOf(64) >= 0) {
            throw new IllegalStateException("Invalid type variable name: " + name);
        }
        ClassNode cn = ClassHelper.makeWithoutCaching((String)name);
        cn.setGenericsPlaceHolder(true);
        if (tv.enterRecursiveFunction()) {
            ClassNode cn2 = ClassHelper.makeWithoutCaching((String)name);
            cn2.setGenericsPlaceHolder(true);
            cn.setGenericsTypes(new GenericsType[]{new GenericsType(cn2)});
            if (tv.firstBound != null && tv.firstBound.id != 1) {
                JDTClassNodeBuilder.setRedirect(cn, this.configureType(tv.firstBound));
            } else {
                cn.setRedirect(ClassHelper.OBJECT_TYPE);
            }
            tv.exitRecursiveFunction();
        }
        return cn;
    }

    private GenericsType configureTypeVariableDefinition(TypeVariableBinding tv) {
        GenericsType gt;
        ClassNode cn = this.configureTypeVariableReference(tv);
        ClassNode redirect = JDTClassNodeBuilder.removeRedirect(cn);
        TypeBinding[] tBounds = JDTClassNodeBuilder.getBounds(tv);
        if (tBounds.length == 0) {
            gt = new GenericsType(cn);
        } else {
            tv.enterRecursiveFunction();
            gt = new GenericsType(cn, this.configureTypes(tBounds), null);
            tv.exitRecursiveFunction();
            gt.setName(cn.getName());
            gt.setPlaceholder(true);
        }
        JDTClassNodeBuilder.setRedirect(cn, redirect);
        return gt;
    }

    private ClassNode configureWildcardType(WildcardBinding wildcard) {
        ClassNode base = ClassHelper.makeWithoutCaching((String)"?");
        base.setRedirect(ClassHelper.OBJECT_TYPE);
        ClassNode[] uppers = this.configureTypes(JDTClassNodeBuilder.getUpperBounds(wildcard));
        ClassNode[] lowers = this.configureTypes(JDTClassNodeBuilder.getLowerBounds(wildcard));
        GenericsType gt = new GenericsType(base, uppers, lowers != null && lowers.length > 0 ? lowers[0] : null);
        gt.setWildcard(true);
        ClassNode cn = ClassHelper.makeWithoutCaching(Object.class, (boolean)false);
        cn.setGenericsTypes(new GenericsType[]{gt});
        return cn;
    }

    private ClassNode configureParameterizedType(ParameterizedTypeBinding tb) {
        GenericsType[] gts;
        if (tb instanceof RawTypeBinding) {
            JDTClassNode cn = new JDTClassNode((ReferenceBinding)tb, this.resolver);
            JDTClassNodeBuilder.setRedirect(cn, this.configureType((TypeBinding)tb.genericType()));
            return cn;
        }
        TypeBinding rt = JDTClassNodeBuilder.toRawType((TypeBinding)tb);
        if (rt instanceof ParameterizedTypeBinding && !(rt instanceof RawTypeBinding)) {
            return new JDTClassNode((ReferenceBinding)((ParameterizedTypeBinding)rt), this.resolver);
        }
        ClassNode cn = this.configureType(rt);
        if (cn instanceof JDTClassNode) {
            ((JDTClassNode)cn).setJdtBinding((ReferenceBinding)tb);
            JDTClassNodeBuilder.setRedirect(cn, this.configureType((TypeBinding)tb.genericType()));
        }
        if ((gts = this.configureTypeArguments(tb.arguments)) != null && cn.isRedirectNode()) {
            int i = 0;
            int n = gts.length;
            while (i < n) {
                if (gts[i].isWildcard() && gts[i].getUpperBounds() == null && tb.genericType().typeVariables()[i].enterRecursiveFunction()) {
                    ClassNode[] implicitBounds = cn.redirect().getGenericsTypes()[i].getUpperBounds();
                    if (implicitBounds != null && !ClassHelper.OBJECT_TYPE.equals((Object)implicitBounds[0])) {
                        gts[i].getType().setRedirect(implicitBounds[0]);
                    }
                    tb.genericType().typeVariables()[i].exitRecursiveFunction();
                }
                ++i;
            }
        }
        cn.setGenericsTypes(gts);
        return cn;
    }

    private ClassNode configureBaseType(BaseTypeBinding tb) {
        switch (tb.id) {
            case 5: {
                return ClassHelper.boolean_TYPE;
            }
            case 3: {
                return ClassHelper.byte_TYPE;
            }
            case 2: {
                return ClassHelper.char_TYPE;
            }
            case 8: {
                return ClassHelper.double_TYPE;
            }
            case 9: {
                return ClassHelper.float_TYPE;
            }
            case 10: {
                return ClassHelper.int_TYPE;
            }
            case 7: {
                return ClassHelper.long_TYPE;
            }
            case 4: {
                return ClassHelper.short_TYPE;
            }
            case 6: {
                return ClassHelper.VOID_TYPE;
            }
            case 12: {
                return ClassHelper.OBJECT_TYPE;
            }
        }
        throw new GroovyEclipseBug("Unexpected BaseTypeBinding: " + String.valueOf(tb) + "(type.id=" + tb.id + ")");
    }

    private ClassNode configureBinaryType(BinaryTypeBinding tb) {
        switch (tb.id) {
            case 33: {
                return ClassHelper.Boolean_TYPE;
            }
            case 26: {
                return ClassHelper.Byte_TYPE;
            }
            case 28: {
                return ClassHelper.Character_TYPE;
            }
            case 32: {
                return ClassHelper.Double_TYPE;
            }
            case 31: {
                return ClassHelper.Float_TYPE;
            }
            case 29: {
                return ClassHelper.Integer_TYPE;
            }
            case 30: {
                return ClassHelper.Long_TYPE;
            }
            case 27: {
                return ClassHelper.Short_TYPE;
            }
            case 34: {
                return ClassHelper.void_WRAPPER_TYPE;
            }
            case 1: {
                return ClassHelper.OBJECT_TYPE;
            }
            case 11: {
                return ClassHelper.STRING_TYPE;
            }
        }
        return new JDTClassNode((ReferenceBinding)tb, this.resolver);
    }

    private ClassNode configureSourceType(SourceTypeBinding tb) {
        return new JDTClassNode((ReferenceBinding)tb, this.resolver);
    }

    private static TypeBinding[] getLowerBounds(WildcardBinding wildcard) {
        if (wildcard.boundKind == 2) {
            return new TypeBinding[]{wildcard.bound};
        }
        return Binding.NO_TYPES;
    }

    private static TypeBinding[] getUpperBounds(WildcardBinding wildcard) {
        if (wildcard.boundKind == 1) {
            int nBounds = wildcard.otherBounds == null ? 1 : 1 + wildcard.otherBounds.length;
            TypeBinding[] bounds = new TypeBinding[nBounds];
            bounds[0] = wildcard.bound;
            if (--nBounds > 0) {
                System.arraycopy(wildcard.otherBounds, 0, bounds, 1, nBounds);
            }
            return bounds;
        }
        return Binding.NO_TYPES;
    }

    private static TypeBinding[] getBounds(TypeVariableBinding tv) {
        if (tv.firstBound == null) {
            return new TypeBinding[]{tv.erasure()};
        }
        TypeBinding[] others = tv.otherUpperBounds();
        TypeBinding[] bounds = new TypeBinding[1 + others.length];
        System.arraycopy(others, 0, bounds, 1, others.length);
        bounds[0] = tv.firstBound;
        return bounds;
    }

    private static TypeBinding toRawType(TypeBinding tb) {
        if (tb instanceof RawTypeBinding || tb instanceof BaseTypeBinding || tb instanceof ProblemReferenceBinding) {
            return tb;
        }
        if (tb instanceof ParameterizedTypeBinding) {
            LookupEnvironment environment = ((ParameterizedTypeBinding)tb).environment();
            return environment.convertToRawType((TypeBinding)((ParameterizedTypeBinding)tb).genericType(), false);
        }
        if (tb instanceof ArrayBinding) {
            LookupEnvironment environment = ((ArrayBinding)tb).environment();
            return environment.convertToRawType(tb, false);
        }
        if (tb instanceof BinaryTypeBinding || tb instanceof SourceTypeBinding) {
            if (tb.isGenericType()) {
                Class cl = tb instanceof BinaryTypeBinding ? BinaryTypeBinding.class : SourceTypeBinding.class;
                LookupEnvironment environment = (LookupEnvironment)ReflectionUtils.getPrivateField(cl, "environment", tb);
                return environment.convertToRawType(tb, false);
            }
            return tb;
        }
        throw new IllegalStateException("nyi " + String.valueOf(tb.getClass()));
    }

    static ClassNode removeRedirect(ClassNode node) {
        ClassNode redirect = (ClassNode)ReflectionUtils.getPrivateField(ClassNode.class, "redirect", node);
        node.setRedirect(null);
        return redirect;
    }

    static void setRedirect(ClassNode node, ClassNode redirect) {
        if (node.isPrimaryClassNode()) {
            throw new GroovyEclipseBug("Tried to set a redirect for a primary ClassNode (" + node.getName() + "->" + redirect.getName() + ")");
        }
        if (node != redirect) {
            ReflectionUtils.setPrivateField(ClassNode.class, "redirect", node, redirect);
            if (node instanceof JDTClassNode) {
                ReflectionUtils.setPrivateField(JDTClassNode.class, "bits", node, 65535);
            }
        }
    }
}

