/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ModuleNodeMapper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.core.AbstractClassFile;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.Disassembler;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyClassFileWorkingCopy
extends GroovyCompilationUnit {
    public final ClassFile classFile;
    private ModuleNode moduleNode;
    private ModuleNodeMapper.ModuleNodeInfo moduleNodeInfo;
    private final JavaModelManager.PerWorkingCopyInfo copyInfo;
    private CompilationUnitElementInfo elementInfo;

    public GroovyClassFileWorkingCopy(ClassFile classFile, WorkingCopyOwner owner) {
        super((PackageFragment)classFile.getParent(), GroovyClassFileWorkingCopy.sourceFileName((AbstractClassFile)classFile), owner);
        this.classFile = classFile;
        if (this.owner == null) {
            this.owner = DefaultWorkingCopyOwner.PRIMARY;
        }
        this.copyInfo = new JavaModelManager.PerWorkingCopyInfo((CompilationUnit)this, null);
    }

    private static String sourceFileName(AbstractClassFile classFile) {
        if (classFile instanceof ModularClassFile) {
            return "module-info.java";
        }
        return ((BinaryType)((ClassFile)classFile).getType()).getSourceFileName(null);
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(967, (IJavaElement)this));
    }

    public IBuffer getBuffer() throws JavaModelException {
        return this.classFile.getBuffer();
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            if (buffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] characters = buffer.getCharacters();
            if (characters == null) {
                return CharOperation.NO_CHAR;
            }
            return characters;
        }
        catch (JavaModelException e) {
            return CharOperation.NO_CHAR;
        }
    }

    public char[] getFileName() {
        return this.name.toCharArray();
    }

    public IPath getPath() {
        return this.classFile.getPath();
    }

    public JavaElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new ClassFileWorkingCopy((AbstractClassFile)this.classFile, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public IResource resource(PackageFragmentRoot root) {
        if (root.isArchive()) {
            return root.resource(root);
        }
        return this.classFile.resource(root);
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer buffer = BufferManager.createBuffer((IOpenable)this);
        IBuffer classFileBuffer = this.classFile.getBuffer();
        if (classFileBuffer != null) {
            buffer.setContents(classFileBuffer.getCharacters());
        } else {
            IClassFileReader reader = ToolFactory.createDefaultClassFileReader((IClassFile)this.classFile, (int)65535);
            Disassembler disassembler = new Disassembler();
            String contents = disassembler.disassemble(reader, Util.getLineSeparator((String)"", (IJavaProject)this.getJavaProject()), 16);
            buffer.setContents(contents);
        }
        BufferManager bufManager = this.getBufferManager();
        ReflectionUtils.executePrivateMethod(BufferManager.class, "addBuffer", new Class[]{IBuffer.class}, bufManager, new Object[]{buffer});
        buffer.addBufferChangedListener((IBufferChangedListener)this);
        return buffer;
    }

    protected IBuffer openBuffer(IProgressMonitor pm, IElementInfo info) throws JavaModelException {
        return this.openBuffer(pm, (Object)info);
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.classFile.getElementName());
    }

    protected void toStringName(StringBuilder buffer) {
        buffer.append(this.classFile.getElementName());
    }

    @Override
    public ModuleNode getModuleNode() {
        this.getPerWorkingCopyInfo();
        return this.moduleNode;
    }

    @Override
    public ModuleNodeMapper.ModuleNodeInfo getModuleInfo(boolean force) {
        if (this.moduleNodeInfo == null) {
            try {
                this.reconcile(true, null);
            }
            catch (JavaModelException e) {
                Util.log((Throwable)e);
            }
        }
        return this.moduleNodeInfo;
    }

    @Override
    public ModuleNodeMapper.ModuleNodeInfo getNewModuleInfo() {
        if (this.moduleNodeInfo == null) {
            try {
                this.open(null);
            }
            catch (JavaModelException e) {
                Util.log((Throwable)e);
            }
        }
        return this.moduleNodeInfo;
    }

    public JavaModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        if (this.elementInfo == null) {
            try {
                this.elementInfo = this.createElementInfo();
                this.openWhenClosed((IElementInfo)this.elementInfo, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                this.elementInfo = null;
                Util.log((Throwable)e);
            }
        }
        return this.copyInfo;
    }

    @Override
    public boolean isOnBuildPath() {
        return true;
    }

    @Override
    protected void maybeCacheModuleNode(JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo, GroovyCompilationUnitDeclaration compilationUnitDeclaration) {
        if (compilationUnitDeclaration != null) {
            this.moduleNode = compilationUnitDeclaration.getModuleNode();
            this.moduleNode.setDescription(this.name);
            this.moduleNodeInfo = new ModuleNodeMapper.ModuleNodeInfo(this.moduleNode, (JDTResolver)compilationUnitDeclaration.getCompilationUnit().getResolveVisitor());
        }
    }

    public IJavaElement convertToBinary(IJavaElement source) {
        if (source.isReadOnly()) {
            return source;
        }
        if (source.getElementType() == 5) {
            return this.classFile;
        }
        if (!(source instanceof IMember)) {
            return this.classFile;
        }
        ArrayList<IJavaElement> srcAncestors = new ArrayList<IJavaElement>(3);
        IJavaElement srcCandidate = source;
        while (srcCandidate != null && srcCandidate != this) {
            srcAncestors.add(srcCandidate);
            srcCandidate = srcCandidate.getParent();
        }
        ClassFile binCandidate = this.classFile;
        try {
            while (!srcAncestors.isEmpty()) {
                srcCandidate = (IJavaElement)srcAncestors.remove(srcAncestors.size() - 1);
                if (srcCandidate instanceof IParent) {
                    String candidateName = srcCandidate.getElementName();
                    IJavaElement[] binChildren = ((IParent)binCandidate).getChildren();
                    boolean found = false;
                    IJavaElement[] iJavaElementArray = binChildren;
                    int n = binChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement binChild = iJavaElementArray[n2];
                        if (binChild.getElementName().equals(candidateName) || binChild.getElementType() == 7 && binChild.getParent().getElementName().equals(candidateName + "$" + binChild.getElementName() + ".class")) {
                            binCandidate = binChild;
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (found) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (JavaModelException e) {
            Util.log((Throwable)e);
        }
        return binCandidate;
    }
}

