/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class GroovyNature
implements IProjectNature {
    private IProject project;
    public static final String GROOVY_NATURE = "org.eclipse.jdt.groovy.core.groovyNature";

    public static void configure(IProject project) throws CoreException {
        GroovyNature.cleanAndRebuildProject(project);
    }

    public static void deconfigure(IProject project) throws CoreException {
        GroovyNature.cleanAndRebuildProject(project);
    }

    private static void cleanAndRebuildProject(final IProject project) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        Job[] existingJob = Job.getJobManager().find((Object)project);
        if (existingJob != null && existingJob.length > 0) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob("Cleaning/Rebuilding Project: " + project.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                project.build(15, monitor);
                if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                    project.build(6, monitor);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family instanceof IProject) {
                    return project.getName().equals(((IProject)family).getName());
                }
                return super.belongsTo(family);
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    public void configure() throws CoreException {
        GroovyNature.configure(this.getProject());
    }

    public void deconfigure() throws CoreException {
        GroovyNature.deconfigure(this.getProject());
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static boolean hasGroovyNature(IProject project) {
        try {
            return project.hasNature(GROOVY_NATURE);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static List<IProject> getAllAccessibleGroovyProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> groovyProjects = new ArrayList<IProject>();
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && GroovyNature.hasGroovyNature(project)) {
                    groovyProjects.add(project);
                }
                ++n2;
            }
        }
        return groovyProjects;
    }
}

