/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.core.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.transform.ASTTransformation;

class IntersectionType
extends ClassNode {
    final List<ClassNode> types;

    IntersectionType(List<ClassNode> types) {
        super(IntersectionType.makeName(types), 1024, IntersectionType.findSuper(types), IntersectionType.findFaces(types), MixinNode.EMPTY_ARRAY);
        this.types = types;
    }

    private static String makeName(List<ClassNode> types) {
        StringJoiner sj = new StringJoiner(" | ", "(", ")");
        for (ClassNode t : types) {
            sj.add(t.toString(false));
        }
        return sj.toString();
    }

    private static ClassNode findSuper(List<ClassNode> types) {
        ClassNode upper = WideningCategories.lowestUpperBound(types);
        if (upper instanceof WideningCategories.LowestUpperBoundClassNode) {
            upper = upper.getUnresolvedSuperClass();
        } else if (upper.isInterface()) {
            upper = ClassHelper.OBJECT_TYPE;
        }
        return upper;
    }

    private static ClassNode[] findFaces(List<ClassNode> types) {
        ClassNode upper = WideningCategories.lowestUpperBound(types);
        if (upper.isInterface()) {
            return new ClassNode[]{upper};
        }
        return Optional.ofNullable(upper.getUnresolvedInterfaces(false)).orElse(ClassNode.EMPTY_ARRAY);
    }

    public void lazyClassInit() {
    }

    public String getPackageName() {
        return null;
    }

    public boolean hasPackageName() {
        return false;
    }

    public String getNameWithoutPackage() {
        return this.types.stream().map(ClassNode::getNameWithoutPackage).collect(Collectors.joining(" | ", "(", ")"));
    }

    public ClassNode getPlainNodeReference() {
        throw new UnsupportedOperationException();
    }

    public ClassNode getPlainNodeReference(boolean b) {
        throw new UnsupportedOperationException();
    }

    public List<FieldNode> getFields() {
        return Collections.emptyList();
    }

    public List<MethodNode> getMethods() {
        return Collections.emptyList();
    }

    public List<PropertyNode> getProperties() {
        return Collections.emptyList();
    }

    public List<ConstructorNode> getDeclaredConstructors() {
        return Collections.emptyList();
    }

    public List<Statement> getObjectInitializerStatements() {
        return Collections.emptyList();
    }

    public void setColumnNumber(int n) {
        throw new UnsupportedOperationException();
    }

    public void setLastColumnNumber(int n) {
        throw new UnsupportedOperationException();
    }

    public void setLastLineNumber(int n) {
        throw new UnsupportedOperationException();
    }

    public void setLineNumber(int n) {
        throw new UnsupportedOperationException();
    }

    public Object putNodeMetaData(Object k, Object v) {
        throw new UnsupportedOperationException();
    }

    public void setSourcePosition(ASTNode n) {
        throw new UnsupportedOperationException();
    }

    public void setStart(int i) {
        throw new UnsupportedOperationException();
    }

    public void setEnd(int i) {
        throw new UnsupportedOperationException();
    }

    public void setNameStart(int i) {
        throw new UnsupportedOperationException();
    }

    public void setNameEnd(int i) {
        throw new UnsupportedOperationException();
    }

    public void setDeclaringClass(ClassNode cn) {
        throw new UnsupportedOperationException();
    }

    public void setHasNoRealSourcePosition(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setSynthetic(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setAnnotated(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setEnclosingMethod(MethodNode mn) {
        throw new UnsupportedOperationException();
    }

    public void setGenericsPlaceHolder(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setGenericsTypes(GenericsType[] gt) {
        throw new UnsupportedOperationException();
    }

    public void setHasInconsistentHierarchy(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setInterfaces(ClassNode[] cn) {
        if (this.getUnresolvedInterfaces(false) == null) {
            super.setInterfaces(cn);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void setMixins(MixinNode[] mn) {
        if (this.getMixins() == null) {
            super.setMixins(mn);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void setModifiers(int bf) {
        throw new UnsupportedOperationException();
    }

    public void setModule(ModuleNode mn) {
        throw new UnsupportedOperationException();
    }

    public String setName(String s) {
        throw new UnsupportedOperationException();
    }

    public void setNameStart2(int i) {
        throw new UnsupportedOperationException();
    }

    public void setPermittedSubclasses(List<ClassNode> ps) {
        throw new UnsupportedOperationException();
    }

    public void setSuperClass(ClassNode cn) {
        if (this.getUnresolvedSuperClass(false) == null) {
            super.setSuperClass(cn);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void setScript(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setScriptBody(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setStaticClass(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setSyntheticPublic(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setUnresolvedSuperClass(ClassNode cn) {
        throw new UnsupportedOperationException();
    }

    public void setUsingGenerics(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void addAnnotation(AnnotationNode node) {
        throw new UnsupportedOperationException();
    }

    public void addConstructor(ConstructorNode node) {
        throw new UnsupportedOperationException();
    }

    public void addField(FieldNode node) {
        throw new UnsupportedOperationException();
    }

    public void addFieldFirst(FieldNode node) {
        throw new UnsupportedOperationException();
    }

    public void addMethod(MethodNode node) {
        throw new UnsupportedOperationException();
    }

    public void addMixin(MixinNode node) {
        throw new UnsupportedOperationException();
    }

    public void addProperty(PropertyNode node) {
        throw new UnsupportedOperationException();
    }

    public void addStaticInitializerStatements(List<Statement> list, boolean init) {
        throw new UnsupportedOperationException();
    }

    public void addTransform(Class<? extends ASTTransformation> cls, ASTNode node) {
        throw new UnsupportedOperationException();
    }

    public void addTypeAnnotations(List<AnnotationNode> list) {
        throw new UnsupportedOperationException();
    }

    public void removeConstructor(ConstructorNode node) {
        throw new UnsupportedOperationException();
    }

    public void removeMethod(MethodNode node) {
        throw new UnsupportedOperationException();
    }

    public void removeField(String name) {
        throw new UnsupportedOperationException();
    }

    public void renameField(String oldName, String newName) {
        throw new UnsupportedOperationException();
    }
}

