/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.util.Util;

public class GenericsMapper {
    final Deque<Map<String, ClassNode>> allGenerics = new LinkedList<Map<String, ClassNode>>();

    public static GenericsMapper gatherGenerics(ClassNode resolvedType) {
        return GenericsMapper.gatherGenerics(resolvedType, resolvedType);
    }

    public static GenericsMapper gatherGenerics(ClassNode resolvedType, ClassNode declaringType) {
        if (resolvedType.isArray() && declaringType.isArray()) {
            return GenericsMapper.gatherGenerics(resolvedType.getComponentType(), declaringType.getComponentType());
        }
        GenericsMapper mapper = new GenericsMapper();
        if (declaringType.isGenericsPlaceHolder()) {
            TreeMap<String, ClassNode> resolved = new TreeMap<String, ClassNode>();
            resolved.put(declaringType.getUnresolvedName(), resolvedType);
            mapper.allGenerics.add(resolved);
            return mapper;
        }
        ClassNode rCandidate = resolvedType;
        ClassNode uCandidate = resolvedType.redirect();
        Iterator<ClassNode> rIterator = GenericsMapper.getTypeHierarchy(rCandidate, true);
        Iterator<ClassNode> uIterator = GenericsMapper.getTypeHierarchy(uCandidate, false);
        while (rIterator.hasNext() && uIterator.hasNext()) {
            int i;
            GenericsMapper gm;
            rCandidate = rIterator.next();
            uCandidate = uIterator.next();
            TreeMap<String, ClassNode> resolved = null;
            ClassNode oc = (ClassNode)rCandidate.getNodeMetaData((Object)"outer.class");
            if (oc != null && (gm = GenericsMapper.gatherGenerics(oc)).hasGenerics()) {
                resolved = gm.allGenerics.getLast();
            }
            GenericsType[] rgts = GroovyUtils.getGenericsTypes(rCandidate);
            GenericsType[] ugts = GroovyUtils.getGenericsTypes(uCandidate);
            int n = ugts.length;
            if (n > 0 && rgts.length == 0) {
                rgts = new GenericsType[n];
                i = 0;
                while (i < n) {
                    rgts[i] = new GenericsType(Optional.ofNullable(ugts[i].getUpperBounds()).map(bounds -> bounds[0]).orElse(ugts[i].getType().redirect()).getPlainNodeReference());
                    ++i;
                }
            }
            assert (rgts.length == ugts.length);
            if (resolved == null) {
                resolved = n > 0 ? new TreeMap<String, ClassNode>() : Collections.emptyMap();
            }
            i = 0;
            while (i < n) {
                resolved.put(ugts[i].getName(), mapper.resolveParameter(rgts[i], 0));
                ++i;
            }
            mapper.allGenerics.add(resolved);
            if (rCandidate.getName().equals(declaringType.getName())) break;
        }
        return mapper;
    }

    public static GenericsMapper gatherGenerics(List<ClassNode> argumentTypes, ClassNode delegateOrThisType, MethodNode methodDeclaration, GenericsType ... methodGenerics) {
        GenericsMapper mapper;
        block4: {
            int n;
            Map<Object, Object> resolved;
            GenericsType[] ugts;
            block5: {
                mapper = methodDeclaration.isStatic() ? new GenericsMapper() : GenericsMapper.gatherGenerics(delegateOrThisType, methodDeclaration.getDeclaringClass());
                ugts = GroovyUtils.getGenericsTypes(methodDeclaration);
                if (ugts.length <= 0) break block4;
                if (mapper.allGenerics.isEmpty() || (resolved = mapper.allGenerics.removeLast()).isEmpty()) {
                    resolved = new TreeMap();
                }
                mapper.allGenerics.add(resolved);
                GenericsType[] genericsTypeArray = ugts;
                n = ugts.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericsType ugt = genericsTypeArray[n2];
                    resolved.remove(ugt.getName());
                    ++n2;
                }
                if (methodGenerics == null || methodGenerics.length <= 0) break block5;
                int i = 0;
                int n3 = Math.min(ugts.length, methodGenerics.length);
                while (i < n3) {
                    resolved.put(ugts[i].getName(), methodGenerics[i].getType());
                    ++i;
                }
                break block4;
            }
            if (argumentTypes == null || argumentTypes.isEmpty()) break block4;
            Parameter[] parameters = methodDeclaration.getParameters();
            GenericsType[] genericsTypeArray = ugts;
            int n4 = ugts.length;
            n = 0;
            while (n < n4) {
                GenericsType ugt = genericsTypeArray[n];
                GenericsMapper.tryResolveMethodT(ugt, resolved, parameters, argumentTypes);
                ++n;
            }
        }
        return mapper;
    }

    public ClassNode resolveParameter(GenericsType topGT, int depth) {
        assert (depth >= 0);
        if (this.allGenerics.isEmpty()) {
            if (!topGT.isWildcard()) {
                return topGT.getType();
            }
            if (topGT.getLowerBound() != null) {
                return topGT.getLowerBound();
            }
            if (topGT.getUpperBounds() != null) {
                return topGT.getUpperBounds()[0];
            }
            if (!topGT.getType().equals((Object)VariableScope.OBJECT_CLASS_NODE)) {
                return topGT.getType();
            }
            ClassNode t = VariableScope.OBJECT_CLASS_NODE.getPlainNodeReference();
            t.putNodeMetaData((Object)"?", (Object)Boolean.TRUE);
            return t;
        }
        if (depth > 10) {
            Util.log((IStatus)new Status(2, "org.eclipse.jdt.groovy.core", "GRECLIPSE-1040: prevent infinite recursion when resolving type parameters on generics type: " + String.valueOf(topGT)));
            return topGT.getType();
        }
        ClassNode theType = this.allGenerics.getLast().getOrDefault(topGT.getName(), topGT.getType());
        if (theType.redirect().isUsingGenerics()) {
            GenericsType[] genericsTypes = (theType = VariableScope.clone(theType)).getGenericsTypes();
            if (genericsTypes == null) {
                genericsTypes = GenericsType.EMPTY_ARRAY;
            }
            GenericsType[] genericsTypeArray = genericsTypes;
            int n = genericsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType genericsType = genericsTypeArray[n2];
                if (!genericsType.getName().equals(topGT.getName())) {
                    genericsType.setType(this.allGenerics.getLast().getOrDefault(genericsType.getName(), this.resolveParameter(genericsType, depth + 1)));
                    genericsType.setName(genericsType.getType().getName());
                    genericsType.setUpperBounds(null);
                    genericsType.setLowerBound(null);
                }
                ++n2;
            }
            ClassNode oc = theType.getOuterClass();
            if (oc != null && oc.getGenericsTypes() != null && !Flags.isStatic((int)theType.getModifiers())) {
                oc = this.resolveParameter(new GenericsType(oc), depth + 1);
                theType.putNodeMetaData((Object)"outer.class", (Object)oc);
            }
        }
        return theType;
    }

    protected boolean hasGenerics() {
        return !this.allGenerics.isEmpty() && !this.allGenerics.getLast().isEmpty();
    }

    protected ClassNode findParameter(String parameterName, ClassNode defaultType) {
        ClassNode type;
        if (!this.allGenerics.isEmpty() && (type = this.allGenerics.getLast().get(parameterName)) != null) {
            return type;
        }
        return defaultType;
    }

    protected static Iterator<ClassNode> getTypeHierarchy(ClassNode type, boolean useResolved) {
        LinkedHashSet<ClassNode> hierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(type, hierarchy, useResolved);
        hierarchy.remove(VariableScope.OBJECT_CLASS_NODE);
        hierarchy.removeIf(cn -> cn.isInterface() && cn.redirect().getGenericsTypes() == null);
        return hierarchy.iterator();
    }

    protected static boolean isVargs(Parameter[] parameters) {
        Parameter last;
        ClassNode type;
        return parameters.length > 0 && (type = (last = parameters[parameters.length - 1]).getType()).isArray();
    }

    protected static void readGenericsLinks(Map<String, ClassNode> map, ClassNode rt, ClassNode ut) {
        if (rt == null || ut == null || rt == ut || GroovyUtils.getBaseType(ut).getGenericsTypes() == null) {
            return;
        }
        if (ut.isGenericsPlaceHolder()) {
            map.put(ut.getUnresolvedName(), rt);
        } else if (rt.isArray() && ut.isArray()) {
            GenericsMapper.readGenericsLinks(map, rt.getComponentType(), ut.getComponentType());
        } else if (rt.equals((Object)ut) || !StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf((ClassNode)rt, (ClassNode)ut)) {
            GenericsMapper.readGenericsLinks(map, rt.getGenericsTypes(), ut.getGenericsTypes());
        } else {
            ClassNode superClass = ClassHelper.getNextSuperClass((ClassNode)ClassHelper.getWrapper((ClassNode)rt), (ClassNode)ut);
            GenericsMapper.readGenericsLinks(map, StaticTypeCheckingSupport.getCorrectedClassNode((ClassNode)rt, (ClassNode)superClass, (boolean)true), ut);
        }
    }

    protected static void readGenericsLinks(Map<String, ClassNode> map, ClassNode[] rt, ClassNode[] ut) {
        if (rt == null || ut == null || rt.length != ut.length) {
            return;
        }
        int i = 0;
        int n = rt.length;
        while (i < n) {
            ClassNode rti = rt[i];
            ClassNode uti = ut[i];
            if (uti.isGenericsPlaceHolder()) {
                map.put(uti.getUnresolvedName(), uti);
            } else if (uti.isUsingGenerics()) {
                GenericsMapper.readGenericsLinks(map, rti.getGenericsTypes(), uti.getGenericsTypes());
            }
            ++i;
        }
    }

    protected static void readGenericsLinks(Map<String, ClassNode> map, GenericsType[] rt, GenericsType[] ut) {
        if (rt == null || ut == null || rt.length != ut.length) {
            return;
        }
        int i = 0;
        int n = rt.length;
        while (i < n) {
            GenericsType rti = rt[i];
            GenericsType uti = ut[i];
            if (uti.isPlaceholder()) {
                map.put(uti.getName(), rti.getType());
            } else if (uti.isWildcard()) {
                if (rti.isWildcard()) {
                    GenericsMapper.readGenericsLinks(map, rti.getLowerBound(), uti.getLowerBound());
                    GenericsMapper.readGenericsLinks(map, rti.getUpperBounds(), uti.getUpperBounds());
                } else {
                    ClassNode cu = rti.getType();
                    GenericsMapper.readGenericsLinks(map, cu, uti.getLowerBound());
                    ClassNode[] upperBounds = uti.getUpperBounds();
                    if (upperBounds != null) {
                        ClassNode[] classNodeArray = upperBounds;
                        int n2 = upperBounds.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ClassNode cn = classNodeArray[n3];
                            GenericsMapper.readGenericsLinks(map, cu, cn);
                            ++n3;
                        }
                    }
                }
            } else {
                GenericsMapper.readGenericsLinks(map, rti.getType(), uti.getType());
            }
            ++i;
        }
    }

    protected static void saveParameterType(Map<String, ClassNode> map, String key, ClassNode val, boolean weak) {
        ClassNode old = map.remove(key);
        if (old != null && !old.equals((Object)val) && !old.equals((Object)VariableScope.OBJECT_CLASS_NODE) && weak) {
            val = old;
        }
        map.put(key, GroovyUtils.getWrapperTypeIfPrimitive(val));
    }

    protected static void tryResolveMethodT(GenericsType unresolved, Map<String, ClassNode> resolved, Parameter[] parameters, List<ClassNode> argumentTypes) {
        int i = 0;
        int n = GenericsMapper.isVargs(parameters) ? argumentTypes.size() : Math.min(argumentTypes.size(), parameters.length);
        while (i < n) {
            ClassNode rbt = argumentTypes.get(i);
            ClassNode ubt = parameters[Math.min(i, parameters.length - 1)].getType();
            while (rbt.isArray() && ubt.isArray()) {
                rbt = rbt.getComponentType();
                ubt = ubt.getComponentType();
            }
            if (ubt.isGenericsPlaceHolder()) {
                if (ubt.getUnresolvedName().equals(unresolved.getName()) && GroovyUtils.isAssignable(rbt, ubt)) {
                    GenericsMapper.saveParameterType(resolved, unresolved.getName(), rbt, true);
                }
            } else if (ubt.redirect().isUsingGenerics()) {
                GenericsType[] ubt_gts = GroovyUtils.getGenericsTypes(ubt);
                int j = 0;
                block2: while (j < ubt_gts.length) {
                    if (!StaticTypeCheckingSupport.isUnboundedWildcard((GenericsType)ubt_gts[j])) {
                        ClassNode ubt_gt_t = GroovyUtils.getBaseType(ubt_gts[j].isWildcard() ? Optional.ofNullable(ubt_gts[j].getUpperBounds()).map(arr -> arr[0]).orElse(ubt_gts[j].getLowerBound()) : ubt_gts[j].getType());
                        if (rbt.equals((Object)ClassHelper.CLOSURE_TYPE) && !ubt.equals((Object)ClassHelper.CLOSURE_TYPE)) {
                            MethodNode sam;
                            if (rbt.isUsingGenerics() && (sam = ClassHelper.findSAM((ClassNode)ubt)) != null) {
                                GenericsMapper um = GenericsMapper.gatherGenerics(ubt);
                                HashMap<String, ClassNode> rm = new HashMap<String, ClassNode>();
                                GenericsMapper.readGenericsLinks(rm, rbt.getGenericsTypes()[0].getType(), sam.getReturnType());
                                for (Map.Entry entry : rm.entrySet()) {
                                    ClassNode ut = um.findParameter((String)entry.getKey(), null);
                                    if (ut == null) continue;
                                    HashMap<String, ClassNode> map = new HashMap<String, ClassNode>();
                                    GenericsMapper.readGenericsLinks(map, (ClassNode)entry.getValue(), ut);
                                    ClassNode rt = (ClassNode)map.get(unresolved.getName());
                                    if (rt == null || !GroovyUtils.isAssignable(rt, ubt_gt_t)) continue;
                                    GenericsMapper.saveParameterType(resolved, unresolved.getName(), rt, false);
                                    break block2;
                                }
                            }
                        } else if (ubt_gt_t.isGenericsPlaceHolder() && ubt_gt_t.getUnresolvedName().equals(unresolved.getName())) {
                            String key = GroovyUtils.getGenericsTypes(ubt.redirect())[j].getName();
                            GenericsMapper map = GenericsMapper.gatherGenerics(rbt, ubt);
                            ClassNode rt = map.findParameter(key, null);
                            if (rt == null || !GroovyUtils.isAssignable(rt, ubt_gt_t)) break;
                            GenericsMapper.saveParameterType(resolved, unresolved.getName(), rt, false);
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

