/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeDeclarationSearchRequestor
implements ITypeRequestor,
IIndexConstants {
    private final char[] simpleNamePattern;
    private final char typeSuffix;
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private TypeDeclarationPattern pattern;

    public TypeDeclarationSearchRequestor(TypeDeclarationPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.pattern = pattern;
        this.simpleNamePattern = pattern.simpleName;
        this.typeSuffix = pattern.typeSuffix;
        this.requestor = requestor;
        this.participant = participant;
    }

    @Override
    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        ClassNode orig;
        ClassNode redirect;
        if (node instanceof ClassNode && (redirect = (orig = (ClassNode)node).redirect()).getNameEnd() > 0 && orig == redirect && this.pattern.matchesName(this.simpleNamePattern, orig.getNameWithoutPackage().toCharArray())) {
            if (switch (this.typeSuffix) {
                case 'C' -> this.isClass(orig);
                case '\n' -> orig.isInterface() || this.isClass(orig);
                case '\t' -> orig.isInterface() || orig.isEnum();
                case 'I' -> orig.isInterface();
                case '\u000b' -> orig.isInterface() || orig.isAnnotationDefinition();
                case 'E' -> orig.isEnum();
                case 'A' -> orig.isAnnotationDefinition();
                default -> true;
            }) {
                try {
                    IJavaElement realElement = enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement) : enclosingElement;
                    this.requestor.acceptSearchMatch((SearchMatch)new TypeDeclarationMatch(realElement, 0, orig.getNameStart(), orig.getNameEnd() - orig.getNameStart() + 1, this.participant, realElement.getResource()));
                }
                catch (CoreException e) {
                    Util.log((Throwable)e, (String)("Exception with groovy search requestor. Looking inside " + String.valueOf(enclosingElement)));
                }
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }

    private boolean isClass(ClassNode orig) {
        return !orig.isInterface() && !orig.isAnnotationDefinition() && !orig.isEnum();
    }
}

