/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.controller.impl;

import com.katalon.execution.controller.IExecutionController;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.ITestPlanningJob;
import com.katalon.execution.services.jobs.TestPlanningJob;
import com.katalon.execution.temporary.FeatureFlags;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.ApplicationRunningMode;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.util.ExecutorUtils;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutionController
implements IExecutionController {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionController.class);
    private static final String UIEVENTS_REQUEST_ENABLEMENT_UPDATE_TOPIC = "org/eclipse/e4/ui/renderer/requestEnablementUpdate";
    private static final String UIEVENTS_ALL_ELEMENT_ID = "ALL";
    @Inject
    IExecutionManager manager;
    @Inject
    private IEventBroker eventBroker;
    private final CopyOnWriteArrayList<IExecutionController.ExecutionJobFuture> activeJobs = new CopyOnWriteArrayList();
    private final Object jobsLock = new Object();
    private final ExecutorService stoppingJobsExecutor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "ExecutionStopper");
        thread.setDaemon(false);
        return thread;
    });

    @PreDestroy
    public void cleanup() {
        if (this.hasActiveExecutions()) {
            logger.warn("Found active executions during shutdown, stopping them...");
            this.stopAllExecutions();
        }
        ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)this.stoppingJobsExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutionController.ExecutionJobFuture executeAsync(TestExecutionRequest executionRequest) {
        TestPlanningJob job = new TestPlanningJob(this.manager, this.eventBroker, executionRequest);
        CompletableFuture<ExecutionJobStatus> future = job.startAsync();
        IExecutionController.ExecutionJobFuture executionJobFuture = new IExecutionController.ExecutionJobFuture((ITestPlanningJob)job, future);
        Object object = this.jobsLock;
        synchronized (object) {
            this.activeJobs.add(executionJobFuture);
            future.whenComplete((result, throwable) -> {
                Object object = this.jobsLock;
                synchronized (object) {
                    this.activeJobs.remove(executionJobFuture);
                }
                this.triggerUIUpdateIfNecessary();
            });
        }
        this.triggerUIUpdateIfNecessary();
        return executionJobFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllExecutions() {
        ArrayList<IExecutionController.ExecutionJobFuture> jobsToStop;
        Object object = this.jobsLock;
        synchronized (object) {
            jobsToStop = new ArrayList<IExecutionController.ExecutionJobFuture>(this.activeJobs);
            this.activeJobs.clear();
        }
        this.triggerUIUpdateIfNecessary();
        this.stoppingJobsExecutor.execute(() -> {
            for (IExecutionController.ExecutionJobFuture jobFuture : jobsToStop) {
                ITestPlanningJob iTestPlanningJob = jobFuture.job();
                if (!(iTestPlanningJob instanceof TestPlanningJob)) continue;
                TestPlanningJob planningJob = (TestPlanningJob)iTestPlanningJob;
                planningJob.safelyStop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveExecutions() {
        try {
            if (FeatureFlags.isNewExecutionFlowEnabled()) {
                Object object = this.jobsLock;
                synchronized (object) {
                    return !this.activeJobs.isEmpty();
                }
            }
            return LauncherManager.getInstance().isAnyLauncherRunning();
        }
        catch (Exception e) {
            logger.warn("Failed to check active executions or running launchers.", (Throwable)e);
            return false;
        }
    }

    private void triggerUIUpdateIfNecessary() {
        if (ApplicationRunningMode.get() != RunningMode.GUI) {
            return;
        }
        try {
            this.eventBroker.post(UIEVENTS_REQUEST_ENABLEMENT_UPDATE_TOPIC, (Object)UIEVENTS_ALL_ELEMENT_ID);
        }
        catch (Exception e) {
            logger.warn("Failed to trigger enablement update", (Throwable)e);
        }
    }
}

