/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.controller.impl;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.manager.ICapabilityManager;
import com.katalon.capability.model.CapabilitySetting;
import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.execution.controller.IRecorderExecutionController;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.ExecutionEventConfiguration;
import com.katalon.execution.dto.request.ExistingDriverConfiguration;
import com.katalon.execution.dto.request.RecordPlaybackRequest;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionPlan;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.events.ExecutionEventsPublisher;
import com.katalon.execution.services.jobs.EntityExecutionJob;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.testcase.RecordPlaybackTestCaseEntity;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import jakarta.inject.Inject;
import java.util.concurrent.CompletableFuture;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecorderExecutionController
implements IRecorderExecutionController {
    private static final Logger logger = LoggerFactory.getLogger(RecorderExecutionController.class);
    @Inject
    ICapabilityManager capabilityManager;
    @Inject
    IExecutionManager manager;
    @Inject
    private IEventBroker eventBroker;

    public CompletableFuture<ExecutionTestResult> executeAsync(RecordPlaybackRequest recordPlaybackRequest) {
        CompletableFuture<ExecutionTestResult> futureResult = new CompletableFuture<ExecutionTestResult>();
        TestExecutionPlan testExecutionPlan = null;
        try {
            TestExecutionRequest testExecutionRequest = this.convertToTestExecutionRequest(recordPlaybackRequest);
            testExecutionPlan = this.manager.plan(testExecutionRequest);
        }
        catch (Exception e) {
            logger.error("Failed to create execution plan for record playback request: {}", (Object)recordPlaybackRequest, (Object)e);
            futureResult.completeExceptionally(e);
            return futureResult;
        }
        EntityExecution entityExecution = testExecutionPlan.getExecution();
        ExecutionEventsPublisher eventsPublisher = new ExecutionEventsPublisher(this.eventBroker, entityExecution);
        EntityExecutionJob entityExecutionJob = new EntityExecutionJob(this.manager, this.eventBroker, eventsPublisher, entityExecution);
        CompletableFuture<ExecutionJobStatus> jobFuture = entityExecutionJob.startAsync();
        jobFuture.whenComplete((status, throwable) -> {
            logger.info("Recorder execution job completed with status: {}", status);
            if (throwable != null) {
                logger.error("Recorder execution job failed with exception: ", throwable);
                futureResult.completeExceptionally((Throwable)throwable);
            } else {
                ExecutionTestResult testResult = entityExecution.getTestResult().orElse(null);
                futureResult.complete(testResult);
            }
        });
        return futureResult;
    }

    private TestExecutionRequest convertToTestExecutionRequest(RecordPlaybackRequest recordPlaybackRequest) throws ExecutionException {
        CapabilitySetting capabilitySetting;
        DriverType driverType = DriverType.fromDisplayName((String)recordPlaybackRequest.getDriverName());
        try {
            capabilitySetting = this.capabilityManager.getCapability(driverType);
        }
        catch (UnsupportedDriverTypeException e) {
            throw new ExecutionException("Cannot determine capability setting for execution.", (Throwable)e);
        }
        ExistingDriverConfiguration existingDriverConfiguration = new ExistingDriverConfiguration();
        existingDriverConfiguration.setSessionId(recordPlaybackRequest.getSessionId());
        existingDriverConfiguration.setRemoteServerUrl(recordPlaybackRequest.getRemoteServerUrl());
        RecordPlaybackTestCaseEntity testCaseEntity = new RecordPlaybackTestCaseEntity();
        testCaseEntity.setId("RecordPlaybackTestCase");
        testCaseEntity.setVariables(recordPlaybackRequest.getVariables());
        testCaseEntity.setProject(recordPlaybackRequest.getProject());
        testCaseEntity.setScript(recordPlaybackRequest.getScript());
        TestExecutionRequest executionRequest = TestExecutionRequest.builder().entity((IExecutableEntity)testCaseEntity).capability((ICapabilitySetting)capabilitySetting).launchMode(LaunchMode.RUN).runningMode(RunningMode.GUI).executionProfile(recordPlaybackRequest.getExecutionProfile()).driverConfiguration((DriverConfiguration)existingDriverConfiguration).eventConfiguration(ExecutionEventConfiguration.recorderConfig()).recordPlaybackCapturedTestObjectsFilePath(recordPlaybackRequest.getCapturedTestObjectsFilePath()).build();
        return executionRequest;
    }
}

