/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.factory;

import com.katalon.capability.constant.DriverType;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.ExistingDriverConfiguration;
import com.katalon.execution.factory.IDriverPropertiesBuilderFactory;
import com.katalon.execution.services.settings.AndroidDriverPropertiesBuilder;
import com.katalon.execution.services.settings.ChromeDriverPropertiesBuilder;
import com.katalon.execution.services.settings.EdgeChromiumDriverPropertiesBuilder;
import com.katalon.execution.services.settings.ExistingDriverPropertiesBuilder;
import com.katalon.execution.services.settings.FirefoxDriverPropertiesBuilder;
import com.katalon.execution.services.settings.FirefoxHeadlessDriverPropertiesBuilder;
import com.katalon.execution.services.settings.HeadlessDriverPropertiesBuilder;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import com.katalon.execution.services.settings.IosDriverPropertiesBuilder;
import com.katalon.execution.services.settings.KobitonDriverPropertiesBuilder;
import com.katalon.execution.services.settings.RemoteWebDriverPropertiesBuilder;
import com.katalon.execution.services.settings.SafariDriverPropertiesBuilder;
import com.katalon.execution.services.settings.TestCloudDriverPropertiesBuilder;
import com.katalon.execution.services.settings.WindowsDriverPropertiesBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class DriverPropertiesBuilderFactoryImpl
implements IDriverPropertiesBuilderFactory {
    private final IEclipseContext eclipseContext;

    @Inject
    public DriverPropertiesBuilderFactoryImpl(IEclipseContext eclipseContext) {
        this.eclipseContext = eclipseContext;
    }

    @Override
    public IDriverPropertiesBuilder getBuilder(DriverType driverType, DriverConfiguration driverConfiguration) {
        if (driverConfiguration instanceof ExistingDriverConfiguration) {
            return (IDriverPropertiesBuilder)ContextInjectionFactory.make(ExistingDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
        }
        return this.getBuilder(driverType);
    }

    @Override
    public IDriverPropertiesBuilder getBuilder(DriverType driverType) {
        return switch (driverType) {
            case DriverType.CHROME_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(ChromeDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.FIREFOX_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(FirefoxDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.EDGE_CHROMIUM_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(EdgeChromiumDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.SAFARI_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(SafariDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.HEADLESS_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(HeadlessDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.FIREFOX_HEADLESS_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(FirefoxHeadlessDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.REMOTE_WEB_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(RemoteWebDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.ANDROID_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(AndroidDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.IOS_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(IosDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.WINDOWS_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(WindowsDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.TESTCLOUD_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(TestCloudDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            case DriverType.KOBITON_WEB_DRIVER -> (IDriverPropertiesBuilder)ContextInjectionFactory.make(KobitonDriverPropertiesBuilder.class, (IEclipseContext)this.eclipseContext);
            default -> throw new MatchException(null, null);
        };
    }
}

