/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.factory;

import com.katalon.execution.factory.IReportIntegrationProviderFactory;
import com.katalon.execution.model.steps.reporting.ReportIntegrationProviderType;
import com.katalon.execution.services.IReportIntegrationProvider;
import com.katalon.execution.services.reporting.AzureReportIntegrationProvider;
import com.katalon.execution.services.reporting.QTestReportIntegrationProvider;
import com.katalon.execution.services.reporting.TestOpsReportIntegrationProvider;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import jakarta.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class ReportIntegrationProviderFactoryImpl
implements IReportIntegrationProviderFactory {
    @Override
    public IReportIntegrationProvider getProvider(String contributionName, ReportIntegrationContribution contribution) {
        ReportIntegrationProviderType providerType = ReportIntegrationProviderType.fromContributionName((String)contributionName);
        if (providerType == null) {
            throw new IllegalArgumentException("Unsupported report integration contribution: " + contributionName);
        }
        return switch (providerType) {
            case ReportIntegrationProviderType.TESTOPS -> new TestOpsReportIntegrationProvider(contribution);
            case ReportIntegrationProviderType.AZURE_DEVOPS -> new AzureReportIntegrationProvider(contribution);
            case ReportIntegrationProviderType.QTEST -> new QTestReportIntegrationProvider(contribution);
            default -> throw new MatchException(null, null);
        };
    }
}

