/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.manager.ICapabilityManager;
import com.katalon.capability.manager.ICustomCapabilityManager;
import com.katalon.capability.model.CapabilitySetting;
import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.factory.IDriverPropertiesBuilderFactory;
import com.katalon.execution.factory.IReportIntegrationProviderFactory;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.TSCExecutionSettings;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionPlan;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.launch.LaunchShortcut;
import com.katalon.execution.services.planner.ExecutionSettingsBuilder;
import com.katalon.execution.services.planner.LegacyDriverConfigurationConverter;
import com.katalon.execution.services.planner.SessionIdGenerator;
import com.katalon.execution.services.planner.TestCaseExecutionPlanner;
import com.katalon.execution.services.planner.TestSuiteCollectionExecutionPlanner;
import com.katalon.execution.services.planner.TestSuiteCollectionReportPlanner;
import com.katalon.execution.services.planner.TestSuiteExecutionPlanner;
import com.katalon.execution.services.planner.TestSuiteReportPlanner;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.RecordPlaybackTestCaseEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.helper.ClasspathHelper;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.session.core.services.IFeatureManager;
import com.kms.katalon.session.core.services.ISessionManager;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;

public class ExecutionManager
implements IExecutionManager {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Inject
    private ISessionManager sessionManager;
    @Inject
    private IFeatureManager featureManager;
    @Inject
    private ICapabilityManager capabilityManager;
    @Inject
    private ICustomCapabilityManager customCapabilityManager;
    @Inject
    private IDriverPropertiesBuilderFactory driverPropertiesBuilderFactory;
    @Inject
    private IReportIntegrationProviderFactory reportIntegrationProviderFactory;

    public ExecutionSettings initializeSettings(TestExecutionRequest request) throws ExecutionException {
        if (request.getEntity() instanceof TestSuiteCollectionEntity) {
            return null;
        }
        ExecutionSettingsBuilder builder = new ExecutionSettingsBuilder(this.sessionManager, this.featureManager, this.driverPropertiesBuilderFactory);
        return builder.build(request);
    }

    public ExecutionSettings cloneSettingsForRetry(ExecutionSettings original, int suiteRerunIndex) throws ExecutionException {
        ExecutionSettingsBuilder builder = new ExecutionSettingsBuilder(this.sessionManager, this.featureManager, this.driverPropertiesBuilderFactory);
        return builder.cloneSettingsForRetry(original, suiteRerunIndex);
    }

    public TestExecutionPlan plan(TestExecutionRequest request) throws ExecutionException {
        if (request == null || request.getEntity() == null) {
            throw new ExecutionException("TestExecutionRequest and entity cannot be null");
        }
        IExecutableEntity iExecutableEntity = request.getEntity();
        if (iExecutableEntity instanceof RecordPlaybackTestCaseEntity) {
            RecordPlaybackTestCaseEntity testCaseEntity = (RecordPlaybackTestCaseEntity)iExecutableEntity;
            return this.planRecordPlayback(request, testCaseEntity);
        }
        IExecutableEntity iExecutableEntity2 = request.getEntity();
        if (iExecutableEntity2 instanceof TestCaseEntity) {
            TestCaseEntity testCaseEntity = (TestCaseEntity)iExecutableEntity2;
            return this.planTestCase(request, testCaseEntity);
        }
        if (request.getEntity() instanceof TestSuiteEntity) {
            return this.planTestSuite(request);
        }
        IExecutableEntity iExecutableEntity3 = request.getEntity();
        if (iExecutableEntity3 instanceof TestSuiteCollectionEntity) {
            TestSuiteCollectionEntity tscEntity = (TestSuiteCollectionEntity)iExecutableEntity3;
            return this.planTestSuiteCollection(request, tscEntity);
        }
        IExecutableEntity iExecutableEntity4 = request.getEntity();
        if (iExecutableEntity4 instanceof SystemFileEntity) {
            SystemFileEntity cucumberFeatureFileEntity = (SystemFileEntity)iExecutableEntity4;
            return this.planCucumberFeatureFile(request, cucumberFeatureFileEntity);
        }
        throw new ExecutionException("Unsupported executable entity type: " + request.getEntity().getClass().getName());
    }

    private TestExecutionPlan planTestCase(TestExecutionRequest request, TestCaseEntity testCaseEntity) throws ExecutionException {
        ExecutionSettings executionSettings = this.initializeSettings(request);
        this.writeExecutionSettingsToFile(executionSettings);
        TestExecutionPlan plan = new TestExecutionPlan();
        Object baseTestCaseExecution = this.isDataBindingEnabled(testCaseEntity) ? new TestCaseBindingExecution(testCaseEntity, executionSettings) : new TestCaseExecution(testCaseEntity, executionSettings);
        plan.setExecution((EntityExecution)baseTestCaseExecution);
        TestCaseExecutionPlanner testCasePlanner = new TestCaseExecutionPlanner(request, (BaseTestCaseExecution)baseTestCaseExecution);
        testCasePlanner.planTestCaseExecutions();
        baseTestCaseExecution.onPlanChanged();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        IFolder scriptFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        try {
            File scriptFile = testCasePlanner.generateTestCaseScriptFile(scriptFolder);
            IFile iScriptFile = GroovyUtil.getTempScriptIFile((File)scriptFile, (ProjectEntity)project);
            executionSettings.setScriptFile(iScriptFile);
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to generate script file for test case execution", (Throwable)e);
        }
        return plan;
    }

    private TestExecutionPlan planRecordPlayback(TestExecutionRequest request, RecordPlaybackTestCaseEntity testCaseEntity) throws ExecutionException {
        ExecutionSettings executionSettings = this.initializeSettings(request);
        this.writeExecutionSettingsToFile(executionSettings);
        TestExecutionPlan plan = new TestExecutionPlan();
        TestCaseExecution baseTestCaseExecution = new TestCaseExecution((TestCaseEntity)testCaseEntity, executionSettings);
        plan.setExecution((EntityExecution)baseTestCaseExecution);
        TestCaseExecutionPlanner testCasePlanner = new TestCaseExecutionPlanner(request, (BaseTestCaseExecution)baseTestCaseExecution);
        testCasePlanner.planTestCaseExecutions();
        baseTestCaseExecution.onPlanChanged();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        IFolder scriptFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        try {
            File scriptFile = testCasePlanner.generateRecordPlaybackScriptFile(scriptFolder, testCaseEntity);
            IFile iScriptFile = GroovyUtil.getTempScriptIFile((File)scriptFile, (ProjectEntity)project);
            executionSettings.setScriptFile(iScriptFile);
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to generate script file for test case execution", (Throwable)e);
        }
        return plan;
    }

    private TestExecutionPlan planTestSuite(TestExecutionRequest request) throws ExecutionException {
        ExecutionSettings executionSettings = this.initializeSettings(request);
        this.writeExecutionSettingsToFile(executionSettings);
        TestExecutionPlan plan = new TestExecutionPlan();
        TestSuiteExecution testSuiteExecution = new TestSuiteExecution(executionSettings, Optional.empty());
        plan.setExecution((EntityExecution)testSuiteExecution);
        this.createAndPlanTestSuiteExecutionAttempt(testSuiteExecution, executionSettings, request);
        TestSuiteReportPlanner reportingPhasePlanner = new TestSuiteReportPlanner(request, this.reportIntegrationProviderFactory, testSuiteExecution);
        TestReportingPhase reportingPhase = reportingPhasePlanner.createPlan();
        plan.setReporting(reportingPhase);
        return plan;
    }

    private TestExecutionPlan planTestSuiteCollection(TestExecutionRequest testExecutionRequest, TestSuiteCollectionEntity tscEntity) throws ExecutionException {
        KREOverridingConfiguration kreOverridingConfiguration = testExecutionRequest != null ? testExecutionRequest.getKreOverridingConfiguration() : null;
        int delayBetweenInstances = kreOverridingConfiguration != null && kreOverridingConfiguration.getDelayBetweenInstances().isPresent() ? ((Integer)kreOverridingConfiguration.getDelayBetweenInstances().get()).intValue() : tscEntity.getDelayBetweenInstances();
        Optional maxFailedTests = kreOverridingConfiguration != null ? kreOverridingConfiguration.getMaxFailedTests() : Optional.empty();
        Optional executionUUID = kreOverridingConfiguration != null ? kreOverridingConfiguration.getExecutionUUID() : Optional.empty();
        TestExecutionPlan plan = new TestExecutionPlan();
        TSCExecutionSettings tscExecutionSettings = new TSCExecutionSettings();
        tscExecutionSettings.setExecutionSessionId(SessionIdGenerator.generateSessionId());
        tscExecutionSettings.setDelayBetweenInstances(delayBetweenInstances);
        tscExecutionSettings.setMaxFailedTests(maxFailedTests);
        TestSuiteCollectionExecution tscExecution = new TestSuiteCollectionExecution(tscEntity, tscExecutionSettings, (String)executionUUID.orElse(null));
        plan.setExecution((EntityExecution)tscExecution);
        TestSuiteCollectionExecutionPlanner tscPlanner = new TestSuiteCollectionExecutionPlanner(this, this.capabilityManager, this.customCapabilityManager, tscExecution, testExecutionRequest);
        tscPlanner.planTestSuiteExecutions();
        if (tscExecution.getTestSuiteExecutions().isEmpty()) {
            throw new ExecutionException("Found no test suite to execute in the test suite collection.");
        }
        TestSuiteExecution emptyTestSuiteExecution = tscExecution.getTestSuiteExecutions().stream().filter(tsExecution -> tsExecution.getFirstAttempt().getTestCaseExecutions().isEmpty()).findFirst().orElse(null);
        if (emptyTestSuiteExecution != null) {
            throw new ExecutionException("Found no test case to execute in the test suite: " + emptyTestSuiteExecution.getTestSuiteId());
        }
        TestSuiteCollectionReportPlanner reportingPhasePlanner = new TestSuiteCollectionReportPlanner(testExecutionRequest, this.featureManager, this.reportIntegrationProviderFactory, tscExecution);
        TestReportingPhase reportingPhase = reportingPhasePlanner.createPlan();
        plan.setReporting(reportingPhase);
        return plan;
    }

    private TestExecutionPlan planCucumberFeatureFile(TestExecutionRequest request, SystemFileEntity cucumberFeatureFileEntity) throws ExecutionException {
        ExecutionSettings executionSettings = this.initializeSettings(request);
        this.writeExecutionSettingsToFile(executionSettings);
        TestExecutionPlan plan = new TestExecutionPlan();
        TestCaseExecution baseTestCaseExecution = new TestCaseExecution(cucumberFeatureFileEntity, executionSettings);
        plan.setExecution((EntityExecution)baseTestCaseExecution);
        TestCaseExecutionPlanner testCasePlanner = new TestCaseExecutionPlanner(request, (BaseTestCaseExecution)baseTestCaseExecution);
        testCasePlanner.planTestCaseExecutions();
        baseTestCaseExecution.onPlanChanged();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        IFolder scriptFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        try {
            File scriptFile = testCasePlanner.generateCucumberScriptFile(scriptFolder);
            IFile iScriptFile = GroovyUtil.getTempScriptIFile((File)scriptFile, (ProjectEntity)project);
            executionSettings.setScriptFile(iScriptFile);
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to generate script file for feature file execution", (Throwable)e);
        }
        return plan;
    }

    private boolean isDataBindingEnabled(TestCaseEntity testCaseEntity) {
        if (testCaseEntity == null) {
            return false;
        }
        return !TestCaseController.getInstance().isNotUsingDataBinding(testCaseEntity);
    }

    public void updateTestSuiteExecutionWithNewRetry(TestSuiteExecution testSuiteExecution, ExecutionSettings executionSettingsForRetry) throws ExecutionException {
        TestSuiteExecutionAttempt lastAttempt = testSuiteExecution.getLastAttempt();
        if (lastAttempt == null) {
            throw new ExecutionException("Cannot find the last attempt of test suite execution: " + String.valueOf(testSuiteExecution.getId()));
        }
        TestSuiteRerunSettings.RetryStrategy retryStrategy = executionSettingsForRetry.getTestSuiteRerunSettings().getRetryStrategy();
        Predicate<BaseTestCaseExecution> shouldRetryPredicate = execution -> true;
        if (retryStrategy == TestSuiteRerunSettings.RetryStrategy.FAILED_EXECUTIONS) {
            shouldRetryPredicate = execution -> execution.isErrorOrFailed();
        }
        this.createAndPlanTestSuiteExecutionAttemptForRetry(testSuiteExecution, executionSettingsForRetry, lastAttempt, shouldRetryPredicate);
        if (testSuiteExecution.getParentEntityExecution() != null) {
            testSuiteExecution.getParentEntityExecution().onPlanChanged();
        }
    }

    private TestSuiteExecutionAttempt createAndPlanTestSuiteExecutionAttempt(TestSuiteExecution testSuiteExecution, ExecutionSettings executionSettings, TestExecutionRequest testExecutionRequest) throws ExecutionException {
        TestSuiteExecutionAttempt newAttempt = new TestSuiteExecutionAttempt(executionSettings, (String)executionSettings.getOverridingExecutionUUID().orElse(null));
        TestSuiteExecutionPlanner testSuitePlanner = new TestSuiteExecutionPlanner(newAttempt, testExecutionRequest);
        testSuitePlanner.planTestCaseExecutions();
        newAttempt.onPlanChanged();
        if (newAttempt.getTestCaseExecutions().isEmpty()) {
            throw new ExecutionException("Found no test case to execute in the test suite.");
        }
        testSuiteExecution.addNewAttempt(newAttempt);
        testSuiteExecution.onPlanChanged();
        this.prepareScriptFile(testSuitePlanner, executionSettings);
        return newAttempt;
    }

    private TestSuiteExecutionAttempt createAndPlanTestSuiteExecutionAttemptForRetry(TestSuiteExecution testSuiteExecution, ExecutionSettings executionSettings, TestSuiteExecutionAttempt previousAttempt, Predicate<BaseTestCaseExecution> shouldRetry) throws ExecutionException {
        String retryExecutionUUID = UUID.randomUUID().toString();
        TestSuiteExecutionAttempt newAttempt = new TestSuiteExecutionAttempt(executionSettings, retryExecutionUUID);
        TestSuiteExecutionPlanner testSuitePlanner = new TestSuiteExecutionPlanner(newAttempt);
        testSuitePlanner.planTestCaseExecutionsForRetry(previousAttempt, shouldRetry);
        newAttempt.onPlanChanged();
        testSuiteExecution.addNewAttempt(newAttempt);
        testSuiteExecution.onPlanChanged();
        this.prepareScriptFile(testSuitePlanner, executionSettings);
        return newAttempt;
    }

    private void prepareScriptFile(TestSuiteExecutionPlanner testSuitePlanner, ExecutionSettings executionSettings) throws ExecutionException {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        IFolder scriptFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        try {
            File scriptFile = testSuitePlanner.generateScriptFile(scriptFolder);
            IFile iScriptFile = GroovyUtil.getTempScriptIFile((File)scriptFile, (ProjectEntity)project);
            executionSettings.setScriptFile(iScriptFile);
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to generate script file for test suite execution", (Throwable)e);
        }
    }

    public void writeExecutionSettingsToFile(ExecutionSettings executionSettings) throws ExecutionException {
        try {
            Files.createDirectories(executionSettings.getExecutionDirPath(), new FileAttribute[0]);
            String jsonContent = OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)executionSettings.getRunConfiguration());
            Files.write(executionSettings.getSettingsFilePath(), jsonContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to write execution settings file", (Throwable)e);
        }
    }

    public ILaunch execute(EntityExecution entityExecution) throws ExecutionException {
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            return this.execute(testCaseExecution.getExecutionSettings());
        }
        if (entityExecution instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)entityExecution;
            return this.execute(testCaseBindingExecution.getExecutionSettings());
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            return this.execute(testSuiteExecutionAttempt.getExecutionSettings());
        }
        throw new ExecutionException("Unsupported entity execution type for execution: " + entityExecution.getClass().getName());
    }

    private ILaunch execute(ExecutionSettings executionSettings) throws ExecutionException {
        List vmArgs = executionSettings.getVmArgs();
        Map environmentVariables = executionSettings.getEnvironmentVariables();
        String[] defaultClassPaths = ClasspathHelper.getDefaultRuntimeClasspath();
        RunningMode runningMode = executionSettings.getRunConfiguration().getRunningMode();
        LaunchShortcut launchShortcut = new LaunchShortcut(runningMode);
        try {
            ILaunch launch = launchShortcut.launch(executionSettings.getScriptFile(), executionSettings.getLaunchMode(), environmentVariables, vmArgs, defaultClassPaths);
            return launch;
        }
        catch (CoreException e) {
            throw new ExecutionException("Failed to initialize ILaunch", (Throwable)e);
        }
    }

    public DriverConfiguration createDriverConfigurationFromLegacyConfig(IRunConfiguration legacyFlowConfig) {
        return LegacyDriverConfigurationConverter.fromLegacyConfig(legacyFlowConfig);
    }

    public Pair<ICapabilitySetting, String> resolveDriverSetting(String displayDriverName) throws UnsupportedDriverTypeException {
        if ("Web Service".equalsIgnoreCase(displayDriverName)) {
            return Pair.of(null, (Object)"Web Service");
        }
        DriverType driverType = DriverType.fromDisplayName((String)displayDriverName);
        CapabilitySetting capabilitySetting = this.capabilityManager.getCapability(driverType);
        return Pair.of((Object)capabilitySetting, (Object)capabilitySetting.getDisplayName());
    }
}

