/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.cleanup;

import com.katalon.execution.constant.ExecutionDriverType;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.kms.katalon.core.windows.driver.FlaUIDriverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionDriversCleanupService {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionDriversCleanupService.class);

    public void cleanupDriversAfterExecution(EntityExecution entityExecution) {
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt attempt = (TestSuiteExecutionAttempt)entityExecution;
            this.cleanUpExecutionDriversAfterTestSuite(attempt);
            return;
        }
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            this.cleanUpExecutionDriversAfterTestCase(testCaseExecution);
            return;
        }
        logger.warn("Execution driver cleanup is not implemented for execution type: {}", (Object)entityExecution.getClass().getSimpleName());
    }

    public void cleanUpExecutionDriversAfterTestSuite(TestSuiteExecutionAttempt attempt) {
        boolean isRunWithWindowDesktopDriver;
        ExecutionSettings executionSettings = attempt.getExecutionSettings();
        boolean shouldTerminate = executionSettings.getRunConfiguration().getExecution().getGeneral().getTerminateDriverAfterTestSuite();
        if (!shouldTerminate) {
            return;
        }
        DriversProperties driversProps = executionSettings.getRunConfiguration().getExecution().getDrivers();
        boolean bl = isRunWithWindowDesktopDriver = driversProps != null && driversProps.getSystemProps().containsKey((Object)ExecutionDriverType.DESKTOP);
        if (isRunWithWindowDesktopDriver) {
            FlaUIDriverManager.getInstance().stopLocalServer();
        }
    }

    public void cleanUpExecutionDriversAfterTestCase(TestCaseExecution testCaseExecution) {
        boolean isRunWithWindowDesktopDriver;
        ExecutionSettings executionSettings = testCaseExecution.getExecutionSettings();
        boolean shouldTerminate = executionSettings.getRunConfiguration().getExecution().getGeneral().getTerminateDriverAfterTestCase();
        if (!shouldTerminate) {
            return;
        }
        DriversProperties driversProps = executionSettings.getRunConfiguration().getExecution().getDrivers();
        boolean bl = isRunWithWindowDesktopDriver = driversProps != null && driversProps.getSystemProps().containsKey((Object)ExecutionDriverType.DESKTOP);
        if (isRunWithWindowDesktopDriver) {
            FlaUIDriverManager.getInstance().stopLocalServer();
        }
    }
}

