/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.capability.constant.DriverType;
import com.katalon.execution.constant.ExecutionDriverType;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.platform.api.execution.TestSuiteCollectionExecutionContext;
import com.katalon.platform.api.execution.TestSuiteExecutionContext;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.entity.TestSuiteCollectionExecutionContextImpl;
import com.kms.katalon.execution.entity.TestSuiteExecutionContextImpl;
import com.kms.katalon.execution.platform.TestCaseExecutionContextImpl;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionContextBuilder.class);

    public TestSuiteExecutionContext buildTestSuiteExecutionContext(TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        TestSuiteEntity testSuite = testSuiteExecutionAttempt.getTestSuite();
        ArrayList<TestCaseExecutionContextImpl> testCaseContexts = new ArrayList<TestCaseExecutionContextImpl>();
        ArrayList<TestCaseExecution> testCaseExecutions = new ArrayList<TestCaseExecution>();
        for (BaseTestCaseExecution baseTestCasecExecution : testSuiteExecutionAttempt.getTestCaseExecutions()) {
            if (baseTestCasecExecution instanceof TestCaseExecution) {
                TestCaseExecution testCaseExecution = (TestCaseExecution)baseTestCasecExecution;
                testCaseExecutions.add(testCaseExecution);
                continue;
            }
            if (!(baseTestCasecExecution instanceof TestCaseBindingExecution)) continue;
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)baseTestCasecExecution;
            testCaseExecutions.addAll(testCaseBindingExecution.getIterations());
        }
        for (TestCaseExecution testCaseExecution : testCaseExecutions) {
            String testResult = String.valueOf(testCaseExecution.getTestResult().orElse(null));
            testCaseContexts.add(TestCaseExecutionContextImpl.Builder.create((String)testCaseExecution.getTestCaseId(), (String)testCaseExecution.getTestCaseId()).withTestCaseStatus(testResult).withStartTime(this.getTimeEpochMs(testCaseExecution.getStartDate())).withEndTime(this.getTimeEpochMs(testCaseExecution.getEndDate())).withMessage((String)testCaseExecution.getJobFailedReason().orElse(null)).build());
        }
        ProjectEntity project = testSuite.getProject();
        Path projectFolderPath = Path.of(project.getFolderLocation(), new String[0]);
        Path executionDirPath = testSuiteExecutionAttempt.getExecutionSettings().getExecutionDirPath();
        String executionId = FilenameUtils.getBaseName((String)executionDirPath.toString());
        String reportEntityId = projectFolderPath.relativize(executionDirPath).toString();
        TestSuiteExecutionContextImpl.Builder builder = TestSuiteExecutionContextImpl.Builder.create((String)executionId, (String)testSuiteExecutionAttempt.getTestSuiteId(), (String)project.getFolderLocation()).withReportId(reportEntityId).withTestCaseContext(testCaseContexts).withStartTime(this.getTimeEpochMs(testSuiteExecutionAttempt.getStartDate())).withEndTime(this.getTimeEpochMs(testSuiteExecutionAttempt.getEndDate()));
        ExecutionSettings executionSettings = testSuiteExecutionAttempt.getExecutionSettings();
        String executionProfileName = executionSettings.getRunConfiguration().getExecution().getGeneral().getExecutionProfile();
        TestSuiteLogRecord testSuiteLogRecord = testSuiteExecutionAttempt.getTestSuiteLogRecord();
        Map runData = testSuiteLogRecord == null ? null : testSuiteLogRecord.getRunData();
        DriversProperties driversProps = executionSettings.getRunConfiguration().getExecution().getDrivers();
        if (runData != null) {
            HashMap<String, String> desiredCaps = new HashMap();
            String desiredCapsJson = this.getValue(runData, "desiredCapabilities", "");
            if (!StringUtils.isBlank((CharSequence)desiredCapsJson)) {
                try {
                    desiredCaps = (Map)new ObjectMapper().readValue(desiredCapsJson, HashMap.class);
                }
                catch (Exception e) {
                    logger.warn("Failed to parse desiredCapabilities JSON. Raw text: " + desiredCapsJson, (Throwable)e);
                }
            }
            builder.withHostName(this.getValue(runData, "hostName", "")).withOs(this.getValue(runData, "os", "")).withBrowser(this.buildFullBrowserName(driversProps, runData, desiredCaps)).withDeviceId(this.getValue(runData, "deviceId", "")).withDeviceName(this.buildFullDeviceName(runData, desiredCaps)).withSuiteName(testSuiteLogRecord.getName()).withExecutionProfile(executionProfileName);
        }
        TestSuiteExecutionContextImpl executionContext = builder.build();
        return executionContext;
    }

    public TestSuiteCollectionExecutionContext buildTSCExecutionContext(TestSuiteCollectionExecution tscExecution) {
        TestSuiteCollectionEntity tsc = tscExecution.getTestSuiteCollection();
        ArrayList<TestSuiteExecutionContext> testSuiteContexts = new ArrayList<TestSuiteExecutionContext>();
        for (TestSuiteExecution testSuiteExecution : tscExecution.getTestSuiteExecutions()) {
            for (TestSuiteExecutionAttempt attempt : testSuiteExecution.getAttempts()) {
                testSuiteContexts.add(this.buildTestSuiteExecutionContext(attempt));
            }
        }
        ProjectEntity project = tsc.getProject();
        String executionId = tscExecution.getExecutionSessionId();
        ReportCollectionEntity reportCollection = this.safelyGetReportCollection(tscExecution);
        String reportCollectionId = reportCollection != null ? reportCollection.getIdForDisplay() : "";
        TestSuiteCollectionExecutionContextImpl executionContext = TestSuiteCollectionExecutionContextImpl.Builder.create((String)executionId, (String)tscExecution.getTestSuiteCollectionId()).withReportId(reportCollectionId).withTestSuiteContexts(testSuiteContexts).withProjectLocation(project.getFolderLocation()).withStartTime(this.getTimeEpochMs(tscExecution.getStartDate())).withEndTime(this.getTimeEpochMs(tscExecution.getEndDate())).build();
        return executionContext;
    }

    private ReportCollectionEntity safelyGetReportCollection(TestSuiteCollectionExecution tscExecution) {
        ReportCollectionEntity reportCollectionEntity = null;
        try {
            reportCollectionEntity = ReportController.getInstance().getReportCollection(tscExecution.getTestSuiteCollection().getProject(), tscExecution.getTestSuiteCollection(), tscExecution.getExecutionSessionId(), tscExecution.getExecutionSessionId());
            return reportCollectionEntity;
        }
        catch (Exception e) {
            logger.warn("Failed to get report collection for Test Suite Collection Execution: {}", (Object)tscExecution.getTestSuiteCollectionId(), (Object)e);
            return null;
        }
    }

    private long getTimeEpochMs(Date date) {
        return date != null ? date.getTime() : 0L;
    }

    private String getValue(Map<String, String> map, String key, String defaultValue) {
        if (map != null && key != null && map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    private String buildFullBrowserName(DriversProperties driversProps, Map<String, String> runData, Map<String, String> desiredCaps) {
        DriversProperties.RemoteDriverSystemProperties remoteDriverProps;
        boolean isMobile;
        Object fullBrowserName = this.getValue(runData, "browser", "");
        if (StringUtils.isBlank((CharSequence)fullBrowserName)) {
            String browserNameWithoutVersion = desiredCaps.get("browserName");
            String browserVersion = desiredCaps.get("browserVersion");
            fullBrowserName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{browserVersion}) ? browserNameWithoutVersion + " " + browserVersion : browserNameWithoutVersion;
        }
        if (StringUtils.isBlank((CharSequence)fullBrowserName)) {
            return "";
        }
        fullBrowserName = StringUtils.capitalize((String)fullBrowserName);
        String devicePlatform = this.buildFullDevicePlatformName(runData, desiredCaps);
        if (StringUtils.isBlank((CharSequence)devicePlatform)) {
            return fullBrowserName;
        }
        boolean bl = isMobile = "android".equalsIgnoreCase(devicePlatform) || "ios".equalsIgnoreCase(devicePlatform);
        if (isMobile) {
            return fullBrowserName;
        }
        fullBrowserName = this.formatDevicePlatform(devicePlatform) + " - " + (String)fullBrowserName;
        DriversProperties.DriverSystemProperties driverSystemProperties = (DriversProperties.DriverSystemProperties)driversProps.getSystemProps().get((Object)ExecutionDriverType.REMOTE);
        if (driverSystemProperties instanceof DriversProperties.RemoteDriverSystemProperties && (remoteDriverProps = (DriversProperties.RemoteDriverSystemProperties)driverSystemProperties).getBrowserType() == DriverType.TESTCLOUD_DRIVER) {
            String browserFullVersion = TestCloudPropertyUtil.getInstance().buildBrowserFullVersion((String)fullBrowserName, this.getValue(runData, "browserVersionType", ""));
            fullBrowserName = "TestCloud - " + browserFullVersion;
        }
        return fullBrowserName;
    }

    private String buildFullDevicePlatformName(Map<String, String> runData, Map<String, String> desiredCaps) {
        String platform = this.getValue(runData, "deviceOS", "");
        if (StringUtils.isBlank((CharSequence)platform) && StringUtils.isBlank((CharSequence)(platform = desiredCaps.get("platform")))) {
            platform = desiredCaps.get("platformName");
        }
        return StringUtils.capitalize((String)platform);
    }

    private String buildFullDeviceName(Map<String, String> runData, Map<String, String> desiredCaps) {
        String udid;
        String deviceName = this.getValue(runData, "deviceName", "");
        if (StringUtils.isBlank((CharSequence)deviceName)) {
            deviceName = this.getValue(desiredCaps, "deviceName", "");
        }
        if (StringUtils.isBlank((CharSequence)deviceName)) {
            deviceName = this.getValue(desiredCaps, "appium:deviceName", "");
        }
        if (StringUtils.isBlank((CharSequence)(udid = this.getValue(desiredCaps, "appium:udid", "")))) {
            return deviceName;
        }
        return deviceName + " (UDID: " + (udid.length() <= 6 ? udid.substring(0, 6) : udid) + ")";
    }

    private String formatDevicePlatform(String devicePlatform) {
        if (StringUtils.isBlank((CharSequence)devicePlatform)) {
            return "";
        }
        if ("ios".equalsIgnoreCase(devicePlatform)) {
            return "iOS";
        }
        if ("macos".equalsIgnoreCase(devicePlatform) || "mac os x".equalsIgnoreCase(devicePlatform) || "mac".equalsIgnoreCase(devicePlatform)) {
            return "macOS";
        }
        return StringUtils.capitalize((String)devicePlatform.toLowerCase());
    }
}

