/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.events;

import com.katalon.execution.event.ExecutionResultUpdatedEvent;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteCollectionReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteReportDataSource;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.reporting.ReportIntegrationProviderType;
import com.katalon.execution.model.steps.reporting.TestReportIntegration;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.events.ExecutionContextBuilder;
import com.katalon.execution.services.events.TestOpsRealtimeReporter;
import com.katalon.platform.api.execution.TestSuiteCollectionExecutionContext;
import com.katalon.platform.api.execution.TestSuiteExecutionContext;
import com.kms.katalon.application.utils.MachineUtil;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.entity.testcase.RecordPlaybackTestCaseEntity;
import com.kms.katalon.entity.testcase.WSVerificationTestCaseEntity;
import com.kms.katalon.execution.handler.OrganizationHandler;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.platform.TestSuiteCollectionExecutionEvent;
import com.kms.katalon.execution.platform.TestSuiteExecutionEvent;
import com.kms.katalon.util.ExecutorUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventsPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEventsPublisher.class);
    private final IEventBroker eventBroker;
    private final TestOpsRealtimeReporter testOpsRealtimeReporter;
    private final ExecutorService eventPublishingExecutor;

    public ExecutionEventsPublisher(IEventBroker eventBroker, EntityExecution rootEntityExecution) {
        this.eventBroker = eventBroker;
        this.testOpsRealtimeReporter = TestOpsRealtimeReporter.safelyCreateIfNecessary(rootEntityExecution);
        this.eventPublishingExecutor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable, "ExecutionEventsPublisher-Thread");
            thread.setDaemon(true);
            return thread;
        });
    }

    public void shutdown() {
        try {
            ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)this.eventPublishingExecutor);
        }
        catch (Exception e) {
            logger.warn("Failed to shutdown executor service", (Throwable)e);
        }
    }

    public void onExecutionStatusChanged(EntityExecution entityExecution, ExecutionJobStatus newStatus) {
        if (entityExecution == null || newStatus == null) {
            logger.warn("EntityExecution or newStatus is null. Cannot fire execution event.");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.fireEventWhenStatusChanged(entityExecution, newStatus);
            }
            catch (Exception e) {
                logger.warn("Failed to fire execution event for EntityExecution id={} with status={}", new Object[]{entityExecution.getIdString(), newStatus, e});
            }
        }, this.eventPublishingExecutor).exceptionally(ex -> {
            logger.error("Unexpected error in async event publishing for EntityExecution id={} with status={}", new Object[]{entityExecution.getIdString(), newStatus, ex});
            return null;
        });
    }

    public void onReportIntegrationCompleted(TestReportIntegration reportIntegration, IReportDataSource dataSource) {
        try {
            boolean isTestOps = ReportIntegrationProviderType.TESTOPS.getContributionName().equals(reportIntegration.getReportIntegrationProvider().getName());
            if (!isTestOps || this.testOpsRealtimeReporter == null) {
                return;
            }
            EntityExecution entityExecution = reportIntegration.getTargetExecution();
            if (entityExecution instanceof TestSuiteCollectionExecution) {
                TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
                this.testOpsRealtimeReporter.safelyReportChange(ExecutionResultUpdatedEvent.testSuiteCollectionAndReportUploadEnded((TestSuiteCollectionExecution)tscExecution));
                return;
            }
            if (dataSource instanceof LegacyTestSuiteReportDataSource) {
                TestSuiteExecution tsExecution;
                LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)dataSource;
                EntityExecution entityExecution2 = legacyDataSource.getTestSuiteExecutionAttempt().getParentEntityExecution();
                if (entityExecution2 instanceof TestSuiteExecution && (tsExecution = (TestSuiteExecution)entityExecution2).isPartOfCollection()) {
                    return;
                }
                this.testOpsRealtimeReporter.safelyReportChange(ExecutionResultUpdatedEvent.testSuiteAttemptAndReportUploadEnded((TestSuiteExecutionAttempt)legacyDataSource.getTestSuiteExecutionAttempt()));
                return;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to send report integration status change to TestOps", (Throwable)e);
        }
    }

    public void onReportGenerationCompleted(IReportDataSource dataSource) {
        try {
            if (dataSource instanceof LegacyTestSuiteCollectionReportDataSource) {
                LegacyTestSuiteCollectionReportDataSource legacyDataSource = (LegacyTestSuiteCollectionReportDataSource)dataSource;
                this.fireTSCExecutionExternalEvent(legacyDataSource.getTscExecution(), "KATALON_EXECUTION/TEST_SUITE_COLLECTION_FINISHED");
                return;
            }
            if (dataSource instanceof LegacyTestSuiteReportDataSource) {
                LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)dataSource;
                this.fireTestSuiteExecutionExternalEvent(legacyDataSource.getTestSuiteExecutionAttempt(), "KATALON_EXECUTION/TEST_SUITE_FINISHED");
                return;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to send execution completed event after report generation", (Throwable)e);
        }
    }

    public void onTestCaseExecutionEnded(TestCaseExecutionAttempt attempt) {
        if (attempt == null) {
            logger.warn("TestCaseExecutionAttempt is null. Cannot fire execution event.");
            return;
        }
        if (this.testOpsRealtimeReporter != null) {
            try {
                this.testOpsRealtimeReporter.safelyReportChange(ExecutionResultUpdatedEvent.testCaseUpdated((TestCaseExecutionAttempt)attempt));
            }
            catch (Exception e) {
                logger.warn("Failed to report TestCaseExecutionAttempt ended to TestOps for id={}", (Object)attempt.getIdString(), (Object)e);
            }
        }
    }

    private void fireEventWhenStatusChanged(EntityExecution entityExecution, ExecutionJobStatus newStatus) {
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            String externalEventName = null;
            if (newStatus != ExecutionJobStatus.RUNNING) {
                if (newStatus.isFinal()) {
                    return;
                }
                logger.warn("No event to fire for TestSuiteCollectionExecution id={} with status={}", (Object)tscExecution.getIdString(), (Object)newStatus);
                return;
            }
            externalEventName = "KATALON_EXECUTION/TEST_SUITE_COLLECTION_STARTED";
            if (externalEventName != null) {
                this.fireTSCExecutionExternalEvent(tscExecution, externalEventName);
            }
            return;
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt tsExecution = (TestSuiteExecutionAttempt)entityExecution;
            String externalEventName = null;
            ArrayList<Pair> internalEvents = new ArrayList<Pair>();
            if (newStatus == ExecutionJobStatus.RUNNING) {
                externalEventName = "KATALON_EXECUTION/TEST_SUITE_STARTED";
                internalEvents.add(new Pair("EXECUTE/EXECUTE_TEST_SUITE", null));
                if (this.testOpsRealtimeReporter != null) {
                    this.testOpsRealtimeReporter.safelyReportChange(ExecutionResultUpdatedEvent.testSuiteAttemptStarted((TestSuiteExecutionAttempt)tsExecution));
                }
            } else if (newStatus.isFinal()) {
                internalEvents.add(new Pair("EXECUTE/EXECUTE_TEST_SUITE_ENDED", null));
                internalEvents.add(new Pair("TESTSUITE/FINISHED", tsExecution.getTestSuite()));
            } else {
                logger.warn("No event to fire for TestSuiteExecutionAttempt id={} with status={}", (Object)tsExecution.getIdString(), (Object)newStatus);
                return;
            }
            for (Pair event : internalEvents) {
                this.eventBroker.send(event.eventName, event.eventObject);
            }
            if (externalEventName != null) {
                this.fireTestSuiteExecutionExternalEvent(tsExecution, externalEventName);
            }
            this.sendTrackingActivityToTestOps(tsExecution);
            return;
        }
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution tcExecution = (TestCaseExecution)entityExecution;
            ArrayList<Pair> internalEvents = new ArrayList<Pair>();
            if (newStatus == ExecutionJobStatus.RUNNING) {
                internalEvents.add(new Pair("EXECUTE/EXECUTE_TEST_CASE", null));
                if (tcExecution.getTestCase() instanceof WSVerificationTestCaseEntity || tcExecution.getTestCase() instanceof RecordPlaybackTestCaseEntity) {
                    internalEvents.add(new Pair("WEBUI_VERIFICATION/START_EXECUTION", null));
                }
                internalEvents.add(new Pair("EXECUTE/EXECUTE_TEST_CASE", null));
                if (tcExecution.getTestCase() instanceof WSVerificationTestCaseEntity) {
                    internalEvents.add(new Pair("WEBUI_VERIFICATION/START_EXECUTION", null));
                }
            } else if (newStatus.isFinal()) {
                internalEvents.add(new Pair("EXECUTE/EXECUTE_TEST_CASE_ENDED", null));
                if (newStatus == ExecutionJobStatus.COMPLETED) {
                    internalEvents.add(new Pair("EXECUTE/EXECUTE_TEST_CASE_COMPLETED", null));
                }
                if (tcExecution.getTestCase() instanceof WSVerificationTestCaseEntity || tcExecution.getTestCase() instanceof RecordPlaybackTestCaseEntity) {
                    TestCaseExecutionAttempt firstAttempt = tcExecution.getFirstAttempt();
                    TestStatus.TestStatusValue statusValue = firstAttempt.getLogRecordTestStatusValue();
                    logger.info("Firing WEBUI_VERIFICATION_EXECUTION_FINISHED event with statusValue={}", (Object)statusValue);
                    internalEvents.add(new Pair("WEBUI_VERIFICATION/EXECUTION_FINISHED", statusValue));
                }
            } else {
                logger.warn("No events to fire for TestCaseExecution id={} with status={}", (Object)tcExecution.getIdString(), (Object)newStatus);
                return;
            }
            for (Pair event : internalEvents) {
                this.eventBroker.send(event.eventName, event.eventObject);
            }
        }
    }

    private void fireTestSuiteExecutionExternalEvent(TestSuiteExecutionAttempt attempt, String eventName) {
        ExecutionContextBuilder contextBuilder = new ExecutionContextBuilder();
        TestSuiteExecutionContext context = contextBuilder.buildTestSuiteExecutionContext(attempt);
        TestSuiteExecutionEvent eventObject = new TestSuiteExecutionEvent(eventName, context);
        this.eventBroker.send(eventName, (Object)eventObject);
    }

    private void fireTSCExecutionExternalEvent(TestSuiteCollectionExecution tscExecution, String eventName) {
        ExecutionContextBuilder contextBuilder = new ExecutionContextBuilder();
        TestSuiteCollectionExecutionContext context = contextBuilder.buildTSCExecutionContext(tscExecution);
        TestSuiteCollectionExecutionEvent eventObject = new TestSuiteCollectionExecutionEvent(eventName, context);
        this.eventBroker.send(eventName, (Object)eventObject);
    }

    private void sendTrackingActivityToTestOps(TestSuiteExecutionAttempt attempt) {
        try {
            ReportIntegrationContribution analyticsProvider = ReportIntegrationFactory.getInstance().getAnalyticsProvider();
            String machineId = MachineUtil.getMachineId();
            String sessionId = attempt.getExecutionUUID();
            Date startTime = attempt.getStartDate();
            Date endTime = attempt.getEndDate();
            String ksVersion = VersionUtil.getCurrentVersion().getVersion();
            Long organizationId = OrganizationHandler.getOrganizationId();
            this.eventPublishingExecutor.submit(() -> {
                try {
                    analyticsProvider.sendTrackingActivity(organizationId, machineId, sessionId, startTime, endTime, ksVersion);
                }
                catch (Exception e) {
                    logger.error("Failed to send tracking activity to TestOps for TestSuiteExecutionAttempt id={}", (Object)attempt.getIdString(), (Object)e);
                }
            });
        }
        catch (Exception e) {
            logger.error("Failed to submit tracking activity task for TestSuiteExecutionAttempt", (Throwable)e);
        }
    }

    public record Pair(String eventName, Object eventObject) {
    }
}

