/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.events;

import com.katalon.execution.event.ExecutionResultUpdatedEvent;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.testops.core.model.AnalyticsTestRun;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOpsRealtimeReporter {
    private static final Logger logger = LoggerFactory.getLogger(TestOpsRealtimeReporter.class);
    private final ReportIntegrationContribution testOpsContribution = ReportIntegrationFactory.getInstance().getAnalyticsProvider();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TestOpsRealtimeReporter safelyCreateIfNecessary(EntityExecution entityExecution) {
        try {
            if (entityExecution instanceof TestSuiteExecution) {
                TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
                LaunchMode launchMode = testSuiteExecution.getExecutionSettings().getLaunchMode();
                if (launchMode == LaunchMode.DEBUG) {
                    return null;
                }
                return new TestOpsRealtimeReporter();
            }
            if (!(entityExecution instanceof TestSuiteCollectionExecution)) {
                return null;
            }
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            LaunchMode launchMode = tscExecution.getFirstTestSuiteExecutionAttempt().getExecutionSettings().getLaunchMode();
            if (launchMode == LaunchMode.DEBUG) {
                return null;
            }
            return new TestOpsRealtimeReporter();
        }
        catch (Exception e) {
            logger.warn("Failed to create TestOpsRealtimeReporter: ", (Throwable)e);
            return null;
        }
    }

    public void safelyReportChange(ExecutionResultUpdatedEvent event) {
        try {
            if (this.testOpsContribution == null || event == null || event.getChangedExecution() == null) {
                return;
            }
            if (event.getChangedExecution().getExecutionJobStatus() == ExecutionJobStatus.PENDING || event.getChangedExecution().getExecutionJobStatus() == ExecutionJobStatus.TERMINATED) {
                return;
            }
            Pair<String, Boolean> pair = this.resolveExecutionUUIDAndIsRootEnd(event.getChangedExecution());
            if (pair == null) {
                return;
            }
            String executionUUID = (String)pair.getLeft();
            boolean isRootEnd = (Boolean)pair.getRight();
            EntityExecution entityExecution = event.getChangedExecution();
            if (entityExecution instanceof TestCaseExecutionAttempt) {
                TestCaseExecutionAttempt testCaseExecutionAttempt = (TestCaseExecutionAttempt)entityExecution;
                if (testCaseExecutionAttempt.getTestResult().isEmpty()) {
                    return;
                }
                TestSuiteExecutionAttempt testSuiteExecutionAttempt = testCaseExecutionAttempt.getAncestorTestSuiteExecutionAttempt();
                if (testSuiteExecutionAttempt == null) {
                    return;
                }
                String testResult = ((ExecutionTestResult)testCaseExecutionAttempt.getTestResult().get()).toString();
                AnalyticsTestRun testRun = new AnalyticsTestRun();
                testRun.setName(testCaseExecutionAttempt.getTestCaseId());
                testRun.setStatus(testResult);
                testRun.setSessionId(executionUUID);
                testRun.setTestSuiteId(testSuiteExecutionAttempt.getTestSuiteId());
                testRun.setEnd(false);
                this.testOpsContribution.notifyProccess(testRun);
            } else {
                EntityExecution entityExecution2 = event.getChangedExecution();
                if (entityExecution2 instanceof TestSuiteExecutionAttempt) {
                    TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution2;
                    AnalyticsTestRun testRun = new AnalyticsTestRun();
                    testRun.setSessionId(executionUUID);
                    testRun.setTestSuiteId(testSuiteExecutionAttempt.getTestSuiteId());
                    testRun.setEnd(isRootEnd);
                    this.testOpsContribution.notifyProccess(testRun);
                    if (isRootEnd) {
                        logger.info("Sent 'end' signal to TestOps for execution uuid: " + executionUUID);
                    }
                } else {
                    EntityExecution entityExecution3 = event.getChangedExecution();
                    if (entityExecution3 instanceof TestSuiteCollectionExecution) {
                        TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution3;
                        AnalyticsTestRun testRun = new AnalyticsTestRun();
                        testRun.setSessionId(tscExecution.getExecutionUUID());
                        testRun.setEnd(isRootEnd);
                        this.testOpsContribution.notifyProccess(testRun);
                        if (isRootEnd) {
                            logger.info("Sent 'end' signal to TestOps for execution uuid: " + tscExecution.getExecutionUUID());
                        }
                    } else {
                        logger.warn("Unsupported changed execution type for TestOps reporting: " + event.getChangedExecution().getClass().getName());
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to report changes to TestOps: ", (Throwable)e);
        }
    }

    private Pair<String, Boolean> resolveExecutionUUIDAndIsRootEnd(EntityExecution entityExecution) {
        if (entityExecution instanceof TestCaseExecutionAttempt) {
            TestCaseExecutionAttempt tcExecutionAttempt = (TestCaseExecutionAttempt)entityExecution;
            TestSuiteExecutionAttempt attempt = tcExecutionAttempt.getAncestorTestSuiteExecutionAttempt();
            String executionUUID = attempt == null ? null : attempt.getExecutionUUID();
            return Pair.of((Object)executionUUID, (Object)false);
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt tsExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            String executionUUID = tsExecutionAttempt.getExecutionUUID();
            boolean isRootEnd = false;
            EntityExecution entityExecution2 = tsExecutionAttempt.getParentEntityExecution();
            if (entityExecution2 instanceof TestSuiteExecution) {
                TestSuiteExecution tsExecution = (TestSuiteExecution)entityExecution2;
                EntityExecution entityExecution3 = tsExecution.getParentEntityExecution();
                if (entityExecution3 instanceof TestSuiteCollectionExecution) {
                    TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution3;
                    isRootEnd = tscExecution.getExecutionJobStatus().isFinal();
                } else {
                    isRootEnd = tsExecution.getExecutionJobStatus().isFinal();
                }
            }
            return Pair.of((Object)executionUUID, (Object)isRootEnd);
        }
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            String executionUUID = tscExecution.getExecutionUUID();
            boolean isRootEnd = tscExecution.getExecutionJobStatus().isFinal();
            return Pair.of((Object)executionUUID, (Object)isRootEnd);
        }
        return null;
    }
}

