/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs;

import com.katalon.execution.dto.result.JobDTO;
import com.katalon.execution.dto.result.Statistics;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.event.ExecutionResultUpdatedEvent;
import com.katalon.execution.event.JobUpdatedEvent;
import com.katalon.execution.event.RearrangeParentChildRequestedEvent;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.BaseTestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.events.ExecutionEventsPublisher;
import com.katalon.execution.services.jobs.ExecutionJob;
import com.katalon.execution.services.jobs.SingleLaunchJob;
import com.katalon.execution.services.kre.KRELogPrinter;
import com.katalon.execution.util.EntityExecutionTraverser;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.util.ExecutorUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class EntityExecutionJob
extends ExecutionJob
implements SingleLaunchJob.ISingleLaunchJobListener,
EventHandler {
    private final EntityExecution entityExecution;
    private final ExecutionSettings executionSettings;
    private final List<SingleLaunchJob> singleLaunchJobs = new CopyOnWriteArrayList<SingleLaunchJob>();
    private final Object jobsLock = new Object();
    private ExecutorService tscExecutor;
    private ExecutorService entityUpdateExecutor = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "EntityExecutionUpdateThread");
        thread.setDaemon(true);
        return thread;
    });
    private final ExecutionEventsPublisher eventsPublisher;
    private final boolean isPublishUIEvents;

    public EntityExecutionJob(IExecutionManager manager, IEventBroker eventBroker, ExecutionEventsPublisher eventsPublisher, EntityExecution entityExecution) {
        super(manager, eventBroker);
        this.entityExecution = entityExecution;
        this.eventsPublisher = eventsPublisher;
        this.executionSettings = this.extractExecutionSettings(entityExecution);
        this.isPublishUIEvents = this.determinePublishUIEvents(this.executionSettings);
    }

    private boolean determinePublishUIEvents(ExecutionSettings executionSettings) {
        if (executionSettings != null && executionSettings.getEventConfiguration() != null) {
            return executionSettings.getEventConfiguration().isPublishUIEvents();
        }
        return true;
    }

    private ExecutionSettings extractExecutionSettings(EntityExecution entityExecution) {
        if (entityExecution instanceof BaseTestCaseExecution) {
            BaseTestCaseExecution tsExecution = (BaseTestCaseExecution)entityExecution;
            return tsExecution.getExecutionSettings();
        }
        if (entityExecution instanceof BaseTestSuiteExecution) {
            BaseTestSuiteExecution tsExecution = (BaseTestSuiteExecution)entityExecution;
            return tsExecution.getExecutionSettings();
        }
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            if (tscExecution.getFirstTestSuiteExecutionAttempt() == null) {
                return null;
            }
            return tscExecution.getFirstTestSuiteExecutionAttempt().getExecutionSettings();
        }
        this.logger.warn("Unable to extract ExecutionSettings from EntityExecution of type: {}", (Object)entityExecution.getClass().getSimpleName());
        return null;
    }

    @Override
    protected void start() throws ExecutionException {
        super.start();
        EntityExecution entityExecution = this.entityExecution;
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            this.startTestCase(testCaseExecution);
            return;
        }
        EntityExecution entityExecution2 = this.entityExecution;
        if (entityExecution2 instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)entityExecution2;
            this.startTestCaseBinding(testCaseBindingExecution);
            return;
        }
        EntityExecution entityExecution3 = this.entityExecution;
        if (entityExecution3 instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution3;
            this.startTestSuite(testSuiteExecution);
            return;
        }
        EntityExecution entityExecution4 = this.entityExecution;
        if (entityExecution4 instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution4;
            this.startTestSuiteCollection(tscExecution);
            return;
        }
        throw new ExecutionException("Unsupported EntityExecution type: " + this.entityExecution.getClass().getSimpleName());
    }

    private void startTestSuite(TestSuiteExecution testSuiteExecution) {
        this.eventBroker.subscribe("EXECUTION_V2/ON_TEST_CASE_EXECUTION_RESULT_ENDED", (EventHandler)this);
        TestSuiteRerunSettings rerunSettings = testSuiteExecution.getExecutionSettings().getTestSuiteRerunSettings();
        CompletableFuture<ExecutionJobStatus> future = this.startTestSuiteExecutionAsync(testSuiteExecution, 0, rerunSettings, new LaunchDelay(0, 0), -1);
        future.whenComplete((subStatus, throwable) -> {
            ExecutionJobStatus finalStatus = throwable != null ? ExecutionJobStatus.FAILED : subStatus;
            this.updateJobStatus(finalStatus, (Throwable)throwable);
        });
    }

    private void startTestCaseBinding(TestCaseBindingExecution testCaseBindingExecution) {
        int logServerPort = testCaseBindingExecution.getExecutionSettings().getRunConfiguration().getHost().getHostPort();
        CompletableFuture<ExecutionJobStatus> future = this.startTestCaseExecutionAsync((EntityExecution)testCaseBindingExecution, logServerPort);
        future.whenComplete((subStatus, throwable) -> {
            ExecutionJobStatus finalStatus = throwable != null ? ExecutionJobStatus.FAILED : subStatus;
            this.updateJobStatus(finalStatus, (Throwable)throwable);
        });
    }

    private void startTestCase(TestCaseExecution testCaseExecution) {
        int logServerPort = testCaseExecution.getExecutionSettings().getRunConfiguration().getHost().getHostPort();
        CompletableFuture<ExecutionJobStatus> future = this.startTestCaseExecutionAsync((EntityExecution)testCaseExecution, logServerPort);
        future.whenComplete((subStatus, throwable) -> {
            ExecutionJobStatus finalStatus = throwable != null ? ExecutionJobStatus.FAILED : subStatus;
            this.updateJobStatus(finalStatus, (Throwable)throwable);
        });
    }

    private void startTestSuiteCollection(TestSuiteCollectionExecution tscExecution) throws ExecutionException {
        this.eventBroker.subscribe("EXECUTION_V2/ON_TEST_CASE_EXECUTION_RESULT_ENDED", (EventHandler)this);
        int maxConcurrentInstances = 1;
        maxConcurrentInstances = tscExecution.getTestSuiteCollection().getExecutionMode() == TestSuiteCollectionEntity.ExecutionMode.SEQUENTIAL ? 1 : tscExecution.getTestSuiteCollection().getMaxConcurrentInstances();
        int delayBetweenInstances = maxConcurrentInstances <= 1 ? 0 : tscExecution.getTscExecutionSettings().getDelayBetweenInstances();
        int maxFailedTests = tscExecution.getTscExecutionSettings().getMaxFailedTests().orElse(-1);
        this.logger.info("Starting TSC with maxConcurrentInstances = {}, delayBetweenInstances = {}, maxFailedTests = {}", new Object[]{maxConcurrentInstances, delayBetweenInstances, maxFailedTests > 0 ? Integer.valueOf(maxFailedTests) : "unlimited"});
        this.tscExecutor = Executors.newFixedThreadPool(maxConcurrentInstances);
        CopyOnWriteArrayList<CompletableFuture<ExecutionJobStatus>> allFutures = new CopyOnWriteArrayList<CompletableFuture<ExecutionJobStatus>>();
        try {
            int suiteIndex = 0;
            while (suiteIndex < tscExecution.getTestSuiteExecutions().size()) {
                TestSuiteExecution testSuiteExecution = (TestSuiteExecution)tscExecution.getTestSuiteExecutions().get(suiteIndex);
                if (this.status.isFinal()) {
                    this.logger.info("EntityExecutionJob was already finished. Skip starting new TestSuiteExecution.");
                    break;
                }
                boolean isFirstBatch = suiteIndex < maxConcurrentInstances;
                int delaySeconds = isFirstBatch ? suiteIndex * delayBetweenInstances : delayBetweenInstances;
                CompletableFuture<ExecutionJobStatus> testSuiteFuture = CompletableFuture.supplyAsync(() -> this.startTestSuiteExecutionAsync(testSuiteExecution, 0, testSuiteExecution.getExecutionSettings().getTestSuiteRerunSettings(), new LaunchDelay(delaySeconds, delayBetweenInstances), maxFailedTests).join(), this.tscExecutor);
                testSuiteFuture.whenComplete((suiteStatus, suiteThrowable) -> {
                    int failedCount;
                    if (maxFailedTests > 0 && (failedCount = tscExecution.countFailedAndErrorTestCaseExecutions()) >= maxFailedTests) {
                        this.stopEarlyDueToMaxFailedTests(allFutures);
                    }
                });
                allFutures.add(testSuiteFuture);
                ++suiteIndex;
            }
            CompletableFuture.allOf(allFutures.toArray(new CompletableFuture[0])).whenComplete((finalStatus, throwable) -> {
                try {
                    List testSuiteExecutions = tscExecution.getTestSuiteExecutions();
                    if (testSuiteExecutions.isEmpty()) {
                        this.updateJobStatus(ExecutionJobStatus.FAILED, new ExecutionException("No Test Suite Executions were started."));
                        return;
                    }
                    try {
                        ExecutionJobStatus tscJobStatus = ((TestSuiteExecution)testSuiteExecutions.get(0)).getExecutionJobStatus();
                        ExecutionException tscException = null;
                        for (TestSuiteExecution testSuiteExecution : testSuiteExecutions) {
                            TestSuiteExecutionAttempt lastAttempt = testSuiteExecution.getLastAttempt();
                            if (lastAttempt.getExecutionJobStatus() != ExecutionJobStatus.FAILED) continue;
                            tscJobStatus = ExecutionJobStatus.FAILED;
                            if (!lastAttempt.getJobFailedReason().isPresent()) break;
                            tscException = new ExecutionException((String)lastAttempt.getJobFailedReason().get());
                            break;
                        }
                        this.updateJobStatus(tscJobStatus, tscException);
                        allFutures.clear();
                    }
                    catch (Exception e) {
                        this.logger.warn("Failed to complete TSC execution", (Throwable)e);
                    }
                }
                finally {
                    this.safelyShutdownExecutorService(this.tscExecutor);
                }
            });
        }
        catch (Exception e) {
            this.safelyShutdownExecutorService(this.tscExecutor);
            throw new ExecutionException("Failed to start TSC execution", (Throwable)e);
        }
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.entityUpdateExecutor.submit(() -> {
            String failedReason = lastException != null ? lastException.getMessage() : null;
            this.entityExecution.updateJobStatus(newStatus, failedReason);
            this.eventsPublisher.onExecutionStatusChanged(this.entityExecution, newStatus);
            if (this.isPublishUIEvents) {
                this.notifyProgressChanged();
            }
            super.updateJobStatus(newStatus, lastException);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<ExecutionJobStatus> startTestCaseExecutionAsync(EntityExecution entityExecution, int logServerPort) {
        SingleLaunchJob singleJob;
        CompletableFuture<ExecutionJobStatus> future = new CompletableFuture<ExecutionJobStatus>();
        try {
            singleJob = new SingleLaunchJob(this.manager, this.eventBroker, entityExecution, logServerPort, this.entityUpdateExecutor);
        }
        catch (ExecutionException e) {
            future.completeExceptionally(e);
            return future;
        }
        EntityExecutionJob parentJob = this;
        Object object = this.jobsLock;
        synchronized (object) {
            this.singleLaunchJobs.add(singleJob);
        }
        singleJob.addListener(parentJob);
        CompletableFuture<ExecutionJobStatus> singleJobFuture = singleJob.startAsync();
        singleJobFuture.whenComplete((subStatus, throwable) -> {
            Object object = this.jobsLock;
            synchronized (object) {
                this.singleLaunchJobs.remove(singleJob);
            }
            singleJob.removeListener(parentJob);
            this.propagateResultToParentFuture(future, (ExecutionJobStatus)subStatus, (Throwable)throwable);
        });
        return future;
    }

    private CompletableFuture<ExecutionJobStatus> startTestSuiteExecutionAsync(TestSuiteExecution testSuiteExecution, int attemptIndex, TestSuiteRerunSettings testSuiteRerunSettings, LaunchDelay launchDelay, int maxFailedTest) {
        CompletableFuture<Object> delayFuture;
        CompletableFuture<ExecutionJobStatus> parentFuture = new CompletableFuture<ExecutionJobStatus>();
        int delay = attemptIndex == 0 ? launchDelay.firstDelay : launchDelay.retryDelay;
        if (delay > 0) {
            if (this.isStopRequested || this.status.isFinal()) {
                this.logger.info("EntityExecutionJob was already stopped or reached final state: {}. Skip starting new TestSuiteExecution.", (Object)this.status);
                return CompletableFuture.completedFuture(this.status);
            }
            delayFuture = CompletableFuture.runAsync(() -> this.sleepSeconds(delay));
        } else {
            delayFuture = CompletableFuture.completedFuture(null);
        }
        ((CompletableFuture)delayFuture.thenRunAsync(() -> {
            SingleLaunchJob singleJob;
            if (this.isStopRequested || this.status.isFinal()) {
                this.logger.info("EntityExecutionJob was stopped or reached final state during delay: {}. Skip starting new TestSuiteExecution.", (Object)this.status);
                parentFuture.complete(this.status);
                return;
            }
            TestSuiteExecutionAttempt attempt = (TestSuiteExecutionAttempt)testSuiteExecution.getAttempts().get(attemptIndex);
            if (attempt.getAttemptIndex() > 0) {
                KRELogPrinter.printReadyToStartTestSuiteRetry(attempt);
            }
            if (testSuiteExecution.isPartOfCollection()) {
                KRELogPrinter.printReadyToStartMessage(attempt, LocalTime.now(), maxFailedTest);
            }
            if (maxFailedTest > 0) {
                int alreadyFailedCount = this.countFailedAndErrorTestCaseExecutions(attempt);
                int remainingFailedThreshold = maxFailedTest - alreadyFailedCount;
                KRELogPrinter.printMaxFailedTestMessage(attempt, maxFailedTest, remainingFailedThreshold);
                if (remainingFailedThreshold <= 0) {
                    parentFuture.completeExceptionally(new ExecutionException("Terminating execution as maximum failed tests threshold reached.", ExecutionJobStatus.TERMINATED));
                    return;
                }
            }
            int logServerPort = attempt.getExecutionSettings().getRunConfiguration().getHost().getHostPort();
            try {
                singleJob = new SingleLaunchJob(this.manager, this.eventBroker, (EntityExecution)attempt, logServerPort, this.entityUpdateExecutor);
            }
            catch (ExecutionException e) {
                parentFuture.completeExceptionally(e);
                return;
            }
            EntityExecutionJob parentJob = this;
            Object object = this.jobsLock;
            synchronized (object) {
                this.singleLaunchJobs.add(singleJob);
            }
            singleJob.addListener(parentJob);
            CompletableFuture<ExecutionJobStatus> singleJobFuture = singleJob.startAsync();
            singleJobFuture.whenComplete((subStatus, throwable) -> {
                int alreadyFailedCount;
                Object object = this.jobsLock;
                synchronized (object) {
                    this.singleLaunchJobs.remove(singleJob);
                }
                singleJob.removeListener(parentJob);
                if (maxFailedTest > 0 && (alreadyFailedCount = this.countFailedAndErrorTestCaseExecutions(attempt)) >= maxFailedTest) {
                    this.propagateResultToParentFuture(parentFuture, (ExecutionJobStatus)subStatus, (Throwable)throwable);
                    return;
                }
                boolean shouldRetry = testSuiteExecution.shouldRetryTestSuite();
                if (!shouldRetry) {
                    this.propagateResultToParentFuture(parentFuture, (ExecutionJobStatus)subStatus, (Throwable)throwable);
                    return;
                }
                try {
                    int suiteRerunIndex = testSuiteExecution.getAttempts().size();
                    ExecutionSettings retrySettings = this.manager.cloneSettingsForRetry(testSuiteExecution.getExecutionSettings(), suiteRerunIndex);
                    this.manager.writeExecutionSettingsToFile(retrySettings);
                    this.manager.updateTestSuiteExecutionWithNewRetry(testSuiteExecution, retrySettings);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to create a new attempt for TestSuiteExecution rerun", (Throwable)e);
                    parentFuture.completeExceptionally(e);
                    return;
                }
                CompletableFuture<ExecutionJobStatus> retryFuture = this.startTestSuiteExecutionAsync(testSuiteExecution, testSuiteExecution.getAttempts().size() - 1, testSuiteRerunSettings, launchDelay, maxFailedTest);
                retryFuture.whenComplete((retryStatus, retryThrowable) -> this.propagateResultToParentFuture(parentFuture, (ExecutionJobStatus)retryStatus, (Throwable)retryThrowable));
            });
        })).exceptionally(ex -> {
            this.logger.error("Error during test suite execution startup", ex);
            parentFuture.completeExceptionally((Throwable)ex);
            return null;
        });
        return parentFuture;
    }

    @Override
    protected void stop() {
        super.stop();
        this.eventBroker.unsubscribe((EventHandler)this);
        this.safelyStopJobs();
        this.entityUpdateExecutor.submit(() -> {
            ArrayList<TestEntityExecutionResult> results = new ArrayList<TestEntityExecutionResult>();
            this.entityExecution.onPlanTerminated();
            List<EntityExecution> changedExecutions = EntityExecutionTraverser.collectUnfinishedExecutions(this.entityExecution);
            results.addAll(changedExecutions.stream().map(e -> TestEntityExecutionResult.simpleStatusUpdate((EntityExecution)e)).toList());
            List<LogRecord> changedLogRecords = EntityExecutionTraverser.collectUnfinishedLogRecords(changedExecutions);
            results.addAll(changedLogRecords.stream().map(lr -> TestEntityExecutionResult.simpleStatusUpdateForIncompleteRecord((LogRecord)lr, (ExecutionJobStatus)ExecutionJobStatus.TERMINATED)).toList());
            this.eventBroker.post("EXECUTION_V2/ON_EXECUTION_RECORDS_STATUS_UPDATED", (Object)results.toArray(new TestEntityExecutionResult[0]));
            if (this.isPublishUIEvents) {
                this.notifyProgressChanged();
            }
        });
        this.shutdownExecutorsAsync();
        if (this.eventsPublisher != null) {
            this.eventsPublisher.shutdown();
        }
        this.safelyCleanupTempClasspathFiles();
    }

    private void stopEarlyDueToMaxFailedTests(List<CompletableFuture<ExecutionJobStatus>> allFutures) {
        this.isStopRequested = true;
        this.logger.info("Stopping execution due to exceeding maximum failed tests threshold.");
        this.safelyStopJobs();
        for (CompletableFuture<ExecutionJobStatus> future : allFutures) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
        this.updateJobStatus(ExecutionJobStatus.FAILED, new ExecutionException("Execution stopped due to exceeding maximum failed tests threshold."));
        if (this.isPublishUIEvents) {
            this.notifyProgressChanged();
        }
        this.shutdownExecutorsAsync();
        this.safelyCleanupTempClasspathFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyStopJobs() {
        ArrayList<SingleLaunchJob> jobsToStop;
        Object object = this.jobsLock;
        synchronized (object) {
            jobsToStop = new ArrayList<SingleLaunchJob>(this.singleLaunchJobs);
            this.singleLaunchJobs.clear();
        }
        for (SingleLaunchJob job : jobsToStop) {
            job.safelyStop();
        }
    }

    private void shutdownExecutorsAsync() {
        new Thread(() -> {
            this.safelyShutdownExecutorService(this.tscExecutor);
            this.safelyShutdownExecutorService(this.entityUpdateExecutor);
        }, "ExecutorShutdownThread").start();
    }

    private void safelyShutdownExecutorService(ExecutorService executor) {
        try {
            ExecutorUtils.awaitWithGracefulShutdown((ExecutorService)executor);
        }
        catch (Exception e) {
            this.logger.warn("Failed to shutdown executor service", (Throwable)e);
        }
    }

    private void safelyCleanupTempClasspathFiles() {
        try {
            if (this.executionSettings == null) {
                this.logger.warn("ExecutionSettings is unavailable. Skipping temporary classpath files cleanup.");
                return;
            }
            String projectDir = this.executionSettings.getRunConfiguration().getProjectDir();
            Path dirPath = Paths.get(projectDir, new String[0]);
            AtomicReference<Integer> deletedFilesCount = new AtomicReference<Integer>(0);
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (Stream<Path> paths = Files.walk(dirPath, new FileVisitOption[0]);){
                    paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(".temp") && path.getFileName().toString().endsWith(".txt")).forEach(path -> {
                        try {
                            Files.delete(path);
                            deletedFilesCount.getAndSet((Integer)deletedFilesCount.get() + 1);
                        }
                        catch (IOException e) {
                            this.logger.warn("Failed to delete temporary classpath file: {}", path, (Object)e);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to walk through project directory for cleanup", (Throwable)e);
            }
            this.logger.info("Deleted {} temporary classpath files after execution.", (Object)deletedFilesCount.get());
        }
        catch (Exception e) {
            this.logger.warn("Failed to cleanup temporary classpath files", (Throwable)e);
        }
    }

    @Override
    public boolean isPausible() {
        return false;
    }

    @Override
    public void onEntityResultsReceived(SingleLaunchJob job, List<TestEntityExecutionResult> entityResults) {
        if (this.isPublishUIEvents) {
            this.notifyEntityResults(entityResults);
        }
    }

    @Override
    public void onProgressChanged(SingleLaunchJob job) {
        if (this.isPublishUIEvents) {
            this.notifyProgressChanged();
        }
    }

    @Override
    public void onStarted(SingleLaunchJob job) {
        EntityExecution startedExecution = job.getEntityExecution();
        this.eventsPublisher.onExecutionStatusChanged(startedExecution, ExecutionJobStatus.RUNNING);
    }

    @Override
    public void onFinished(SingleLaunchJob job) {
        EntityExecution finishedExecution = job.getEntityExecution();
        this.eventsPublisher.onExecutionStatusChanged(finishedExecution, ExecutionJobStatus.COMPLETED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(Event event) {
        try {
            String topic;
            switch (topic = event.getTopic()) {
                case "EXECUTION_V2/ON_TEST_CASE_EXECUTION_RESULT_ENDED": {
                    ExecutionResultUpdatedEvent updatedEvent;
                    EntityExecution entityExecution;
                    Object object = event.getProperty("org.eclipse.e4.data");
                    if (!(object instanceof ExecutionResultUpdatedEvent) || !((entityExecution = (updatedEvent = (ExecutionResultUpdatedEvent)object).getChangedExecution()) instanceof TestCaseExecutionAttempt)) return;
                    TestCaseExecutionAttempt attempt = (TestCaseExecutionAttempt)entityExecution;
                    this.eventsPublisher.onTestCaseExecutionEnded(attempt);
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to handle event with topic: {}", (Object)(event != null ? event.getTopic() : "unknown"), (Object)e);
        }
    }

    private void notifyEntityResults(List<TestEntityExecutionResult> entityResults) {
        if (entityResults == null || entityResults.isEmpty()) {
            return;
        }
        Consumer<List> flushResultBatch = resultBatch -> {
            if (!resultBatch.isEmpty()) {
                TestEntityExecutionResult.UpdateType updateType = ((TestEntityExecutionResult)resultBatch.get((int)0)).updateType;
                switch (updateType) {
                    case STATUS_ONLY: {
                        this.eventBroker.post("EXECUTION_V2/ON_EXECUTION_RECORDS_STATUS_UPDATED", (Object)resultBatch.toArray(new TestEntityExecutionResult[0]));
                        break;
                    }
                    case FULL: {
                        this.eventBroker.post("EXECUTION_V2/ON_EXECUTION_RECORDS_RECEIVED", (Object)resultBatch.toArray(new TestEntityExecutionResult[0]));
                        break;
                    }
                    case REARRANGE_PARENT_CHILDREN: {
                        for (TestEntityExecutionResult rearrangedResult : resultBatch) {
                            this.eventBroker.post("EXECUTION_V2/ON_REARRANGE_PARENT_CHILDREN_REQUESTED", (Object)new RearrangeParentChildRequestedEvent(rearrangedResult, rearrangedResult.anchorChildId));
                        }
                        break;
                    }
                }
                resultBatch.clear();
            }
        };
        ArrayList<TestEntityExecutionResult> currentBatch = new ArrayList<TestEntityExecutionResult>();
        TestEntityExecutionResult.UpdateType currentUpdateType = null;
        for (TestEntityExecutionResult result : entityResults) {
            if (currentUpdateType == null || result.updateType != currentUpdateType) {
                flushResultBatch.accept(currentBatch);
                currentUpdateType = result.updateType;
            }
            currentBatch.add(result);
        }
        flushResultBatch.accept(currentBatch);
    }

    private void notifyProgressChanged() {
        JobDTO jobUpdate = JobDTO.fromEntityExecution((EntityExecution)this.entityExecution);
        Statistics stats = Statistics.fromEntityExecution((EntityExecution)this.entityExecution);
        this.eventBroker.post("EXECUTION_V2/ON_JOB_UPDATED", (Object)JobUpdatedEvent.withJob((JobDTO)jobUpdate));
        this.eventBroker.post("EXECUTION_V2/ON_TEST_STATISTICS_UPDATED", (Object)stats);
    }

    private void propagateResultToParentFuture(CompletableFuture<ExecutionJobStatus> parentFuture, ExecutionJobStatus childStatus, Throwable childThrowable) {
        if (childThrowable != null) {
            parentFuture.completeExceptionally(childThrowable);
        } else {
            parentFuture.complete(childStatus);
        }
    }

    private void sleepSeconds(long seconds) {
        try {
            long sleepIntervalMs = 500L;
            long totalMs = seconds * 1000L;
            long sleptMs = 0L;
            while (sleptMs < totalMs && !this.status.isFinal()) {
                long remainingMs = totalMs - sleptMs;
                long currentSleepMs = Math.min(sleepIntervalMs, remainingMs);
                Thread.sleep(currentSleepMs);
                sleptMs += currentSleepMs;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private int countFailedAndErrorTestCaseExecutions(TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        EntityExecution entityExecution = testSuiteExecutionAttempt.getParentEntityExecution();
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            if (testSuiteExecution.getParentEntityExecution() == null) {
                return testSuiteExecution.countFailedAndErrorTestCaseExecutions();
            }
            EntityExecution entityExecution2 = testSuiteExecution.getParentEntityExecution();
            if (entityExecution2 instanceof TestSuiteCollectionExecution) {
                TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution2;
                return tscExecution.countFailedAndErrorTestCaseExecutions();
            }
        }
        return 0;
    }

    private record LaunchDelay(int firstDelay, int retryDelay) {
    }
}

