/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs;

import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.services.IExecutionManager;
import java.util.concurrent.CompletableFuture;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionJob {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected volatile ExecutionJobStatus status = ExecutionJobStatus.PENDING;
    protected volatile boolean isStopRequested = false;
    protected IExecutionManager manager;
    protected IEventBroker eventBroker;
    private CompletableFuture<ExecutionJobStatus> future;

    protected ExecutionJob(IExecutionManager manager, IEventBroker eventBroker) {
        this.manager = manager;
        this.eventBroker = eventBroker;
    }

    protected final void updateJobStatus(ExecutionJobStatus newStatus) {
        this.updateJobStatus(newStatus, null);
    }

    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        if (newStatus == null) {
            this.logger.warn("Cannot set null status for execution job. Treat it as FAILED");
            newStatus = ExecutionJobStatus.FAILED;
        }
        this.status = newStatus;
        if (this.future == null) {
            this.logger.warn("Future is not initialized yet when setting status to {}", (Object)newStatus);
            return;
        }
        if (newStatus == ExecutionJobStatus.COMPLETED || newStatus == ExecutionJobStatus.TERMINATED) {
            this.future.complete(newStatus);
            return;
        }
        if (newStatus == ExecutionJobStatus.FAILED) {
            Throwable finalException = lastException != null ? lastException : new ExecutionException("Execution job failed without exception details.");
            this.future.completeExceptionally(finalException);
        }
    }

    public ExecutionJobStatus getStatus() {
        return this.status;
    }

    public abstract boolean isPausible();

    public final CompletableFuture<ExecutionJobStatus> startAsync() {
        this.future = new CompletableFuture();
        try {
            this.start();
        }
        catch (Exception e) {
            this.logger.error("Failed to run execution job: " + e.getMessage(), (Throwable)e);
            this.updateJobStatus(ExecutionJobStatus.FAILED, e);
        }
        return this.future;
    }

    protected void start() throws ExecutionException {
        this.updateJobStatus(ExecutionJobStatus.RUNNING);
    }

    public final void safelyStop() {
        try {
            this.stop();
        }
        catch (Exception e) {
            this.logger.warn("Failed to stop execution job", (Throwable)e);
        }
    }

    protected void stop() {
        this.isStopRequested = true;
        if (this.status.isFinal()) {
            this.logger.warn("Cannot stop a finished job. Current status: {}", (Object)this.status);
            return;
        }
        if (this.status == ExecutionJobStatus.PENDING) {
            this.updateJobStatus(ExecutionJobStatus.SKIPPED);
            return;
        }
        this.updateJobStatus(ExecutionJobStatus.TERMINATED);
    }
}

