/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs;

import com.katalon.execution.constant.ExecutionDriverType;
import com.katalon.execution.dto.request.ExecutionEventConfiguration;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.cleanup.ExecutionDriversCleanupService;
import com.katalon.execution.services.jobs.ExecutionJob;
import com.katalon.execution.services.launch.ExecutionLogServer;
import com.katalon.execution.services.launch.LaunchOutputConsumer;
import com.katalon.execution.services.logrecord.ExecutionXMLLogParser;
import com.katalon.execution.services.logrecord.LogRecordSynchronizer;
import com.katalon.execution.util.EntityExecutionTraverser;
import com.katalon.execution.util.SlowStepTracker;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.execution.session.ExecutionSession;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.e4.core.services.events.IEventBroker;

public class SingleLaunchJob
extends ExecutionJob
implements ExecutionLogServer.IExecutionLogListener {
    private static final long LOG_RECORD_FLUSH_TIMEOUT_SECONDS = 30L;
    private final EntityExecution entityExecution;
    private final ExecutionSettings executionSettings;
    private final File executionFolder;
    private final RunningMode runningMode;
    private final ExecutionLogServer logServer;
    private final ExecutionXMLLogParser logParser = new ExecutionXMLLogParser();
    private final ExecutionDriversCleanupService driversCleanupService = new ExecutionDriversCleanupService();
    private final ExecutorService entityUpdateExecutor;
    private ILaunch launch;
    private LaunchOutputConsumer launchOutputHandler;
    private LogRecordSynchronizer logRecordSynchronizer;
    private final List<ISingleLaunchJobListener> listeners = new ArrayList<ISingleLaunchJobListener>();
    private ILaunchesListener2 launchListener;
    private PublishSubject<XmlLogRecord> logRecordsSubject;
    private Disposable logRecordsSubscription;
    private final CountDownLatch logRecordBatchesSubmittedLatch;
    private EntityExecution.JobProgress currentProgress = null;
    private final boolean slowStepTrackerEnabled = false;
    private final SlowStepTracker slowStepTracker = new SlowStepTracker();
    private volatile boolean isLaunchTerminated = false;

    public SingleLaunchJob(IExecutionManager manager, IEventBroker eventBroker, EntityExecution entityExecution, int logServerPort, ExecutorService entityUpdateExecutor) throws ExecutionException {
        super(manager, eventBroker);
        this.entityExecution = entityExecution;
        this.executionSettings = this.extractExecutionSettings();
        this.executionFolder = this.executionSettings.getExecutionDirPath().toFile();
        this.runningMode = this.executionSettings.getRunConfiguration().getRunningMode();
        this.entityUpdateExecutor = entityUpdateExecutor;
        this.currentProgress = entityExecution.buildJobProgress();
        this.logServer = new ExecutionLogServer(logServerPort);
        this.logRecordSynchronizer = new LogRecordSynchronizer(entityExecution, eventBroker);
        this.logRecordBatchesSubmittedLatch = new CountDownLatch(1);
        this.logRecordsSubject = PublishSubject.create();
        this.logRecordsSubscription = this.logRecordsSubject.buffer((ObservableSource)this.logRecordsSubject.debounce(100L, TimeUnit.MILLISECONDS)).filter(batch -> !batch.isEmpty()).subscribe(this::processLogRecordsBatch, error -> {
            this.logger.warn("Error in log records stream", error);
            this.logRecordBatchesSubmittedLatch.countDown();
        }, () -> this.logRecordBatchesSubmittedLatch.countDown());
    }

    @Override
    protected void start() throws ExecutionException {
        TestSuiteExecutionAttempt testSuiteExecutionAttempt;
        super.start();
        this.markDriverConnectionUnavailableToUseByOthers();
        this.logServer.addListener(this);
        try {
            this.logServer.start();
        }
        catch (Exception e) {
            if (e instanceof ExecutionException) {
                ExecutionException ee = (ExecutionException)((Object)e);
                throw ee;
            }
            throw new ExecutionException("Failed to start log server on port " + this.logServer.getPort(), (Throwable)e);
        }
        this.registerLaunchListener();
        try {
            this.launch = this.manager.execute(this.entityExecution);
        }
        catch (Exception e) {
            this.logger.error("Failed to start launch", (Throwable)e);
            throw e;
        }
        if (this.launch == null) {
            throw new ExecutionException("Failed to start launch for entity execution id: " + String.valueOf(this.entityExecution.getId()));
        }
        this.eventBroker.post("EXECUTION_V2/ON_ILAUNCH_STARTED", (Object)this.launch);
        boolean isPartOfCollection = false;
        EntityExecution entityExecution = this.entityExecution;
        if (entityExecution instanceof TestSuiteExecutionAttempt && (testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution).getParentEntityExecution().getParentEntityExecution() != null) {
            isPartOfCollection = true;
        }
        boolean shouldPrintToConsole = !isPartOfCollection;
        ExecutionEventConfiguration eventConfig = this.executionSettings.getEventConfiguration();
        boolean shouldPublishConsoleLog = eventConfig != null && eventConfig.isPublishConsoleLog();
        try {
            this.launchOutputHandler = new LaunchOutputConsumer(shouldPublishConsoleLog ? this.eventBroker : null, this.launch, this.executionFolder, this.runningMode, shouldPrintToConsole);
            this.launchOutputHandler.start();
        }
        catch (IOException | SecurityException ex) {
            throw new ExecutionException("Failed to start launch output handler", (Throwable)ex);
        }
    }

    private ExecutionSettings extractExecutionSettings() throws ExecutionException {
        EntityExecution entityExecution = this.entityExecution;
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            return testCaseExecution.getExecutionSettings();
        }
        EntityExecution entityExecution2 = this.entityExecution;
        if (entityExecution2 instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)entityExecution2;
            return testCaseBindingExecution.getExecutionSettings();
        }
        EntityExecution entityExecution3 = this.entityExecution;
        if (entityExecution3 instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution3;
            return testSuiteExecutionAttempt.getExecutionSettings();
        }
        throw new ExecutionException("Unsupported entity execution type: " + this.entityExecution.getClass().getName());
    }

    private void registerLaunchListener() {
        this.launchListener = new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch l = iLaunchArray[n2];
                    if (SingleLaunchJob.this.launch != null && l.equals(SingleLaunchJob.this.launch)) {
                        SingleLaunchJob.this.onLaunchTerminated();
                        break;
                    }
                    ++n2;
                }
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesRemoved(ILaunch[] launches) {
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.launchListener);
    }

    private void unregisterLaunchListener() {
        if (this.launchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.launchListener);
            this.launchListener = null;
        }
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.updateJobStatusAsync(newStatus, lastException);
    }

    protected CompletableFuture<Void> updateJobStatusAsync(ExecutionJobStatus newStatus, Throwable lastException) {
        String failedReason = lastException != null ? lastException.getMessage() : null;
        Runnable task = () -> {
            this.entityExecution.updateJobStatus(newStatus, failedReason);
            if (newStatus == ExecutionJobStatus.RUNNING) {
                this.notifyStarted();
            }
            if (newStatus.isFinal()) {
                this.notifyFinished();
                this.driversCleanupService.cleanupDriversAfterExecution(this.entityExecution);
            }
            this.notifyProgressChanged();
            this.slowStepTracker.trackStart("updateJobStatus.superCall");
            super.updateJobStatus(newStatus, lastException);
            this.slowStepTracker.trackEnd("updateJobStatus.superCall");
        };
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.submitTrackedTask(() -> {
            try {
                task.run();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }, "updateJobStatus[" + String.valueOf(newStatus) + "]");
        return future;
    }

    @Override
    protected void stop() {
        super.stop();
        this.safelyCleanupAfterStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyCleanupAfterStop() {
        try {
            this.unregisterLaunchListener();
        }
        catch (Exception e) {
            this.logger.warn("Failed to unregister launch listener", (Throwable)e);
        }
        if (this.launch != null) {
            try {
                this.launch.terminate();
            }
            catch (Exception e) {
                this.logger.warn("Failed to terminate launch", (Throwable)e);
            }
            this.launch = null;
        }
        if (this.logServer != null) {
            try {
                this.logServer.removeListener(this);
                this.logServer.stop();
            }
            catch (Exception e) {
                this.logger.warn("Failed to stop log server on port " + this.logServer.getPort(), (Throwable)e);
            }
        }
        if (this.launchOutputHandler != null) {
            try {
                this.launchOutputHandler.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close LaunchOutputHandler", (Throwable)e);
            }
            this.launchOutputHandler = null;
        }
        if (this.logRecordsSubscription != null && !this.logRecordsSubscription.isDisposed()) {
            this.logRecordsSubscription.dispose();
            this.logRecordsSubscription = null;
        }
        if (this.logRecordsSubject != null && !this.logRecordsSubject.hasComplete()) {
            this.logRecordsSubject.onComplete();
        }
        this.logRecordsSubject = null;
        List<ISingleLaunchJobListener> e = this.listeners;
        synchronized (e) {
            this.listeners.clear();
        }
        this.logRecordSynchronizer = null;
        this.currentProgress = null;
        try {
            this.markDriverConnectionAvailableToUseByOthers();
        }
        catch (Exception e2) {
            this.logger.warn("Failed to mark driver connection as available", (Throwable)e2);
        }
    }

    @Override
    public boolean isPausible() {
        return false;
    }

    @Override
    public void onLogRecordsReceived(List<XmlLogRecord> rawXmlRecords) {
        PublishSubject<XmlLogRecord> subject = this.logRecordsSubject;
        if (subject == null || subject.hasComplete()) {
            return;
        }
        for (XmlLogRecord rawXmlRecord : rawXmlRecords) {
            try {
                subject.onNext((Object)rawXmlRecord);
            }
            catch (Exception exception) {
                break;
            }
        }
    }

    @Override
    public void onReadingFinished() {
        if (this.logRecordsSubject != null && !this.logRecordsSubject.hasComplete()) {
            this.logRecordsSubject.onComplete();
        }
    }

    public EntityExecution getEntityExecution() {
        return this.entityExecution;
    }

    private void submitTrackedTask(Runnable task, String taskName) {
        this.entityUpdateExecutor.submit(task);
    }

    private void processLogRecordsBatch(List<XmlLogRecord> rawXmlRecords) {
        if (this.logRecordSynchronizer == null) {
            this.logger.info("Log records received after job stopped, ignoring");
            return;
        }
        ArrayList newCombinedLogRecords = new ArrayList();
        AtomicReference<Object> lastLogRecord = new AtomicReference<Object>(null);
        rawXmlRecords.stream().map(this.logParser::mapLogRecord).filter(newLogRecord -> newLogRecord != null).forEach(logRecord -> {
            if (!Objects.equals(logRecord, lastLogRecord.get())) {
                newCombinedLogRecords.add(logRecord);
                lastLogRecord.set(logRecord);
            }
        });
        if (newCombinedLogRecords.isEmpty()) {
            return;
        }
        this.submitTrackedTask(() -> {
            List<TestEntityExecutionResult> changedEntities = null;
            try {
                if (this.logRecordSynchronizer == null) {
                    return;
                }
                changedEntities = this.logRecordSynchronizer.syncLogRecordsToOriginalPlan(newCombinedLogRecords);
            }
            catch (Exception e) {
                this.logger.error("Failed to synchronize log records to entity execution: " + e.getMessage(), (Throwable)e);
                return;
            }
            EntityExecution.JobProgress afterProgress = this.entityExecution.buildJobProgress();
            this.notifyEntityResultsReceived(changedEntities);
            if (this.currentProgress != null && afterProgress != null && this.currentProgress.executedUnits() != afterProgress.executedUnits()) {
                this.notifyProgressChanged();
                this.currentProgress = afterProgress;
            }
        }, "processLogRecordsBatch[" + newCombinedLogRecords.size() + " records]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISingleLaunchJobListener listener) {
        List<ISingleLaunchJobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISingleLaunchJobListener listener) {
        List<ISingleLaunchJobListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(ListenerNotifier notifier) {
        ArrayList<ISingleLaunchJobListener> currentListeners;
        boolean warnIfEmpty = this.runningMode == RunningMode.GUI;
        List<ISingleLaunchJobListener> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<ISingleLaunchJobListener>(this.listeners);
        }
        if (currentListeners.isEmpty()) {
            if (warnIfEmpty) {
                this.logger.warn("No listeners to notify");
            }
            return;
        }
        for (ISingleLaunchJobListener listener : currentListeners) {
            try {
                notifier.notify(listener);
            }
            catch (Exception e) {
                this.logger.error("Failed to notify listener", (Throwable)e);
            }
        }
    }

    private void notifyEntityResultsReceived(List<TestEntityExecutionResult> entityResults) {
        this.notifyListeners(listener -> listener.onEntityResultsReceived(this, entityResults));
    }

    private void notifyProgressChanged() {
        this.notifyListeners(listener -> listener.onProgressChanged(this));
    }

    private void notifyStarted() {
        this.notifyListeners(listener -> listener.onStarted(this));
    }

    private void notifyFinished() {
        this.notifyListeners(listener -> listener.onFinished(this));
    }

    private void onLaunchTerminated() {
        this.isLaunchTerminated = true;
        int exitCode = this.getLaunchExitCode(this.launch);
        if (this.status == ExecutionJobStatus.COMPLETED) {
            this.logger.info("Job already completed, no further action needed.");
            return;
        }
        if (this.status == ExecutionJobStatus.TERMINATED) {
            this.logger.info("Job was terminated by user, no further action needed.");
            return;
        }
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.waitForLogRecordBatchesAsync().thenCompose(v -> this.flushPendingLogRecordProcessingAsync())).thenCompose(v -> this.updateUnfinishedStepsAsync())).thenAccept(changedEntityResults -> {
            this.notifyEntityResultsReceived((List<TestEntityExecutionResult>)changedEntityResults);
            this.notifyProgressChanged();
            ExecutionException exception = null;
            if (exitCode != 0) {
                exception = new ExecutionException("Launch terminated with non-zero exit code: " + exitCode);
            } else if (this.entityExecution.getExecutionJobStatus() == ExecutionJobStatus.FAILED) {
                exception = new ExecutionException("Some steps are not properly finished.");
            }
            this.updateJobStatusAsync(this.entityExecution.getExecutionJobStatus(), exception).whenComplete((v2, ex) -> this.safelyCleanupAfterStop());
        })).exceptionally(ex -> {
            this.logger.error("Error during launch termination handling", ex);
            this.safelyCleanupAfterStop();
            return null;
        });
    }

    private CompletableFuture<Void> waitForLogRecordBatchesAsync() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.submitTrackedTask(() -> {
            try {
                boolean finished;
                if (this.logRecordBatchesSubmittedLatch != null && !(finished = this.logRecordBatchesSubmittedLatch.await(5L, TimeUnit.SECONDS))) {
                    this.logger.warn("Timeout waiting for log record batches to be submitted");
                }
                future.complete(null);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn("Interrupted while waiting for log record batches to be submitted", (Throwable)e);
                future.completeExceptionally(e);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }, "waitForLogRecordBatches");
        return future;
    }

    private CompletableFuture<Void> flushPendingLogRecordProcessingAsync() {
        CompletableFuture future = new CompletableFuture();
        this.submitTrackedTask(() -> {
            this.logger.debug("All pending log record processing tasks completed");
            future.complete(null);
        }, "flushPendingLogRecordProcessing");
        return future.orTimeout(30L, TimeUnit.SECONDS).handle((result, ex) -> {
            if (ex != null) {
                this.logger.warn("Timeout or error while waiting for log records to be processed, continuing anyway: ", ex);
            }
            return null;
        });
    }

    private CompletableFuture<List<TestEntityExecutionResult>> updateUnfinishedStepsAsync() {
        CompletableFuture<List<TestEntityExecutionResult>> future = new CompletableFuture<List<TestEntityExecutionResult>>();
        this.submitTrackedTask(() -> {
            try {
                this.entityExecution.onLaunchEnded();
                ArrayList<TestEntityExecutionResult> results = new ArrayList<TestEntityExecutionResult>();
                List<EntityExecution> changedExecutions = EntityExecutionTraverser.collectUnfinishedExecutions(this.entityExecution);
                results.addAll(changedExecutions.stream().map(e -> TestEntityExecutionResult.simpleStatusUpdate((EntityExecution)e)).toList());
                List<LogRecord> incompleteLogRecords = this.logParser.collectIncompleteLogRecords();
                results.addAll(incompleteLogRecords.stream().map(lr -> TestEntityExecutionResult.simpleStatusUpdateForIncompleteRecord((LogRecord)lr, (ExecutionJobStatus)ExecutionJobStatus.FAILED)).toList());
                future.complete(results);
            }
            catch (Exception ex) {
                this.logger.error("Failed to update unfinished steps after launch termination", (Throwable)ex);
                future.complete(new ArrayList());
            }
        }, "updateUnfinishedSteps");
        return future;
    }

    private int getLaunchExitCode(ILaunch launch) {
        try {
            IProcess[] processes = launch.getProcesses();
            if (processes.length > 0) {
                IProcess process = processes[0];
                return process.getExitValue();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to get launch exit code", (Throwable)e);
        }
        return -1;
    }

    private void markDriverConnectionAvailableToUseByOthers() {
        ExecutionSession executionSession = this.findExecutionSession();
        if (executionSession != null) {
            executionSession.resume();
        }
    }

    private void markDriverConnectionUnavailableToUseByOthers() {
        ExecutionSession executionSession = this.findExecutionSession();
        if (executionSession != null) {
            executionSession.pause();
        }
    }

    private ExecutionSession findExecutionSession() {
        DriversProperties.DriverSystemPropertiesMap driverSystemProps = this.executionSettings.getRunConfiguration().getExecution().getDrivers().getSystemProps();
        DriversProperties.DriverSystemProperties driverSystemProperties = (DriversProperties.DriverSystemProperties)driverSystemProps.get((Object)ExecutionDriverType.EXISTING);
        if (driverSystemProperties instanceof DriversProperties.ExistingDriverSystemProperties) {
            DriversProperties.ExistingDriverSystemProperties existingProps = (DriversProperties.ExistingDriverSystemProperties)driverSystemProperties;
            String sessionId = existingProps.getSessionId();
            String remoteServerUrl = existingProps.getRemoteServerUrl();
            return ExecutionSessionSocketServer.getInstance().getExecutionSessionBySessionAndRemoteURL(sessionId, remoteServerUrl);
        }
        return ExecutionSessionSocketServer.getInstance().getExecutionSessionByLogFolderPath(this.executionFolder.getAbsolutePath());
    }

    private /* synthetic */ void lambda$6(String string, Runnable runnable) {
        this.slowStepTracker.trackStart(string);
        try {
            runnable.run();
        }
        finally {
            this.slowStepTracker.trackEnd(string);
        }
    }

    public static interface ISingleLaunchJobListener {
        public void onStarted(SingleLaunchJob var1);

        public void onEntityResultsReceived(SingleLaunchJob var1, List<TestEntityExecutionResult> var2);

        public void onProgressChanged(SingleLaunchJob var1);

        public void onFinished(SingleLaunchJob var1);
    }

    @FunctionalInterface
    private static interface ListenerNotifier {
        public void notify(ISingleLaunchJobListener var1) throws Exception;
    }
}

