/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs;

import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.dto.result.JobDTO;
import com.katalon.execution.dto.result.OverallProgress;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.event.JobUpdatedEvent;
import com.katalon.execution.event.OverallProgressUpdatedEvent;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionPlan;
import com.katalon.execution.model.steps.TestPreparing;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.ITestPlanningJob;
import com.katalon.execution.services.events.ExecutionEventsPublisher;
import com.katalon.execution.services.jobs.EntityExecutionJob;
import com.katalon.execution.services.jobs.ExecutionJob;
import com.katalon.execution.services.jobs.reporting.TestReportingPhaseJob;
import com.katalon.execution.services.kre.KRELogPrinter;
import com.katalon.execution.services.tracking.ExecutionTrackingService;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.file.FileEntity;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestPlanningJob
extends ExecutionJob
implements ITestPlanningJob {
    private TestExecutionRequest testExecutionRequest;
    private TestExecutionPlan testExecutionPlan;
    private EntityExecutionJob entityExecutionJob;
    private TestReportingPhaseJob reportingPhaseJob;

    public TestPlanningJob(IExecutionManager manager, IEventBroker eventBroker, TestExecutionRequest testExecutionRequest) {
        super(manager, eventBroker);
        if (testExecutionRequest == null) {
            throw new IllegalArgumentException("testExecutionRequest cannot be null");
        }
        this.testExecutionRequest = testExecutionRequest;
    }

    @Override
    protected void start() throws ExecutionException {
        super.start();
        this.performJob();
    }

    private void performJob() throws ExecutionException {
        this.eventBroker.post("EXECUTION_V2/ON_NEW_EXECUTION_SESSION_REQUESTED", null);
        String executionDisplayName = this.buildExecutionDisplayName(this.testExecutionRequest);
        String driverName = this.buildDriverName(this.testExecutionRequest);
        TestEntityExecutionResult.TestExecutionType executionType = TestEntityExecutionResult.TestExecutionType.fromExecutableEntity((IExecutableEntity)this.testExecutionRequest.getEntity());
        OverallProgress overallProgress = new OverallProgress(executionDisplayName, executionType, driverName);
        TestPreparing preparingStep = new TestPreparing();
        overallProgress.addJob(JobDTO.fromTestPreparing((TestPreparing)preparingStep));
        this.notifyOverallProgressUpdated(overallProgress);
        try {
            preparingStep.updateJobStatus(ExecutionJobStatus.RUNNING);
            this.notifyProgressChanged(preparingStep);
            this.testExecutionPlan = this.manager.plan(this.testExecutionRequest);
        }
        catch (Exception e) {
            preparingStep.updateJobStatus(ExecutionJobStatus.FAILED, e.getMessage());
            this.notifyProgressChanged(preparingStep);
            throw e instanceof ExecutionException ? (ExecutionException)((Object)e) : new ExecutionException("Failed to plan execution: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.updateOverallProgressWithPlan(overallProgress, this.testExecutionPlan);
            this.notifyOverallProgressUpdated(overallProgress);
            preparingStep.updateJobStatus(ExecutionJobStatus.COMPLETED);
            this.notifyProgressChanged(preparingStep);
            ExecutionEventsPublisher eventsPublisher = new ExecutionEventsPublisher(this.eventBroker, this.testExecutionPlan.getExecution());
            this.entityExecutionJob = new EntityExecutionJob(this.manager, this.eventBroker, eventsPublisher, this.testExecutionPlan.getExecution());
            if (this.testExecutionPlan.getReporting() != null) {
                this.reportingPhaseJob = new TestReportingPhaseJob(this.manager, this.eventBroker, eventsPublisher, this.testExecutionPlan.getReporting(), this.testExecutionPlan.getExecution());
            }
            CompletionStage<Object> jobChain = this.entityExecutionJob.startAsync();
            if (this.reportingPhaseJob != null) {
                jobChain = ((CompletableFuture)jobChain.handle((executionStatus, executionThrowable) -> {
                    KRELogPrinter.printExecutionProgress(this.testExecutionPlan.getExecution());
                    if (executionThrowable != null) {
                        return ExecutionJobStatus.FAILED;
                    }
                    return executionStatus;
                })).thenCompose(executionStatus -> {
                    if (executionStatus == ExecutionJobStatus.TERMINATED) {
                        return CompletableFuture.completedFuture(executionStatus);
                    }
                    return this.reportingPhaseJob.startAsync();
                });
            }
            jobChain.whenComplete((finalStatus, throwable) -> {
                if (throwable != null) {
                    this.updateJobStatus(ExecutionJobStatus.FAILED, (Throwable)throwable);
                } else if (finalStatus != null) {
                    this.updateJobStatus((ExecutionJobStatus)finalStatus);
                } else {
                    this.logger.warn("Job chain completed without explicit status. Marking as FAILED.");
                    this.updateJobStatus(ExecutionJobStatus.FAILED, new ExecutionException("Execution completed without detailed reason"));
                }
                if (this.status != ExecutionJobStatus.TERMINATED) {
                    ExecutionTrackingService trackingService = new ExecutionTrackingService();
                    trackingService.safelySendTrackingInfo(this.testExecutionPlan.getExecution(), this.testExecutionPlan.getReporting());
                }
            });
        }
        catch (Exception e) {
            if (this.entityExecutionJob != null) {
                this.entityExecutionJob.safelyStop();
                this.entityExecutionJob = null;
            }
            if (this.reportingPhaseJob != null) {
                this.reportingPhaseJob.safelyStop();
                this.reportingPhaseJob = null;
            }
            throw e instanceof ExecutionException ? (ExecutionException)((Object)e) : new ExecutionException("Failed to plan execution", (Throwable)e);
        }
    }

    private String buildDriverName(TestExecutionRequest testExecutionRequest) {
        if (testExecutionRequest == null || testExecutionRequest.getCapability() == null) {
            return "";
        }
        return testExecutionRequest.getCapability().getDisplayName();
    }

    private String buildExecutionDisplayName(TestExecutionRequest request) {
        if (request == null || request.getEntity() == null) {
            this.logger.warn("Request or entity is null, using default execution name");
            return "Execution";
        }
        IExecutableEntity iExecutableEntity = request.getEntity();
        if (iExecutableEntity instanceof FileEntity) {
            FileEntity fileEntity = (FileEntity)iExecutableEntity;
            return fileEntity.getName();
        }
        this.logger.warn("Unknown entity type: {}, using default execution name", (Object)request.getEntity().getClass().getName());
        return "Execution";
    }

    private void updateOverallProgressWithPlan(OverallProgress overallProgress, TestExecutionPlan testExecutionPlan) {
        overallProgress.addJob(JobDTO.fromEntityExecution((EntityExecution)testExecutionPlan.getExecution()));
        if (testExecutionPlan.getReporting() != null) {
            overallProgress.addJob(JobDTO.fromReportingPhase((TestReportingPhase)testExecutionPlan.getReporting()));
        }
    }

    private void notifyOverallProgressUpdated(OverallProgress overallProgress) {
        this.eventBroker.post("EXECUTION_V2/ON_OVERALL_PROGRESS_UPDATED", (Object)OverallProgressUpdatedEvent.withSummary((OverallProgress)overallProgress));
    }

    private void notifyProgressChanged(TestPreparing preparingStep) {
        this.eventBroker.post("EXECUTION_V2/ON_JOB_UPDATED", (Object)JobUpdatedEvent.withJob((JobDTO)JobDTO.fromTestPreparing((TestPreparing)preparingStep)));
    }

    @Override
    protected void stop() {
        super.stop();
        if (this.entityExecutionJob != null) {
            this.entityExecutionJob.safelyStop();
            this.entityExecutionJob = null;
        }
        if (this.reportingPhaseJob != null) {
            this.reportingPhaseJob.safelyStop();
            this.reportingPhaseJob = null;
        }
    }

    @Override
    public boolean isPausible() {
        return false;
    }

    public Optional<Integer> getExitCode() {
        if (this.testExecutionPlan == null) {
            return Optional.empty();
        }
        if (this.testExecutionPlan.getExecution() == null) {
            return Optional.empty();
        }
        return Optional.of(this.testExecutionPlan.getExecution().determineExitCode());
    }

    public Optional<TestExecutionPlan> getTestExecutionPlan() {
        if (this.testExecutionPlan == null) {
            return Optional.empty();
        }
        return Optional.of(this.testExecutionPlan);
    }

    public boolean isTerminated() {
        return this.status == ExecutionJobStatus.TERMINATED;
    }
}

